<?php
/**
 * Develop due to wordpress 21-Jul-2025
 * 
 * This file initializes the WordPress environment, determines which booking-related page is being accessed via query variables,
 * and dynamically includes the required CSS and JavaScript resources for that specific page.
 * It is shared across all booking system pages within the FAST Booking Engine integration.
 */
 
define('WP_USE_THEMES', true);
require __DIR__ . '/../../wp-blog-header.php';
get_header();


$current_page = '';

if (get_query_var('custom_booking')) {
    $current_page = 'booking';
} elseif (get_query_var('custom_amend')) {
    $current_page = 'amend';
} elseif (get_query_var('custom_booking_form')) {
    $current_page = 'booking-form';
} elseif (get_query_var('custom_booking_list')) {
    $current_page = 'booking-list';
} elseif (get_query_var('custom_chg_pwd')) {
    $current_page = 'chg-pwd';
} elseif (get_query_var('custom_forgotp')) {
    $current_page = 'forgotp';
} elseif (get_query_var('custom_login')) {
    $current_page = 'login';
} elseif (get_query_var('custom_memb_mailbox')) {
    $current_page = 'memb-mailbox';
} elseif (get_query_var('custom_memb_profile')) {
    $current_page = 'memb-profile';
} elseif (get_query_var('custom_msg')) {
    $current_page = 'msg';
} elseif (get_query_var('custom_pymt-status')) {
    $current_page = 'pymt-status';
} elseif (get_query_var('custom_setp')) {
    $current_page = 'setp';
} elseif (get_query_var('custom_signup')) {
    $current_page = 'signup';
}

?>
<div class="custom-page">

    <!doctype html>
    <html>

    <head>
        <meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=1,maximum-scale=1,user-scalable=0" />
        <meta charset="UTF-8">
        <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
        <meta http-equiv="Pragma" content="no-cache">
        <meta http-equiv="Expires" content="0">

        <title>FAST Booking Engine</title>
        <link rel="stylesheet" href="../css/material-icons.css">
        <link rel="stylesheet" href="../css/celcalendar.css">
        <link rel="stylesheet" href="../css/ui-app.css">

        <?php
        if ($current_page === 'amend') {
            echo '<script src="../js/amend.js"></script>';
        } elseif ($current_page === 'booking-form') {
            echo '<script src="../js/bk-form.js"></script>';
        } elseif ($current_page === 'booking-list') {
            echo '<script src="../js/bk-list.js"></script>';
        } elseif ($current_page === 'chg-pwd') {
            echo '<script src="../js/chg-pwd.js"></script>';
        } elseif ($current_page === 'forgotp') {
            echo '<script src="../js/forgotp.js"></script>';
        } elseif ($current_page === 'login') {
            echo '<script src="../js/login.js"></script>';
        } elseif ($current_page === 'memb-mailbox') {
            echo '<script src="../js/cel/celDataProc.js"></script>';
            echo '<script src="../js/memb-mailbox.js"></script>';
        } elseif ($current_page === 'memb-profile') {
            echo '<script src="../js/memb-profile.js"></script>';
        } elseif ($current_page === 'msg') {
            echo '<script src="../js/msg.js"></script>';
        } elseif ($current_page === 'pymt-status') {
            echo '<script src="../js/pymt-status.js"></script>';
        } elseif ($current_page === 'setp') {
            echo '<script src="../js/setp.js"></script>';
        } elseif ($current_page === 'signup') {
            echo '<script src="../js/signup.js"></script>';
        } 
        ?>

        <script src="../js/menu.js"></script>
    </head>

    <body>