/*
06-Mar-2024,lhw-
*/
//====================== Header ========================================================

function enqForm() {}

// Change the container from .fast-obe-enq to .fast-obe-amend
enqForm.getContainer = () => {
	return $(".fast-obe-pymt-status");
};

enqForm.init = () => {
	const c0 = enqForm.getContainer();

	// Menu-related click handlers (login, signup, profile, etc.)
	celUI.click(c0, [
		[
			"btn-amend-bk0",
			() => {
				window.location = getBookingUrl() + "/amend?ts=" + getNowString();
			},
		],
		[
			"btn-sign-up0",
			() => {
				window.location = getBookingUrl() + "/signup?ts=" + getNowString();
			},
		],
		[
			"btn-bk-profile0",
			() => {
				window.location = getBookingUrl() + "/memb-profile?ts=" + getNowString();
			},
		],
		[
			"btn-bk-msg0",
			() => {
				window.location = getBookingUrl() + "/memb-mailbox?ts=" + getNowString();
			},
		],
		[
			"btn-bk-hist0",
			() => {
				window.location = getBookingUrl() + "/booking-list?ts=" + getNowString();
			},
		],
		[
			"btn-login0",
			() => {
				// If currently labeled "logout", then call logout; otherwise go to login page
				if (
					isStrEqual(
						text_get_val(c0.find(".btn-login0 .btn-t0")),
						"logout"
					)
				) {
					let mpa1 = app.get_mpa1();
					if (mpa1) {
						ajaxCall({
							check_status: false,
							p: {
								c: "my-acct",
								a: "logout",
								data: {
									sess_id: mpa1.b,
								},
							},
							on_success: (d2) => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
							on_fail: () => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
						});
					} else {
						window.location =  getBookingUrl() + "/?ts=" + getNowString();
					}
				} else {
					window.location =  getBookingUrl() + "/login?ts=" + getNowString();
				}
			},
		],
	]);

	// Membership check for toggling menu items (logout vs login, etc.)
	const mpa1 = app.get_mpa1();
	if (mpa1 && mpa1.b) {
		let ime = app.get_id();
		if (ime) {
			// Hide sign-up group, show member set
			c0.find(".g-set").hide();
			c0.find(".memb-set").show();

			// Change Login button to Logout
			text_set_val(c0.find(".btn-login0 .btn-t0"), "Logout");

			// Show greeting in .ime3
			text_set_val(c0.find(".ime3"), "Helo " + ime);

			// Load any unread message count
			enqForm.load_notif_cnt();
		}
	}
};

// Load unread message count for the mailbox menu icon
enqForm.load_notif_cnt = () => {
	ajaxCall({
		p: {
			c: "bk-op",
			a: "msg-unread-cnt",
			data: {
				db_id: db_id,
				sess_id: app.get_id2(),
			},
		},
		check_status: false,
		on_success: (d2) => {
			const c0 = $(".btn-bk-msg0");
			let c2 = c0.find(".unread-cnt");
			if (c2.length == 0) {
				c2 = $('<div class="unread-cnt"></div>');
				c0.append(c2);
			}

			let i2 = arrLen(d2.data) > 0 ? toInt(d2.data[0].count) : 0;
			text_set_val(c2, i2);
			hide_input(c0, [["unread-cnt", i2 == 0]]);
		},
		on_fail: () => {},
	});
};

// Initialize
$(() => {
	(async () => {
		await app.chk_mpa1();
		enqForm.init();
	})();
});


//====================== End Header ========================================================
//==============================================================================

function pymtStatus() {}
pymtStatus.udf_list = null;

pymtStatus.getContainer = () => {
    return $('.fast-obe-pymt-status');
};

pymtStatus.init = () => {
    const c0 = pymtStatus.getContainer();

    (async () => {
        await pymtStatus.load_data();
    })();

    celUI.click(c0,
        [
            ['btn-restart0', pymtStatus.on_restart_click],

        ]);

};

//------------------------------------------------------------------------------
pymtStatus.load_data = () => {
    return new Promise((resolve, reject) => {
        const data = {
            db_id: db_id,
            sess_id: app.get_id2(),
            resv_id: getParam('id'),
        };

        ajaxCall({
            p: {
                c: 'bk-op',
                a: 'bk-submit-get',
                data: data,
            },
            on_success: (d2) => {
                const c0 = pymtStatus.getContainer();
                celestial.currency_symbol = d2.data.curr_code || '$';
                text_set_val(c0.find('.curr-code'), celestial.currency_symbol);

                if (arrLen(d2.data.bk) == 0) {
                    // rec not found, restart the process.
                    pymtStatus.on_restart_click();
                }
                else {
                    // load pre-submit data
                    const o2 = d2.data.bk[0];
                    o2.ci_dt = toDate(o2.ci_dt);
                    o2.co_dt = toDate(o2.co_dt);
                    o2.no_of_adult = toInt(o2.no_of_adult);
                    o2.no_of_kid = toInt(o2.no_of_kid);
                    o2.no_of_room = toInt(o2.no_of_room);

                    const day_cnt = dateDiff.inDays(o2.ci_dt, o2.co_dt);
                    let pymt_status, payable_lbl;

                    if (toInt(o2.pymt_status) == '1') {
                        if (isStrEqual(o2.status, 'uci')) {
                            pymt_status = 'Pay upon check in';
                            payable_lbl = 'Total payable';
                        }
                        else {
                            pymt_status = 'SUCCESS';
                            payable_lbl = 'Paid amount';
                        }
                    }
                    else {
                        pymt_status = 'FAILED';
                        payable_lbl = 'Amount';
                    }

                    text_set_val(c0,
                        [
                            ['period', fmtDateRange(o2.ci_dt, o2.co_dt, 'dd')],
                            ['non', ' ' + day_cnt.toString() + ' night' + (day_cnt > 1 ? 's' : '')],
                            ['noa', o2.no_of_adult.toString() + ' adult' + (o2.no_of_adult > 1 ? 's' : '')],
                            ['nok', o2.no_of_kid.toString() + ' kid' + (o2.no_of_kid > 1 ? 's' : '')],
                            ['nor', o2.no_of_room.toString() + ' room' + (o2.no_of_room > 1 ? 's' : '')],
                            ['payable', formatValue(toDbl(o2.net_amt), 'm2')],
                            ['bk-mod', formatValue(toDate(o2.pymt_update_on), 'dt')],

                            ['user-eml', o2.user_email],
                            ['ref-no', o2.web_ref_no],
                            ['pymt-status', pymt_status],
                            ['payable2', payable_lbl],

                        ]);

                    if (toInt(o2.pymt_status) == '1') {
                        c0.find('.payable0').show();
                    }
                }

                c0.find('.wait-status').hide();
                c0.find('.status0').show();

                resolve();
            },
            on_fail: () => {
                resolve();
            }
        });
    });
};

//------------------------------------------------------------------------------
pymtStatus.on_restart_click = () => {
    window.location = getBookingUrl() + "/?ts=" + getNowString();
};

//------------------------------------------------------------------------------
$(() => {
    pymtStatus.init();
});


//====================== Header ========================================================

function enqForm() {}


enqForm.getContainer = () => {
	return $(".fast-obe-pymt-status");
};

enqForm.init = () => {
	const c0 = enqForm.getContainer();

	// Menu-related click handlers (login, signup, profile, etc.)
	celUI.click(c0, [
		[
			"btn-amend-bk0",
			() => {
				window.location = getBookingUrl() + "/amend?ts=" + getNowString();
			},
		],
		[
			"btn-sign-up0",
			() => {
				window.location = getBookingUrl() + "/signup?ts=" + getNowString();
			},
		],
		[
			"btn-bk-profile0",
			() => {
				window.location = getBookingUrl() + "/memb-profile?ts=" + getNowString();
			},
		],
		[
			"btn-bk-msg0",
			() => {
				window.location = getBookingUrl() + "/memb-mailbox?ts=" + getNowString();
			},
		],
		[
			"btn-bk-hist0",
			() => {
				window.location = getBookingUrl() + "/booking-list?ts=" + getNowString();
			},
		],
		[
			"btn-login0",
			() => {
				// If currently labeled "logout", then call logout; otherwise go to login page
				if (
					isStrEqual(
						text_get_val(c0.find(".btn-login0 .btn-t0")),
						"logout"
					)
				) {
					let mpa1 = app.get_mpa1();
					if (mpa1) {
						ajaxCall({
							check_status: false,
							p: {
								c: "my-acct",
								a: "logout",
								data: {
									sess_id: mpa1.b,
								},
							},
							on_success: (d2) => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
							on_fail: () => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
						});
					} else {
						window.location =  getBookingUrl() + "/?ts=" + getNowString();
					}
				} else {
					window.location =  getBookingUrl() + "/login?ts=" + getNowString();
				}
			},
		],
	]);

	// Membership check for toggling menu items (logout vs login, etc.)
	const mpa1 = app.get_mpa1();
	if (mpa1 && mpa1.b) {
		let ime = app.get_id();
		if (ime) {
			// Hide sign-up group, show member set
			c0.find(".g-set").hide();
			c0.find(".memb-set").show();

			// Change Login button to Logout
			text_set_val(c0.find(".btn-login0 .btn-t0"), "Logout");

			// Show greeting in .ime3
			text_set_val(c0.find(".ime3"), "Helo " + ime);

			// Load any unread message count
			enqForm.load_notif_cnt();
		}
	}
};

// Load unread message count for the mailbox menu icon
enqForm.load_notif_cnt = () => {
	ajaxCall({
		p: {
			c: "bk-op",
			a: "msg-unread-cnt",
			data: {
				db_id: db_id,
				sess_id: app.get_id2(),
			},
		},
		check_status: false,
		on_success: (d2) => {
			const c0 = $(".btn-bk-msg0");
			let c2 = c0.find(".unread-cnt");
			if (c2.length == 0) {
				c2 = $('<div class="unread-cnt"></div>');
				c0.append(c2);
			}

			let i2 = arrLen(d2.data) > 0 ? toInt(d2.data[0].count) : 0;
			text_set_val(c2, i2);
			hide_input(c0, [["unread-cnt", i2 == 0]]);
		},
		on_fail: () => {},
	});
};

// Initialize
$(() => {
	(async () => {
		await app.chk_mpa1();
		enqForm.init();
	})();
});


//====================== End Header ========================================================
