/*
06-Mar-2024,lhw-
*/

//====================== Header ========================================================

function enqForm() {}

// Change the container from .fast-obe-enq to .fast-obe-amend
enqForm.getContainer = () => {
	return $(".fast-obe-mp");
};

enqForm.init = () => {
	const c0 = enqForm.getContainer();

	// Menu-related click handlers (login, signup, profile, etc.)
	celUI.click(c0, [
		[
			"btn-amend-bk0",
			() => {
				window.location = getBookingUrl() + "/amend?ts=" + getNowString();
			},
		],
		[
			"btn-sign-up0",
			() => {
				window.location = getBookingUrl() + "/signup?ts=" + getNowString();
			},
		],
		[
			"btn-bk-profile0",
			() => {
				window.location = getBookingUrl() + "/memb-profile?ts=" + getNowString();
			},
		],
		[
			"btn-bk-msg0",
			() => {
				window.location = getBookingUrl() + "/memb-mailbox?ts=" + getNowString();
			},
		],
		[
			"btn-bk-hist0",
			() => {
				window.location = getBookingUrl() + "/booking-list?ts=" + getNowString();
			},
		],
		[
			"btn-login0",
			() => {
				// If currently labeled "logout", then call logout; otherwise go to login page
				if (
					isStrEqual(
						text_get_val(c0.find(".btn-login0 .btn-t0")),
						"logout"
					)
				) {
					let mpa1 = app.get_mpa1();
					if (mpa1) {
						ajaxCall({
							check_status: false,
							p: {
								c: "my-acct",
								a: "logout",
								data: {
									sess_id: mpa1.b,
								},
							},
							on_success: (d2) => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
							on_fail: () => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
						});
					} else {
						window.location =  getBookingUrl() + "/?ts=" + getNowString();
					}
				} else {
					window.location =  getBookingUrl() + "/login?ts=" + getNowString();
				}
			},
		],
	]);

	// Membership check for toggling menu items (logout vs login, etc.)
	const mpa1 = app.get_mpa1();
	if (mpa1 && mpa1.b) {
		let ime = app.get_id();
		if (ime) {
			// Hide sign-up group, show member set
			c0.find(".g-set").hide();
			c0.find(".memb-set").show();

			// Change Login button to Logout
			text_set_val(c0.find(".btn-login0 .btn-t0"), "Logout");

			// Show greeting in .ime3
			text_set_val(c0.find(".ime3"), "Helo " + ime);

			// Load any unread message count
			enqForm.load_notif_cnt();
		}
	}
};

// Load unread message count for the mailbox menu icon
enqForm.load_notif_cnt = () => {
	ajaxCall({
		p: {
			c: "bk-op",
			a: "msg-unread-cnt",
			data: {
				db_id: db_id,
				sess_id: app.get_id2(),
			},
		},
		check_status: false,
		on_success: (d2) => {
			const c0 = $(".btn-bk-msg0");
			let c2 = c0.find(".unread-cnt");
			if (c2.length == 0) {
				c2 = $('<div class="unread-cnt"></div>');
				c0.append(c2);
			}

			let i2 = arrLen(d2.data) > 0 ? toInt(d2.data[0].count) : 0;
			text_set_val(c2, i2);
			hide_input(c0, [["unread-cnt", i2 == 0]]);
		},
		on_fail: () => {},
	});
};

// Initialize
$(() => {
	(async () => {
		await app.chk_mpa1();
		enqForm.init();
	})();
});


//====================== End Header ========================================================


//==============================================================================

function membProfile() {}
membProfile.udf_list = null;

membProfile.getContainer = () => {
    return $('.fast-obe-mp');
};

membProfile.init = () => {
    const c0 = membProfile.getContainer();

    (async () => {
        await membProfile.load_country();
        await membProfile.load_data();
    })();

    celUI.click(c0,
        [
            ['btn-submit-mp0', membProfile.on_submit_click],
            ['btn-chg-pwd0',
                () => {
                    window.location = getBookingUrl() + "/chg_pwd?ts=" + getNowString();
                }], 
            ['btn-restart0',
                () => {
                    window.location = getBookingUrl() + "/?ts=" + getNowString();
                }],

        ]);

};


//------------------------------------------------------------------------------
membProfile.load_country = () => {
    return new Promise((resolve, reject) => {
        const data = {
            db_id: db_id,
            sess_id: app.get_id2(),
        };

        ajaxCall({
            p: {
                c: 'bk-op',
                a: 'country',
                data: data,
            },
            on_success: (d2) => {
                const c0 = membProfile.getContainer();
                const c2 = c0.find('.nationality-input');
                cbo_clear(c2);
                cbo_add_item(c2, '--Select--', '');

                celLoop.each(d2.data, (o2) => {
                    cbo_add_item(c2, o2.country, o2.country_id);
                });

                resolve();
            },
            on_fail: () => {
                resolve();
            }
        });
    });
};

//------------------------------------------------------------------------------
membProfile.load_data = () => {
    return new Promise((resolve, reject) => {
        ajaxCall({
            check_status: false,
            p: {
                c: 'my-acct',
                a: 'profile',
                data: {
                    db_id: db_id,
                    sess_id: app.get_id2(),
                    axn2: 'g',
                },
            },
            on_success: (d2) => {
                if (arrLen(d2.data) > 0) {
                    const c0 = membProfile.getContainer();
                    const o2 = d2.data[0];

                    text_set_val(c0,
                        [
                            ['f-name-input', o2.f_name],
                            ['l-name-input', o2.l_name],
                            ['mobile-phone-input', o2.mobile_phone],
                            ['nationality-input', o2.country_id],
                        ]);
                }

                resolve();
            },
            on_fail: () => {
                resolve();
            }
        });
    });
};

//------------------------------------------------------------------------------
membProfile.on_submit_click = () => {
    if (!celClickOnce.acqLock('membProfile.on_submit_click')) {
        return;
    }

    const unlock = () => {
        celClickOnce.release('membProfile.on_submit_click');
    };

    //-------------------------
    const c0 = membProfile.getContainer();
    const o2 = {
        db_id: db_id,
        sess_id: app.get_id2(),
        axn2: 'gs'
    };

    text_get_val2(c0, o2,
        [
            ['f_name', 'f-name-input'],
            ['l_name', 'l-name-input'],
            ['mobile_phone', 'mobile-phone-input'],
            ['country_id', 'nationality-input'],
        ]);

    if (isStrEmpty(o2.f_name)) {
        msgbox.show('First name cannot be blank');
        unlock();
        return;
    }

    if (isStrEmpty(o2.l_name)) {
        msgbox.show('Last name cannot be blank');
        unlock();
        return;
    }

    if (isStrEmpty(o2.country_id)) {
        msgbox.show('Nationality cannot be blank');
        unlock();
        return;
    }

    //-------------------------
    ajaxCall({
        p: {
            c: 'my-acct',
            a: 'profile',
            data: o2,
        },
        on_success: (d2) => {
            msgbox.show('The changes has been saved');
            unlock();
        },
        on_fail: () => {
            unlock();
        }
    });

};

//------------------------------------------------------------------------------
$(() => {
    (async () => {
        if (await app.chk_mpa1()) {
            membProfile.init();
        }
        else {
            window.location.href =  getBookingUrl() + "/?ts=" + getNowString();
        }
    })();
});
