/*
06-Mar-2024,lhw-
- the hotel configuation.
- this file must be included in all html files.
*/

// the FAST OBE live URL.
var _base_url = _base_url || 'https://obe.fastsoftware.biz/fastobe';

// the hotel id assigned by the system.
const db_id = 'ab6ca881-e1fa-4ab3-a07d-3304c68fc488';


function app() {}


//------------------------------------------------------------------------------
app.list_pwd_pol = function(p0, c0) {
    p0._pwd_pol = null;

    ajaxCall({
        p: {
            c: 'pwd-policy',
        },
        on_success: function(d2) {
            p0._pwd_pol = d2.data;
            const o2 = d2.data;

            text_set_val(c0,
                [
                    ['min-len2', o2.pub_set.min_len],
                    ['max-len2', o2.pub_set.max_len],
                    ['incl-alpha2', formatValue(o2.pub_set.include_alphabet, 'yn')],
                    ['incl-num2', formatValue(o2.pub_set.include_numeric, 'yn')],
                    ['incl-symbol2', formatValue(o2.pub_set.include_symbol, 'yn')],
                    ['mix-char2', formatValue(o2.pub_set.mix_case, 'yn')],
                ]);

            if (!o2.pub_set.include_alphabet) {
                c0.find('.incl-alpha0').hide();
            }

            if (!o2.pub_set.include_numeric) {
                c0.find('.incl-num0').hide();
            }

            if (!o2.pub_set.include_symbol) {
                c0.find('.incl-symbol0').hide();
            }

            if (!o2.pub_set.mix_case) {
                c0.find('.mix-char0').hide();
            }
        }
    });
};

//------------------------------------------------------------------------------
app.chk_pwd_pol = function (p0, c0, e) {
    const c2 = $(e.target);
    let s0 = text_get_val(c2);
    const pol = p0._pwd_pol;

    //reset before validation
    p0._pwd_pol_result = null;
    c0.find('.pwd-notes .material-icons').removeClass('img-ok').addClass('img-not-met');

    // start validation
    s0 = s0.trim();
    const len = s0.length;
    // console.log(len, s0)

    if (len < pol.pub_set.min_len) {
        p0._pwd_pol_result = `Password must be at least ${pol.pub_set.min_len}`;
    }
    else {
        c0.find('.min-len0 .material-icons').removeClass('img-not-met').addClass('img-ok');

        if (len > pol.pub_set.max_len) {
            p0._pwd_pol_result = `Password cannot be longer than ${pol.pub_set.max_len} characters`;
        }
        else {
            c0.find('.max-len0 .material-icons').removeClass('img-not-met').addClass('img-ok');
        }
    }

    let s2, b2;
    if (pol.pub_set.include_alphabet) {
        const rg = /[a-zA-Z]/g;
        s2 = s0.replace(rg, '');
        if (s2.length == len) {
            p0._pwd_pol_result = `Password must include at least one letter`;
        }
        else {
            c0.find('.incl-alpha0 .material-icons').removeClass('img-not-met').addClass('img-ok');
        }

        if (pol.pub_set.mix_case) {
            b2 = true;
            const rg_lower_case = /[a-z]/g;
            s2 = s0.replace(rg_lower_case, '');
            if (s2.length == len) {
                p0._pwd_pol_result = `Password must include at least one lower case letter`;
                b2 = false;
            }

            const rg_upper_case = /[A-Z]/g;
            s2 = s0.replace(rg_upper_case, '');
            if (s2.length == len) {
                p0._pwd_pol_result = `Password must include at least one upper case letter`;
                b2 = false;
            }

            if (b2) {
                c0.find('.mix-char0 .material-icons').removeClass('img-not-met').addClass('img-ok');
            }
        }
    }

    if (pol.pub_set.include_numeric) {
        const rg = /[0-9]/g;
        s2 = s0.replace(rg, '');
        if (s2.length == len) {
            p0._pwd_pol_result = `Password must include at least one numeric`;
        }
        else {
            c0.find('.incl-num0 .material-icons').removeClass('img-not-met').addClass('img-ok');
        }
    }

    if (pol.pub_set.include_symbol) {
        const rg = /[\!\"\#\$\%\&\'\(\)\*\+\,\/\:\;\<\=\>\?\@\[\]\\\^\`\{\}\|\~\.]/g;
        s2 = s0.replace(rg, '');
        if (s2.length == len) {
            p0._pwd_pol_result = `Password must include at least one symbol such as comma or dot`;
        }
        else {
            c0.find('.incl-symbol0 .material-icons').removeClass('img-not-met').addClass('img-ok');
        }
    }
};

//------------------------------------------------------------------------------
app.set_mpa1 = function (v, v2) {
    let o2 = {
        a: (new Date).getTime(),
        b: v,
        c: Math.random().toString(),
        v2: v2,
    };
    data.set_value('mpa11', o2);
};

app.get_mpa1 = function () {
    let o2 = data.get_obj('mpa11');
    if (o2 && o2.a) {
        let n1 = new Date(o2.a);
        let n2 = new Date();

        if (dateDiff.inMinutes(n1, n2) > 15) {
            // expired
            data.remove('mpa11');
            o2 = null;
        }
        else {
            // update last access
            o2.a = n2.getTime();
            data.set_value('mpa11', o2);
        }
    }
    return o2;
};

app.get_id = () => {
    let o2 = app.get_mpa1();
    if (o2 && o2.v2) {
        return o2.v2.login_id;
    }
};

app.get_id2 = () => {
    let o2 = app.get_mpa1();
    if (o2 && o2.v2) {
        return o2.b;
    }
};

app.chk_mpa1 = async function(skip_redir) {
    return new Promise((resolve, reject) => {
        const i = app.get_id2();
        if (!i) {
            resolve(false);
            return;
        }

        ajaxCall({
            check_status: false,
            p: {
                c: 'bk-op',
                a: 'cs',
                data: {
                    sess_id: i,
                }
            },
            on_success: function(d2) {
                if (d2.msg == 'invalid_session') {
                    //reset the data
                    data.remove('mpa11');

                    if (!skip_redir) {
                        // nav to home page
                        setTimeout(() => {
                            window.location.href =  getBookingUrl() + "/?ts=" + getNowString();
                        }, 100);
                    }

                    resolve(false);
                }
                else {
                    resolve(true);
                }
            }
        });
    });
};

