/*
06-Mar-2024,lhw-
*/

//==============================================================================

function enqForm() {}
enqForm.eid_state = 0;
enqForm.special_code = "";

enqForm.getContainer = () => {
	return $(".searchForm");
};

enqForm.init = () => {

	const c0 = enqForm.getContainer();

	const paramArrival = getParam("arrival");    // e.g., 17.Apr.2025
	const paramDeparture = getParam("departure");

	enqForm.eid_state = 0;
	const today = dateValue(new Date());

	let c2 = c0.find(".search-arr-input");
	dt_make(c2, { onSelected: enqForm.on_arr_change });

	c2 = c0.find(".search-dep-input");
	dt_make(c2, { onSelected: enqForm.on_dep_change });

	if (paramArrival && paramDeparture) {
		const arrDate = new Date(paramArrival);
		const depDate = new Date(paramDeparture);
	
		// Apply range and value from URL
		dt_set_val(c0.find(".search-arr-input"), arrDate);
		dt_set_range(c0.find(".search-arr-input"), today);
		dt_set_val(c0.find(".search-dep-input"), depDate);
		dt_set_range(c0.find(".search-dep-input"), today);
	} else {
		// Default behavior (no URL param)
		dt_set_val(c0.find(".search-arr-input"), today);
		dt_set_range(c0.find(".search-arr-input"), today);
	
		dt_set_val(c0.find(".search-dep-input"), addDays(today, 1));
		dt_set_range(c0.find(".search-dep-input"), today);
	}
	
	// Menu-related click handlers (login, signup, profile, etc.)
	celUI.click(c0, [
		// [UPDATE] 2024-12-12, AL - enquiry.js: -
		["btn-slide-close", enqForm.closeSlide],
		[
			"btn-slide-prev",
			() => {
				enqForm.plusSlides(-1);
			},
		],
		[
			"btn-slide-next",
			() => {
				enqForm.plusSlides(1);
			},
		],

		// [UPDATE] 2025-01-09, AL - enquiry.js: Room photo gallery
		["rate-il0", "btn-room-gallery", enqForm.loadRoomPhoto],

		["btn-search0", enqForm.on_search],

		[
			"btn-amend-bk0",
			() => {
				window.location = getBookingUrl() + "/amend?ts=" + getNowString();
			},
		],

		["rate-il0", "btn-bk0", enqForm.on_book_click],

		[
			"btn-sign-up0",
			() => {
				window.location = getBookingUrl() + "/signup?ts=" + getNowString();
			},
		],

		[
			"btn-bk-profile0",
			() => {
				window.location = getBookingUrl() + "/memb-profile?ts=" + getNowString();
			},
		],

		[
			"btn-bk-msg0",
			() => {
				window.location = getBookingUrl() + "/memb-mailbox?ts=" + getNowString();
			},
		],

		[
			"btn-bk-hist0",
			() => {
				window.location = getBookingUrl() + "/booking-list?ts=" + getNowString();
			},
		],

		[
			"btn-login0",
			() => {
				if (
					isStrEqual(
						text_get_val(c0.find(".btn-login0 .btn-t0")),
						"logout"
					)
				) {
					let mpa1 = app.get_mpa1();
					if (mpa1) {
						ajaxCall({
							check_status: false,
							p: {
								c: "my-acct",
								a: "logout",
								data: {
									sess_id: mpa1.b,
								},
							},
							on_success: (d2) => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
							on_fail: () => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
						});
					} else {
						window.location =  getBookingUrl() + "/?ts=" + getNowString();
					}
				} else {
					window.location =  getBookingUrl() + "/login?ts=" + getNowString();
				}
			},
		],
	]);
	

	celUI.change(c0, [["search-night-input", enqForm.on_night_change]]);

	//-------------------------
	const mpa1 = app.get_mpa1();
	if (mpa1 && mpa1.b) {
		let ime = app.get_id();
		if (ime) {
			// c0.find('.btn-sign-up0').hide();
			c0.find(".g-set").hide();
			c0.find(".memb-set").show();

			text_set_val(c0.find(".btn-login0 .btn-t0"), "Logout");
			text_set_val(c0.find(".ime3"), "Helo " + ime);
			// c0.find('.ime3').show();

			enqForm.load_notif_cnt();
		}
	}

	//-------------------------
	(async () => {
		await enqForm.validate_eid();

		// by default, load today's avail.
		// enqForm.on_search();
		// [UPDATE] 2024-12-12, AL - enquiry.js: loadSlideshow() or do not show when return from bk-form.html.
		!getParam("slideshow") || getParam("slideshow") != 0
			? enqForm.loadSlideshow()
			: "";
	})();
};

//------------------------------------------------------------------------------
enqForm.on_night_change = () => {
	const c0 = enqForm.getContainer();
	const arr = dt_get_val(c0.find(".search-arr-input"));
	const dep = c0.find(".search-dep-input");
	const i = toInt(text_get_val(c0.find(".search-night-input")));

	const new_dt = addDays(arr, i);
	dt_set_val(dep, new_dt);
	enqForm.on_search();
};

//------------------------------------------------------------------------------
enqForm.on_arr_change = () => {
	const c0 = enqForm.getContainer();
	const arr = dt_get_val(c0.find(".search-arr-input"));
	const i = toInt(text_get_val(c0.find(".search-night-input")));

	const dep2 = addDays(arr, i);
	dt_set_val(c0.find(".search-dep-input"), dep2);
	enqForm.on_search();
};

//------------------------------------------------------------------------------
enqForm.on_dep_change = () => {
	const c0 = enqForm.getContainer();
	const arr = dt_get_val(c0.find(".search-arr-input"));
	const dep = dt_get_val(c0.find(".search-dep-input"));

	const i = dateDiff.inDays(arr, dep);
	text_set_val(c0.find(".search-night-input"), i);
	enqForm.on_search();
};

//------------------------------------------------------------------------------
enqForm.on_search = () => {
	
	if (!celClickOnce.acqLock("enqForm.on_search")) {
		return;
	}
	const unlock = () => {
		celClickOnce.release("enqForm.on_search");
	};


	const c0 = enqForm.getContainer();
	c0.find(".avail-rate0").show();
	const il0 = c0.find(".rate-il0 > div");
	il0.html('<div class="spinner"></div>');

	const data = {
		db_id: db_id,
		sess_id: app.get_id2(),
		ci_dt: dt_get_val(c0.find(".search-arr-input")),
		co_dt: dt_get_val(c0.find(".search-dep-input")),
		no_of_room: toInt(text_get_val(c0.find(".search-nor-input"))),
		no_of_adult: toInt(text_get_val(c0.find(".search-noa-input"))),
		no_of_kid: toInt(text_get_val(c0.find(".search-nok-input"))),
		// [UPDATE] 2024-12-17, AL - enquiry.js: Pass new parameter.
		special_code: text_get_val(c0.find(".special-code-input")),
	};

	ajaxCall({
		p: {
			c: "bk-op",
			a: "enquiry",
			data: data,
		},
		on_success: (d2) => {
			il0.html("");
			celestial.currency_symbol = d2.data.curr_code || "$";
			text_set_val(c0.find(".curr-code"), celestial.currency_symbol);

			enqForm.special_code = data.special_code;

			const opt = {
				c0: c0,
				cls: "rate-item0",
			};
			const ts = getNowString();

			if (arrLen(d2.data.list) == 0) {
				enqForm.clear_result(true);
				il0.append(
					'<div class="enq-no-data">No rate is available for the period. Please choose other date or contact the hotel.</div>'
				);
			} else {
				celLoop.each(d2.data.list, (o2) => {
					celUI.clone(opt, o2);

					text_set_val(opt.c2, [
						["rate-desc", o2.rate_desc],
						["rt-desc", o2.rt_desc],
						["amt", formatValue(toDbl(o2.amt), "m2")],
					]);

					opt.c2
						.find(".long-desc")
						.html(o2.rate_long_desc.replace(/\n/g, "<br/>"));

					const img = o2.img_file_url || o2.rt_img_file_url;
					opt.c2
						.find("img")
						.attr("src", `${_base_url}q?c=img&f=${img}&ts=${ts}`);

					let c3 = opt.c2.find(".allow-cxl");
					if (toInt(o2.allow_cxl) == 1) {
						text_set_val(c3, "Allow cancellation");
					} else {
						text_set_val(c3, "Not allow cancellation");
					}
					c3 = opt.c2.find(".allow-amend");
					if (toInt(o2.allow_amend) == 1) {
						text_set_val(c3, "Allow amendment");
					} else {
						text_set_val(c3, "Not allow amendment");
					}

					// show r feature
					c3 = opt.c2.find(".rf");
					if (arrLen(o2.r_feature) > 0) {
						celLoop.each(o2.r_feature, (f2) => {
							let c4 = $("<div/>");
							text_set_val(c4, f2.feature_desc);
							c3.append(c4);
						});
					} else {
						c3.parent().remove();
					}

					// show rt feature
					c3 = opt.c2.find(".rtf");
					if (arrLen(o2.rt_feature) > 0) {
						celLoop.each(o2.rt_feature, (f2) => {
							let c4 = $("<div/>");
							text_set_val(c4, f2.feature_desc);
							c3.append(c4);
						});
					} else {
						c3.parent().remove();
					}

					il0.append(opt.c2);
				});
			}

			setTimeout(() => {
				const availableRateSection = document.getElementById("availableRate");
				if (availableRateSection) {
					availableRateSection.style.display = "block"; 
					availableRateSection.scrollIntoView({ behavior: "smooth" });
				}
			}, 500);

			unlock();
		},
		on_fail: (d2) => {
			enqForm.clear_result();
			unlock();
		},
	});
};

//------------------------------------------------------------------------------
// [UPDATE] 2024-12-12, AL - enquiry.js: Function for Slideshow()
enqForm.slideIndex = 1;

enqForm.closeSlide = () => {
	const header = document.querySelector('header.jupiterx-header');
    if (header) {
        header.style.display = 'block';
    }
	if (!celClickOnce.acqLock("enqForm.closeSlide")) {
		return;
	}
	const unlock = () => {
		celClickOnce.release("enqForm.closeSlide");
	};

	const c0 = enqForm.getContainer();
	const slideModal = c0.find(".slideshow-list0");
	slideModal[0].style.display = "none";

	const slideshowContainer = c0.find(".slideshow-container");
	
	//[UPDATE] 2025-01-09, AL - enquiry.js: -
    slideshowContainer.find(".slideshow-item").remove();

	enqForm.slideIndex = 1;

	unlock();
};

enqForm.plusSlides = (n) => {
	enqForm.showSlides((enqForm.slideIndex += n));
};

enqForm.showSlides = (n) => {

	const header = document.querySelector('header.jupiterx-header');
    if (header) {
        header.style.display = 'none';
    }
	
	const c0 = enqForm.getContainer();

	let i;
	let slides = c0.find(".slideshow-item");

	if (slides.length === 0) {
		enqForm.closeSlide();
		return;
	}

	if (n > slides.length) {
		enqForm.slideIndex = 1;
	}

	if (n < 1) {
		enqForm.slideIndex = slides.length;
	}

	for (i = 0; i < slides.length; i++) {
		slides[i].style.display = "none";
	}

	slides[enqForm.slideIndex - 1].style.display = "block";
	slides[enqForm.slideIndex - 1].style.opacity = "1";

};

enqForm.loadSlideshow = () => {
	if (!celClickOnce.acqLock("enqForm.loadSlideshow")) {
		return;
	}
	const unlock = () => {
		celClickOnce.release("enqForm.loadSlideshow");
	};

	const c0 = enqForm.getContainer();

	const today = dateValue(new Date());

	const data = {
		db_id: db_id,
		sess_id: app.get_id2(),
		dt: today,
	};

	ajaxCall({
		p: {
			c: "bk-op",
			a: "slideshow",
			data: data,
		},

		on_success: (d2) => {
			const opt = {
				c0: c0,
				cls: "slideshow-item0",
			};
			const ts = getNowString();

			if (arrLen(d2.data.list) > 0) {
				c0.find(".slideshow-list0").show();
				const il0 = c0.find(".slideshow-il0 > div");

				celLoop.each(d2.data.list, (o2) => {
					celUI.clone(opt, o2);

					const img = o2.img_file_url;
					opt.c2
						.find("img")
						.attr("src", `${_base_url}q?c=img&f=${img}&ts=${ts}`);

					il0.append(opt.c2);
				});
			}
			enqForm.showSlides(enqForm.slideIndex);
			unlock();
		},

		on_fail: (d2) => {
			unlock();
		},
	});
};

// [UPDATE] 2025-01-09, AL - enquiry.js: Function load room photo gallery using Slideshow Model
enqForm.loadRoomPhoto = (e) => {

	if (!celClickOnce.acqLock("enqForm.loadRoomPhoto")) {
		return;
	}
	const unlock = () => {
		celClickOnce.release("enqForm.loadRoomPhoto");
	};

	const c0 = enqForm.getContainer();
	const o2 = celUI.getData(e, "rate-item");

	const data = {
		db_id: db_id,
		sess_id: app.get_id2(),
		rt_id: o2.rt_id,
	};

	ajaxCall({
	    p: {
	        c: 'bk-op',
	        a: 'room-photo',
	        data: data,
	    },

	    on_success: (d2) => {
	        const opt = {
	            c0: c0,
	            cls: 'slideshow-item0',
	        };
	        const ts = getNowString();


	        if (arrLen(d2.data.list) > 0) {
	            c0.find('.slideshow-list0').show();

	            const il0 = c0.find('.slideshow-il0 > div');

				celUI.clone(opt, o2);
				opt.c2.find('img').attr('src', `${_base_url}q?c=img&f=${o2.rt_img_file_url}&ts=${ts}`);
				il0.append(opt.c2);

	            celLoop.each(d2.data.list, (o2) => {
	                celUI.clone(opt, o2);

	                const img = o2.img_file_url;
	                opt.c2.find('img').attr('src', `${_base_url}q?c=img&f=${img}&ts=${ts}`);

	                il0.append(opt.c2);
	            })
	        }

	        enqForm.showSlides(enqForm.slideIndex);
	        unlock();
	    },

	    on_fail: (d2) => {
	        unlock();
	    }
	});
};

//------------------------------------------------------------------------------
enqForm.on_book_click = (e) => {
	if (!celClickOnce.acqLock("enqForm.on_book_click")) {
		return;
	}
	const unlock = () => {
		celClickOnce.release("enqForm.on_book_click");
	};

	const o2 = celUI.getData(e, "rate-item");
	let promo_code;

	const data = {
		db_id: db_id,
		enq_id: o2.enq_id,
		sess_id: app.get_id2(),
		rate_list: [
			{
				rate_line_id: o2.rate_line_id,
				rate_id: o2.rate_id,
			},
		],
		promo_code: promo_code,
	};

	ajaxCall({
		p: {
			c: "bk-op",
			a: "pre-submit",
			data: data,
		},
		on_success: (d2) => {
			if (arrLen(d2.data) == 0) {
				msgbox.err(
					"Your enquriy has expired. Please restart your booking process."
				);
				unlock();
				enqForm.clear_result();
				return;
			}
			
			let u = getBookingUrl() + "/booking-form?ts=" + getNowString() + "&id=" + d2.data[0].resv_id;
			if (enqForm.eid_state == 1) {
				// continue the editing process.
				u += "&eid=" + getParam("eid");
			}

			// [UPDATE] 2024-12-17, AL - enquiry.js: - Passing special_code to bk-form.html
			if (enqForm.special_code && !isStrEmpty(enqForm.special_code)) {
				// continue the editing process.
				u += "&sc=" + enqForm.special_code;
			}

			window.location = u;

			// for dev use
			// unlock();
		},
		on_fail: (d2) => {
			unlock();
		},
	});
};

//------------------------------------------------------------------------------
enqForm.clear_result = (skip_hide_c0) => {
	const c0 = enqForm.getContainer();
	const il0 = c0.find(".rate-il0 > div");
	il0.html("");

	if (!skip_hide_c0) {
		c0.find(".avail-rate0").hide();
	}
};

//------------------------------------------------------------------------------
enqForm.validate_eid = async () => {
	enqForm.eid_state = 0;

	return new Promise((resolve, reject) => {
		const eid = getParam("eid");
		if (!eid || eid.trim().length == 0) {
			resolve();
			return;
		}

		ajaxCall({
			p: {
				c: "bk-op",
				a: "bk-submit-get",
				data: {
					db_id: db_id,
					sess_id: app.get_id2(),
					resv_id: eid,
				},
			},
			on_success: (d2) => {
				if (arrLen(d2.data.bk) > 0) {
					const o2 = d2.data.bk[0];
					if (
						!(
							isStrEqual(o2.status, "cxl") ||
							toInt(o2.pymt_status) == 0 ||
							o2.ci_dt < new Date()
						)
					) {
						// console.log('amend is allowed')
						enqForm.eid_state = 1;
					} else {
						// console.log('amend is not allowed')
						enqForm.eid_state = 2;
					}
				}

				resolve();
			},
			on_fail: () => {
				resolve();
			},
		});
	});
};

//------------------------------------------------------------------------------
/**
 * Show the notification counter.
 */
enqForm.load_notif_cnt = () => {
	ajaxCall({
		p: {
			c: "bk-op",
			a: "msg-unread-cnt",
			data: {
				db_id: db_id,
				sess_id: app.get_id2(),
			},
		},
		check_status: false,
		on_success: (d2) => {
			// console.log('appObe.load_notif_cnt', d2);

			const c0 = $(".btn-bk-msg0");
			let c2 = c0.find(".unread-cnt");
			if (c2.length == 0) {
				c2 = $('<div class="unread-cnt"></div>');
				c0.append(c2);
			}

			let i2 = arrLen(d2.data) > 0 ? toInt(d2.data[0].count) : 0;
			text_set_val(c2, i2);
			hide_input(c0, [["unread-cnt", i2 == 0]]);
		},
		on_fail: () => {},
	});
};

//------------------------------------------------------------------------------
$(() => {
	(async () => {
		await app.chk_mpa1();
		enqForm.init();
	})();
});


//----------------- Kid , Room , Adult Drop Down-------------------------------
/* 
   We'll set initial values from the hidden selects 
   so our new UI is always in sync. 
   Then plus/minus update those selects, 
   so your existing JS sees the correct #adult/#kid/#room.
*/

let roomValue  = 1; 
let adultValue = 1;
let kidValue   = 0;

// At DOM load, read the default from the hidden selects:
document.addEventListener('DOMContentLoaded', function () {
	const selAdult = document.querySelector('.search-noa-input');
	const selKid   = document.querySelector('.search-nok-input');
	const selRoom  = document.querySelector('.search-nor-input');
	
	// Check for URL parameters
	const paramAdult = getParam('adult');
	const paramKid   = getParam('kid');
	const paramRoom  = getParam('room');
	
	// Set values from URL if present, otherwise from existing values
	if (selAdult) {
	adultValue = paramAdult !== null ? parseInt(paramAdult, 10) : parseInt(selAdult.value);
	selAdult.value = adultValue;
	}
	
	if (selKid) {
	kidValue = paramKid !== null ? parseInt(paramKid, 10) : parseInt(selKid.value);
	selKid.value = kidValue;
	}
	
	if (selRoom) {
	roomValue = paramRoom !== null ? parseInt(paramRoom, 10) : parseInt(selRoom.value);
	selRoom.value = roomValue;
	}
	
	// Update UI display based on new values
	updateRoomsGuestUI();
});


/* Sync UI text + hidden selects */
function updateRoomsGuestUI() {
  // Plural labels
  let roomLabel  = roomValue  === 1 ? 'Room'  : 'Rooms';
  let adultLabel = adultValue === 1 ? 'Adult' : 'Adults';
  let kidLabel   = kidValue   === 1 ? 'Kid'   : 'Kids';

  // E.g. "2 Rooms, 1 Adult, 0 Kids"
  let display = `${roomValue} ${roomLabel}, ${adultValue} ${adultLabel}, ${kidValue} ${kidLabel}`;
  document.getElementById('roomsGuestSummary').value = display;

  // Also update the numeric spans
  document.getElementById('roomCount').innerText  = roomValue;
  document.getElementById('adultCount').innerText = adultValue;
  document.getElementById('kidCount').innerText   = kidValue;

  // Update the hidden selects so your existing code sees them
  const selAdult = document.querySelector('.search-noa-input');
  const selKid   = document.querySelector('.search-nok-input');
  const selRoom  = document.querySelector('.search-nor-input');
  if (selAdult) selAdult.value = adultValue;
  if (selKid)   selKid.value   = kidValue;
  if (selRoom)  selRoom.value  = roomValue;
}

// Plus/minus functions for Rooms
function incRooms() {
  // For example, cap it at 10 if you want
  if (roomValue < 10) roomValue++;
  updateRoomsGuestUI();
}
function decRooms() {
  if (roomValue > 1) roomValue--;
  updateRoomsGuestUI();
}

// Plus/minus for Adults
function incAdults() {
  if (adultValue < 10) adultValue++;
  updateRoomsGuestUI();
}
function decAdults() {
  if (adultValue > 1) adultValue--;
  updateRoomsGuestUI();
}

// Plus/minus for Kids
function incKids() {
  if (kidValue < 10) kidValue++;
  updateRoomsGuestUI();
}
function decKids() {
  if (kidValue > 0) kidValue--;
  updateRoomsGuestUI();
}
		
		
// Close the "Rooms & Guests" dropdown when clicking anywhere outside it
document.addEventListener('click', function(event) {
  var panel  = document.getElementById('roomsGuestPanel');
  var button = document.getElementById('roomsGuestSummary');
  
  // If the dropdown is visible, and you click outside of both
  // the dropdown and the summary input, hide it.
  if (
    panel.style.display === 'block' &&
    !panel.contains(event.target) &&
    event.target !== button
  ) {
    panel.style.display = 'none';
  }
});


enqForm.extractParamsAndSearch = () => {
    const params = new URLSearchParams(window.location.search);
    const c0 = enqForm.getContainer();

    // Extract parameters
    const arrival = params.get("arrival");
    const departure = params.get("departure");
    const night = params.get("night");
    const room = params.get("room");
    const adult = params.get("adult");
    const kid = params.get("kid");
    const specialCode = params.get("code") || ""; 

	const ci_dt = new Date(arrival);
    const co_dt = new Date(departure);

    // If all required parameters exist, set values in the input fields
    if (arrival) dt_set_val(c0.find(".search-arr-input"), ci_dt);
    if (departure) dt_set_val(c0.find(".search-dep-input"), co_dt);
    if (night) text_set_val(c0.find(".search-night-input"), night);
    if (room) text_set_val(c0.find(".search-nor-input"), room);
    if (adult) text_set_val(c0.find(".search-noa-input"), adult);
    if (kid) text_set_val(c0.find(".search-nok-input"), kid);
    if (specialCode) text_set_val(c0.find(".special-code-input"), specialCode);

    // Proceed with search if required parameters exist
    if (arrival && departure && night && room && adult && kid) {
        const data = {
            db_id: db_id,
            sess_id: app.get_id2(),
            ci_dt: ci_dt,
            co_dt: co_dt,
            no_of_room: toInt(room),
            no_of_adult: toInt(adult),
            no_of_kid: toInt(kid),
            special_code: specialCode,
        };

        c0.find(".avail-rate0").show();
        const il0 = c0.find(".rate-il0 > div");
        il0.html('<div class="spinner"></div>');

        ajaxCall({
            p: {
                c: "bk-op",
                a: "enquiry",
                data: data,
            },
            on_success: (d2) => {
                il0.html("");
                celestial.currency_symbol = d2.data.curr_code || "$";
                text_set_val(c0.find(".curr-code"), celestial.currency_symbol);

                enqForm.special_code = data.special_code;

                const opt = {
                    c0: c0,
                    cls: "rate-item0",
                };
                const ts = getNowString();

                if (arrLen(d2.data.list) == 0) {
                    enqForm.clear_result(true);
                    il0.append(
                        '<div class="enq-no-data">No rate is available for the period. Please choose another date or contact the hotel.</div>'
                    );
                } else {
                    celLoop.each(d2.data.list, (o2) => {
                        celUI.clone(opt, o2);

                        text_set_val(opt.c2, [
                            ["rate-desc", o2.rate_desc],
                            ["rt-desc", o2.rt_desc],
                            ["amt", formatValue(toDbl(o2.amt), "m2")],
                        ]);

                        opt.c2
                            .find(".long-desc")
                            .html(o2.rate_long_desc.replace(/\n/g, "<br/>"));

                        const img = o2.img_file_url || o2.rt_img_file_url;
                        opt.c2
                            .find("img")
                            .attr("src", `${_base_url}q?c=img&f=${img}&ts=${ts}`);

                        let c3 = opt.c2.find(".allow-cxl");
                        text_set_val(c3, toInt(o2.allow_cxl) == 1 ? "Allow cancellation" : "Not allow cancellation");

                        c3 = opt.c2.find(".allow-amend");
                        text_set_val(c3, toInt(o2.allow_amend) == 1 ? "Allow amendment" : "Not allow amendment");

                        // Show room feature
                        c3 = opt.c2.find(".rf");
                        if (arrLen(o2.r_feature) > 0) {
                            celLoop.each(o2.r_feature, (f2) => {
                                let c4 = $("<div/>");
                                text_set_val(c4, f2.feature_desc);
                                c3.append(c4);
                            });
                        } else {
                            c3.parent().remove();
                        }

                        // Show room type feature
                        c3 = opt.c2.find(".rtf");
                        if (arrLen(o2.rt_feature) > 0) {
                            celLoop.each(o2.rt_feature, (f2) => {
                                let c4 = $("<div/>");
                                text_set_val(c4, f2.feature_desc);
                                c3.append(c4);
                            });
                        } else {
                            c3.parent().remove();
                        }

                        il0.append(opt.c2);
                    });
                }

                // Scroll to available rates section after successful search
                setTimeout(() => {
                    const availableRateSection = document.getElementById("availableRate");
                    if (availableRateSection) {
                        availableRateSection.style.display = "block";
                        availableRateSection.scrollIntoView({ behavior: "smooth" });
                    }
                }, 500); // Adjust timing if needed

            },
            on_fail: (d2) => {
                enqForm.clear_result();
            },
        });
    }
};


document.addEventListener("DOMContentLoaded", function () {
    // Check if the necessary parameters are available in the URL
    const params = new URLSearchParams(window.location.search);
    const arrival = params.get("arrival");
    const departure = params.get("departure");
    const night = params.get("night");
    const room = params.get("room");
    const adult = params.get("adult");
    const kid = params.get("kid");

    // Perform search only if all required parameters are present
    if (arrival && departure && night && room && adult && kid) {
        enqForm.extractParamsAndSearch();
    }
});