﻿'use strict';



const CTL_TYPE_CHECKBOX = 'chk';
const CTL_TYPE_DATE = 'dt';
// drop down list and drop down edit.
const CTL_TYPE_DROPDONWLIST = 'cbo';
const CTL_TYPE_LABEL = 'lbl';
const CTL_TYPE_NUMERIC = 'nb';
const CTL_TYPE_RADIOLIST = 'rb';
const CTL_TYPE_TEXT = 'txt';

//11.Mar.20,lhw-
const CTL_TYPE_IMG = 'img';

//27.Sep.19,lhw-
const CTL_TYPE_MONEY = 'curr';

//19-Nov-2020,lhw-
const CTL_TYPE_HTML = 'html';

//28-Jun-2021,lhw-
const CTL_TYPE_MEMO = 'memo';

//08-Aug-2023,lhw-
const CTL_TYPE_CHECKBOX_LIST = 'chklist';


//4.Mar.17, lhw-stores local settings.
var celestial = $.extend(true, { timezoneOffset: null }, celestial);

celestial.mth = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
celestial.wk = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];

//28.Aug.17,lhw-
celestial.imgFileType = ['bmp', 'jpg', 'jpeg', 'ico', 'gif', 'png', 'tif', 'tiff', 'jpe', 'jfif'];


//2.Nov.17,lhw-localize setting.
//**It should be provided by the ios.
celestial.thousand_separator = ',';
celestial.decimal_separator = '.';
celestial.currency_symbol = '$';

celestial.chk_state = ['btn-checkbox0', 'btn-checkbox'];
//23-Jul-2021,lhw-
celestial.rb_state = ['rbl-chk0', 'rbl-chk'];

//the following cache use by loadResource(). The key is url.
celestial.cache = {};

//12.May.19,lhw-used by celLocalCache. The key is query param in json format.
celestial.data_cache = {};

//12.May.19,lhw-by default, the data_cache is enabled globally.
celestial.data_cache_enable = true;

//12-Oct-2021,lhw-'0'-ajax, '1'-sys/ui.
celestial.pd = {
    ajax_seq_job: [{}, {}]
};

//04-Jul-2022,lhw-
celestial.queue_ajax = false;


if (!('contains' in String.prototype)) {
    String.prototype.contains = function (str, startIndex) {
        return ''.indexOf.call(this, str, startIndex) !== -1;
    };
}

if (!('padLeft' in String.prototype)) {
    String.prototype.padLeft = function (l, c) {
        return Array(l - this.length + 1 >= 0 ? l - this.length + 1 : 0).join(c || ' ') + this;
    };
}
if (!('padRight' in String.prototype)) {
    String.prototype.padRight = function (l, c) {
        return this + Array(l - this.length + 1 >= 0 ? l - this.length + 1 : 0).join(c || ' ');
    };
}


//07-Jul-2022,lhw-restore this function
if (!('extractWithin' in String.prototype)) {
    String.prototype.extractWithin = function (start_char, end_char) {
        let s = this;

        if (typeof s != 'string'
            || typeof start_char != 'string'
            || typeof end_char != 'string'
            || isStrEmpty(s)
            || isStrEmpty(start_char)
            || isStrEmpty(end_char)) {

            return '';
        }

        var pos = s.indexOf(start_char);
        var pos2 = s.indexOf(end_char);

        if (pos > -1 && pos2 > -1) {
            return s.substring(pos + start_char.length, pos2);
        }
        else {
            return s;
        }
    };
}

function arrRemoveItem(arr, i) {
    arr.splice(i, 1);
}

//23-Sep-2020,lhw-
function arrInsertItem(arr, i, obj) {
    arr.splice(i, 0, obj);
}


// get all the items that match the predicate.
function arrWhere(arr, p) {
    if (isUndefinedOrNull(arr)) {
        return [];
    }

    var m = arr.length;
    var o;
    var r = [];

    for (var n = 0; n < m; n++) {
        o = arr[n];
        if (p(o)) {
            r.push(o);
        }
    }

    return r;
}

// returns the first object that meet the predicate.
function arrFindFirst(arr, p) {
    if (isUndefinedOrNull(arr)) {
        return null;
    }

    var m = arr.length;
    var o;

    for (var n = 0; n < m; n++) {
        o = arr[n];
        if (p(o)) {
            return o;
        }
    }

    return null;
}

//14.Oct.16,lhw-insert an item to the top.
function arrInsertFirstItem(arr, o) {
    arr.unshift(o);
}

//22.Dec.16,lhw-
function arrLen(l) {

    //2.Oct.18,lhw-isArray() does not work for FileList object (file to be uploaded)
    // because FileList is not an array.

    //1.May.20,lhw-IN operator does not work for 'object' type. Use hasOwnProperty() instead.
    //18.May.20,lhw-added 'length in l' condition since either condition will be able to detect the field.
    ////if (!isUndefinedOrNull(l) && Array.isArray(l)) {
    ////if (l && length in l) {

    //16.Jun.20,lhw-avoid 'string.length' being return. We must do type checking now.
    ////if (l && (obj_has_fld(l, 'length') || length in l)) {
    ////    return l.length;
    ////}

    // exit immediately if the param is missing or null.
    if (typeof l == 'undefined' || l == null) {
        return 0;
    }

    // for array, returns the length.
    if (Array.isArray(l)) {
        return l.length;
    }

    var t = typeof l;

    if (t == 'function' || t == 'object') {
        try {
            return l.length;
        } catch (e) {
            // ignore the err
        }
    }

    return 0;
}


function isUndefined(val) {
    return (typeof val === 'undefined');
}

function isUndefinedOrNull(val) {
    return (typeof val === 'undefined') || (val === null);
}

function isNull(val) {
    return (typeof val === 'undefined') || (val === null);
}

function isNotNull(val) {
    return !isNull(val);
}

//17.Apr.17,lhw-returns b if a is null/undefined. Otherwise, returns a.
//25.Apr.20,lhw-added param 'ignore_empty'.
function coalesce(a, b, ignore_empty) {

    //25.Apr.20,lhw-
    if (ignore_empty && isStrEmpty(a)) {
        return b;
    }

    return isUndefinedOrNull(a) ? b : a;
}

function isStrEmpty(val) {
    //6.Oct.18,lhw-
    ////if (val) {
    if (!((typeof val === 'undefined') || (val === null))) {

        if (typeof val !== 'string') {
            val = val.toString();
        }

        return (val.length === 0 || val.trim().length === 0);
    }

    return true;
}

//11-feb-14,lhw
function isStrEqual(s1, s2) {

    //25.Sep.18,lhw-should check nullability.
    ////if (s1 && s2) {
    if (s1 != null && s2 != null) {
        // ensure that it is string type
        if (typeof s1 !== 'string') {
            s1 = s1.toString();
        }

        if (typeof s2 !== 'string') {
            s2 = s2.toString();
        }

        return (s1.length === s2.length && s1.toLowerCase() === s2.toLowerCase());
    }

    return false;
}

//20.Oct.18,lhw-
function isStr(s) {
    return typeof (s) === 'string' || s instanceof String;
}

//27.Jul.16,lhw-
function isOK(s) {
    if (typeof s === 'string') {
        return isStrEqual(s, 'ok');
    }
    else {
        return s && obj_has_fld(s, 'msg') && isStrEqual(s.msg, 'ok');
    }
}

//11-feb-14,lhw
function isStrContain(s1, s2) {
    if (isUndefinedOrNull(s1) || isUndefinedOrNull(s2)) {
        return false;
    }
    else if ((s1.length > 0) && (s2.length > 0) && (s1.toLowerCase().indexOf(s2.toLowerCase()) >= 0)) {
        return true;
    }
    else {
        return false;
    }
}

//14.May.16,lhw-
function isIn(a, arr) {
    if (a && arr && Array.isArray(arr)) {

        // for string, we need to use case insensitive comparison.
        if (typeof a === 'string') {
            var m = arr.length;

            for (var i = 0; i < m; i++) {
                if (isStrEqual(arr[i], a)) {
                    return true;
                }
            }
        }
        else {
            // for type other string, use the Array built-in function.
            return (arr.indexOf(a) > -1);
        }
    }
    return false;
}

function extractStringByLen(s, look_for, len) {
    var pos = s.indexOf(look_for);

    if (pos > -1) {
        return s.substring(pos + look_for.length, pos + look_for.length + len);
    }
    else {
        return s;
    }
}

//to generate a unique URL to make sure that the browser send the request to the server.
function getNowString() {
    return (new Date()).getTime();
}



/**
 * 26-Jan-2022,lhw-
 * @param {Boolean} - if true, include the century in the result (YYYYMMDDHHmmss, 14 char).
 * Otherwise, returns 'YYMMDDHHmmss' (12 char).
 * @returns {String} - returns current timestamp.
 */
function currentTimeStamp(with_century) {
    let ts = new Date();
    ts.setMinutes(ts.getMinutes() - ts.getTimezoneOffset());

    let i = (with_century ? 0 : 2);
    return ts.toISOString().replace(/-/g, '').replace(/:/g, '').replace('T', '').substring(i, 14);
}


function getUniqueID(without_ts) {
    //13-Feb-2022,lhw-revised the result so that it is more predictable.
    // return getNowString() + Math.random().toString().replace('.', '');

    if (!obj_has_fld(celestial, 'msg_id')) {
        celestial.msg_id = 0;
    }

    ++celestial.msg_id;
    // console.log('celestial.msg_id',celestial.msg_id);

    // cap the msg_id to 4 digits and recycle it in every 10k cycle.
    if (celestial.msg_id >= 10000) {
        celestial.msg_id = 1;
    }

    if (without_ts) {
        return celestial.msg_id;
    }

    let id;
    if (celestial.msg_id < 10) {
        id = '000' + celestial.msg_id.toString();
    }
    else if (celestial.msg_id < 100) {
        id = '00' + celestial.msg_id.toString();
    }
    else if (celestial.msg_id < 1000) {
        id = '0' + celestial.msg_id.toString();
    }
    else {
        id = celestial.msg_id.toString();
    }

    return currentTimeStamp() + id;
}

//12-jun-13,lhw-
function isJQueryObject(val) {
    return (val instanceof jQuery);
}


//12-jun-13,lhw- always returns jquery object.
function getJObject(ctl_id) {
    if (isUndefinedOrNull(ctl_id)) {
        return $('');
    }

    var c = null;
    if (isJQueryObject(ctl_id)) {
        c = ctl_id;
    }
    else if (typeof ctl_id === 'string') {
        if (ctl_id.length === 0) {
            return $('');
        }

        var ch = ctl_id.substring(0, 1);

        // if the caller did not specify the type of selector to be used,
        // we will use the 'id' selector.
        if (ch != '#' && ch != '.') {
            ch = '#';
            c = $(ch + ctl_id);

            if (c.length === 0) {
                c = $('.' + ctl_id);
            }
        }
        else {
            // the selector has been included. Skip guessing it.
            ch = '';
            c = $(ch + ctl_id);
        }
    }
    else if (typeof ctl_id === 'object') {
        c = $(ctl_id);
    }

    if (c === null) {
        // Avoid returning null value and crash the rest of the process.
        // Just return the JQuery object with zero length.
        c = $('');
    }

    return c;
}

//13.May.16,lhw-
//23-Jul-2021,lhw-allows passing 'b' as an array of elem+state.
function disableInput(c, b) {

    function _disable_input(c2, b2) {
        if (typeof b2 === 'undefined') {
            b2 = true;
        }

        if (c2.hasClass('celDatePicker')) {

            try {
                //25.Nov.18,lhw-this proc handles the date picker as well.
                // After disabled the celDatePicker, disable the input box.
                c2.celDatePicker('option', 'disable', b2);

            } catch (e) {
                //25.Nov.18,lhw-silent the err
            }
        }
        else if (c2.hasClass('celchk')) {

            try {
                //31.Jul.19,lhw-
                c2.celCheckbox('setEnable', !b2);
                return;

            } catch (e) {
                //25.Nov.18,lhw-silent the err
            }
        }
        else if (c2.hasClass('celrblist')) {

            try {
                //12.Aug.19,lhw-
                c2.celRadioButtonList('setEnable', !b2);
                return;
            } catch (e) {
                //25.Nov.18,lhw-silent the err
            }
        }
        else if (c2.hasClass('celcbo')) {
            //23-Jul-2021,lhw-
            c2.celDropDownList('setEnable', !b2);
            return;
        }

        if (b2) {
            getJObject(c2).attr('disabled', 'disabled');
        }
        else {
            getJObject(c2).attr('disabled', null);
        }
    }

    //-------------------------
    if (isJQueryObject(c) && Array.isArray(b)) {
        //23-Jul-2021,lhw-
        let c3, b3;

        celLoop.each(b, function (b2) {
            c3 = c.find(elemCss(b2[0]).wrap());

            if (arrLen(b2) == 2) {
                b3 = b2[1];
            }

            _disable_input(c3, b3);
        });

    }
    else {
        _disable_input(c, b);
    }

}

// 11-apr-14,lhw
function boolToInt(b) {
    return b ? 1 : 0;
}

function intToBool(i) {
    return (i == 1);
}

/**
 * Convert any value to integer value.
 * @param {Any} i
 * @returns
 */
function toInt(i) {
    if (isUndefinedOrNull(i)
        //09-Feb-2023,lhw-
        //12-Jul-2023,lhw-bug fixed-this will cause '1,234' become '0'. It should handle null and undefined.
        // || isNaN(i)
        || isUndefinedOrNull(i)
    ) {
        return 0;
    }

    if (typeof i == 'boolean') {
        //8.Sep.18,lhw-
        return boolToInt(i);
    }

    //17.Jun.20,lhw-standardize the process.
    ////var v, i2 = i.toString().replace(/,/g, '');
    //////remove the negative symbol.
    ////if (i2.substring(0, 1) === '(' && i2.substring(i2.length - 1, i2.length) === ')') {
    ////    i2 = i2.replace('(', '-').replace(')');
    ////}

    var v;
    var i2 = removeThousandSeparator(i);
    i2 = removeAcctNegSymbol(i2);

    // using 10 base to parse the value.
    v = parseInt(i2, 10);

    if (!isNaN(v)) {
        return v;
    }

    return 0;
}

function toDbl(i) {
    if (isUndefinedOrNull(i)) {
        return 0;
    }

    //17.Jun.20,lhw-standardize the process.
    ////var v, i2 = i.toString().replace(/,/g, '');
    //////remove the negative symbol.
    ////if (i2.substring(0, 1) === '(' && i2.substring(i2.length - 1, i2.length) === ')') {
    ////    i2 = i2.replace('(', '-').replace(')');
    ////}

    var i2 = removeThousandSeparator(i);
    i2 = removeAcctNegSymbol(i2);

    let v = parseFloat(i2);
    if (!isNaN(v)) {
        return v;
    }

    return 0;
}

//10-Jul-2022,lhw-convert the value to the given type.
function toType(v2, dt) {
    switch (dt) {
        case 'd':
            return toDate(v2);
        case 'm0':
            return toInt(v2);
        case 'm2':
        case 'm4':
        case 'm6':
            return toDbl(v2);
        case 'sys_d':
            return toSysDate(v2);
        case 'sys_dt':
            return toSysDateTime(v2);
        case 't':
            return fmt_time_input(v2);
        case 'yn':
            return boolToInt(!!v2);
        default:
            return v2;
    }
}


//19-feb-14,lhw
function isTrue(b) {
    return !isUndefinedOrNull(b) && (b === '1' || b === 1 || b === 'true' || b === true);
}

// format the value in a text input with currency format.
function fmtCurrency(txt_id) {
    if (isUndefinedOrNull(txt_id)) {
        return;
    }

    if (isNumeric(txt_id) || txt_id instanceof Number) {
        return formatValue(toDbl(txt_id), 'm2');
    }
    else {
        var a;
        var b;
        a = getJObject(txt_id);

        if (a) {
            b = a.val();

            if (b) {
                a.val(toDbl(b).toFixed(2));
            }
        }
    }
}

//24-apr-12,lhw
function fmt4Decimal(txt_id) {
    if (isUndefinedOrNull(txt_id)) {
        return;
    }

    let a = getJObject(txt_id);

    if (a) {
        let b = a.val();
        if (b) {
            a.val(toDbl(b).toFixed(4));
        }
    }
}

//17.Jun.20,lhw-this is to ensure that all procs are relying on celestial.thousand_separator.
function removeThousandSeparator(i) {

    //17.Jun.20,lhw-the old way of remove the comma symbol
    ////var s = i.toString().replace(/,/g, '');
    if (typeof i == 'undefined' || i == null) {
        return '';
    }

    if (typeof celestial.thousand_separator == 'undefined' || celestial.thousand_separator == null) {
        celestial.thousand_separator = ',';
    }
    var s;

    try {
        var r = new RegExp(celestial.thousand_separator, 'g');

        s = i.toString().replace(r, '');
    }
    catch (x) {
        // fallback to the old standard way.
        s = i.toString().replace(/,/g, '');
    }

    return s;
}

//17.Jun.20,lhw-convert '(' and ')' symbol back to '-' (negative) symbol
// so that the value is recognize as -ve value by computer.
function removeAcctNegSymbol(i) {
    if (typeof i == 'undefined' || i == null) {
        return '';
    }

    if (typeof i != 'string') {
        i = i.toString();
    }

    if (i.substring(0, 1) === '(' && i.substring(i.length - 1, i.length) === ')') {
        i = i.replace('(', '-').replace(')');
    }

    return i;
}

//format the string with thousand separator.
function addCommas(nStr) {
    if (isUndefinedOrNull(nStr)) {
        return '';
    }

    nStr += '';

    var x = nStr.split('.');
    var x1 = x[0];
    //var x2 = x.length > 1 ? '.' + x[1] : '';
    var x2 = (x.length > 1) ? (celestial.decimal_separator + x[1]) : '';
    var rgx = /(\d+)(\d{3})/;

    while (rgx.test(x1)) {
        //x1 = x1.replace(rgx, '$1' + ',' + '$2');
        x1 = x1.replace(rgx, '$1' + celestial.thousand_separator + '$2');
    }

    return x1 + x2;
}

function confirmDelete() {
    return confirm('Are you sure you want to delete the current record? Click OK to continue');
}

function getParameterByName(name) {

    //30.Mar.20,lhw-bug fixed-should check the hash first.
    //var u = window.location.hash;
    //if (isStrEmpty(u)) {
    //    // starts with '?'
    //    u = window.location.search;
    //}
    //27.Jul.20,lhw-must include both
    var u = window.location.search;
    if (isStrEmpty(u)) {
        u += window.location.hash;
    }

    ////var match = new RegExp('[?&]' + name + '=([^&]*)').exec(window.location.search);
    var match = new RegExp('[?&]' + name + '=([^&]*)').exec(u);
    return match && decodeURIComponent(match[1].replace(/\+/g, ' '));
}

function getParamByNameFromUrl(name, url) {
    var match = new RegExp('[?&]' + name + '=([^&]*)').exec(url);
    return match && decodeURIComponent(match[1].replace(/\+/g, ' '));
}

function getParam(name, url) {
    if (typeof url == 'undefined' || url === null) {
        return getParameterByName(name);
    }
    else {
        return getParamByNameFromUrl(name, url);
    }
}

//9.Apr.17,lhw-parse the query string/archor into an array
function getAllParam(u) {
    var o = {};

    if (isUndefinedOrNull(u)) {
        u = window.location.hash;

        if (isStrEmpty(u)) {
            // starts with '?'
            u = window.location.search;
        }
    }

    let pos = u.indexOf('#');
    if (pos >= 0) {
        pos = u.indexOf('#');
        o[0] = '#';
    }
    else {
        pos = u.indexOf('?');
        o[0] = '?';

        // exit because no param.
        if (pos < 0) {
            return {};
        }
    }


    //22-Jul-2022,lhw-bug fixed-the first param is missing.
    // let pos2 = u.indexOf('&');
    // if (pos2 < 0) {
    //     // no param, only the query string OR anchor.
    //     o[1] = u.replace(o[0], '');
    // }
    // else {
    //     o[1] = u.substr(pos + 1, pos2 - pos - 1);
    //     u = u.substr(pos2 + 1, u.length - pos2);

    //     let a = u.split('&');
    //     let m = arrLen(a);

    //     for (var i = 0; i < m; i++) {
    //         let o2 = a[i];
    //         let pos = o2.indexOf('=');
    //         let k = o2.substring(0, pos);
    //         let v = o2.substring(pos + 1, o2.length);
    //         o[k] = v;
    //     }
    // }

    //07-Dec-2022,lhw-bug fixed
    // o[1] = u.substring(1, u.length);
    // let a = o[1].split('&');
    o[1] = u.substring(0, u.length);
    let a = o[1].substring(pos + 1, o[1].length).split('&');

    //11-Jan-2023,lhw-remove the '#' from the value.
    if (o[1][0] == o[0]) {
        o[1] = o[1].substring(1, o[1].length);
    }

    const m = arrLen(a);

    for (var i = 0; i < m; i++) {
        let o2 = a[i];
        let pos = o2.indexOf('=');
        if (pos >= 0) {
            let k = o2.substring(0, pos);
            let v = o2.substring(pos + 1, o2.length);
            o[k] = v;
        }
        else {
            //11-Jan-2023,lhw-it has the key but value section is missing.
            o[o2] = '';
        }
    }

    //31.May.17,lhw-
    o.getParam = function (k) {
        if (obj_has_fld(o, k)) {
            return o[k];
        }

        return null;
    };

    return o;
}

//9.Jul.16,lhw-append css to the current page.
//21-mar-17,lhw-replaced by addCssFile().
//function loadCss(u) {
//    $('head').append('<link rel="stylesheet" href="' + u + '" type="text/css"/>');
//}

function fromSysDate(dt) {
    if (isUndefinedOrNull(dt)) {
        return null;
    }

    var s = dt.toString();

    //10-May-2021,lhw-'dt' could be '2021-10-25'.
    if (s.indexOf('-') > 0) {
        s = s.replace(/-/g, '');
    }

    if (s.indexOf('/') > 0) {
        s = s.replace(/\//g, '');
    }

    if (s.indexOf('.') > 0) {
        s = s.replace(/\./g, '');
    }

    if (s && s.length >= 8) {
        var y = toInt(s.substr(0, 4));
        var m = toInt(s.substr(4, 2)) - 1;
        var d = toInt(s.substr(6, 2));
        var hh = 0;
        var mm = 0;
        var ss = 0;
        //23-Sep-2021,lhw-new section.
        var ms = 0;

        //23-Sep-2021,lhw-code retired
        //30.Aug.18,lhw-bug fixed-omitted the conditions on checking the symbols.
        // if (s.length === 19 && s.contains('-') && s.contains(':')) {
        //     //20.Sep.16,lhw-this is the data parsed by Newtonsoft: '2016-08-20T00:00:00'
        //     y = toInt(s.substr(0, 4));
        //     m = toInt(s.substr(5, 2)) - 1;
        //     d = toInt(s.substr(8, 2));
        //     hh = toInt(s.substr(12, 2));
        //     mm = toInt(s.substr(15, 2));
        //     ss = toInt(s.substr(18, 2));
        // }
        // else if (s.length >= 14) {
        //     hh = toInt(s.substr(8, 2));
        //     mm = toInt(s.substr(10, 2));
        //     ss = toInt(s.substr(12, 2));
        // }

        y = toInt(s.substr(0, 4));
        m = toInt(s.substr(4, 2)) - 1;
        d = toInt(s.substr(6, 2));
        hh = toInt(s.substr(8, 2));
        mm = toInt(s.substr(10, 2));
        ss = toInt(s.substr(12, 2));

        if (s.length >= 17) {
            ms = toInt(s.substr(14, 3));
        }

        return new Date(y, m, d, hh, mm, ss, ms);
    }
    else {
        return null;
    }
}

//11.Feb.18,lhw-time=> hh:mm:ss
function fromSysTime(time) {
    var c;
    var hh;
    var mm;
    var ss;

    c = time.replace('.').split(':');
    hh = 0;
    mm = 0;
    ss = 0;

    if (c.length >= 3) {
        ss = toInt(c[2]);
    }

    if (c.length >= 2) {
        mm = toInt(c[1]);
    }

    if (c.length == 1) {
        //25.Jul.19,lhw-bug fixed on 'time=1030' without the separator.
        var t = time.replace('.');
        if (t.length >= 2) {
            hh = t.substr(0, 2);
        }

        if (t.length >= 4) {
            mm = t.substr(2, 2);
        }

        if (t.length >= 6) {
            ss = t.substr(4, 2);
        }
    }
    else {
        hh = toInt(c[0]);
    }

    if (mm < 0 || mm > 59) {
        mm = 0;
    }
    if (ss < 0 || ss > 59) {
        ss = 0;
    }
    if (hh < 0 || hh > 23) {
        hh = 0;
    }

    //10-Jul-2023,lhw-bug fixed
    // c = new Date(1, 1, 1, hh, mm, ss);
    c = new Date(1, 0, 1, hh, mm, ss);
    return c;
}

// 'dt' must be Date object.
function toSysDate(dt, sep, with_century) {
    if (isUndefinedOrNull(dt) || !isDate(dt)) {
        return '';
    }

    //15-Sep-2023,lhw-
    sep = sep || '';

    let yr = dt.getFullYear().toString();
    if (with_century === false) {
        yr = yr.substring(2, 4);
    }

    return yr
        + sep
        + (dt.getMonth() + 1).toString().padLeft(2, '0')
        + sep
        + dt.getDate().toString().padLeft(2, '0');
}

// 'dt' must be Date object.
function toSysDateTime(dt) {
    if (isUndefinedOrNull(dt) || !isDate(dt)) {
        return '';
    }

    return toSysDate(dt)
        + dt.getHours().toString().padLeft(2, '0')
        + dt.getMinutes().toString().padLeft(2, '0')
        + dt.getSeconds().toString().padLeft(2, '0');
}


//25-may-13,lhw
function isDate(val) {
    if (isUndefinedOrNull(val)) {
        return false;
    }
    else {
        return (val instanceof Date);
    }
}

//25-may-13,lhw
//-returns true if the value is json date (formatted by .net framework).
function isJsonDate(val) {
    if (isUndefinedOrNull(val)) {
        return false;
    }

    var s2 = val.toString();
    var len = s2.length;

    if (s2.indexOf('/Date(') >= 0 && s2.substring(len - 1, len) === '/') {
        return true;
    }
    else {
        return false;
    }
}

//27-may-13,lhw
// extract the date value only.
function dateValue(d1) {
    if (isUndefinedOrNull(d1)) {
        return null;
    }

    //05-Apr-2021,lhw-
    // if (d1 instanceof moment) {
    //     d1 = d1.toDate();
    // }

    return new Date(d1.getFullYear(), d1.getMonth(), d1.getDate());
}

//25-may-13,lhw
//-convert the value to date value.
function toDate(val) {
    var dt = null;
    var s2;
    var len;

    if (!val) {
        //skip the process.
        dt = null;
    }
    else if (isDate(val)) {
        //06-Aug-2023,lhw-we should clone the value and returns a new ref
        //      to avoid everyone is accessing the same var ref.
        // dt = val;
        dt = new Date(val.getTime());
    }
    else if (typeof val == 'number'
        //10-Aug-2022,lhw-
        || (typeof val == 'string' && val.indexOf('T') > 0 && val.indexOf('Z') > 0)
    ) {
        //05-Apr-2021,lhw-bug fixed-the value is number type was not handled
        dt = new Date(val);
    }
    else {
        if (isStrEqual(val, '0001-01-01T00:00:00') || isStrEqual(val, '0001-01-01')) {
            //13.Mar.17, lhw-avoid converting the min value to a date object.
            dt = null;
        }
        else {
            // the value could be a date value in string type (which was json-ised by the server).
            // If that's the case, we need to handle it properly as well.
            s2 = val.toString();
            len = s2.length;

            if (s2.contains('T')) {
                //sample: 2016-05-14T12:14:00.313
                s2 = s2.toString().replace(/-/g, '').replace(/:/g, '').replace(/T/g, '');
                dt = fromSysDate(s2);
            }
            else if (isJsonDate(s2)) {
                s2 = s2.substring(6, 19);
                dt = new Date(toInt(s2));
            }
            else {
                // dt = fromSysDate(val);

                //<<==========
                //23-Sep-2021,lhw-bug fixed-should handle this format as well.
                // sample: '2021-09-15 10:27:31.926'
                s2 = s2.toString().replace(/-/g, '').replace(/:/g, '').replace(/\s/g, '').replace('.', '');
                dt = fromSysDate(s2);
                //<<==========

            }
        }
    }

    return dt;
}

function addHours(dt, i) {
    var d2 = new Date(dt);
    d2.setHours(d2.getHours() + i);

    //handle the minutes
    var j = (i * 10) % 10;
    if (j != 0) {
        d2.setMinutes(d2.getMinutes() + (j / 10) * 60);
    }

    return d2;
}

function addDays(dt, i) {
    var d2 = new Date(dt);
    d2.setDate(d2.getDate() + i);
    return d2;
}

function addMonths(dt, i) {
    var d2 = new Date(dt);
    d2.setMonth(d2.getMonth() + i);
    return d2;
}

/**
 * 31-May-2021,lhw-calculate the age upto day.
 * @param {Date} dob - the birthdate.
 * @param {Date} [now] - default is today.
 * @returns {Number} - age.
 */
function calc_age(dob, now) {
    if (typeof dob == 'undefined' || dob == null) {
        return 0;
    }
    dob = toDate(dob);

    if (typeof now == 'undefined' || now == null) {
        now = new Date();
    }

    // get the date section only.
    now = new Date(now.getFullYear(), now.getMonth(), now.getDate());

    let result = 0;
    let one_yr_old = new Date(dob.getFullYear(), dob.getMonth(), dob.getDate());

    one_yr_old.setFullYear(one_yr_old.getFullYear() + 1);
    one_yr_old.setDate(one_yr_old.getDate() - 1);

    while (one_yr_old <= now) {
        result++;
        one_yr_old.setFullYear(one_yr_old.getFullYear() + 1);
    }

    if (one_yr_old > now) {
        one_yr_old.setFullYear(one_yr_old.getFullYear() - 1);

        let days_to_dt = dateDiff.inDays(now, one_yr_old);
        if (days_to_dt == 0) {
            result--;
        }
    }

    return result;
}

function get_begin_of_day(dt) {
    return new Date(dt.getFullYear(), dt.getMonth(), dt.getDate());
}

// the result will include 23:59:59.
function get_end_of_day(dt) {
    return new Date(dt.getFullYear(), dt.getMonth(), dt.getDate(), 23, 59, 59);
}

function get_begin_of_month(dt) {
    return new Date(dt.getFullYear(), dt.getMonth(), 1);
}

function get_end_of_month(dt) {
    //12.May.20,lhw-the following code will have 23:59:59 but we don't need the hours & minutes.
    return addDays(addMonths(dt, 1), -1);
}

//10.Jul.19,lhw-
function get_begin_of_yr(dt) {
    //10-Jul-2023,lhw-bug fixed
    // return new Date(dt.getFullYear(), 1, 1);
    return new Date(dt.getFullYear(), 0, 1);
}

//10.Jul.19,lhw-
function get_end_of_yr(dt) {
    //12.May.20,lhw-the following code will have 23:59:59 but we don't need the hours & minutes.
    //10-Jul-2023,lhw-bug fixed
    // return new Date(dt.getFullYear() + 1, 12, 31);
    return new Date(dt.getFullYear(), 11, 31);
}


function fmtDateProper(dt) {
    //show wk+dmy
    return formatDateValue(dt, 'D.MMM.YYYY, ddd');
}

function fmtDateProper2(dt) {
    // show dmy only
    return formatDateValue(dt, 'D.MMM.YYYY');

}

function fmtTimeProper(dt) {
    // if (!isUndefinedOrNull(dt)) {
    //     var hh = dt.getHours();
    //     var mm = dt.getMinutes();
    //     return (hh >= 10 ? hh : '0' + hh) + ':' + (mm >= 10 ? mm : '0' + mm);
    // } else {
    //     return '';
    // }

    //02-Oct-2020,lhw-ehn-try to convert to date object
    dt = toDate(dt);

    if (dt instanceof Date) {
        var hh = dt.getHours();
        var mm = dt.getMinutes();

        return (hh >= 10 ? hh : '0' + hh)
            + ':' + (mm >= 10 ? mm : '0' + mm);

    }

    return '';
}


//25-may-13,lhw-format the value into the predefined format.
//06-Sep-2020,lhw-added 'null_text' param.
function formatValue(val, fmt_str, null_text) {

    if (isUndefinedOrNull(val)
        || isUndefinedOrNull(fmt_str)
        || val == '0001-01-01T00:00:00'
        //03-Oct-2020,lhw-enh-since input is empty, skip the lengthy process.
        || (typeof val == 'string' && isStrEmpty(fmt_str) && isStrEmpty(val))
    ) {
        return null_text || '';
    }

    var s = '';

    // for other data type
    if (fmt_str === 'm' || fmt_str === 'm2') {
        s = addCommas(toDbl(val).toFixed(2));
    }
    else if (fmt_str === 'm0') {
        s = addCommas(toDbl(val).toFixed(0));
    }
    else if (fmt_str === 'm1') {
        s = addCommas(toDbl(val).toFixed(1));
    }
    else if (fmt_str === 'm4') {

        s = addCommas(toDbl(val).toFixed(4));
    }
    else if (fmt_str === 'm6') {
        s = addCommas(toDbl(val).toFixed(6));
    }

    //-------------------------
    else if (fmt_str === 'd') {
        // date only.
        // s = fmtDateProper2(toDate(val));
        s = formatDateValue(val, 'D.MMM.YYYY');

    }
    else if (fmt_str === 'd2') {
        //05-Apr-2021,lhw-
        s = formatDateValue(val, 'D.M.YY');

    }
    else if (fmt_str === 'd3') {
        //05-Apr-2021,lhw-
        //15-Jul-2022,lhw-
        // s = formatDateValue(val, 'D.MMM');

        val = toDate(val);
        if (val.getFullYear() == get_curr_yr()) {
            //05-Apr-2021,lhw-
            s = formatDateValue(val, 'D.MMM');
        }
        else {
            //06-Jul-2021,lhw-in case the year value is diff, show it.
            s = formatDateValue(val, 'D.MMM.YY');
        }

    }
    else if (fmt_str === 'dd') {
        // proper date
        // s = fmtDateProper(toDate(val));
        //05-Apr-2021,lhw-
        s = formatDateValue(val, 'D.MMM.YYYY, ddd');
    }
    else if (fmt_str === 'dd2') {
        //05-Apr-2021,lhw-
        s = formatDateValue(val, 'D.M.YY, ddd');
    }
    else if (fmt_str === 'dd3') {

        if (typeof val == 'undefined'
            || val == null
            || (typeof val == 'string' && val.trim().length == 0)
        ) {
            s = (null_text || '');
        }
        else {
            val = toDate(val);
            if (val.getFullYear() == get_curr_yr()) {
                //05-Apr-2021,lhw-
                s = formatDateValue(val, 'D.MMM, ddd');
            }
            else {
                //06-Jul-2021,lhw-in case the year value is diff, show it.
                s = formatDateValue(val, 'D.MMM.YY, ddd');
            }
        }
    }
    else if (fmt_str === 'dd4') {
        s = formatDateValue(val, 'D.MMM.YY, ddd');
    }

    //-------------------------
    else if (fmt_str === 't') {
        // time only
        // s = fmtTimeProper(toDate(val));
        //05-Apr-2021,lhw-
        s = fmtTimeProper(val);

    }

    //-------------------------
    else if (fmt_str === 'dt') {
        // date + time.
        // dt = toDate(val);
        // s = fmtDateProper2(dt) + ' @ ' + fmtTimeProper(dt);
        //05-Apr-2021,lhw-
        s = formatDateValue(val, 'D.MMM.YYYY @ HH:mm');

    }
    else if (fmt_str === 'dt2') {
        // dt = toDate(val);
        //05-Apr-2021,lhw-
        s = formatDateValue(val, 'D.MMM.YY @ HH:mm');

    }
    else if (fmt_str === 'dt3') {
        //28.May.19,lhw-
        // dt = toDate(val);

        if (typeof val == 'undefined'
            || val == null
            || (typeof val == 'string' && val.trim().length == 0)
        ) {
            s = (null_text || '');
        }
        else {
            val = toDate(val);
            if (val.getFullYear() == get_curr_yr()) {
                //05-Apr-2021,lhw-
                s = formatDateValue(val, 'D.MMM @ HH:mm');
            }
            else {
                //06-Jul-2021,lhw-
                s = formatDateValue(val, 'D.MMM.yy @ HH:mm');
            }
        }

    }
    else if (fmt_str === 'ddt') {
        // proper date + time.
        // dt = toDate(val);
        // s = fmtDateProper(dt) + ' @ ' + fmtTimeProper(dt);
        //05-Apr-2021,lhw-
        s = formatDateValue(val, 'D.MMM.YYYY, ddd @ HH:mm');

    }
    else if (fmt_str === 'ddt2') {
        //05-Apr-2021,lhw-
        s = formatDateValue(val, 'ddd, D.MMM.YY @ HH:mm');
    }
    else if (fmt_str === 'my') {
        // date + time.
        //05-Apr-2021,lhw-
        // dt = toDate(val);
        // s = celestial.mth[dt.getMonth()] + ' ' + dt.getFullYear();
        s = formatDateValue(val, 'MMM YYYY');
    }
    //-------------------------
    else if (fmt_str === 'yn') {
        //12.Sep.18,lhw-
        // if ((typeof val === 'boolean') || (typeof val === 'number')) {
        //     s = val ? 'Yes' : 'No';
        // }
        // else {
        //     s = val;
        // }

        //03-Oct-2020,lhw-bug fixed-should not check the data type
        s = (val ? 'Yes' : 'No');
    }

    return s;
}


/**
 * 31-May-2022,lhw-
 * @returns {Number}
 */
function get_curr_yr() {

    if (!celestial.curr_yr) {
        let now = new Date();
        celestial.curr_yr = now.getFullYear();

        // watch the year value changed if current month is Dec and the date is 20th.
        // assuming that the server will be restarted on 1st of the month.
        if (now.getMonth() == 11 && now.getDate() >= 20) {
            watch_curr_yr();
        }
    }

    return celestial.curr_yr;
}

/**
 * 31-May-2022,lhw-Watch the current year value. Update the memory if it changed.
 */
function watch_curr_yr() {

    if (!celestial.curr_yr_watch) {
        celestial.curr_yr_watch = setInterval(() => {
            let yr = (new Date()).getFullYear();

            if (celestial.curr_yr != yr) {
                // if the year value has changed, update it.
                celestial.curr_yr = yr;

                // disable the timer because it takes another 365 days to changed.
                clearInterval(celestial.curr_yr_watch);
            }
        },
            // check on every 5 minutes
            1000 * 60 * 5);
    }
}


//------------------------------------------------------------------------------

//08-Feb-2021,lhw-parse the date format string.
const _dt_fmt_rg = /(MMM|MM|M|ddd|dd|d|DDD|DD|D|yyyy|yy|YYYY|YY|HH|hh|h|H|mm|m|ss|ss|nnn|\S\s*|\s*)/g;

//08-Feb-2021,lhw-date formatting function.
const _dt_fmt_fn = {

    // day
    'd': function (val) {
        return val.getDate().toString();
    },
    'D': function (val) {
        return val.getDate().toString();
    },

    'dd': function (val) {
        let s = val.getDate().toString();
        if (s.length == 1) {
            return '0' + s;
        }
        return s;
    },
    'DD': function (val) {
        let s = val.getDate().toString();
        if (s.length == 1) {
            return '0' + s;
        }
        return s;
    },

    // weekday
    'ddd': function (val) {
        return celestial.wk[val.getDay()];
    },
    'DDD': function (val) {
        return celestial.wk[val.getDay()];
    },

    // month
    'M': function (val) {
        return (val.getMonth() + 1).toString();
    },
    'MM': function (val) {
        let s = (val.getMonth() + 1).toString();
        if (s.length == 1) {
            return '0' + s;
        }
        return s;
    },
    'MMM': function (val) {
        return celestial.mth[val.getMonth()];
    },

    // year
    'YY': function (val) {
        return val.getFullYear().toString().substr(2, 2);
    },
    'yy': function (val) {
        return val.getFullYear().toString().substr(2, 2);
    },

    'YYYY': function (val) {
        return val.getFullYear().toString();
    },
    'yyyy': function (val) {
        return val.getFullYear().toString();
    },

    // hour
    'h': function (val) {
        return val.getHours().toString();
    },
    'H': function (val) {
        return val.getHours().toString();
    },

    'hh': function (val) {
        let s = val.getHours().toString();
        if (s.length == 1) {
            return '0' + s;
        }
        return s;
    },
    'HH': function (val) {
        let s = val.getHours().toString();
        if (s.length == 1) {
            return '0' + s;
        }
        return s;
    },

    // minute
    'm': function (val) {
        return val.getMinutes().toString();
    },
    'mm': function (val) {
        let s = val.getMinutes().toString();
        if (s.length == 1) {
            return '0' + s;
        }
        return s;
    },

    // second
    's': function (val) {
        return val.getSeconds().toString();
    },
    'ss': function (val) {
        let s = val.getSeconds().toString();
        if (s.length == 1) {
            return '0' + s;
        }
        return s;
    },
    //02-Mar-2022,lhw-
    'nnn': function (val) {
        let s = val.getMilliseconds().toString();
        while (s.length < 3) {
            s = '0' + s;
        }
        return s;
    },
};


//------------------------------------------------------------------------------
/**
 * 08-Feb-2021,lhw-
 * @param {String|Date} val - A date value.
 * @param {String} fmt_str - The date format string such as 'D.MMM.YY'
 * - 'd' or 'ddd'
 * - 'M' or 'MMM'
 * - 'YY' or 'YYYY'
 *
 * @param {*} null_text
 */
function formatDateValue(val, fmt_str, null_text) {

    if (typeof val == 'undefined'
        || val == null
        || (typeof val == 'string' && val.trim().length == 0)
    ) {
        return null_text || '';
    }

    val = toDate(val);

    // set the default value
    if (!fmt_str) {
        fmt_str = 'd.MMM.YYYY';
    }

    let f = fmt_str.match(_dt_fmt_rg);
    let m = f.length;
    let s2 = [];

    for (let i = 0; i < m; i++) {
        if (obj_has_fld(_dt_fmt_fn, f[i])) {
            s2.push(_dt_fmt_fn[f[i]].apply(null, [val]));
        }
        else {
            s2.push(f[i]);
        }
    }

    return s2.join('');
}

//------------------------------------------------------------------------------


//17.Dec.16,lhw-
//05-Apr-2021,lhw-added 'null_text' param.
function fmtDateTime_as_at_today(dt, today, null_text) {
    var s;

    null_text = null_text || '';

    if (!(typeof dt == 'string' || dt instanceof Date)) {
        return null_text;
    }

    dt = toDate(dt);

    // could be parsed err - exit if err
    if (!(dt instanceof Date)) {
        return null_text;
    }

    if (isUndefinedOrNull(today)) {
        today = new Date();
    }

    if (dt.getFullYear() === today.getFullYear()
        && dt.getMonth() === today.getMonth()
        && dt.getDate() === today.getDate()
    ) {
        s = fmtTimeProper(dt);
    }
    else if (dt.getFullYear() === today.getFullYear()) {
        s = formatDateValue(dt, 'D.MMM @ HH:mm');
    }
    else {
        s = formatDateValue(dt, 'D.MMM.YY @ HH:mm');
    }

    return s;
}

//2.Sep.18,lhw-format date range.
function fmtDateRange(dt1, dt2, fmt, fmt2, null_text) {
    var s;

    //09-May-2023,lhw-bug fixed
    // if (isUndefinedOrNull(dt1) || isUndefinedOrNull(dt2)) {
    if (isUndefinedOrNull(dt1) && isUndefinedOrNull(dt2)) {
        if (!isUndefinedOrNull(null_text)) {
            //16-Jul-2021,lhw-
            return null_text;
        }

        //05-Apr-2021,lhw-bug fixed-should return dash instead of undefined.
        return '-';
    }

    //05-Apr-2021,lhw-
    if (typeof dt1 == 'string'
        && typeof dt2 == 'string'
        && isStrEmpty(dt1)
        && isStrEmpty(dt2)
    ) {

        if (!isUndefinedOrNull(null_text)) {
            //16-Jul-2021,lhw-
            return null_text;
        }

        return '-';
    }

    if (isUndefinedOrNull(fmt)) {
        fmt = 'd';
    }
    if (isUndefinedOrNull(fmt2)) {
        fmt2 = 'D.MMM';
    }

    //-------------------------
    //05-Apr-2021,lhw-
    if (!isUndefinedOrNull(dt1)
        && isUndefinedOrNull(dt2)
    ) {
        return formatValue(dt1, fmt);
    }

    if (isUndefinedOrNull(dt1)
        && !isUndefinedOrNull(dt2)
    ) {
        return formatValue(dt2, fmt);
    }

    //-------------------------
    if (!(dt1 instanceof Date)) {
        dt1 = toDate(dt1);
    }
    if (!(dt2 instanceof Date)) {
        dt2 = toDate(dt2);
    }


    //-------------------------------
    if (dt1.getFullYear() === dt2.getFullYear()
        && dt1.getMonth() === dt2.getMonth()
        && dt1.getDate() === dt2.getDate()
    ) {

        //05-Apr-2021,lhw-
        // s = formatValue(dt1, fmt);

        if (fmt.indexOf('.') >= 0) {
            // call this proc if the caller passed in 'd.MMM.yy'
            s = formatDateValue(dt1, fmt);
        }
        else {
            s = formatValue(dt1, fmt);
        }
    }
    else if (dt1.getFullYear() === dt2.getFullYear()
        && dt1.getMonth() === dt2.getMonth()
    ) {
        //05-Apr-2021,lhw-
        // s = dt1.getDate().toString() + ' - ' + formatValue(dt2, fmt);

        s = dt1.getDate().toString() + ' ~ ';

        //  + sharedLib.formatValue(dt2, fmt);
        if (fmt.indexOf('.') >= 0) {
            s += formatDateValue(dt2, fmt);
        }
        else {
            s += formatValue(dt2, fmt);
        }
    }
    else if (dt1.getFullYear() === dt2.getFullYear()) {

        s = formatDateValue(dt1, fmt2) + ' ~ ';

        // + sharedLib.formatValue(dt2, fmt);
        if (fmt.indexOf('.') >= 0) {
            s += formatDateValue(dt2, fmt);
        }
        else {
            s += formatValue(dt2, fmt);
        }

    }
    else {

        //05-Apr-2021,lhw-
        // s = formatValue(dt1, fmt) + ' - ' + formatValue(dt2, fmt);

        s = formatValue(dt1, fmt) + ' ~ ';
        //  + sharedLib.formatValue(dt2, fmt);

        if (fmt.indexOf('.') >= 0) {
            s += formatDateValue(dt2, fmt);
        }
        else {
            s += formatValue(dt2, fmt);
        }

    }

    return s;
}

//7.Dec.18,lhw-returns the duration in the format of 'h:mm:ss'.
// param:
// start - start time
// end - end time (optional).
// include_ms - 28-Feb-2022,lhw-
function fmtDuration(start, end, include_ms) {
    var c;
    var s;

    //-------------------------
    //12-Apr-2021,lhw-if 'start' param is number type, convert the value into hours+minutes.
    //07-Jun-2021,lhw-bug fixed-exclude checking on 'start'. If 'start=0' and 'end=undefined',
    // unexpected behavior will happen.
    // if (start && typeof start == 'number' && typeof end == 'undefined') {
    if (typeof start == 'number' && typeof end == 'undefined') {
        if (start > 0) {
            s = toInt(start) + 'H';
        }

        let m = Math.round((toDbl(start) - toInt(start)) * 60);
        if (m > 0) {
            s = (s || '') + m.toString() + 'M';
        }

        return s;
    }

    //-------------------------
    if (typeof end == 'undefined' || end == null) {
        end = new Date();
    }

    let a = dateDiff.inSeconds(end, start);
    let b = toInt(a / 60);

    if (b >= 60) {
        c = toInt(b / 60);
        b = toInt(b % 60);
    }

    a = toInt(a % 60);

    if (c) {
        // hours
        s = c + ':';
    }
    else {
        s = '';
    }

    // minutes
    if (b < 10) {
        s += '0' + b.toString();
    }
    else {
        s += b.toString();
    }

    s += ':';

    // seconds
    if (a < 10) {
        s += '0' + a.toString();
    }
    else {
        s += a.toString();
    }

    if (include_ms) {
        //28-Feb-2022,lhw-
        let s2 = '000' + ((end.getTime() - start.getTime()) % 1000);
        s += '.' + s2.substring(s2.length - 3, s2.length);
    }

    return s;
}

// show the 'popup' (div) below the 'ctl' (any types element).
function show_popup(ctl, popup, callback, duration, auto_hide, align, position_popup, use_effect) {

    if (typeof duration === 'undefined' || duration === null) {
        ////duration = 'slow';
        duration = 'fast';
    }

    if (!popup.is(':visible') || position_popup) {

        var pos = ctl.offset();
        var h = ctl.height();
        var w = ctl.width();
        var ph = popup.height();
        var pw = popup.width();

        var l = pos.left + w - pw;
        var t = pos.top + h + 10;

        if (align && align == 'left') {
            l = pos.left;
        }
        else {
            // bound checking: left
            if (pos.left + w - pw < 10) {
                l = 10;
            }
            else if (l + pw + 30 > $(document).width()) {
                //bounced at right..
                l = l - (l + pw + 30 - $(document).width());
            }
            ////console.log('bounce check..bott')

            // bound checking: bottom
            //16.Sep.18,lhw-check body.overflow
            if (pos.top + h + ph + 10 > $(document).height() || $('body').css('overflow') == 'hidden') {
                if (pos.top - ph - 10 >= 0) {
                    t = pos.top - ph - 10;
                    ////console.log('adj t', t);
                }

                ////console.log('t=>', pos.top - ph - 10)
            }
        }

        ////console.log('show_pp ')
        ////console.log('ctl pos ', pos)
        ////console.log('wnd offset', $(window).height(), $('body').css('overflow'));
        ////console.log('pp pos ', { left: l, top: t, ph: ph })

        popup.css({ left: l, top: t });

        ////if (typeof duration === 'undefined' || duration === null) {
        ////    ////duration = 'slow';
        ////    duration = 'fast';
        ////}

        if (typeof use_effect == 'undefined' || use_effect) {
            popup.slideDown(duration, callback);
        }
        else {
            //1.Sep.18,lhw-
            popup.show(callback);
        }

    }
    else {
        //3-apr-14,lhw-must allow the caller to control whether the popup should be closed when the user click
        // on it again.
        if (isUndefinedOrNull(auto_hide) || auto_hide) {
            if (typeof use_effect == 'undefined' || use_effect) {
                popup.slideUp(duration);
            }
            else {
                popup.hide();
            }
        }
    }

    return false;
}

//1.Sep.18,lhw-trim down the param
function show_popup2(p) {
    var ctl = p.ctl;
    var popup = p.popup;
    var callback = obj_has_fld(p, 'callback') ? p.callback : null;
    var duration = obj_has_fld(p, 'duration') ? p.duration : null;
    var auto_hide = obj_has_fld(p, 'auto_hide') ? p.auto_hide : null;
    var align = obj_has_fld(p, 'align') ? p.align : null;
    var position_popup = obj_has_fld(p, 'position_popup') ? p.position_popup : null;
    var use_effect = obj_has_fld(p, 'use_effect') ? p.use_effect : null;

    show_popup(ctl, popup, callback, duration, auto_hide, align, position_popup, use_effect);

    //1.Sep.18,lhw-enhancement
    if (p.hide_on_outside_click) {

        attachHideOnOutsideClick(ctl, popup, function () {
            if (isUndefinedOrNull(use_effect) || use_effect) {
                popup.slideUp();
            }
            else {
                popup.hide();
            }
        });

    }

}

//1.Sep.18,lhw-if the user clicks outside of the pp, the pp should hide itself. This reduces
// the need of 'blk' object.
function attachHideOnOutsideClick(c0, pp, cb) {
    var within = false;

    var hideOnDocClick = function (e) {
        // if the target is element that was clicked, skip.
        var c2 = $(e.target);

        if (c2.is(c0) || within) {
            return;
        }

        //exec the callback
        cb();

        //remove the handler
        $(document).off('click', hideOnDocClick);

        pp.off('mouseenter', me);
        pp.off('mouseleave', ml);
        pp.off('mousedown', md);
    };

    var me = function (e) { within = true; };
    var ml = function (e) { within = false; };
    var md = function (e) { e.preventDefault(); };

    // track the mouse pointer location
    pp.off('mouseenter', me).on('mouseenter', me);
    pp.off('mouseleave', ml).on('mouseleave', ml);
    pp.off('mousedown', md).on('mousedown', md);

    // attach the click handle in the document.
    $(document).off('click', hideOnDocClick).on('click', hideOnDocClick);

}

// reference: http://stackoverflow.com/questions/487073/check-if-element-is-visible-after-scrolling
function isScrolledIntoView(elem) {
    var docViewTop = celUI.getWnd().scrollTop();
    var docViewBottom = docViewTop + celUI.getWnd().height();
    var elemTop = $(elem).offset().top;
    var elemBottom = elemTop + $(elem).height();
    return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
}

// show 'me' (any types of element) in the center of the window.
function center(me) {
    var c = getJObject(me);
    c.css({
        'position': 'absolute',
        'top': Math.max(0, ((celUI.getWnd().height() - c.outerHeight()) / 2) + celUI.getWnd().scrollTop()) + 'px',
        'left': Math.max(0, ((celUI.getWnd().width() - c.outerWidth()) / 2) + celUI.getWnd().scrollLeft()) + 'px'
    });
    // allow chaining. So, returns the current object.
    return c;
}

//19-feb-13,lhw-load the data into drop down list.
function load_cbo(url, ctl_id, value_fld, text_fld, sel_value, callback) {

    $.getJSON(url, { t: getNowString() }, function (data) {
        if (typeof RecordSettings == 'function') {
            var rec = new RecordSettings();

            if (!rec.checkSess(data)) {
                return;
            }
        }

        if (isJQueryObject(ctl_id)) {
            //31.May.17,lhw-
            cbo_clear(ctl_id);
            for (var i = 0; i < data.length; i++) {
                cbo_add_item(ctl_id, data[i][text_fld], data[i][value_fld]);
            }
        }
        else {
            var c = getJObject(ctl_id);
            var optionsValues = '<select id="' + ctl_id + '" name="' + ctl_id + '" class="txt_input">';

            if (data) {
                for (let i = 0; i < data.length; i++) {
                    optionsValues += '<option value="' + data[i][value_fld] + '"';
                    optionsValues += '>' + data[i][text_fld] + '</option>';
                }
            }
            optionsValues += '</select>';
            c.replaceWith(optionsValues);
        }

        if (!isUndefinedOrNull(sel_value)) {
            c.val(sel_value).attr('selected', true);
        }

        if (!isUndefinedOrNull(callback)) {
            callback();
        }
    });
}


/**
 * 27-Aug-2020,lhw-fill up the cbo with the data obj in an array.
 *
 * Sample:
 *    cbo_from_arr(c2, d2.data, {id:'cls_id', text:'cls', first_item:{id:'', text:'All'}});
 *
 * @param {Object} cbo - a JQuery object.
 * @param {Array} l2 - the data list.
 * @param {Array|Object} k2 -
 * If k2 is an array, then it should have 2 items: [id, text].
 * 12-Jul-2022,lhw-If k2 is an object, {id, text, first_item:{id, text}}.
 * If k2 is missing, it uses the first field as id and second field as text.
 *
 *
 * @returns {Object} - the cbo JQuery object.
 */
function cbo_from_arr(cbo, l2, k2) {
    var id;
    var text;
    var item_is_str;

    cbo_clear(cbo);

    //30-Nov-2022,lhw-bug fixed in guessing the id & text value.
    if (typeof k2 == 'object') {
        //12-Jul-2022,lhw-
        if ((arrLen(l2) > 0) && (typeof l2[0] == 'string')) {
            item_is_str = true;
        }
        else {
            id = k2.id;
            text = k2.text;
        }

        if (k2.first_item) {
            cbo_add_item(cbo, k2.first_item.text, k2.first_item.id);
        }
    }
    else if (typeof k2 == 'undefined' || k2 == null || Array.isArray(l2)) {
        if (arrLen(l2) > 0) {
            if (typeof l2[0] == 'string') {
                item_is_str = true;
            }
            else {
                // guess the field name to be used.
                k2 = Object.keys(l2[0]);

                // k2 must have 2 items.
                if (k2.length == 1 && arrLen(l2) > 1) {
                    k2 = Object.keys(l2[1]);
                }
            }
        }
    }

    if (!item_is_str && !id && !text) {
        if (Array.isArray(l2)) {
            k2 = Object.keys(l2[0]);
        }

        // the id & text field has not been retrieved yet.
        id = k2[0];
        if (k2.length == 2) {
            text = k2[1];
        }
        else {
            text = id;
        }
    }

    // populate the items into the drop down list
    celLoop.each(l2, (o3, idx) => {
        if (item_is_str) {
            cbo_add_item(cbo, o3, idx);
        }
        else {
            cbo_add_item(cbo, o3[text], o3[id]);
        }
    });

    return cbo;
}

//8-apr-13,lhw
function cbo_copy_all_item(ctl_id0, ctl_id1) {
    var c = getJObject(ctl_id0).children().clone();
    var c2 = getJObject(ctl_id1);
    var c3 = c2.children();

    // remove all existing items in the destination.
    c3.remove().end();
    // insert all items from source.
    c2.append(c);
}

//19-feb-13,lhw-returns the selected item.
function cbo_get_sel_item(ctl_id) {
    var c = getJObject(ctl_id);
    var v = null;

    if (typeof c.isCelDropDownEdit === 'function') {
        if (c.isCelDropDownEdit()) {
            var t = c.celDropDownEdit('getText');
            var v2 = c.celDropDownEdit('getValue');
            v = {};
            v.text = function () { return t; };
            v.val = function () { return v2; };
        }
    }

    if (v === null) {
        v = c.find('option:selected');
    }

    return v;
}
//5.Oct.15,lhw-
function cbo_get_sel_item_text(ctl_id) {
    var o = cbo_get_sel_item(ctl_id);

    if (o && typeof o.text === 'function') {
        return o.text();
    }
    else {
        return o;
    }
}

function cbo_get_val(ctl_id, skip_celcbo_route) {
    return cbo_get_sel_val(ctl_id, skip_celcbo_route);
}

function cbo_get_sel_val(ctl_id) {
    var v;
    var c = getJObject(ctl_id);

    if (typeof c.isCelDropDownEdit === 'function' && c.isCelDropDownEdit()) {
        v = c.celDropDownEdit('getValue');
        if (!isUndefinedOrNull(v)) {
            return v;
        }
    }

    c = cbo_get_sel_item(ctl_id);

    if (!isUndefinedOrNull(c)) {
        return c.val();
    }
    else {
        return '';
    }
}

//31.Jul.15, lhw-
function cbo_get_sel_idx(ctl_id) {
    var v = cbo_get_sel_item(ctl_id);

    if (v !== null) {
        return v.index();
    }

    return -1;
}

function cbo_set_val(ctl_id, sel_value, search_by_text, skip_celcbo_route) {
    cbo_set_sel_item(ctl_id, sel_value, search_by_text, skip_celcbo_route);
}

//19-feb-13,lhw-set the selected item.
function cbo_set_sel_item(ctl_id, sel_value, search_by_text, skip_celcbo_route) {

    if (isUndefinedOrNull(ctl_id) || isUndefinedOrNull(sel_value)) {
        return;
    }

    var c = getJObject(ctl_id);

    // if can't find the control, exit.
    if (c.length === 0) {
        return;
    }

    if (typeof skip_celcbo_route === 'undefined' && !skip_celcbo_route && c.hasClass('celcbo')) {
        c.celDropDownList('setValue', sel_value);
        return;
    }

    if (typeof c.isCelDropDownEdit === 'function' && c.isCelDropDownEdit()) {
        c.celDropDownEdit('setValue', null, sel_value);
        return;
    }

    var sv = sel_value.toString().toLowerCase();

    //23-Feb-2023,lhw-it could have multiple item.
    let mx = c.length;
    for (let m2 = 0; m2 < mx; m2++) {
        if (search_by_text) {
            for (var i = 0; i < c[m2].options.length; i++) {
                if (c[m2].options[i].text.toLowerCase() === sv) {
                    c[m2].options[i].selected = true;
                    break;
                }
            }
        }
        else {
            for (var j = 0; j < c[m2].options.length; j++) {
                if (c[m2].options[j].value.toLowerCase() === sv) {
                    c[m2].options[j].selected = true;
                    break;
                }
            }
        }
    }
}

//3.Jun.20,lhw-set the selected item by index.
function cbo_set_by_idx(ctl_id, idx) {
    var c = getJObject(ctl_id);
    c.find('option:eq(' + idx.toString() + ')').attr('selected', 'selected');
}

//11-feb-14,lhw
function cbo_add_item(ctl_id, text, v, idx) {
    //var c = getJObject(ctl_id);
    //if (isUndefinedOrNull(idx)) { c.append($("<option></option>").val(v).text(text)); }
    //else { c.find('option').eq(idx).before($("<option></option>").val(v).text(text)); }

    var c = getJObject(ctl_id);
    var c2 = $('<option></option>');

    if (isUndefinedOrNull(idx)) {
        c.append(c2.val(v).text(text));
    }
    else {
        c.find('option').eq(idx).before(c2.val(v).text(text));
    }

    return c2;
}

//18-mar-13,lhw-delete the given item.
function cbo_delete_item(ctl_id, v) {
    if (!isUndefinedOrNull(v)) {
        if (isJQueryObject(ctl_id)) {
            //14-Dec-2021,lhw-
            ctl_id.find('option[value="' + v + '"]').remove();
        }
        else {
            var c = $(ctl_id + ' option[value="' + v + '"]');
            c.remove();
        }

    }
}

function cbo_get_item(ctl_id, v) {
    if (isUndefinedOrNull(v)) {
        return null;
    }

    if (isJQueryObject(ctl_id)) {
        return ctl_id.find('option[value="' + v + '"]');
    }
    else {
        return $(ctl_id + ' option[value="' + v + '"]');
    }
}

//3-mar-13,lhw-clear all items in the drop down list.
function cbo_clear(ctl_id) {
    var c = getJObject(ctl_id);
    c.find('option').remove().end();

    if (c.hasClass('celcbo')) {
        c.celDropDownList('clear');
    }
}

//6-mar-13,lhw-returns the number of items in the drop down list.
function cbo_get_item_count(ctl_id) {
    var c = getJObject(ctl_id);
    return c.children().length;
}

// 15-feb-14,lhw-convert cbo to span.
function cbo_to_span(ctl_id, cls, style, blank_item_value, blank_text, span_style, ctl) {
    var v = cbo_get_sel_item(ctl_id);
    var c;
    var s;

    if (isUndefinedOrNull(ctl)) {
        // if the caller has passed in the control reference
        c = getJObject(ctl_id);
    }
    else {
        c = ctl;
    }

    if (isUndefinedOrNull(v)) {
        if (isUndefinedOrNull(blank_text)) {
            v = '&nbsp;';
        }
        else {
            v = blank_text;
        }
    } else {
        if (!isUndefinedOrNull(blank_item_value) && isStrEqual(v.val(), blank_item_value)) {
            if (isUndefinedOrNull(blank_text)) {
                v = '&nbsp;';
            }
            else {
                v = blank_text;
            }
        }
        else {
            v = v.text();
        }
    }

    if (isStrEmpty(v)) {
        v = '&nbsp;';
    }
    if (isUndefinedOrNull(span_style)) {
        span_style = '';
    }

    if (typeof ctl_id === 'string') {
        s = '<div class="' + cls + '" style="' + style + '"><span id="' + ctl_id.replace('#', '') + '" style="' + span_style + '">' + v + '</span></div>';
    }
    else {
        //4.Jun.17,lhw-bug fixed-allows caller to pass in the jObject of ctl_id.
        s = '<div class="' + cls + '" style="' + style + '"><span class="' + ctl_id.attr('class') + '" style="' + span_style + '">' + v + '</span></div>';
    }

    c.replaceWith(s);
}

//19-feb-14,lhw
function cbo_set_item_text(ctl_id, idx, new_text) {
    getJObject(ctl_id).find('option').eq(idx).text(new_text);
}

//31.Jul.15, lhw-
function cbo_is_blank(ctl_id, msg) {
    var c = getJObject(ctl_id);
    var v = cbo_get_sel_idx(c);

    if (c.hasClass('celcbo')) {
        c = c.celDropDownList('getInput');
    }

    unhighlight_compulsory(c);

    if (v <= 0) {
        highlight_compulsory(c);
        c.trigger('focus');

        //25-May-2023,lhw-
        // msgbox.show(msg);
        msgbox.err(msg);
        return true;
    }
    return false;
}

//1-aug-14,lhw
function cbo_attach_change_event(ctl_id, callback) {
    getJObject(ctl_id).on('change', callback);
}

//6.Jun.16,lhw-convert the drop down list to array of objects.
function cbo_to_array(ctl_id) {
    var c = getJObject(ctl_id);
    var c2 = c.find('option');
    var i;
    var result = [];
    var max = c2.length;

    for (i = 0; i < max; i++) {
        let c3 = $(c2[i]);

        let o = {};
        o.text = c3.text();
        o.value = c3.val();
        result.push(o);
    }

    return result;
}

//3-mar-13,lhw-returns the textbox value and encode it if necessary.
function text_get_val(ctl_id, for_posting, remove_crlf, trim) {
    var s;
    let c = getJObject(ctl_id);

    // if it is 'span', call text(). Otherwise, call val().
    //if (c.is('span') || c.is('div')) { s = c.text(); }
    //else { s = c.val(); }
    if (c.is('input') || c.is('select') || c.is('textarea')) {
        s = c.val();
    }
    //if (c.is('input') || c.is('select')) { s = c.val(); }
    else {
        s = c.text();
    }

    let t = c.attr('title');
    if (s == t) {
        return '';
    }
    else {
        if (remove_crlf) {
            s = s.replace(/(\r\n|\n|\r)/g, '');
        }

        if (trim) {
            s = s.trim();
        }

        // use for_posting=true when you need to post the data in the URL.
        if (for_posting) {
            return encodeURIComponent(s);
        }
        else {
            return s;
        }
    }
}

//------------------------------------------------------------------------------
/**
 * 10-Jul-2022,lhw-
 * Sample:
 *
 * ```
 * text_get_val2(c0, o,
 *       [
 *           ['dt', 'dt-input'],
 *           ['amt', 'amt-input', 'm2'],
 *           ['cls_id', 'cls-id-input'],
 *
 *           ['expense_type', 'sel-group',
 *               function (o2, c0, c2, f2) {
 *                   return toInt(c2.attr('data-value'));
 *               }],
 *       ]);
 * ```
 *
 * @param {Object} c0 - a JObject.
 * @param {Object} o - the destination data object.
 * @param {Array} fld_arr - field/ui elem map in [fld, ctl_id, data type, cb].
 * - fld - the field name.
 * - ctl_id - the input control class name.
 * - [data type] - optional. Usually, the value is 'm0' (int) or 'm2' (decimal).
 * - [cb] - fn(o,c0,c2,f2):any. Retrieves the user input manually (such as translate the user input to a predefined value).
 *          Returns 'undefined' to skip the field.
 *
 * @param {Object} [opt]
 * @param {Boolean} [opt.to_sys_dt] - default is false and convert to local time.
 * @param {Boolean} [opt.to_js_dt] - 03-Nov-2022,lhw-default is false. If true, the Date value read from the UI and will not do any conversion.
 * @returns
 */
function text_get_val2(c0, o, fld_arr, opt) {
    if (typeof fld_arr == 'undefined' && Array.isArray(o)) {
        fld_arr = o;
        o = {};
    }

    opt = opt || {};

    celLoop.each(fld_arr, function (f2) {
        let c2 = $(c0.find(elemCss(f2[1]).wrap()));
        let v2, get_val_cb;

        if (typeof f2[2] == 'function') {
            get_val_cb = f2[2];
        }
        else if (typeof f2[3] == 'function') {
            get_val_cb = f2[3];
        }

        if (get_val_cb) {
            // exec the callback to retrieve the user input.
            v2 = get_val_cb(o, c0, c2, f2);
        }
        else {
            if (c2.is('select')) {
                v2 = cbo_get_val(c2);
            }
            else if (c2.hasClass('celrblist')) {
                v2 = rb_get_val(c2);
            }
            else if (typeof c2.isCelDropDownEdit === 'function' && c2.isCelDropDownEdit()) {
                v2 = c2.celDropDownEdit('getValue');
            }
            else if (c2.hasClass('celchk') || c2.hasClass('btn-checkbox')) {
                v2 = boolToInt(chk_get_val(c2));
            }
            else if (c2.hasClass('celDatePicker')) {
                v2 = dt_get_val(c2);
                if (opt.to_sys_dt) {
                    v2 = toSysDate(v2);
                }
                else if (opt.to_js_dt) {
                    //03-Nov-2022,lhw-no action, just captured the date value to be used in the mem.
                }
                else {
                    v2 = dt_to_local_time(v2);
                }
            }
            else {
                //16.Aug.18,lhw-added 'textarea' checking. But textarea val()
                // does not work on iphone
                if (isiOS()) {
                    if (c2.is('input')) {
                        v2 = c2.val();
                    }
                    else {
                        v2 = c2.text();
                    }
                }
                else {
                    if (c2.is('input') || c2.is('textarea')) {
                        v2 = c2.val();
                    }
                    else {
                        v2 = c2.text();
                    }
                }
            }
        }

        // if the data type (dt) has been specified, ensure that the value is in the correct.
        if (f2.length >= 2) {
            if (typeof f2[2] == 'string') {
                v2 = toType(v2, f2[2]);
            }
        }

        // update the data obj.
        if (typeof v2 != 'undefined') {
            o[f2[0]] = v2;
        }
    });

    return o;
}


//------------------------------------------------------------------------------
//12-june-13,lhw
//22-Jul-2021,lhw-allow 's' to be an array and 'ctl_id' to be the container.
//   This proc is no longer limited to text input!!
function text_set_val(ctl_id, s) {

    // if (isUndefinedOrNull(ctl_id)) {
    //     return '';
    // }
    // if (isUndefinedOrNull(s)) {
    //     s = '';
    // }
    // var c = getJObject(ctl_id);

    function _txt_set_val(c2, s2) {

        // if it is 'span', call text(). Otherwise, call val().
        // if (c.is('span') || c.is('div') || c.is('a')) { c.text(s); }
        // else { c.val(s); }

        // able to handle any types of input elem.
        if (c2.is('select')) {
            cbo_set_val(c2, s2);
        }
        else if (c2.hasClass('celrblist')) {
            rb_set_val(c2, s2);
        }
        else if (typeof c2.isCelDropDownEdit === 'function' && c2.isCelDropDownEdit()) {
            // set the 'id' (the 3rd param).
            c2.celDropDownEdit('setValue', null, s2);
        }
        else if (c2.hasClass('celchk') || c2.hasClass('btn-checkbox')) {
            chk_set_val(c2, s2);
        }
        else if (c2.hasClass('celDatePicker')) {
            dt_set_val(c2, s2);
        }
        else {
            //16.Aug.18,lhw-added 'textarea' checking. But textarea val()
            // does not work on iphone
            if (isiOS()) {
                if (c2.is('input')) {
                    c2.val(s2);
                }
                else {
                    c2.text(s2);
                }
            }
            else {
                if (c2.is('input') || c2.is('textarea')) {
                    c2.val(s2);
                }
                else {
                    c2.text(s2);
                }
            }
        }

        return c2;
    }

    //-------------------------
    if (Array.isArray(ctl_id)) {
        //23-Jul-2021,lhw-
        let c3, s3;

        celLoop.each(ctl_id, function (s2) {
            c3 = s2[0];

            if (arrLen(s2) == 2) {
                s3 = s2[1];
            }
            else {
                s3 = '';
            }

            _txt_set_val(c3, s3);
        });

    }
    else if (isJQueryObject(ctl_id) && Array.isArray(s)) {
        //23-Jul-2021,lhw-'s' param is an array.
        let c3, s3;

        // s2[0] - ctl id.
        // s2[1] - value.
        // s2[2] - a HTML tag (INPUT,DIV,SELECT, etc). s2[1] will be ignored.
        celLoop.each(s, function (s2) {
            if (arrLen(s2) >= 3 && s2[2]) {
                // 's2[2]' is 'skip_wrap' setting.
                // For eg, the value is 'INPUT' or 'DIV'.
                c3 = ctl_id.find(s2[0]);
            }
            else if (isJQueryObject(s2[0])) {
                //07-Aug-2023,lhw-allows caller passing in a jquery object.
                c3 = s2[0];
            }
            else {
                c3 = ctl_id.find(elemCss(s2[0]).wrap());
            }

            if (arrLen(s2) >= 2) {
                //12-Jul-2022,lhw-bug fixed-if `s2[1]== (zero, false)`, the following code will crash.
                // s3 = (s2[1] || null);

                if (isUndefinedOrNull(s2[1])) {
                    s3 = null;
                }
                else {
                    s3 = s2[1];
                }
            }
            else {
                s3 = '';
            }

            _txt_set_val(c3, s3);

        });
        return ctl_id;
    }
    else {
        // 1 elem
        // _txt_set_val(getJObject(ctl_id), s);
        let c2 = getJObject(ctl_id);
        _txt_set_val(c2, s);
        return c2;
    }

}


//14.Jun.19,lhw-show the amount with currency code in a 'label' element.
// !!!!!NOTE: DO NOT CALL THIS FOR INPUT FIELD!!!!!
function text_set_curr(ctl_id, a, null_text, hide_symb_on_null) {
    if (isUndefinedOrNull(ctl_id)) {
        return '';
    }
    if (isUndefinedOrNull(a)) {
        a = 0;
    }

    var c = getJObject(ctl_id);

    var s;
    var cc = celestial.currency_symbol;

    if (toDbl(a) != 0) {
        s = formatValue(toDbl(a), 'm2');
    }
    else if (typeof null_text != 'undefined') {
        s = null_text;

        if (hide_symb_on_null) {
            cc = '';
        }
    }

    text_set_val(c, s);
    c.prepend('<span class="curr-code">' + cc + '</span>');
}

//14.Jun.19,lhw-show date/time
function text_set_dt(ctl_id, a, fmt) {
    if (isUndefinedOrNull(ctl_id)) {
        return '';
    }
    if (isUndefinedOrNull(a)) {
        a = 0;
    }

    var c = getJObject(ctl_id);
    if (isUndefinedOrNull(fmt)) {
        fmt = 'dt';
    }

    text_set_val(c, formatValue(toDate(a), fmt));
}



// 15-feb-14,lhw-convert textbox to span.
function text_to_span(ctl_id, cls, style, blank_text, span_style) {
    var v = text_get_val(ctl_id);
    var c = getJObject(ctl_id);
    var s;

    if (isUndefinedOrNull(v)) {
        v = '&nbsp;';
    }
    else if (isStrEmpty(v)) {
        if (!isUndefinedOrNull(blank_text)) {
            v = blank_text;
        }
        else {
            v = '&nbsp;';
        }
    }

    if (isUndefinedOrNull(span_style)) {
        span_style = '';
    }

    var id = '';
    if (typeof ctl_id == 'string') {
        id = 'id="' + ctl_id.replace('#', '') + '"';
    }
    else {
        id = c.attr('id');
        if (!isUndefinedOrNull(id)) {
            id = 'id="' + id + '"';
        }
        else {
            id = '';
        }
    }

    if (!isStrEmpty(id)) {
        s = '<div class="' + cls + '" style="' + style + '"><span ' + id + 'style="' + span_style + '">' + v + '</span></div>';
    }
    else if (isJQueryObject(c)) {
        //4.Jun.17,lhw-bug fixed.
        s = '<div class="' + cls + '" style="' + style + '"><span class="' + c.attr('class') + '" style="' + span_style + '">' + v + '</span></div>';
    }

    c.replaceWith(s);
    return c;
}

//31.Jul.15, lhw-
function text_is_blank(ctl_id, msg) {
    var c = getJObject(ctl_id);
    var v = text_get_val(c);
    unhighlight_compulsory(c);

    if (isStrEmpty(v)) {
        highlight_compulsory(c);
        c.trigger('focus');

        //25-May-2023,lhw-
        // msgbox.show(msg);
        msgbox.err(msg);
        return true;
    }
    return false;
}

//26-oct-15,lhw
function disable_enter_key(e) {
    if (is_enter_key(e)) {
        e.preventDefault();
        return false;
    }
}

//04-Aug-2021,lhw-returns true if current keypress is Enter key.
function is_enter_key(e) {
    return (e.keyCode == 13 || e.which == 13);
}

//12-Sep-2021,lhw-
function is_esc_key(e) {
    return (e.keyCode == 27 || e.which == 27);
}


function disable_enter_key_for(ctl) {
    //05-Apr-2021,lhw-
    // getJObject(ctl).keypress(disable_enter_key);
    getJObject(ctl).on('keypress', disable_enter_key);
}

//26-oct-15,lhw
function text_disable_enter_key(ctl_id) {
    //05-Apr-2021,lhw-
    // getJObject(ctl_id).keypress(disable_enter_key);
    getJObject(ctl_id).on('keypress', disable_enter_key);
}

//5.Dec.15,lhw-
function numeric_key_only(e) {
    // 8-backspace, 9-tab, 46-del.
    var k = e.which || e.keyCode;

    // if (k == 8 || k == 9 || k == 46 || (k >= 37 && k <= 40)) {
    if (k == 8 || k == 9 || (k == 46 && e.key !== '.') || (k >= 37 && k <= 40)) {
        return true;
    }

    if (e.key < '0' || e.key > '9') {
        e.preventDefault();
        return false;
    }
}

function text_accept_numeric_only(ctl_id) {
    const c = getJObject(ctl_id);
    c.on('keypress', numeric_key_only);

    //10-Dec-2022,lhw-handle the following events.
    c.on('paste', function (e) {
        var c2 = $(e.target);
        var v = formatValue(toInt(c2.val()), 'm0');
        text_set_val(c2, v);

        celUI.discardEvent(e);
        return false;
    });

    c.on('focus', function (e) {
        var c2 = $(e.target);
        var v = toInt(c2.val());
        text_set_val(c2, v);
        c2.trigger('select');
    });

    c.on('blur', function (e) {
        var c2 = $(e.target);
        var v = formatValue(toInt(c2.val()), 'm0');
        text_set_val(c2, v);
    });
}

// 9-jul-17,lhw-accepts currency/percentage input.
// expecting: e.data => {int, dec, dot, negative}
function currency_only(e) {
    var c0 = $(e.target);
    var s = c0.val();
    var sel_len = c0[0].selectionEnd - c0[0].selectionStart;

    // accept one dot only.
    if (e.key == e.data.dot && s.contains(e.data.dot)) {
        e.preventDefault();
        return false;
    }

    if (e.data.negative && e.key == '-') {
        if (sel_len > 0) {
            return true;
        }

        if (s.contains('-') || c0[0].selectionStart > 0) {
            e.preventDefault();
            return false;
        }

        return true;
    }

    // 8-backspace, 9-tab, 46-del & '.' dot
    var k = e.which || e.keyCode;
    if (k == 8 || k == 9 || k == 46 || (k >= 37 && k <= 40 || e.key == e.data.dot)) {
        //accept
        return true;
    }

    if (e.key < '0' || e.key > '9') {
        e.preventDefault();
        return false;
    }

    // -------------
    // the user highlighted some text.
    if (sel_len > 0) {
        // accept
        return true;
    }

    // -------------
    var v;
    v = s + e.key;
    s = v.split(e.data.dot);

    // check len of int
    if (s[0].length > e.data.int) {
        e.preventDefault();
        return false;
    }

    // check len of dec
    if (s.length > 1 && s[1].length > e.data.dec) {
        e.preventDefault();
        return false;
    }

}

// 9-jul-17,lhw-
function text_accept_currency_only(c, dec, int, dot, negative, fmt, def_val) {
    c = getJObject(c);

    if (isUndefinedOrNull(dec)) {
        dec = 2;
    }
    if (isUndefinedOrNull(int)) {
        int = 15;
    }
    if (isUndefinedOrNull(dot)) {
        dot = '.';
    }
    if (isUndefinedOrNull(negative)) {
        negative = true;
    }
    if (isUndefinedOrNull(fmt)) {
        fmt = 'm2';
    }

    c.on('paste', function (e) {
        var c2 = $(e.target);
        var v = formatValue(toDbl(c2.val()), fmt);
        text_set_val(c2, v);

        e.preventDefault();
        return false;
    });

    //05-Apr-2021,lhw-
    // c.keypress(function (e) {
    c.on('keypress', function (e) {
        if (isUndefinedOrNull(e.data)) {
            e.data = {};
        }

        e.data.dot = dot;
        e.data.int = int;
        e.data.dec = dec;
        e.data.negative = negative;
        return currency_only(e);
    });

    //05-Apr-2021,lhw-
    // c.focus(function (e) {
    c.on('focus', function (e) {
        var c2 = $(e.target);
        var v = toDbl(c2.val());

        //24.Nov.18,lhw-allows setting the default value.
        if (v == 0 && ((typeof def_val != 'undefined') || def_val == null)) {
            v = def_val;
        }

        text_set_val(c2, v);

        //05-Apr-2021,lhw-
        // c2.select();
        c2.trigger('select');
    });

    //05-Apr-2021,lhw-
    // c.blur(function (e) {
    c.on('blur', function (e) {
        var c2 = $(e.target);
        var v = toDbl(c2.val()).toFixed(dec);
        var s = v.toString().split(dot);

        // check the int len
        if (s[0].length > int) {
            v = (0.0).toFixed(dec);
        }

        //24.Nov.18,lhw-allows setting the default value.
        if (toDbl(v) == 0 && ((typeof def_val != 'undefined') || def_val == null)) {
            v = def_val;
        }
        else {
            v = formatValue(toDbl(v), fmt);
        }

        text_set_val(c2, v);
    });

    //27-Nov-2022,lhw-
    if (typeof $.fn.celKeypad == 'function') {
        let img_btn = c.next();
        if (img_btn.hasClass('material-icons')) {
            c.celKeypad({
                int: int,
                dec: dec,
                format: fmt || '',
                negative: negative,
                // maxValue: max,
                // minValue: min,
                show_on_focus: false,
                block_on_show: false,
                imgBtn: img_btn
            });
        }
    }

}


//26.Jul.19,lhw-format the string to hh:mm format
function fmt_time_input(s0) {

    //07-Apr-2021,lhw-
    if (s0 && s0 instanceof Date) {
        s0 = s0.getHours().toString() + '.' + s0.getMinutes().toString();
    }

    if (isStrEmpty(s0)) {
        return '';
    }


    //06-Apr-2021,lhw-bug fixed-must ensure the input is string type.
    if (typeof s0 != 'string') {
        s0 = s0.toString();
    }

    var s = s0.replace('.', ':');

    if (s.contains(':')) {
        s = s.split(':');

        if (isStrEmpty(s[1])) {
            s[1] = '00';
        }
        else {
            if (toInt(s[1]) == 0) {
                s[1] = '00';
            }
            else if (toInt(s[1]) < 10) {
                s[1] = '0' + toInt(s[1]);
            }
        }
    }
    else {
        if (s.length == 4) {
            //16.Sep.18,lhw-4 digits is a valid time.
            s = [s.substr(0, 2), s.substr(2, 2)];
        }
        else if (s.length == 3) {
            if (toInt(s.substr(0, 2)) > 23) {
                //26.May.20,lhw-bug fixed
                s = [s.substr(0, 1), s.substr(1, 2)];
            }
            else {
                //16.Sep.18,lhw
                s = [s.substr(0, 2), '0' + s.substr(2, 1)];
            }
        }
        else {
            s = [s, '00'];
        }
    }

    if (toInt(s[0]) == 0) {
        s[0] = '00';
    }
    else if (toInt(s[0]) < 10) {
        s[0] = '0' + toInt(s[0]);
    }

    //-------------------------------
    if (toInt(s[0]) > 23
        //26.May.20,lhw-bug fixed
        || s[0].length > 2) {

        s[0] = '00';
    }
    if (toInt(s[1]) > 59
        //26.May.20,lhw-bug fixed
        || s[1].length > 2) {

        s[1] = '00';
    }

    return s[0] + ':' + s[1];
}


//11.Feb.18,lhw-accept 'time' value (hh:mm)
function text_accept_time(e0) {

    var f = function time_fld_on_blur(e) {
        var c2 = $(e.target);

        //26.Jul.19,lhw-moved the process to func
        var s = text_get_val(c2);
        text_set_val(c2, fmt_time_input(s));

    };

    if (isJQueryObject(e0)) {
        //18.Jul.19,lhw-
        e0.off('blur').on('blur', f);
    }
    else if (Array.isArray(e0)) {

        //26-Apr-2021,lhw-make an array of element to format as time value.
        celLoop.each(e0, function (e2) {
            getJObject(e2).off('blur').on('blur', f);
        });

    }
    else {
        f(e0);
    }


}

//2.Dec.18,lhw-reset the input field, cbo & rb.
// param:
// - c0 - the container
// - arr - the array of the css class for the input.
function reset_input(c0, arr) {
    var c2;

    if (isUndefinedOrNull(c0) || !isJQueryObject(c0) || c0.length == 0 || isUndefinedOrNull(arr)) {
        return;
    }

    celLoop.each(arr, function (c20) {

        //04-Sep-2021,lhw-get the first item in the array and treat it as the elem css.
        // This is required for 'arr' was part of celUI.entryFlow().
        if (Array.isArray(c20)) {
            c20 = c20[0];
        }

        //26-Apr-2021,lhw-allows user passing in the elem css class.
        if (typeof c20 == 'string' && c20.length > 0) {
            if (c20[0] != '.' && c20[0] != '#') {
                c20 = elemCss(c20).wrap();
            }
        }

        c2 = $(c0.find(c20));

        if (c2.is('select')) {
            cbo_set_val(c2, '0');
        }
        else if (c2.hasClass('celrblist')) {
            rb_set_val(c2, '0');
        }
        else if (typeof c2.isCelDropDownEdit === 'function' && c2.isCelDropDownEdit()) {
            c2.celDropDownEdit('setValue', null, '');
        }
        else if (c2.hasClass('celchk')
            //26-Apr-2021,lhw-
            || c2.hasClass('btn-checkbox')
        ) {
            //30-Nov-2020,lhw-
            chk_set_val(c2, false);
        }
        else if (c2.hasClass('celDatePicker')) {
            unhighlight_compulsory(c2);

            //26-Apr-2021,lhw-
            dt_set_val(c2, null);
        }
        else if (c2.hasClass('celchklist')) {
            chklist_reset(c2);
        }
        else {
            //21-Sep-2021,lhw-we should skip the 'btn-xxx' elem.
            if (!c2.attr('class').contains('btn-')) {
                unhighlight_compulsory(c2);
                text_set_val(c2, '');
            }
        }
    });

}


//------------------------------------------------------------------------------
//23-Apr-2021,lhw-hide the input.
// c0 - the container.
// l - an array of element.
//     => [str1, str2,...] - an array of element CSS or ID.
//     => [ [str1, b], [str2,b], ...] - an array of element+visiblity state.
// b - if false (default), show on screen. True to hide.
// flip - if true, the visibility state will be flipped to the other state.
//        This is useful when you have a buttons which either ON or OFF.
//------------------------------------------------------------------------------
function hide_input(c0, l, b, flip) {
    let s2;
    let b2;

    if (typeof c0 == 'undefined' || c0 == null
        || typeof l == 'undefined' || l == null
    ) {
        return;
    }

    if (typeof b == 'undefined' || b == null) {
        b = true;
    }

    if (typeof l == 'string') {
        // convert the elem to array of elem.
        l = [l];
    }

    celLoop.each(l, function (i) {

        if (Array.isArray(i)) {
            s2 = i[0];

            if (i.length > 1) {
                b2 = i[1];
            }
            else {
                b2 = b;
            }
        }
        else {
            s2 = i;
            b2 = b;
        }

        if (flip) {
            b2 = !b2;
        }

        if (s2.length > 0) {
            if (s2[0] != '.' && s2[0] != '#') {
                s2 = '.' + s2;
            }

            if (b2) {
                c0.find(s2).hide();
            }
            else {
                c0.find(s2).show();
            }
        }
    });
}


//------------------------------------------------------------------------------
//18-Jun-2021,lhw-make the input readonly.
// c0 - the container.
// l - an array of element.
//     => [str1, str2,...] - an array of element CSS or ID.
//     => [ [str1, b], [str2,b], ...] - an array of element+visiblity state.
// b - if false (default), enable the input. True to make the input readonly.
// flip - if true, the visibility state will be flipped to the other state.
//        This is useful when you have a buttons which either ON or OFF.
// add_css -
// rm_css
//------------------------------------------------------------------------------
function readonly_input(c0, l, b, flip, add_css, rm_css) {
    let s2;
    let b2;
    let c2;

    if (typeof c0 == 'undefined' || c0 == null
        || typeof l == 'undefined' || l == null
    ) {
        return;
    }

    if (typeof b == 'undefined' || b == null) {
        b = true;
    }

    if (typeof l == 'string') {
        // convert the elem to array of elem.
        l = [l];
    }

    celLoop.each(l, function (i) {

        if (Array.isArray(i)) {
            s2 = i[0];

            if (i.length > 1) {
                b2 = i[1];
            }
            else {
                b2 = b;
            }
        }
        else {
            s2 = i;
            b2 = b;
        }

        if (flip) {
            b2 = !b2;
        }

        if (s2.length > 0) {
            if (s2[0] != '.' && s2[0] != '#') {
                s2 = '.' + s2;
            }

            c2 = c0.find(s2);
            if (b2) {
                c2.attr('readonly', 'readonly');

                if (add_css) {
                    c2.addClass(add_css);
                }

                if (rm_css) {
                    c2.removeClass(rm_css);
                }
            }
            else {
                c2.attr('readonly', null);

                if (add_css) {
                    c2.removeClass(add_css);
                }

                if (rm_css) {
                    c2.addClass(rm_css);
                }
            }
        }
    });
}


//------------------------------------------------------------------------------
// 14-jul-17,lhw
function nb_set_val(c, v, fmt) {
    c = getJObject(c);

    if (c.hasClass('celKeypad')) {
        c.celKeypad('setValue', toDbl(v));
    }
    else {
        text_set_val(c, v);
    }
}

//18.Sep.18,lhw-returns the user input.
function nb_get_val(c) {
    return toDbl(text_get_val(c));
}

function nb_get_int(c) {
    return toInt(text_get_val(c));
}

//////12.Mar.17, lhw-
////function nb_makeMoneyBox(c) {
////    c.decimalMask({ separator: '.', decSize: 2, intSize: 12, allowNegative: false });
////}


/**
 * 27-Nov-2022,lhw-
 * @param {object} c2
 * @param {Number} [len] - default is 7 size.
 * @param {object} [opt]
 * @param {Number} [opt.max] - default is 9,999,999.
 * @param {Number} [opt.min] - default is 0.
 * @param {string} [opt.fmt] - format string
 * @param {boolean} [opt.negative] - default is false.
 */
function nb_make_int(c2, len, opt) {
    if (typeof len == 'undefined' || len == null) {
        len = 7;
    }
    opt = opt || {};

    if (typeof opt.max == 'undefined' || opt.max == null) {
        opt.max = 9999999;
    }
    if (typeof opt.min == 'undefined' || opt.min == null) {
        opt.min = 0;
    }

    text_accept_numeric_only(c2);
    c2.attr('maxlength', len);

    c2.on('focus', function() {
        const s2 = text_get_val(c2);
        if (s2.indexOf(',') > 0) {
            text_set_val(c2 , s2.replace(/,/g, ''));
        }
    });

    c2.on('paste', function(e2) {
        if (e2.originalEvent.clipboardData) {
            const s2 = e2.originalEvent.clipboardData.getData('text/plain');
            text_set_val(c2 , toInt(s2));
            celUI.discardEvent(e2);
        }
    });

    if (len > 3) {
        c2.on('blur', function(e2) {
            const s2 = text_get_val(c2);
            if (s2.length > 3) {
                text_set_val(c2 , formatValue(toInt(s2), 'm0'));
            }
        });
    }

    if (typeof $.fn.celKeypad == 'function') {
        let img_btn = c2.next();
        if (img_btn.hasClass('material-icons')) {
            c2.celKeypad({
                int: len,
                dec: 0,
                format: opt.fmt || '',
                negative: opt.negative,
                maxValue: opt.max,
                minValue: opt.min,
                show_on_focus: false,
                block_on_show: false,
                imgBtn: img_btn
            });
        }
    }
}




//22.Sep.15,lhw-
function nb_is_zero_or_less(ctl_id, msg) {
    var c = getJObject(ctl_id);
    var v = toDbl(text_get_val(c));

    unhighlight_compulsory(c);

    if (v <= 0) {
        //25-May-2023,lhw-
        // msgbox.show(msg);
        msgbox.err(msg);

        highlight_compulsory(c);
        c.trigger('focus');
        return true;
    }

    return false;
}

//2.Oct.15,lhw-
function nb_is_less_than_zero(ctl_id, msg) {
    var c = getJObject(ctl_id);
    var v = toDbl(text_get_val(c));

    unhighlight_compulsory(c);

    if (v < 0) {
        //25-May-2023,lhw-
        // msgbox.show(msg);
        msgbox.err(msg);

        highlight_compulsory(c);
        c.trigger('focus');
        return true;
    }

    return false;
}

//14-aug-15,lhw
function text_is_invalid_email(ctl_id, msg) {
    var c = getJObject(ctl_id);
    var v = text_get_val(c);

    unhighlight_compulsory(c);

    if (!is_valid_email(v)) {
        //25-May-2023,lhw-
        // msgbox.show(msg);
        msgbox.err(msg);

        highlight_compulsory(c);
        c.trigger('focus');
        return true;
    }

    return false;
}

//27.Aug.15,lhw-
function text_is_invalid_time(ctl_id, msg) {
    var c = getJObject(ctl_id);
    var v = text_get_val(c);
    unhighlight_compulsory(c);

    if (!is_valid_time(v)) {
        //25-May-2023,lhw-
        // msgbox.show(msg);
        msgbox.err(msg);

        highlight_compulsory(c);
        c.trigger('focus');
        return true;
    }

    return false;
}

//1-mar-17,lhw
//1.Sep.18,lhw-added opt param.
//
// sample:
//  var p = {
//    block_on_show: false,
//    show_on_focus: false,
//    imgBtn: getJObject('btn-calendar')
//  };
//  dt_makeDatePicker('txt', p);
//
function dt_makeDatePicker(c, fmt, opt) {
    var p;

    if (typeof $.fn.celDatePicker == 'function') {

        if (typeof fmt == 'object') {
            //1.Sep.18,lhw-
            opt = fmt;
            fmt = null;
        }

        if (isStrEmpty(fmt)) {
            fmt = 'D.MMM.YYYY';
        }

        p = {};

        //9.May.20,lhw-bug fixed-the format was alwyas reset to default.
        if (!obj_has_fld(opt, 'format')) {
            p.format = fmt;
        }

        //1.Sep.18,lhw-
        if (!isUndefinedOrNull(opt)) {
            p = $.extend(opt, p);
        }

        ////return c.celDatePicker({ format: fmt, onSelected:onSelDate });

        if (!Array.isArray(c)) {
            return getJObject(c).celDatePicker(p);
        }
        else {
            //26-Apr-2021,lhw-
            celLoop.each(c, function (c20) {
                getJObject(c20).celDatePicker(p);
            });
        }

    }
    else {

        if (isStrEmpty(fmt)) {
            fmt = 'd.M.yy';
        }

        //1.Sep.18,lhw-
        ////return getJObject(c).datepicker({ dateFormat: fmt, changeMonth: true, changeYear: true }).blur(dt_auto_fill).addClass('datepicker');

        p = {
            dateFormat: fmt,
            changeMonth: true,
            changeYear: true
        };

        ////return getJObject(c).datepicker(p).blur(dt_auto_fill).addClass('datepicker');
        return getJObject(c).datepicker(p).on('change', dt_auto_fill).addClass('datepicker');
    }
}

//11-Aug-2023,lhw-new alias
var dt_make = dt_makeDatePicker;


//1-mar-17,lhw
function dt_remove_timezone(dt) {
    dt.setMinutes(dt.getMinutes() - dt.getTimezoneOffset());
    return dt;
}

function dt_get_val(ctl_id) {
    return dt_get_value(ctl_id);
}

function dt_get_value(ctl_id) {
    var c = getJObject(ctl_id);

    if (c.hasClass('datepicker')) {
        return c.datepicker('getDate');
    }
    else if (c.hasClass('celDatePicker')) {
        return c.celDatePicker('getDate');
    }
    //05-Apr-2021,lhw-retired
    // else if (c.hasClass('celCalendar')) {
    //     //27.Sep.18,lhw-
    //     return c.celCalendar('getDate');
    // }
    else {
        //05-Apr-2021,lhw-
        let s = text_get_val(c).replace(/./g, '-').split('-');
        let now1 = new Date();

        if (s.length == 1) {
            return new Date(now1.getFullYear(), now1.getMonth(), toInt(s[0]));
        }

        if (s.length >= 2) {
            let ok2 = false;

            if (s[1].length == 3) {
                for (var i = 0; i < i < celestial.mth.length; i++) {
                    if (isStrEqual(celestial.mth[i], s[1])) {
                        s[1] = i;
                        ok2 = true;
                        break;
                    }
                }
            }

            if (s.length > 2) {
                s[2] = toInt(s[2]);
            }
            else {
                s.push(now1.getFullYear());
            }

            if (ok2) {
                return new Date(s[2], s[1], toInt(s[0]));
            }

            return null;
        }
    }
}

function dt_set_val(ctl_id, dt) {
    dt_set_value(ctl_id, dt);
}

function dt_set_value(ctl_id, dt) {
    var c = getJObject(ctl_id);

    if (c.hasClass('datepicker')) {
        c.datepicker('setDate', toDate(dt));
    }
    else if (c.hasClass('celDatePicker')) {
        c.celDatePicker('setDate', toDate(dt));
    }
    //27.Sep.18,lhw-
    //05-Apr-2021,lhw-retired
    // else if (c.hasClass('celCalendar')) { c.celCalendar('setDate', toDate(dt)); }
    else {
        text_set_val(c, formatValue(dt, 'd'));
    }
}

//25-jul-14,lhw-callback signature=> on_dt_changed(dt_value, picker_obj { ctl_id });
function dt_attach_value_change_event(ctl_id, callback) {
    var c = getJObject(ctl_id);

    if (c.hasClass('datepicker')) {
        c.datepicker('option', 'onSelect', callback);
    }
    else if (c.hasClass('celDatePicker')) {
        c.celDatePicker('option', 'onSelected', callback);
    }
    else {
        c.on('change', callback);
    }
}

//31.Jul.15, lhw-
function dt_is_blank(ctl_id, msg) {
    var c = getJObject(ctl_id);
    var v = dt_get_value(c);

    unhighlight_compulsory(c);

    if (v === null || v === '') {
        highlight_compulsory(c);
        c.trigger('focus');

        //25-May-2023,lhw-
        // msgbox.show(msg);
        msgbox.err(msg);

        return true;
    }

    return false;
}

//20.Dec.16,lhw-
function dt_isEqual_date(d1, d2) {
    if (isUndefinedOrNull(d1) || isUndefinedOrNull(d2)) {
        return false;
    }

    var d11 = toInt(toSysDate(toDate(d1)));
    var d21 = toInt(toSysDate(toDate(d2)));
    return d11 === d21;
}

//20.Dec.16,lhw-
function dt_isEqual_datetime(d1, d2) {
    if (isUndefinedOrNull(d1) || isUndefinedOrNull(d2)) {
        return false;
    }

    return d1.getTime() === d2.getTime();
}

//20.Dec.16,lhw-
function dt_isBetween(dt, min, max) {
    if (isUndefinedOrNull(min) || isUndefinedOrNull(max)) {
        return false;
    }

    var dt1 = toInt(toSysDate(toDate(dt)));
    var min1 = toInt(toSysDate(toDate(min)));
    var max1 = toInt(toSysDate(toDate(max)));

    return (dt1 >= min1 && dt1 <= max1);
}

//21.Sep.15,lhw-
function dt_period_is_invalid(ctl_id1, ctl_id2, msg) {
    var c = getJObject(ctl_id2);
    var v1 = dt_get_value(ctl_id1);
    var v2 = dt_get_value(c);

    unhighlight_compulsory(c);

    if (v1 > v2) {
        //25-May-2023,lhw-
        // msgbox.show(msg);
        msgbox.err(msg);

        highlight_compulsory(c);
        c.trigger('focus');
        return true;
    }
    return false;
}

//21.Aug.15,lhw-
function dt_enable_auto_fill(css) {
    if (css) {
        if (css.substring(0, 1) != '.') {
            css = '.' + css;
        }

        ////$(css).blur(dt_auto_fill);
        // $(css).change(dt_auto_fill);
        //05-Apr-2021,lhw-
        $(css).on('change', dt_auto_fill);
    }
    else {
        ////$('.datepicker').blur(dt_auto_fill);
        // $('.datepicker').change(dt_auto_fill);
        //05-Apr-2021,lhw-
        $('.datepicker').on('change', dt_auto_fill);
    }
}

//7.Nov.18,lhw-if attached to 'blur', jquery date picker will crash. Use 'change' event instead.
function dt_auto_fill(e) {

    var c = getJObject(e.target);
    var v = text_get_val(c);

    if (isUndefinedOrNull(v) || (typeof v == 'string' && v.length === 0)) {
        //13.May.19,lhw-in case of empty value, it should trigger the change event.
        dt_set_val(c, null);

        // console.log('dt_auto_fill-reset to null');
        return;
    }



    //-------------------------------
    var dt = new Date();
    var v1;
    var v2;
    var set_dt = false;
    var old_val = text_get_val(c);

    if (v.toString().contains('-') || v.toString().contains('.')) {
        v = v.replace(/-/g, '.');
        v2 = v.toString().split('.');

        ////console.log('auto fill v2=', v2, v2.length);

        if (v2.length >= 2 && !isNumeric(v2[1])) {
            //2.Sep.18,lhw-translate the month text (the user input) to mth index.
            v2[1] = monthIndex(v2[1]) + 1;
        }

        if (v2.length == 2) {
            // d-m
            if (isNumeric(v2[0]) && isNumeric(v2[1])) {
                v1 = dt.getFullYear().toString();

                if (toInt(v2[0]) <= 12 && toInt(v2[1]) > 12) {
                    v1 += v2[0].toString().padLeft(2, '0') + v2[1].toString().padLeft(2, '0');
                }
                else {
                    v1 += v2[1].toString().padLeft(2, '0') + v2[0].toString().padLeft(2, '0');
                }

                dt_set_val(c, fromSysDate(v1));
                set_dt = true;
            }
            else {
                dt_set_val(c, null);
                set_dt = true;
            }
        }
        else if (v2.length == 3) {
            // d-m-y
            if (isNumeric(v2[0]) && isNumeric(v2[1]) && isNumeric(v2[2])) {
                v1 = v2[2].toString();

                if (v1.length == 2) {
                    v1 = '20' + v1;
                }

                if (toInt(v2[0]) <= 12 && toInt(v2[1]) > 12) {
                    v1 += v2[0].toString().padLeft(2, '0') + v2[1].toString().padLeft(2, '0');
                }
                else {
                    v1 += v2[1].toString().padLeft(2, '0') + v2[0].toString().padLeft(2, '0');
                }

                dt_set_val(c, fromSysDate(v1));
                set_dt = true;
            }
        }
    }
    else if (isNumeric(v)) {
        //days only
        v1 = toInt(v);
        if (v1 > 0) {
            v1 = dt.getFullYear().toString()
                + (dt.getMonth() + 1).toString().padLeft(2, '0')
                + v1.toString().padLeft(2, '0');

            dt_set_val(c, fromSysDate(v1));
            set_dt = true;
        }
    }
    else {
        // invalid date.
        dt_set_val(c, null);
        set_dt = true;
    }

    //-------------------------------
    if (set_dt) {
        var new_val = text_get_val(c);

        if (new_val != old_val) {

            //18-Apr-2021,lhw-bug fixed-if this proc was called by celCalendar.on_blur,
            // should skip trigger onSelected event.
            if (e.data && e.data.skip_trigger_cb) {
                return;
            }

            if (c.hasClass('celDatePicker')) {
                //26.Aug.16,lhw-trigger the on select event
                c.celDatePicker('triggerOnSelected');
            }
            else if (c.hasClass('datepicker')) {
                //30.Nov.16,lhw-fire onSelect event if the input has changed.
                var inst = $.datepicker._getInst(c[0]);

                if (inst) {
                    var onSelect = $.datepicker._get(inst, 'onSelect');

                    if (onSelect) {
                        var dateStr = $.datepicker._formatDate(inst);
                        onSelect.apply((inst.input ? inst.input[0] : null), [dateStr, inst]);
                    }
                }
            }
        }
    }

}

//------------------------------------------------------------------------------
//05-Apr-2021,lhw-extracted from dt_auto_fill().
function parseDateStr(v) {
    var dt = new Date();
    var v1;
    var v2;
    var result = null;

    if (v.toString().contains('-') || v.toString().contains('.')) {
        v = v.replace(/-/g, '.');
        v2 = v.toString().split('.');

        if (v2.length >= 2 && !isNumeric(v2[1])) {
            //2.Sep.18,lhw-translate the month text (the user input) to mth index.
            v2[1] = monthIndex(v2[1]) + 1;
        }

        if (v2.length == 2) {
            // d-m
            if (isNumeric(v2[0]) && isNumeric(v2[1])) {
                v1 = dt.getFullYear().toString();

                if (toInt(v2[0]) <= 12 && toInt(v2[1]) > 12) {
                    v1 += v2[0].toString().padLeft(2, '0') + v2[1].toString().padLeft(2, '0');
                }
                else {
                    v1 += v2[1].toString().padLeft(2, '0') + v2[0].toString().padLeft(2, '0');
                }

                // dt_set_val(c, fromSysDate(v1));
                result = fromSysDate(v1);
            }

        }
        else if (v2.length == 3) {
            // d-m-y
            if (isNumeric(v2[0]) && isNumeric(v2[1]) && isNumeric(v2[2])) {
                v1 = v2[2].toString();

                if (v1.length == 2) {
                    v1 = '20' + v1;
                }

                if (toInt(v2[0]) <= 12 && toInt(v2[1]) > 12) {
                    v1 += v2[0].toString().padLeft(2, '0') + v2[1].toString().padLeft(2, '0');
                }
                else {
                    v1 += v2[1].toString().padLeft(2, '0') + v2[0].toString().padLeft(2, '0');
                }

                result = fromSysDate(v1);
            }
        }
    }
    else if (isNumeric(v)) {
        //days only
        v1 = toInt(v);
        if (v1 > 0) {
            v1 = dt.getFullYear().toString()
                + (dt.getMonth() + 1).toString().padLeft(2, '0')
                + v1.toString().padLeft(2, '0');
            result = fromSysDate(v1);
        }
    }

    return result;
}


//8.Nov.15,lhw-
function dt_set_range(ctl_id, d1, d2) {
    var c = getJObject(ctl_id);

    if (c.hasClass('datepicker')) {
        if (d1) {
            c.datepicker('option', 'minDate', d1);
        }

        if (d2) {
            c.datepicker('option', 'maxDate', d2);
        }
    }
    else if (c.hasClass('celDatePicker')) {
        if (d1) {
            c.celDatePicker('option', 'minDate', d1);
        }

        if (d2) {
            c.celDatePicker('option', 'maxDate', d2);
        }
    }
    else {
        console.log('unknow control. failed to set the min/max date.');
    }
}

//9.Jul.16,lhw-returns a array (6 row x 7 col) (ie, calendar layout) for the given month.
// col=0 is Monday and col=6 is Sunday.
function dt_cal_layout(dt) {
    var dow;
    ////var cal = new Array(7);//8.Jul.19,lhw-this MUST be 6.
    var cal = new Array(6);
    var o = {};

    o.mth = dt.getMonth();
    o.yr = dt.getFullYear();

    // the calendar of 6x7 items
    o.cal = cal;
    // the day list with index.
    o.list = [];
    // the cell that is out of range.
    o.out_of_range = [];

    var curr_mth = dt.getMonth();

    if (dt.getDate() !== 1) {
        dt = get_begin_of_month(dt);
    }

    for (var i = 0; i < 6; i++) {
        cal[i] = new Array(7);

        for (var j = 0; j < 7; j++) {
            let dt2 = null;

            if (i === 0) {
                // monday is '1' and array uses '0' as the first item.
                dow = dt.getDay() - 1;

                if ((dow === j) || (dow === -1 && j === 6)) {
                    dt2 = dt;
                }
            }
            else if (dt.getMonth() === curr_mth) {
                dt2 = dt;
            }

            if (dt2) {
                cal[i][j] = dt;
                o.list.push({ day: dt.getDate(), row: i, col: j });

                // next day
                dt = addDays(dt, 1);
            }
            else {
                // current date is out of range.
                cal[i][j] = null;
                o.out_of_range.push({ row: i, col: j });
            }
        }
    }

    // returns the position for the given date.
    o.getPosByDate = function (dt3) {
        if (dt3.getMonth() === o.mth && dt3.getFullYear() === o.yr) {
            return this.list[dt3.getDate() - 1];
        }

        return null;
    };

    return o;
}




//4.Mar.17, lhw-convert the date/time value to local time.
//13.Mar.17, lhw-call this proc before passing the data to server to ensure that the date saves to the db uses GMT+8.
//26.Nov.19,lhw-bug fixed- Malaysia GMT is not fixed at GMT+8. Before year 1982, GMT+730

function dt_to_local_time(d) {

    //10-Aug-2022,lhw-this works for Nodejs (not for c#) where
    // we don't want to adjust the GMT hours. The reason is that
    // browser JS engine handle the date value same as Nodejs.
    // So, no adjustment is required.
    //08-Jun-2023,lhw-if the browser is at GMT+8 and the server is at GMT+0,
    // we must enable this function!
    if (celestial.dt_to_local_time_disabled) {
        return d;
    }

    if (!isUndefinedOrNull(d)) {
        //26.Nov.19,lhw-
        ////if (celestial.timezoneOffset == null) {
        ////    var d0 = new Date();

        ////    // KL timezone is GMT+8 and the value is -480.
        ////    // We must switch it to +480 to be added to the server date value.
        ////    celestial.timezoneOffset = -1 * d0.getTimezoneOffset();
        ////}

        ////if (!(d instanceof Date)) {
        ////    d = toDate(d);
        ////}
        ////else {
        ////    //21.Aug.19,lhw-create a new instance so that it won't affect the original var.
        ////    d = new Date(d.getTime());
        ////}

        ////if (d instanceof Date) {
        ////    d.setMinutes(d.getMinutes() + celestial.timezoneOffset);
        ////    return d;
        ////}

        if (!(d instanceof Date)) {
            d = toDate(d);
        }
        else {
            //21.Aug.19,lhw-create a new instance so that it won't affect the original var.
            d = new Date(d.getTime());
        }

        d.setMinutes(d.getMinutes() - d.getTimezoneOffset());
    }

    return d;
}

//18.Aug.19,lhw-this proc helps to add the timezone hours back to the date.
function dt_restore_timezone(d) {
    if (!isUndefinedOrNull(d)) {

        ////if (celestial.timezoneOffset == null) {
        ////    var d0 = new Date();

        ////    // KL timezone is GMT+8 and the value is -480.
        ////    // We must switch it to +480 to be added to the server date value.
        ////    celestial.timezoneOffset = -1 * d0.getTimezoneOffset();
        ////}

        ////if (!(d instanceof Date)) {
        ////    d = toDate(d);
        ////}

        ////if (d instanceof Date) {
        ////    // add the timezone hours back
        ////    d.setMinutes(d.getMinutes() - celestial.timezoneOffset);
        ////    return d;
        ////}

        if (!(d instanceof Date)) {
            d = toDate(d);
        }
        else {
            //21.Aug.19,lhw-create a new instance so that it won't affect the original var.
            d = new Date(d.getTime());
        }

        //15-May-2021,lhw-bug fixed-it should be minus instead of plus.
        //27-Nov-2021,lhw-dt_to_local_time() is minus, so, restore must be plus.
        // This proc is not changing the value to 'computer time'!
        d.setMinutes(d.getMinutes() + d.getTimezoneOffset());
        // d.setMinutes(d.getMinutes() - d.getTimezoneOffset());
    }

    return d;
}



//15.Mar.17, lhw-
function dt_fmt_range(d1, d2, fmt) {
    if (isUndefinedOrNull(d1) && isUndefinedOrNull(d2)) {
        return '-';
    }

    if (typeof fmt == 'undefined' || fmt == null) {
        //23.Sep.19,lhw-include the default format string
        fmt = 'd';
    }

    if (!isUndefinedOrNull(d1) && isUndefinedOrNull(d2)) {
        return formatValue(d1, fmt);
    }

    if (isUndefinedOrNull(d1) && !isUndefinedOrNull(d2)) {
        return formatValue(d2, fmt);
    }

    if (d1 instanceof Date && d2 instanceof Date) {

        if (d1.getTime() == d2.getTime()) {
            return formatValue(d1, fmt);
        }

        if (d1.getFullYear() === d2.getFullYear() && d1.getMonth() === d2.getMonth()) {
            return d1.getDate().toString() + ' ~ ' + formatValue(d2, fmt);
        }

        if (d1.getFullYear() === d2.getFullYear()) {
            return formatValue(d1, fmt).replace('.' + d1.getFullYear().toString(), '') + ' ~ ' + formatValue(d2, fmt);
        }

        //20.May.20,al-bug fixed
        //return formatValue(d2, fmt) + ' ~ ' + formatValue(d2, fmt);
        return formatValue(d1, fmt) + ' ~ ' + formatValue(d2, fmt);
    }

    return '-';
}

/**
 * 09-Dec-2022,lhw-return today.
 * @returns {Date}
 */
function dt_today() {
    return dateValue(new Date());
}

/**
 * 09-Dec-2022,lhw-returns current date/time.
 * @returns {Date}
 */
function dt_now() {
    return new Date();
}


//08-Aug-2023,lhw-
function rb_make(c2, list, onChecked, opt){
    c2 = getJObject(c2)

    if (isUndefinedOrNull(opt)) {
        opt = {};
    }

    obj_set_val_if_missing(opt, 'id_fld', 'id');
    obj_set_val_if_missing(opt, 'text_fld', 'text');
    c2.celRadioButtonList({ list: list, onChecked: onChecked, id_fld: opt.id_fld, text_fld: opt.text_fld });
}

//10-jun-13,lhw-for radio button list.
function rb_get_sel_item(ctl_id) {
    // try to find in the child elements
    var c0 = getJObject(ctl_id);
    var c = c0.find(':checked');

    // if can't find, try to find it in the current level as well.
    if (c.length === 0) {
        c = c0.filter(':checked');
    }

    return c;
}

function rb_get_val(ctl_id) {
    return rb_get_sel_val(ctl_id);
}

//10-jun-13,lhw-for radio button list.
function rb_get_sel_val(ctl_id) {

    //23.Jun.19,lhw-bug fixed-if the screen has multiple celrblist and it was build from 'list',
    // then, this proc will not return correct vaule.
    if (getJObject(ctl_id).hasClass('celrblist')) {
        return getJObject(ctl_id).celRadioButtonList('getValue');
    }

    var c = rb_get_sel_item(ctl_id);
    if (c.length > 0) {
        return c.val();
    }
    else {
        return '';
    }
}

//14.May.16,lhw-
function rb_is_blank(ctl_id, msg) {
    var c = rb_get_sel_item(ctl_id);

    unhighlight_compulsory(c);
    if (c.length === 0) {
        highlight_compulsory(c);
        c.trigger('focus');

        //25-May-2023,lhw-
        // msgbox.show(msg);
        msgbox.err(msg);
        return true;
    }

    return false;
}

function rb_set_val(ctl_id, sel_value) {
    rb_set_sel_val(ctl_id, sel_value);
}

function rb_set_sel_val(ctl_id, sel_value) {
    if (isUndefinedOrNull(ctl_id)) {
        return;
    }

    if (getJObject(ctl_id).hasClass('celrblist')) {
        getJObject(ctl_id).celRadioButtonList('setValue', sel_value);
        return;
    }

    var c = getJObject(ctl_id).find('input');
    if (c.length === 0) {
        return;
    }

    //21-mar-17,lhw-it looks like a bug which is just reset the previous selection and not setting the new value.
    //if (!sel_value) {
    //14.May.16,lhw-
    //    c = rb_get_sel_item(ctl_id);
    //    if (c.length > 0) {
    //        c.removeAttr('checked');
    //    }
    //    return;
    //}

    // if the selected value is not empty, set to 1st item and exit.
    //if (isUndefinedOrNull(sel_value)) {
    //    c[0].checked = true;
    //    return;
    //}

    if (isUndefinedOrNull(sel_value)) {
        return;
    }

    // set the item one by one.
    var sv = sel_value.toString().toLowerCase();

    for (var i = 0; i < c.length; i++) {
        if ($(c[i]).is('input')) {
            if (c[i].value.toLowerCase() === sv) {
                c[i].checked = true;
                break;
            }
        }
    }
}

// 15-feb-14,lhw-convert radio button list to span.
function rb_to_span(ctl_id, cls, style, blank_text) {
    var v = rb_get_sel_item(ctl_id);
    var c = getJObject(ctl_id);
    var s;

    if (isUndefinedOrNull(v)) {
        v = '&nbsp;';
    }
    else {
        // get the selected item id.
        var v2 = '';

        for (var i = 0; i < v.length; i++) {
            let i2 = $(v[i]).attr('id');

            if (!isStrEmpty(v2)) {
                v2 += ', ';
            }
            v2 += lbl_get_text(i2);
        }
        v = v2;

        if (isStrEmpty(v) && !isUndefinedOrNull(blank_text)) {
            v = blank_text;
        }
    }

    if (!isJQueryObject(ctl_id)) {
        s = '<div class="' + cls + '" style="' + style + '"><span id="' + ctl_id.replace('#', '') + '" >' + v + '</span></div>';
    }
    else {
        s = '<div class="' + cls + '" style="' + style + '"><span class="' + ctl_id.attr('class') + '" >' + v + '</span></div>';
    }

    //5.Jun.17,lhw-bug fixed-if there are multiple elements in the 'ctl_id', move to the parent (ie, the container).
    if (c.length > 1) {
        c.each(function () {
            $(this).hide();
        });

        c = c.parent();
        s = $(s).addClass('rb-span');
        c.append(s);
    }
    else {
        c.replaceWith(s);
    }


}

//26-jul-14,lhw-this proc is for 'radio btn list within a dataList control'.
function rb_in_datalist_to_span(ctl_id, cls, style, blank_text) {
    var c = getJObject(ctl_id);
    var c2 = c.find('input[type="radio"]:checked');

    for (var i = 0; i < c2.length; i++) {
        //look for the radio btn list control.
        let c3 = $(c2[i]).closest('table');
        rb_to_span(c3.attr('id'), cls, style, blank_text);
    }
}

//8.Dec.18,lhw-
function rb_attach_change_event(c, callback) {
    if (c.hasClass('celrblist')) {
        c.celRadioButtonList('option', 'onChecked', callback);
    }
}

//10.Mar.17, lhw-patch the 'id' for the label & checkbox/radio.
function ui_patch_label(c2) {
    var id = toInt(Math.random() * 1000000);
    var ii = toInt(Math.random() * 1000);

    c2.each(function () {
        var c3 = $(this);

        // assign new id to the label.
        c3.find('input').attr('id', 'c' + id + '_' + ii.toString()).attr('name', 'c' + id);
        c3.find('label').attr('for', 'c' + id + '_' + ii.toString());

        ii++;
    });
}

//2.Dec.18,lhw-patch the 'table view' where the 'table' was composed by DIV-s.
function ui_patch_col_width(c0, c2, arr) {
    var w;
    var w0;

    if (isUndefinedOrNull(c0) || !isJQueryObject(c0) || isUndefinedOrNull(c2) || !isJQueryObject(c2) || isUndefinedOrNull(arr)) {
        return;
    }

    celLoop.each(arr, function (i2) {
        w = c0.find(i2).width();
        w0 = c0.find(i2).attr('style');

        if (isStrEmpty(w0) || !w0.toLowerCase().contains('width')) {
            // set the col header once.
            c0.find(i2).width(w);
        }

        // set the individual item line.
        c2.find(i2).width(w);
    });
}

function chk_get_val(ctl_id) {
    if (isUndefinedOrNull(ctl_id)) {
        return null;
    }
    var c = getJObject(ctl_id);

    if (c.hasClass('celchk')) {
        return c.celCheckbox('getValue');
    }
    else if (c.is('input')) {
        // this is for input=checkbox only
        return c.is(':checked');
    }
    else {
        //26-Apr-2021,lhw-if ctl_id is a 'material-icons', we should check the css class.
        return c.hasClass('btn-checkbox');
    }
}

function chk_set_val(ctl_id, checked) {
    if (isUndefinedOrNull(ctl_id)) {
        return;
    }
    var c = getJObject(ctl_id);

    if (c.hasClass('celchk')) {
        c.celCheckbox('setValue', checked);
    }
    else if (c.is('input')) {
        // this is for input=checkbox only
        if (checked) {
            c.prop('checked', true);
        }
        else {
            c.prop('checked', false);
        }
    }
    else {
        //26-Apr-2021,lhw-if ctl_id is a 'material-icons', we should change the css class.
        chk_toggle_state(c, !checked);
    }
}

//12.Nov.17,lhw-change the state.
//23-Jul-2021,lhw-'b' can be bool or array of elem in c0.
function chk_set_state(c0, b, state) {

    if (isNull(state) || state == 'chk') {
        state = celestial.chk_state;
    }
    else if (state == 'rb' || state == 'rbl') {
        //23-Jul-2021,lhw-
        state = celestial.rb_state;
    }

    function _chk_set_state(c2, b2) {
        c2.removeClass(state[b2 ? 0 : 1]).addClass(state[b2 ? 1 : 0]);
    }

    //-------------------------
    if (Array.isArray(b)) {
        //23-Jul-2021,lhw-support many elem in the container.
        let c3, b3;

        celLoop.each(b, function (b2) {
            c3 = c0.find(elemCss(b2[0]).wrap());

            if (arrLen(b2) >= 2) {
                b3 = b2[1];
            }
            else {
                b3 = false;
            }

            _chk_set_state(c3, b3);
        });

    }
    else {
        if (typeof b == 'number') {
            //20.Sep.18,lhw-
            b = (b == 1);
        }
        else if (typeof b == 'string') {
            //3.Aug.19,lhw-
            b = (b == '1');
        }

        _chk_set_state(c0, b);
    }

}

//12-mar-14,lhw
function chk_to_span(ctl_id, cls, style, blank_text) {
    var v = chk_get_val(ctl_id);
    var c = getJObject(ctl_id);

    if (isUndefinedOrNull(v) || !v) {
        v = '[ ] ';
    }
    else {
        if (!isUndefinedOrNull(blank_text)) {
            v = blank_text;
        }
        else {
            v = '[x] ';
        }
    }

    if (c.hasClass('celchk')) {
        // hide the checkbox img
        c.celCheckbox('setHide', true);
    }

    c.hide();
    c = lbl_get_ctl(ctl_id);
    c.text(v + c.text());
}

//26-Apr-2021,lhw-
// l - an elem or an array of elem.
// b0 - opt. Set the state. b0=true => uncheck !!
function chk_toggle_state(l, b0) {
    if (!Array.isArray(l)) {
        l = [l];
    }

    let b;
    if (typeof b0 != 'undefined') {
        b = b0;
    }
    else {
        b = l[0].hasClass('btn-checkbox');
    }

    celLoop.each(l, function (l2) {
        if (b) {
            l2.removeClass('btn-checkbox').addClass('btn-checkbox0');
        }
        else {
            l2.removeClass('btn-checkbox0').addClass('btn-checkbox');
        }
    });

    //02-Aug-2022,lhw-returns the new state.
    return !b;
}

//26-Apr-2021,lhw-
function chk_make(l, onChecked) {
    let lbl;

    if (Array.isArray(l)) {
        let cb;
        let c2;

        celLoop.each(l, function (l2) {

            if (Array.isArray(l2)) {
                c2 = l2[0];
                cb = l2[1];
            }
            else {
                c2 = l2;
                cb = onChecked;
            }

            lbl = c2.parent().find('.chk-lbl');

            c2.celCheckbox({
                lbl: lbl,
                onChecked: cb
            });

        });

    }
    else {
        lbl = l.parent().find('.chk-lbl');

        l.celCheckbox({
            lbl: lbl,
            onChecked: onChecked
        });
    }
}

/*
08-Aug-2023,lhw-

    let c2 = c0.find('.fruit-input');
    let l = [];
    l.push({ id: 'FA', text: 'Apple' });
    l.push({ id: 'FB', text: 'Banana' });
    l.push({ id: 'FC', text: 'Coconut' });
    chklist_make(c2, l, box1.on_fruit_changed);

*/

function chklist_make(c2, list, onChecked, opt) {
    c2.html('').addClass('celchklist');

    if (isUndefinedOrNull(opt)) {
        opt = {};
    }

    obj_set_val_if_missing(opt, 'id_fld', 'id');
    obj_set_val_if_missing(opt, 'text_fld', 'text');
    c2.data('opt', opt);

    const ct = $('<div class="celchkitem flx-nw"><div class="material-icons btn-checkbox0"></div><div class="chk-lbl text"></div></div>');
    celLoop.each(list, function(o2) {
        let ct2 = ct.clone();
        ct2.data('data', o2);
        text_set_val(ct2.find('.text'), o2[opt.text_fld]);

        //23-Jan-2024,lhw-
        ct2.find('.material-icons').addClass(o2[opt.id_fld].replace(/_/g, '-') + '-input');

        chk_make(ct2.find('.material-icons'), onChecked);
        c2.append(ct2);
    });
}


//3-apr-14,lhw-get the selected items (in comma separated).
function chklist_get_val(ctl_id, rtn_arr) {
    var s = [];
    let sel_item;
    let c2 = getJObject(ctl_id);

    if (c2.hasClass('celchklist')) {
        //08-Aug-2023,lhw-
        const opt = c2.data('opt');
        sel_item = c2.find('.btn-checkbox');

        celLoop.each(sel_item, function(c30) {
            let c3 = $(c30).parent();
            let o3 = c3.data('data');
            s.push(o3[opt.id_fld]);
        });
    }
    else {
        sel_item = rb_get_sel_item(ctl_id);

        for (var i = 0; i < sel_item.length; i++) {
            let c = $(sel_item[i]);

            // it is checked, append the text value that was shown in the label.
            if (c.val() === 'on') {
                //08-Aug-2023,lhw-
                // if (s.length > 0) {
                //     s += ',';
                // }
                // s += lbl_get_text(c.attr('id'));

                s.push(lbl_get_text(c.attr('id')));
            }
        }
    }

    if (!rtn_arr) {
        s = s.join(',');
    }
    return s;
}

// 20-sep-15,lhw
function chklist_get_sel_count(ctl_id) {
    var j = 0;
    let c2 = getJObject(ctl_id);

    if (c2.hasClass('celchklist')) {
        //08-Aug-2023,lhw-
        j = c2.find('.btn-checkbox').length;
    }
    else {
        var sel_item = rb_get_sel_item(ctl_id);

        for (var i = 0; i < sel_item.length; i++) {
            let c = $(sel_item[i]);
            // it is checked, append the text value that was shown in the label.
            if (c.val() === 'on') {
                j++;
            }
        }
    }
    return j;
}

//3-apr-14,lhw-return all the checkboxes in the given control.
function chklist_get_all(ctl_id) {
    let c2 = getJObject(ctl_id);

    if (c2.hasClass('celchklist')) {
        //08-Aug-2023,lhw-
        return c2.find('.celchkitem');
    }
    else {
        return getJObject(ctl_id).find('input[type="checkbox"]');
    }
}

//3-apr-14,lhw-update the checkboxes with the 'sel_value' (the selected value is separated by comma).
function chklist_set_val(ctl_id, sel_value) {
    if (isStrEmpty(sel_value)) {
        return;
    }

    var sub_str;
    if (Array.isArray(sel_value)) {
        //18-Jan-2024,lhw-handel the array value.
        sub_str = sel_value;
    }
    else {
        sub_str = sel_value.split(',');
    }

    let c2 = getJObject(ctl_id);

    if (c2.hasClass('celchklist')) {
        //08-Aug-2023,lhw-
        // reset the state
        chk_set_val(c2.find('.material-icons'), false);

        // get all items;
        let il = c2.find('.celchkitem');
        const opt = c2.data('opt');

        celLoop.each(il, function(c30) {
            let c3 = $(c30);
            let o3 = c3.data('data');

            celLoop.each(sub_str, function(s3) {
                if (isStrEqual(o3[opt.id_fld], s3)) {
                    // tick the item
                    chk_set_val(c3.find('.material-icons'), true);
                    // exit the loop
                    return false;
                }
            });
        });
    }
    else {
        var items = chklist_get_all(ctl_id);

        for (var i = 0; i < items.length; i++) {
            let c = $(items[i]);
            let s = lbl_get_text(c.attr('id'));

            for (var i2 = 0; i2 < sub_str.length; i2++) {
                if (isStrEqual(sub_str[i2], s)) {
                    chk_set_val(c.attr('id'), true);
                    break;
                }
            }
        }
    }
}

//08-Aug-2023,lhw-
function chklist_reset(c2) {
    let il = chklist_get_all(c2);
    celLoop.each(il, function(c30) {
        chk_set_val($(c30).find('.material-icons'), false);
    });
}


//17-feb-14,lhw-this proc looks for the 'label' tag but not 'span' tag!
function lbl_hide(ctl_id) {
    $('label[for="' + ctl_id.replace('#', '') + '"]').hide();

}

//17-feb-14,lhw-this proc looks for the 'label' tag but not 'span' tag!
function lbl_get_ctl(ctl_id) {
    return $('label[for="' + ctl_id.replace('#', '') + '"]');

}

//17-feb-14,lhw-this proc looks for the 'label' tag but not 'span' tag!
function lbl_get_text(ctl_id) {
    return $('label[for="' + ctl_id.replace('#', '') + '"]').text();
}

//17-feb-14,lhw-this proc looks for the 'label' tag but not 'span' tag!
function lbl_set_text(ctl_id, s) {
    return $('label[for="' + ctl_id.replace('#', '') + '"]').text(s);
}

//19-mar-13,lhw
//http://stackoverflow.com/questions/1219860/javascript-jquery-html-encoding
function htmlEncode(value) {
    if (value) {
        return $('<div/>').text(value).html();
    }
    else {
        return '';
    }
}

//19-mar-13,lhw
//http://stackoverflow.com/questions/1219860/javascript-jquery-html-encoding
function htmlDecode(value) {
    if (value) {
        return $('<div/>').html(value).text();
    }
    else {
        return '';
    }
}

//19-mar-13,lhw
//http://stackoverflow.com/questions/1219860/javascript-jquery-html-encoding
function htmlEscape(str) {
    if (str) {
        return String(str).replace(/&/g, '&amp;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#39;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;');
    }
    else {
        return '';
    }
}

//19-mar-13,lhw
//http://stackoverflow.com/questions/1219860/javascript-jquery-html-encoding
function htmlUnescape(value) {
    if (value) {
        return String(value).replace(/&quot;/g, '"')
            .replace(/&#39;/g, '\'')
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>')
            .replace(/&amp;/g, '&');
    }
    else {
        return '';
    }
}

function reloadCurrentPage() {
    //05-May-2021,lhw-
    // window.location.reload(true);
    window.location.reload();
}

function currentPageIs(pg_name) {
    // 21-may-13,lhw-returns true if the current page is the pg_name.
    var s = window.location.href;
    var pos;

    if (s && pg_name) {
        s = s.toLowerCase();
        pos = s.indexOf(pg_name.toLowerCase());
        return (pos >= 0);
    }

    return false;
}

//21-may-13,lhw-returns the element ID that has the given prefix.
function ctlStartsWith(me, ctl_id_prefix) {
    return getJObject(me).find('[id^="' + ctl_id_prefix + '"]');
}

//21-may-13,lhw-returns the element ID that has the given postfix.
function ctlEndsWith(me, ctl_id_postfix) {
    return getJObject(me).find('[id$="' + ctl_id_postfix + '"]');
}

//21-may-13,lhw-returns the element where the id contains the given string.
function ctlContains(me, s) {
    return getJObject(me).find('[id*="' + s + '"]');
}

// 27-may-13,lhw-copied from the following url
//http://stackoverflow.com/questions/7763327/how-to-calculate-date-difference-in-javascript
const dateDiff = {
    inDays: function (d1, d2) {
        var t2 = dateValue(d2).getTime();
        var t1 = dateValue(d1).getTime();
        return toInt((t2 - t1) / (24 * 3600 * 1000));
    },
    inWeeks: function (d1, d2) {
        var t2 = dateValue(d2).getTime();
        var t1 = dateValue(d1).getTime();
        return toInt((t2 - t1) / (24 * 3600 * 1000 * 7));
    },
    inMonths: function (d1, d2) {
        var d1Y = d1.getFullYear();
        var d2Y = d2.getFullYear();
        var d1M = d1.getMonth();
        var d2M = d2.getMonth();
        return (d2M + 12 * d2Y) - (d1M + 12 * d1Y);
    },
    inYears: function (d1, d2) {
        return d2.getFullYear() - d1.getFullYear();
    },
    inHours: function (d1, d2) {
        if (d1 <= d2) {
            return (d2 - d1) / 36e5;
        }
        else {
            var d10 = new Date(d1.getFullYear(), d1.getMonth(), d1.getDate(), 23, 59, 59, 999);
            var h1 = (d10 - d1) / 36e5;
            var d20 = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate());
            var h2 = (d2 - d20) / 36e5;
            return h1 + h2;
        }
    },
    inMinutes: function (d1, d2) {
        return Math.abs((d1.getTime() - d2.getTime()) / 60 / 1000);
    },
    inSeconds: function (d1, d2) {
        return Math.abs((d1.getTime() - d2.getTime()) / 1000);
    },

    /**
     * 15-May-2023,lhw-returns true if the month+year is same in both d1 & d2.
     * @param {Date} d1
     * @param {Date} d2
     * @returns {Boolean}
     */
    isSameYM: function(d1, d2) {
        return d1 && d2 && (d1.getMonth() == d2.getMonth()) && (d1.getFullYear() == d2.getFullYear());
    },

};

// 12-feb-14,lhw-this class handle the GUID.
const celGuid = {
    // returns the empty guid.
    emptyId: function () {
        return '00000000-0000-0000-0000-000000000000';
    },

    // returns true if the param value is empty guid.
    isEmpty: function (g) {
        return (typeof g === 'undefined') || (g === null) || (g.length !== 36) || (g === celGuid.emptyId());
    }
};

//9-apr-14,lhw-returns true if the server response invalid session.
function isInvalidSession(d) {
    if (d && typeof d === 'object' && obj_has_fld(d, 'msg')) {
        return isStrEqual(d.msg, 'invalid_session');
    }
    else {
        return (d && (d === 'invalid_session'));
    }
}

//14-aug-15,lhw
function is_valid_email(email) {
    if (email === null || email.length === 0) {
        return false;
    }

    //06-Sep-2020,lhw-
    email = email.trim();

    //18-Nov-2020,lhw-allows "name <email>" input.
    if (email.indexOf('<') > 0 && email.indexOf('>') > 0) {
        email = email.extractWithin('<', '>').trim();
    }

    const EMAIL_ADDR_ALLOW_SYMBOL = '@_.-';
    const EMAIL_ADDRESS_NUMERIC = '0123456789';
    const EMAIL_ADDRESS_ALLOW_ALPHA = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
    const EMAIL_ADDR_ALLOW_CHAR = EMAIL_ADDR_ALLOW_SYMBOL + EMAIL_ADDRESS_NUMERIC + EMAIL_ADDRESS_ALLOW_ALPHA;

    var pos = email.indexOf('@');
    if (pos <= 0) {
        return false;
    }

    var pos2 = email.indexOf('@', pos + 1);
    if (pos2 > 0) {
        return false;
    }

    pos2 = email.indexOf('.', pos + 1);

    if ((pos2 < 0) || (pos2 < pos) || (pos + 1 == pos2)) {
        return false;
    }

    if ((pos2 + 1) == email.length) {
        return false;
    }

    var pos3 = email.indexOf('.', pos2 + 1);
    if ((pos3 > 0) && ((pos2 + 1) == pos3)) {
        return false;
    }

    for (var i = 0; i < email.length; i++) {
        if (!EMAIL_ADDR_ALLOW_CHAR.contains(email.substr(i, 1))) {
            return false;
        }
    }

    var last_char = email.substr(email.length - 1, 1);
    if (!(EMAIL_ADDRESS_NUMERIC.contains(last_char) || EMAIL_ADDRESS_ALLOW_ALPHA.contains(last_char))) {
        return false;
    }

    return true;
}


//27.Aug.15,lhw-
function is_valid_time(time) {
    if (!isUndefinedOrNull(time)) {
        var cont = false;
        var s = time.toString();

        if (s.length == 4 || s.length == 5) {
            if ((s.length == 5) && (s.indexOf(':') == 2)) {
                cont = true;
            }
            else {
                cont = true;
            }

            if (cont) {
                var s1 = s.substr(0, 2);
                var s2 = s.substr(s.length - 2, 2);

                if (isNumeric(s1) && isNumeric(s2) && toInt(s1) < 24 && toInt(s2) < 60) {
                    return true;
                }
            }
        }
    }

    return false;
}
//21.Aug.15,lhw-
function highlight_compulsory(c) {
    getJObject(c).addClass('compulsory');
}
//21.Aug.15,lhw-
function unhighlight_compulsory(c) {
    getJObject(c).removeClass('compulsory');
}

//31.Aug.15,lhw-
function do_post_back(eventTarget, eventArgument) {
    var f = $('#form1');
    var t = $('#__EVENTTARGET');

    if (t.length === 0) {
        f.append('<input type="hidden" name="__EVENTTARGET" id="__EVENTTARGET"/>');
        t = $('#__EVENTTARGET');
    }

    var a = $('#__EVENTARGUMENT');
    if (a.length === 0) {
        f.append('<input type="hidden" name="__EVENTARGUMENT" id="__EVENTARGUMENT"/>');
        a = $('#__EVENTARGUMENT');
    }

    t.val(eventTarget);
    a.val(eventArgument);

    //05-Apr-2021,lhw-
    // f.submit();
    f.trigger('submit');

}

//==============================================================================
/* progress bar & background */
//3.Nov.15,lhw-
//==============================================================================
function progress() { }

progress.state = 0;
// this value comes from pp_dlg css class.
// This value should be lesser than msgbox css class (z=3000).
progress.zindex = 2000;

progress.get = function () {
    var c = $('#blk');

    //08-Jul-2021,lhw-detect the resizing
    function _progress_resize() {
        c.css('height', $(document).height());
    }

    if (c.length === 0) {
        $('body').append('<div id="blk" style="display:none;"></div>');
        c = $('#blk');
        celUI.getWnd().on('resize', _progress_resize);
    }

    _progress_resize();

    return c;
};

//4.Oct.16,lhw-returns a new blocking layer to the caller.
progress.getNewLayer = function (id, z) {
    id = 'blk-' + id;

    //08-Jul-2021,lhw-detect the resizing
    function _progress_resize2() {
        c.css('height', $(document).height());
    }

    var c = getJObject(id);

    if (c.length === 0) {
        if (isUndefinedOrNull(z)) {
            progress.zindex += 1;
            z = progress.zindex;
        }

        $('body').append('<div id="' + id + '" class="blk" style="display:none;z-index:' + z.toString() + '"></div>');
        c = getJObject(id);
        celUI.getWnd().on('resize', _progress_resize2);
    }

    _progress_resize2();
    return c;
};


progress.increaseState = function () {
    progress.state++;
    ////console.log('progress.increaseState', progress.state);
    ////console.log(new Error());
};

progress.decreaseState = function () {
    progress.state--;
    //console.log('progress.decreaseState', progress.state);
};

progress.show_blk = function (b) {
    progress.get().fadeIn();
    progress.increaseState();

    if (!b) {
        progress.is_working();
    }
};

progress.show = function (b) {
    progress.show_blk(b);
};

//27.May.19,lhw-
progress.show_layer = function (l) {
    if (l) {
        l.fadeIn();
    }
};

progress.hide_blk = function (b) {
    progress.decreaseState();

    if (progress.state <= 0) {
        progress.get().fadeOut();
        progress.state = 0;
    }

    if (!b) {
        progress.is_done();
    }
};

progress.hide = function (b) {
    progress.hide_blk(b);
};

//27.May.19,lhw-
progress.hide_layer = function (l) {
    if (l) {
        l.fadeOut();
    }
};

progress.reset = function () {
    progress.get().fadeOut();
    progress.state = 0;
};

progress.is_working = function () {
    getJObject('floatingBarsG').fadeIn();
};

progress.is_done = function () {
    getJObject('floatingBarsG').fadeOut();
};

//29.May.18,lhw-
progress.im_busy = function (c2) {

    //09-Sep-2021,lhw-this avoids the spinner to 'show' multiple times.s
    // if (c2) {
    //     c2.find('.spinner').fadeIn();
    // }
    // else {
    //     getJObject('spinner').fadeIn();
    // }

    if (c2) {
        c2 = c2.find('.spinner');
    }
    else {
        c2 = getJObject('spinner');
    }

    if (!c2.is(':visible')) {
        c2.fadeIn();
    }

};

//29.May.18,lhw-
progress.im_free = function (c2, stop_pending) {
    var c3;

    if (c2) {
        c3 = c2.find('.spinner');
    }
    else {
        c3 = getJObject('spinner');
    }

    if (stop_pending) {

        c3.fadeOut(function () {
            //stop the pending calls
            c3.clearQueue();
        });

    }
    else {
        c3.fadeOut();
    }
};

//27.Mar.18,lhw-
progress.attachHideHandler = function (cb) {
    var blk = progress.get();

    //05-Apr-2021,lhw-
    // blk.off('keypress', progress._clickHandler).click({ cb: cb }, progress._clickHandler);
    // $('body').off('keypress', progress._keypressHandler).keypress({ cb: cb }, progress._keypressHandler);

    blk.off('keypress', progress._clickHandler).on('click', { cb: cb }, progress._clickHandler);
    $('body').off('keypress', progress._keypressHandler).on('keypress', { cb: cb }, progress._keypressHandler);

};

//21.Jul.18,lhw-standardize the code - remove the handler.
progress.detachHideHandler = function (cb) {
    var blk = progress.get();

    blk.off('keypress', progress._clickHandler);
    $('body').off('keypress', progress._keypressHandler);
};

//21.Jul.18,lhw-
progress._clickHandler = function (e) {
    if (!celClickOnce.canFire('blk.click')) {
        return;
    }

    if (e.data.cb) {
        e.data.cb();
    }
};

//21.Jul.18,lhw-
progress._keypressHandler = function (e) {
    if (is_esc_key(e)) {
        $('body').off('keypress');

        if (e.data.cb) {
            e.data.cb();
        }
    }
};


//9.Aug.18,lhw-
progress.addSpinnerAt = function (c2) {
    if (c2.find('.spinner').length == 0) {
        c2.append('<div class="spinner" style="display: none;"></div>');
    }
};

/**
 * 29-Nov-2022,lhw-inject the spinner function `showSpinner()` to `p0`.
 * @param {function} p0 - the parent object.
 * @param {object} c2 - a spinner div will be added to `c2`.
 */
progress.addSpinnerFunc = function (p0, c2) {
    p0.showSpinner = function (b) {
        progress.addSpinnerAt(c2);

        if (b) {
            progress.im_busy(c2);
        }
        else {
            progress.im_free(c2);
        }
    };
};


/**
 * 14-Jul-2022,lhw
 * - Show a spinner while waiting for data from server.
 *
 * @param {Object} c2 - a JQuery object.
 * @param {Object} opt
 * @param {String} [opt.bg_clr] - background color. Default is transparent.
 * @param {String} [opt.size] - spinner size. Default is 60px.
 * @param {Boolean} [opt.set_html] - default is false. If true, calls `.html()` to replace the content. Otherwise, call `.append()`.
 */
progress.showSpinner = function (c2, opt) {
    opt = opt || {};
    obj_set_val_if_missing(opt, 'bg_clr', 'transparent');
    obj_set_val_if_missing(opt, 'size', '60px');

    let e2 = `
<div style="width:100%;background-color:${opt.bg_clr};padding-top:40px;">
    <div class="spinner" style="background-size:${opt.size} ${opt.size};width:${opt.size};height:${opt.size};margin:0 auto 0 auto;"></div>
</div>
    `;

    if (opt.set_html) {
        c2.html(e2);
    }
    else {
        c2.append(e2);
    }

};



//==============================================================================
//30.Jun.19,lhw-

function longProcess() { }

longProcess.blk = null;
longProcess.z = null;

// create a new layer to avoid competing with progress.get() object.
longProcess.createNewBlkLayer = function (id, z) {
    // delete the prev blk (which as diff id).
    if (longProcess.blk && (longProcess.blk.attr('id') != 'blk-' + id)) {
        longProcess.blk.remove();

        longProcess.blk = null;
        longProcess.z = null;
    }

    // create a new one
    longProcess.blk = progress.getNewLayer(id, z);
    longProcess.z = z;
};

// delete the blk
longProcess.clearBlk = function () {
    // delete the prev blk
    if (longProcess.blk) {
        longProcess.blk.remove();
    }

    longProcess.blk = null;
    longProcess.z = null;
};

//3.Aug.19,lhw-
longProcess.getContainer = function () {
    return getJObject('u-progress-pp');
};

//10.Oct.19,lhw-
longProcess.getPopup = function () {
    let pp = longProcess.getContainer();

    if (pp.length == 0) {
        let s = [];
        s.push('<div class="u-progress-pp flx-nw" style="display:none;">');
        s.push('<div class="ico0">');
        s.push('<div class="spinner" style="display:none;"></div>');
        s.push('<div class="material-icons ico-progress-done" style="display:none;"></div>');
        s.push('</div>');
        s.push('<div class="u1"></div>');
        s.push('</div>');

        $('body').append(s.join(''));
        pp = longProcess.getContainer();

        if (longProcess.z) {
            pp.css('z-index', (longProcess.z + 1).toString());
        }
    }

    return pp;
};

// show the long process with current progress (ie, 's').
//25-Jul-2023,lhw-'s' allows to be simple text or html text.
longProcess.show = function (s) {
    if (Array.isArray(s)) {
        s = s.join('');
    }

    const pp = longProcess.getPopup();

    //25-Jul-2023,lhw-
    pp.find('.ico-progress-done').hide();

    //10.Oct.19,lhw-must reset the previous html content before showing the new message.
    pp.find('.u1')
        .css('margin-top', '')
        .html(s);

    // this avoids when multiple calls to show() that leads to calling progress.show_blk() multiple time.
    // Then, the blk will not be able to hide due to it's 'state'.
    if (longProcess.blk) {
        if (!longProcess.blk.is(':visible')) {
            longProcess.blk.show();
        }
    }
    else {
        if (!progress.get().is(':visible')) {
            progress.get().off();
            progress.show_blk();
        }
    }

    pp.find('.ico0').show();

    //12.Oct.19,lhw-always show busy state
    progress.im_busy(pp);

    center(pp);
    pp.show();
    return pp;
};

/**
 * Show current progress.
 *
 * @param {String|Number} s - if it is string, it is the progress text.
 * If it is number, it will be used in conjunction with `longProcess.showChecklist()`.
 * @param {Boolean} [show_done_ico] -
 * @param {Function} [on_user_close_cb] - if set, the callback will be passed to `longProcess.waitUserToClose()`.
 * @returns
 */
longProcess.setProgress = function (s, show_done_ico, on_user_close_cb) {
    const pp = longProcess.getContainer();

    if (typeof s == 'number') {
        // done for current step
        let c2 = pp.find(`.idx${s} .progress-ico`);
        c2.html('<div class="material-icons ico-progress-done"></div>');

        // show progress for next step
        c2 = pp.find(`.idx${s + 1} .progress-ico`);
        if (c2.length > 0) {
            c2.html('<div class="spinner"></div>');
        }

        return;
    }

    if (Array.isArray(s)) {
        s = s.join('');
    }

    pp.find('.u1').html(s);

    if ((typeof show_done_ico == 'boolean') && (show_done_ico === true)) {
        //25-Jul-2023,lhw-
        pp.find('.spinner').hide();
        pp.find('.ico-progress-done').show();
    }

    if (typeof on_user_close_cb == 'function') {
        longProcess.waitUserToClose(on_user_close_cb);
    }

    return pp;
};

//25-Jul-2023,lhw-
longProcess.showDoneIcon = function() {
    const pp = longProcess.getContainer();
    pp.find('.spinner').hide();
    pp.find('.ico-progress-done').show();
};

/**
 * 25-Jul-2023,lhw-
 * - Allows caller to pass in a checklist (multiple items).
 *   To mark item #1 as completed, `longProcess.setProgress(1);`
 *
 * @param {Array} l2
 * @param {Boolean} [preformat]
 * @returns {Object} - returns the longProcess jQuery object.
 */
longProcess.showChecklist = function(l2, preformat) {
    const pp = longProcess.getPopup();
    pp.find('.ico0').hide();
    pp.find('.ico-progress-done').hide();
    pp.find('.spinner').hide();

    let s = [];
    if (!preformat) {
        celLoop.each(l2, function(s2, idx2) {
            s.push(`<div class="progress-item flx-nw idx${idx2 + 1}">`);
            s.push('<div class="progress-ico">');
            if (idx2 == 0) {
                s.push('<div class="spinner"></div>')
            }
            s.push('</div>');

            s.push('<div class="progress-item-t1">');
            s.push(s2);
            s.push('</div>');
            s.push('</div>');
        });
    }
    else {
        s = l2;
    }

    pp.find('.u1')
        .html(s.join(''))
        .css('margin-top', 'unset');

    // this avoids when multiple calls to show() that leads to calling progress.show_blk() multiple time.
    // Then, the blk will not be able to hide due to it's 'state'.
    if (longProcess.blk) {
        if (!longProcess.blk.is(':visible')) {
            longProcess.blk.show();
        }
    }
    else {
        if (!progress.get().is(':visible')) {
            progress.get().off();
            progress.show_blk();
        }
    }

    center(pp);
    pp.show();
    return pp;
};


// stop the spinner and wait for user to click to close it.
//10-Nov-2021,lhw-added 'cb'
longProcess.waitUserToClose = function (immediate, cb) {
    if (typeof immediate == 'function') {
        cb = immediate;
        immediate = null;
    }

    const pp = longProcess.getContainer();
    if (immediate) {
        pp.find('.spinner').hide();
    }
    else {
        progress.im_free(pp);
    }

    if (longProcess.blk) {
        longProcess.blk.off().on('click',
            function () {
                longProcess.hide(cb);
            });
    }
    else {
        progress.get().off().on('click',
            function () {
                longProcess.hide(cb);
            });
    }

    return pp;
};


// the process has been completed and hide the pp & blk.
longProcess.hide = function (cb) {
    const pp = longProcess.getContainer();
    pp.hide();

    if (longProcess.blk) {
        longProcess.blk.hide();
    }
    else {
        progress.hide();
    }

    //10-Nov-2021,lhw-
    if (cb) {
        cb();
    }
};



//==============================================================================
/* message box class */
//==============================================================================

// this is a singleton class.
function msgbox() { }

//0-sliding, 1-fading, 2-no effect;
msgbox.visibleEffect = 2;


msgbox.pd = {
    //18-Jul-2023,lhw-allows multiple messages to be shown one after another.
    queue: [],

    blk_zidx: null,

    msg_min_width: 200,

};

msgbox.get = function () {
    let c = $('#msgbox');

    if (c.length === 0) {
        let s = [];

        s.push('<div id="msgbox" class="msgbox-info" tabindex="-1" style="display:none;">');

            s.push('<div class="msgbox-title0">');
                s.push('<div class="msgbox-title1" style="display:none;">');
                    s.push('<div class="material-icons msgbox-ico"></div>');
                    s.push('<div class="msgbox-title"></div>');
                s.push('</div>');
            s.push('</div>');

            s.push('<div class="msgbox-msg0"><div class="msgbox-msg"></div></div>');

            s.push('<div class="remarks0 remarks"><input type="text"/></div>');
            s.push('<div class="opt0 opt2">');
                s.push('<div class="button axn4" style="display:none;"></div>');
                s.push('<div class="button axn3" style="display:none;"></div>');
                s.push('<div class="button axn2" style="display:none;"></div>');
                s.push('<div class="button axn1">Cancel</div>');
                s.push('<div class="button axn0">OK</div>');
            s.push('</div>');
        s.push('</div>');
        $('body').append(s.join(''));

        // get the reference
        c = $('#msgbox');
    }

    return c;
};

msgbox._show_axn_btn = function (c0, axn_idx, axn, validate_cb, on_hide) {
    const c_axn = c0.find('.axn' + axn_idx);
    c_axn.off('click').show();

    if (axn.text) {
        msgbox._set_axn_text(axn_idx, axn.text);
    }

    c_axn.on('click', function () {
        if (axn_idx == 0) {
            if (typeof validate_cb === 'function') {
                b = validate_cb();
                if (!b) {
                    return;
                }
            }
        }

        //prevent double click on delete.
        if (!celClickOnce.canFire(`msgbox:fire:axn${axn_idx}_callback`)) {
            return;
        }

        if (typeof axn.cb === 'function') {
            let s;
            if (axn_idx == 0) {
                if (c0.find('.remarks0').hasClass('remarks2')) {
                    s = text_get_val(c0.find('.remarks0 > input'));
                }
            }

            axn.cb(s);
        }

        msgbox.hide();

        if (typeof on_hide == 'function') {
            on_hide();
        }
    });

};

//18.Jul.16,lhw-show the remarks input box for prompt().
msgbox._setup_user_input = function (c0, opt2) {
    if (opt2.get_user_input) {
        c0.find('.remarks0').removeClass('remarks').addClass('remarks2');

        const c2 = msgbox.getRemarksCtl();
        c2.attr('placeholder', opt2.user_input_placeholder);
        c2.attr('title', opt2.user_input_placeholder);
        c2.attr('maxlength', opt2.user_input_maxlength);
        c2.css('width', opt2.user_input_width || '');

        if (!isStrEmpty(opt2.def_val)) {
            // show the default value.
            text_set_val(c2, opt2.def_val);
        }
        else {
            //3.Jul.19,lhw-reset the prev input.
            text_set_val(c2, '');
        }

        c2.off('keypress');
        if (opt2.user_input_on_keypress) {
            c2.on('keypress',
                function (e2) {
                    return opt2.user_input_on_keypress(e2);
                });
        }

        setTimeout(() => {
            celUI.focusInput(c2);
        }, 300);
    }
    else {
        c0.find('.remarks0').removeClass('remarks2').addClass('remarks');
    }
};

//18-Jul-2023,lhw-the object struct of the message.
// and the message will be queue for displaying on the screen.
msgbox.setting = function() {
    // msgbox-info, msgbox-err, msgbox-warn.
	this.cls = null;

    // can be a pure text or html.
	this.msg = null;
    this.title = null;

    // fix the msgbox size (px).
    this.msg_width = null;
    this.msg_height = null;

    // the action button.
    // type: [{text, cb, keycode[]},..] | function
    // where `keycode` is String|String[].
    // max actions: 5
	this.axn = [];

	this.blk_click_axn_idx = null;
	this.on_hide = null;

    // for caller to finalize the UI or run any other process.
    this.on_init_msg = null;

    //-------------------------
    // for prompt() - to get user input.
    //-------------------------
    this.get_user_input = null;

    // the placeholder attr in the textbox.
    this.user_input_placeholder = null;
    this.user_input_maxlength = null;
    this.user_input_width = null;

    // the default value to be edited by the user
    this.def_val = null;

    // for validating the user input.
    this.on_validate = null;

    //for example, restricting 'numeric' in the user input through the keypress event.
    this.user_input_on_keypress = null;

};

msgbox._do_show_next_msg = function () {
    // console.log('_msgbox_do_show_next', msgbox.pd.queue);

    const blk = progress.getNewLayer(1, msgbox.getBlkZindex());
    blk.off('click');

    if (arrLen(msgbox.pd.queue) == 0) {
        msgbox.hide();
        blk.hide();
        return;
    }

    //-------------------------
    /** @type {msgbox.setting} */
    const opt2 = msgbox.pd.queue[0];
    // console.log('_msgbox_do_show_next, msg=', opt2);

    if (!isStrEmpty(opt2.blk_click_axn_idx)) {
        blk.on('click',
            function() {
                msgbox.get().find('.axn' + opt2.blk_click_axn_idx).trigger('click');
            });
    }

    const c0 = msgbox.get();

    // show title, if any.
    let c_title = c0.find('.msgbox-title');
    if (isStrEmpty(opt2.title)) {
        c_title.html('');
        c_title.parent().hide();
        c0.find('.msgbox-msg0').css('margin-top', '0');
    }
    else {
        c_title.parent().show();
        c_title.html(opt2.title);
        c0.find('.msgbox-msg0').css('margin-top', '60px');
    }

    // show message
    let c2 = c0.find('.msgbox-msg');
    c2.html(opt2.msg || '?');


    let w, h;
    // if (opt2.msg_width) {
    //     if (typeof opt2.msg_width == 'number') {
    //         w = opt2.msg_width + 'px';
    //     }
    //     else {
    //         w = opt2.msg_width;
    //     }
    // }

    // if (!w) {
    //     w = msgbox.pd.msg_min_width + 'px';
    // }
    // Remove the set width logic

    if (opt2.msg_height) {
        if (typeof opt2.msg_height == 'number') {
            h = opt2.msg_height + 'px';
        }
        else {
            h = opt2.msg_height;
        }
    }

    c2.css({
        width: w || '',
        height: h || '',
    });

    //-------------------------
    // by default, hide all buttons.
    c0.find('.opt0 .button').hide();

    celLoop.each(opt2.axn, function(axn2, axn_idx2) {
        // if the caller passes in a callback function,
        // we have to format the setup.
        if (typeof axn2 == 'function') {
            axn2 = {
                text: (axn_idx2 == 0 ? 'OK'
                        : axn_idx2 == 1 ? 'Cancel'
                        : 'Action ' + axn_idx2),
                cb: axn2,
            };

            if (arrLen(opt2.axn) == 1) {
                axn2.keycode = ['Enter', 'Escape'];
            }
            else if (arrLen(opt2.axn) == 2) {
                axn2.keycode = (axn_idx2 == 0 ? 'Enter'
                    : axn_idx2 == 1 ? 'Escape'
                    : null);
            }

            opt2.axn[axn_idx2] = axn2;
        }

        msgbox._show_axn_btn(c0, axn_idx2, axn2, opt2.on_validate, opt2.on_hide);
    });

    //-------------------------
    if (isUndefinedOrNull(opt2.get_user_input)) {
        opt2.get_user_input = false;
    }

    msgbox._setup_user_input(c0, opt2);

    //-------------------------
    if (isUndefinedOrNull(opt2.cls)) {
        opt2.cls = 'msgbox-info';
    }

    c0.removeClass('msgbox-info')
        .removeClass('msgbox-err')
        .removeClass('msgbox-warn')
        .removeClass('msgbox-cfm')
        .removeClass('msgbox-prompt')
        .addClass(opt2.cls);

    // for caller to finalize the UI or run any other process.
    if (typeof opt2.on_init_msg == 'function') {
        opt2.on_init_msg();
    }

    // final step: set horizontal pos to center.
    c0.css({ 'left': Math.max(0, ((celUI.getWnd().width() - c0.outerWidth()) / 2) + celUI.getWnd().scrollLeft()) + 'px' });

};


// the 's' param can be text or html. In case of html, you may pass in
// multiple input boxes and call msgbox.confirm() to show the form.
//18-Jul-2023,lhw-`s` is String or msgbox.setting() type.

/**
 *
 * @param {String|msgbox.setting} s
 * @param {Function} [hide_callback]
 * @param {String} [cls]
 * @param {Boolean} [show_opt]
 * @param {Boolean} [show_rem]
 * @param {Function} [validate_cb]
 * @param {Boolean} [skip_handle_esc]
 * @param {Number} [blk_click_axn_idx]
 *
 */
msgbox.show = function (s, hide_callback, cls, show_opt,
    axn0_callback, axn1_callback,
    show_rem, validate_cb,
    //19-Jul-2023,lhw-this param has retired.
    skip_handle_esc,
    //18-Jul-2023,lhw-either '0' or '1'.
    blk_click_axn_idx
) {
    let opt2;

    if (s instanceof msgbox.setting) {
        opt2 = s;

        // the last button is for the blk click in case it has not been specified.
        obj_set_val_if_missing(opt2, 'blk_click_axn_idx', (arrLen(opt2.axn) - 1));
    }
    else if (typeof s == 'object') {
        opt2 = new msgbox.setting();
        const k2 = Object.keys(opt2);

        k2.forEach((k3) => {
            opt2[k3] = s[k3];
        });
        obj_set_val_if_missing(opt2, 'blk_click_axn_idx', (arrLen(opt2.axn) - 1));
    }
    else {
        opt2 = new msgbox.setting();
        opt2.msg = s;
        opt2.cls = cls;
        opt2.on_hide = hide_callback;
        opt2.get_user_input = show_rem;
        opt2.on_validate = validate_cb;
        opt2.blk_click_axn_idx = isUndefinedOrNull(blk_click_axn_idx) ? 0 : blk_click_axn_idx;

        if (axn0_callback) {
            opt2.axn.push({
                text: 'OK',
                keycode: 'Enter',
                cb: axn0_callback
            });

            if (axn1_callback) {
                opt2.axn.push({
                    text: 'Cancel',
                    keycode: 'Escape',
                    cb: axn1_callback
                });
            }
            else {
                // if only 1 action, it handles 2 keys
                opt2.axn[0].keycode = ['Enter', 'Escape'];
            }
        }
        else {
            // by default, it always show the OK button.
            opt2.axn.push({
                text: 'OK',
                keycode: ['Enter', 'Escape'],
                cb: function() {}
            });
        }
    }

    obj_set_val_if_missing(opt2, 'title', 'Information');

    const cnt = arrLen(msgbox.pd.queue);

    // queue for display
    msgbox.pd.queue.push(opt2);
    // console.log('opt2', opt2);

    // if there is a message pending for user to pickup,
    // queue it and wait for its' turn.
    if (cnt > 0) {
        return;
    }

    //-------------------------
    // show the msgbox.
    //-------------------------

    // Get a new progress layer to do the background blocking.
    // This is to avoid that the default background blocking has been used
    // (the user will have chance to access other popup).
    const blk = progress.getNewLayer(1, msgbox.getBlkZindex());
    blk.show();

    if (typeof blk_idx != 'undefined' && toInt(blk_idx) > 0) {
        //change the zindex which could be obstructed by the dockbar.
        blk.css('z-index', blk_idx);
    }

    // show the message
    msgbox._do_show_next_msg();

    const c0 = msgbox.get();
    if (msgbox.visibleEffect === 0) {
        c0.slideDown('slow');
    }
    else if (msgbox.visibleEffect === 1) {
        c0.fadeIn();
    }
    else {
        //29.Aug.19,lhw-we don't need to show it again if it is visible.
        if (!c0.is(':visible')) {
            c0.show();
        }
    }

    msgbox._attach_keydown();
};

/**
 *
 * @param {String|msgbox.setting} s
 * @param {Function} [hide_callback]
 */
msgbox.err = function (s, hide_callback) {
    let opt2;

    if (s instanceof msgbox.setting) {
        opt2 = s;
        obj_set_val_if_missing(opt2, 'blk_click_axn_idx', 0);
    }
    else if (typeof s == 'object') {
        opt2 = new msgbox.setting();
        const k2 = Object.keys(opt2);

        k2.forEach((k3) => {
            opt2[k3] = s[k3];
        });
        obj_set_val_if_missing(opt2, 'blk_click_axn_idx', 0);
    }
    else {
        opt2 = new msgbox.setting();
        opt2.msg = s;
        opt2.blk_click_axn_idx = 0;

        opt2.axn.push({
            text: 'OK',
            keycode: [ 'Enter', 'Escape'],
            cb: hide_callback,
        });
    }

    obj_set_val_if_missing(opt2, 'cls', 'msgbox-err');
    obj_set_val_if_missing(opt2, 'title', 'Error');
    msgbox.show(opt2);
};

/**
 *
 * @param {String|msgbox.setting} s
 * @param {Function} [hide_callback]
 */
msgbox.warn = function (s, hide_callback) {
    let opt2;

    if (s instanceof msgbox.setting) {
        opt2 = s;
        obj_set_val_if_missing(opt2, 'blk_click_axn_idx', 0);
    }
    else if (typeof s == 'object') {
        opt2 = new msgbox.setting();
        const k2 = Object.keys(opt2);

        k2.forEach((k3) => {
            opt2[k3] = s[k3];
        });
        obj_set_val_if_missing(opt2, 'blk_click_axn_idx', 0);
    }
    else {
        opt2 = new msgbox.setting();
        opt2.msg = s;
        opt2.blk_click_axn_idx = 0;

        opt2.axn.push({
            text: 'OK',
            keycode: [ 'Enter', 'Escape'],
            cb: hide_callback,
        });
    }

    obj_set_val_if_missing(opt2, 'cls', 'msgbox-warn');
    obj_set_val_if_missing(opt2, 'title', 'Warning');
    msgbox.show(opt2);
};


/**
 *
 * @param {String|msgbox.setting} s
 * @param {Function} [axn0_callback]
 * @param {Function} [axn1_callback]
 */
msgbox.confirm = function (s, axn0_callback, axn1_callback) {
    let opt2;

    if (s instanceof msgbox.setting) {
        opt2 = s;
        obj_set_val_if_missing(opt2, 'blk_click_axn_idx', 1);
    }
    else if (typeof s == 'object') {
        opt2 = new msgbox.setting();
        const k2 = Object.keys(opt2);

        k2.forEach((k3) => {
            opt2[k3] = s[k3];
        });
        obj_set_val_if_missing(opt2, 'blk_click_axn_idx', 1);
    }
    else {
        opt2 = new msgbox.setting();
        opt2.msg = s;
        opt2.blk_click_axn_idx = 1;

        opt2.axn.push({
            text: 'OK',
            keycode: 'Enter',
            cb: axn0_callback,
        });

        opt2.axn.push({
            text: 'Cancel',
            keycode: 'Escape',
            cb: axn1_callback
        });
    }

    obj_set_val_if_missing(opt2, 'cls', 'msgbox-cfm');
    obj_set_val_if_missing(opt2, 'title', 'Confirm');
    msgbox.show(opt2);
};

/**
 * 18.Jul.16,lhw-for validating the user input, returns true/false in axn0_callback().
 * @param {String|msgbox.setting} s
 * @param {Function} [axn0_callback]
 * @param {Function} [axn1_callback]
 * @param {Any} [def_value]
 * @param {Function} [validate_cb]
 */
msgbox.prompt = function (s, axn0_callback, axn1_callback, def_value, validate_cb) {
    let opt2;

    if (s instanceof msgbox.setting) {
        opt2 = s;
        obj_set_val_if_missing(opt2, 'blk_click_axn_idx', 1);
    }
    else if (typeof s == 'object') {
        opt2 = new msgbox.setting();
        const k2 = Object.keys(opt2);

        k2.forEach((k3) => {
            opt2[k3] = s[k3];
        });
        obj_set_val_if_missing(opt2, 'blk_click_axn_idx', 1);
    }
    else {
        opt2 = new msgbox.setting();
        opt2.msg = s;
        opt2.def_val = def_value;
        opt2.on_validate = validate_cb;
        opt2.blk_click_axn_idx = 1;

        opt2.axn.push({
            text: 'OK',
            keycode: 'Enter',
            cb: axn0_callback,
        });

        opt2.axn.push({
            text: 'Cancel',
            keycode: 'Escape',
            cb: axn1_callback
        });
    }

    opt2.get_user_input = true;
    obj_set_val_if_missing(opt2, 'cls', 'msgbox-prompt');
    obj_set_val_if_missing(opt2, 'title', 'Need your input');
    msgbox.show(opt2);
};

// get the user remarks (for prompt()).
msgbox.getRemarks = function () {
    var c = msgbox.get();
    var c2 = c.find('.remarks0 > input');
    return text_get_val(c2);
};

//7.Jun.17,lhw-
msgbox.getRemarksCtl = function () {
    var c = msgbox.get();
    return c.find('.remarks0 > input');
};

msgbox.hide = function () {
    // console.log('msgbox.hide');

    // delete 1 msg from the queue.
    if (arrLen(msgbox.pd.queue) > 0) {
        msgbox.pd.queue.splice(0, 1);
    }

    // check to see if there is any other message in the queue.
    if (arrLen(msgbox.pd.queue) == 0) {
        //21-Jul-2020,lhw-
        const cb1 = function _msgbox_hide_cb() {
            msgbox._restore_axn_text();
        };

        //-------------------------
        if (msgbox.visibleEffect == 0) {
            msgbox.get().slideUp(cb1);
        } else if (msgbox.visibleEffect == 1) {
            msgbox.get().fadeOut(cb1);
        } else {
            msgbox.get().hide();
            cb1();
        }

        const blk = progress.getNewLayer(1, msgbox.getBlkZindex());
        blk.hide().off('click');
        msgbox._detach_keydown();
    }
    else {
        msgbox._do_show_next_msg();
    }
};



//19.Oct.18,lhw-change the button text.
msgbox._set_axn_text = function (i, s) {
    msgbox.get().find('.axn' + i.toString()).text(s);
};

//19.Oct.18,lhw-
msgbox._restore_axn_text = function (i, s) {
    var c = msgbox.get();
    c.find('.axn0').text('OK');
    c.find('.axn1').text('Cancel');
};


msgbox.setBlkZindex = function (i) {
    msgbox.pd.blk_zidx = toInt(i);

    // update the blk.
    let blk = progress.getNewLayer(1, msgbox.getBlkZindex());
    if (blk) {
        blk.css('z-index', msgbox.getBlkZindex());
    }
};

msgbox.getBlkZindex = function () {
    if (msgbox.pd.blk_zidx == null || msgbox.pd.blk_zidx <= 0) {
        return 1000;
    }

    return msgbox.pd.blk_zidx;
};

//01-Oct-2021,lhw-
msgbox.isActivated = function () {
    let c2 = $('#msgbox');
    return (c2.length > 0) && c2.is(':visible');
};

msgbox._key_handler = function (e2) {
    if (arrLen(msgbox.pd.queue) == 0) {
        return;
    }

    const opt2 = msgbox.pd.queue[0];
    const m = arrLen(opt2.axn);
    let h;
    for (let i = 0; i < m; i++) {
        const axn2 = opt2.axn[i];

        if (axn2.keycode ) {
            if (typeof axn2.keycode == 'string' && (axn2.keycode == e2.code)) {
                h = true;
            }
            else if (Array.isArray(axn2.keycode)) {
                for (let j = 0; j < axn2.keycode.length; j++) {
                    if (axn2.keycode[j] == e2.key) {
                        h = true;
                        break;
                    }
                }
            }

            if (h) {
                e2.preventDefault();
                e2.stopPropagation();
                msgbox.get().find('.axn' + i).trigger('click');
                return;
            }
        }
    }
}

msgbox._attach_keydown = function () {
    // console.log('msgbox._attach_keydown');
    msgbox._detach_keydown();

    let c2 = celUI.getWnd();
    c2.on('keydown', msgbox._key_handler );
    msgbox.get().trigger('focus');
};

msgbox._detach_keydown = function () {
    // console.log('msgbox._detach_keydown');
    let c2 = celUI.getWnd();
    c2.off('keydown', msgbox._key_handler );
};




//==============================================================================
//21.Nov.15,lhw-
//==============================================================================
function cookie() { }

cookie.set_value = function (k, v) {
    var expires = new Date();
    expires.setTime(expires.getTime() + (1 * 24 * 60 * 60 * 1000));
    document.cookie = k + '=' + v + ';expires=' + expires.toUTCString() + ';sameSite=none;secure;';
};

cookie.get_value = function (k) {
    var keyValue = document.cookie.match('(^|;) ?' + k + '=([^;]*)(;|$)');
    return keyValue ? keyValue[2] : null;
};

cookie.remove = function (k) {
    document.cookie = k + '=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;';
};

//==============================================================================
//21.Nov.15,lhw-this class will fall back to cookie if localStorage is not available.
//==============================================================================
function data() { }

data.set_value = function (k, v) {
    if (typeof localStorage !== 'undefined') {

        //12.Jun.19,lhw-auto convert
        if (v != null && typeof v == 'object') {
            v = JSON.stringify(v);
        }

        localStorage.setItem(k, v);
    }
    else {
        cookie.set_value(k, v);
    }
};

data.get_value = function (k) {
    if (typeof localStorage !== 'undefined') {
        return localStorage.getItem(k);
    }
    else {
        return cookie.get_value(k);
    }
};

//12.Jun.19,lhw-
data.get_obj = function (k) {
    var v;

    if (typeof localStorage !== 'undefined') {
        v = localStorage.getItem(k);
    }
    else {
        v = cookie.get_value(k);
    }

    if (v != null) {
        //30-Jul-2021,lhw-
        // return JSON.parse(v);
        return parseJSONText(v);
    }

    return v;
};

//3.Sep.18,lhw-
data.remove = function (k) {
    if (typeof localStorage !== 'undefined') {
        localStorage.removeItem(k);
    }
    else {
        cookie.remove(k);
    }
};





//-------------------------------
//13.Sep.17,lhw-
//-------------------------------
function sessData() { }

sessData.set_value = function (k, v) {

    if (typeof sessionStorage !== 'undefined') {
        //28-Jul-2020,lhw-auto convert
        if (v != null && typeof v == 'object') {
            v = JSON.stringify(v);
        }

        sessionStorage.setItem(k, v);
    }
    else {
        cookie.set_value(k, v);
    }
};

sessData.get_value = function (k) {
    if (typeof sessionStorage !== 'undefined') {
        return sessionStorage.getItem(k);
    }
    else {
        cookie.get_value(k);
    }
};

//28-Jul-2020,lhw-
sessData.get_obj = function (k) {
    var v;

    if (typeof sessionStorage !== 'undefined') {
        v = sessionStorage.getItem(k);
    }
    else {
        v = cookie.get_value(k);
    }

    if (v != null) {
        //30-Jul-2021,lhw-
        // return JSON.parse(v);
        return parseJSONText(v);
    }

    return v;
};

//1.Jun.18,lhw-
sessData.remove = function (k) {
    if (typeof sessionStorage !== 'undefined') {
        sessionStorage.removeItem(k);
    }
    else {
        cookie.remove(k);
    }
};

/*==============================================================================
07-Sep-2021,lhw-

Sample code:

    try {
        // create a local db.
        let db = new celIdb();
        myApp.pd.ldb = db;

        db.open('ciysys-admcli', 1,
            function _idb_upg(db2, tx) {
                if (!db2.tableExist('obj')) {
                    db2.createTable('obj', 'id');
                }
            },
            function _idb_open(x) {
                if (x) {
                    //failed to open the db, disable the cache.
                    myApp.pd.ldb = null;
                }

                // ok to run any op
                //...
            });
    }
    catch {
        console.log('failed to open idx #2');
        //failed to open the db, disable the cache.
        myApp.pd.ldb = null;

        // continue the app?
        //...
    }

==============================================================================*/
function celIdb() {
    let self = this;
    self.db = null;
    self.max_retry = 5;
    self.retry_interval = 50;

    //-------------------------
    // open the database
    // upgrade:fn(db:celIdb, tx)
    // cb:fn(err)
    //-------------------------
    self.open = function (n, v, upgrade, cb) {
        let idb = celIdb.getDbEngine();
        if (!idb) {
            cb(new Error('indexedDB is not supported'));
            return;
        }

        let req = idb.open(n, v);
        _handle_err(req, cb);

        req.onupgradeneeded = function (event) {
            // console.log('onupgradeneeded', event.target.transaction)
            self.db = event.target.result;

            // reference:
            // https://gist.github.com/TalAter/45e0b87ee0cf8b65f943c4320b092b0e
            upgrade(self, event.target.transaction);

        };

        req.onsuccess = function (e2) {
            // get the db ref
            self.db = e2.target.result;

            if (cb) {
                cb();
            }
        };
    };

    //-------------------------
    function _handle_err(req, cb) {
        req.onerror = function (e2) {
            console.log('idb=>', e2.target.error);
            cb(new Error('failed'));
        };
    }

    //-------------------------
    function _handle_success(req, cb) {
        req.onsuccess = function (e2) {
            if (cb) {
                cb(null);
            }
        };
    }

    //-------------------------
    // returns an array that contains all table names.
    //-------------------------
    self.allTables = function () {
        return self.db.objectStoreNames;
    };

    //-------------------------
    // returns true if the table already exist.
    //-------------------------
    self.tableExist = function (n) {
        return self.db.objectStoreNames.contains(n);
    };

    //-------------------------
    // create a new table.
    // - n- table name.
    // - kn - key name.
    //-------------------------
    self.createTable = function (n, kn) {
        let store = self.db.createObjectStore(n, { keyPath: kn });

        // default primary index name is 'pk'.
        store.createIndex('pk', kn, { unique: true });
    };

    //-------------------------
    // delete a table.
    //-------------------------
    self.dropTable = function (n) {
        self.db.deleteObjectStore(n);
    };

    //-------------------------
    // get the table.
    // Notes: this proc might crash due to creating new transaction failed.
    //        The caller must handle it manually if calling this proc directly.
    //-------------------------
    self.getTb = function (n, rw, tx) {
        if (typeof tx != 'undefined' && tx != null) {
            return tx.objectStore(n);
        }

        if (rw) {
            return self.db.transaction([n], 'readwrite').objectStore(n);
        }
        else {
            return self.db.transaction([n]).objectStore(n);
        }
    };


    //-------------------------
    // returns true if the index already exist.
    //-------------------------
    self.indexExist = function (tb, idx, tx) {
        let store = self.getTb(tb, null, tx);
        return store.indexNames.contains(idx);
    };

    //-------------------------
    // find the data where 'rec' is undefined it does not exist.
    // cb:fn(err, rec)
    //-------------------------
    self.getData = function (tb, k, cb) {
        let retry = 0;

        function _do_get_data() {
            try {
                let store = self.getTb(tb);
                let req = store.get(k);
                _handle_err(req, cb);

                req.onsuccess = function (e2) {
                    cb(null, e2.target.result);
                };
            }
            catch (x) {
                setTimeout(() => {
                    retry++;
                    if (retry > self.max_retry) {
                        throw (x)
                    }

                    // retry
                    _do_get_data();
                }, self.retry_interval);
            }
        }

        // start the process
        _do_get_data();
    };

    //-------------------------
    // add/update the rec in idb.
    // cb:fn(err)
    //-------------------------
    self.setData = function (tb, k, v, cb) {
        let retry = 0;

        function _do_set_data() {
            try {
                let store = self.getTb(tb, true);
                let req = store.get(k);
                _handle_err(req, cb);

                req.onsuccess = function (e2) {
                    if (e2.target.result) {
                        // rec exist - update
                        let req2 = store.put(v);
                        _handle_err(req2, cb);
                        _handle_success(req2, cb);
                    }
                    else {
                        // rec not exist - add
                        let req2 = store.add(v);
                        _handle_err(req2, cb);
                        _handle_success(req2, cb);
                    }
                };
            }
            catch (x) {
                setTimeout(() => {
                    retry++;
                    if (retry > self.max_retry) {
                        throw (x)
                    }

                    // retry
                    _do_set_data();
                }, self.retry_interval);
            }
        }

        // start the process
        _do_set_data();
    };


    //-------------------------
    // delete the data.
    // cb:fn(err)
    //-------------------------
    self.remove = function (tb, k, cb) {
        let retry = 0;

        function _do_remove() {
            try {
                let store = self.getTb(tb, true);
                let req = store.delete(k);
                _handle_err(req, cb);
                _handle_success(req, cb);
            }
            catch (x) {
                setTimeout(() => {
                    retry++;
                    if (retry > self.max_retry) {
                        throw (x)
                    }

                    // retry
                    _do_remove();
                }, self.retry_interval);
            }
        }

        // start the process
        _do_remove();
    };

    //-------------------------
    // retrieve all recs and returns it one after another.
    // - cb:fn(err, rec):bool - to be each for every rec. Returns false to stop the loop.
    // - [idx] - if value has been specified, the rec will be retrieved using this index.
    //          -> side effects - NULL value will be ignore from the output.
    //-------------------------
    self.foreach = function (tb, cb, idx) {
        let retry = 0;

        function _do_foreach() {
            try {
                let store = self.getTb(tb);
                if (idx) {
                    store = store.index(idx);
                }

                let req = store.openCursor();
                _handle_err(req, cb);

                req.onsuccess = function (e2) {
                    let rec = e2.target.result;
                    if (rec) {
                        let b = cb(null, rec.value);

                        if (typeof b != 'undefined' && b == false) {
                            // stop the loop
                            return;
                        }

                        // next rec
                        rec.continue();
                    }
                    else {
                        // EOF
                        cb();
                    }
                };
            }
            catch (x) {
                setTimeout(() => {
                    retry++;
                    if (retry > self.max_retry) {
                        throw (x)
                    }

                    // retry
                    _do_foreach();
                }, self.retry_interval);
            }
        }

        // start the process
        _do_foreach();
    };

    //-------------------------
    // retrieve all recs.
    // - cb:fn(err, l) - returns all recs to the caller.
    // - [idx] - if value has been specified, the rec will be retrieved using this index.
    //          -> side effects - NULL value will be ignore from the output.
    //-------------------------
    self.all = function (tb, cb, idx) {
        let retry = 0;
        let l2 = [];

        function _all() {
            try {
                let store = self.getTb(tb);
                if (idx) {
                    store = store.index(idx);
                }

                let req = store.openCursor();
                _handle_err(req, cb);

                req.onsuccess = function (e2) {
                    let rec = e2.target.result;
                    if (rec) {
                        l2.push(rec.value);

                        // next rec
                        rec.continue();
                    }
                    else {
                        // EOF
                        cb(null, l2);
                    }
                };

            } catch (x) {
                setTimeout(() => {
                    retry++;
                    if (retry > self.max_retry) {
                        throw (x)
                    }

                    // retry
                    _all();
                }, self.retry_interval);
            }
        }

        _all();
    };
}

//-------------------------
// returns true if the browser supports IDB.
celIdb.getDbEngine = function () {
    return (window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB);
};

//-------------------------
// - cb:fn(err, arr)
celIdb.deleteDb = function (n) {
    let idb = celIdb.getDbEngine();
    if (idb) {
        idb.deleteDatabase(n);
    }
};




//==============================================================================
// to find the exact match in the array.
// predicate(o):int => '0'-equal, '1'-greater, '-1'-smaller.
// 'target' => optional. The value to be pass into the predicate.
// The index will be return once it found the item.
//==============================================================================
function binarySearch(arr, predicate, target) {
    var m = 0;
    var n = arr.length - 1;
    var k;
    var cmp;

    while (m <= n) {
        k = (n + m) >> 1;
        cmp = predicate(arr[k], target);

        if (cmp > 0) {
            m = k + 1;
        } else if (cmp < 0) {
            n = k - 1;
        } else {
            return k;
        }
    }
    return m - 1;
}

//==============================================================================
//20.Jun.16,lhw-insert the new item into the 'sorted' element array.
//==============================================================================
$.fn.insertItem = function (j_arr, text_class, new_text, new_j_obj) {
    var max = j_arr.length;
    var done = false;

    new_text = new_text.toLowerCase();

    for (var i = 0; i < max; i++) {
        let c3 = $(j_arr[i]);
        let text2 = text_get_val(c3.find('.' + text_class), null, true).trim().toLowerCase();

        if (text2 > new_text) {
            new_j_obj.insertBefore(c3);
            done = true;
            break;
        }
    }

    // append the new object to the end of 'this' (ie, jquery object).
    if (!done) {
        this.append(new_j_obj);
    }
};

//30.Jun.16,lhw-
$.fn.extractClassThatStartsWith = function (cls_prefix) {
    var cls = this.attr('class');

    if (!isStrEmpty(cls)) {
        cls = cls.split(' ');

        for (var i = 0; i < cls.length; i++) {
            if (cls[i].startsWith(cls_prefix)) {
                return cls[i];
            }
        }
    }
    return null;
};

//30.Jun.16,lhw-
$.fn.replaceClass = function (old_cls, new_cls) {
    return this.removeClass(old_cls).addClass(new_cls);
};

//8.Jul.16,lhw-
$.fn.setEnable = function (b) {
    return this.prop('disabled', !b);
};

//26.Jul.16,lhw-
$.fn.isEnabled = function () {
    return !this.prop('disabled');
};

//8.Jul.16,lhw-
$.fn.setVisible = function (b) {
    if (b) {
        this.show();
    }
    else {
        this.hide();
    }
};

//10.Jul.16,lhw-return true if the text content is same as 's'.
$.fn.isTextEqual = function (s) {
    return isStrEqual(text_get_val(this, null, true, true), s);
};

//==============================================================================
//30.Jun.16,lhw
// -run the callback for multiple times without have to worry someone mess up the looping var.
// -the functions are chainable.
//
// where 'myConditionNotMatch()' is a function that will return false to stop the loop.
//
//  celLoop.runBetween(3, 10, function (i) {
//      if (myConditionNotMatch(i)) {
//           console.log(i);
//      } else { return false; }
//  });
//
//  celLoop.repeatFor(3, function (i) {
//      console.log(i);
//  });
//
//==============================================================================
const celLoop = {
    // run the process between i and j (inclusive of both i & j values).
    runBetween: function (i, j, p) {
        var a;
        var b;

        if (i instanceof Date && j instanceof Date) {
            //27.Jun.19,lhw-handle date range
            var dt0 = i;
            var sd = toSysDate(dt0);
            var ed = toSysDate(j);

            while (sd <= ed) {
                b = p(dt0);
                if (!isUndefinedOrNull(b) && !b) {
                    break;
                }

                dt0 = addDays(dt0, 1);
                sd = toSysDate(dt0);
            }
            return;
        }


        if (i <= j) {
            for (a = i; a <= j; a++) {
                b = p(a);
                if (!isUndefinedOrNull(b) && !b) {
                    break;
                }
            }
        }
        else {
            for (a = i; a >= j; a--) {
                b = p(a);
                if (!isUndefinedOrNull(b) && !b) {
                    break;
                }
            }
        }
        return this;
    },

    // repeat the same process for n times.
    repeatFor: function (n, p) {
        if (n > 0) {
            return this.runBetween(0, n - 1, p);
        }
        else {
            return this;
        }
    },

    // repeat until 'c()' or 'p()' returns false.
    // 'c' can be something other than function.
    whileTrue: function (c, p) {
        var b;
        var is_func = (typeof c === 'function');

        while ((is_func && c()) || (!is_func && c)) {
            b = p();
            if (!isUndefinedOrNull(b) && !b) {
                break;
            }
        }
        return this;
    },


    /**
     * 20.Jul.16,lhw- loop all the items in the array and stop when p() returns false.
     * @param {Array|Object} arr - if passed in an object, struct={startIdx, endIdx,p,arr/list}
     * @param {Function} p
     * @param {Number} [startIdx]
     * @param {Number} [endIdx]
     * @returns
     */
    each: function (arr, p, startIdx, endIdx) {
        if (!arr) {
            return;
        }

        // if the caller pass in the param as an object, parse it to the appropriate param.
        //30.Dec.18,lhw-bug fixed- "typeof 'a=[]'" is an object!! Check the 'length' property as well.
        if (!Array.isArray(arr) && !(length in arr) && (typeof arr === 'object')) {

            if (obj_has_fld(arr, 'startIdx')) {
                startIdx = arr.startIdx;
            }
            if (obj_has_fld(arr, 'endIdx')) {
                endIdx = arr.endIdx;
            }

            if (arr.p) {
                p = arr.p;
            }

            if (arr.arr) {
                arr = arr.arr;
            }
            else if (arr.list) {
                arr = arr.list;
            }
        }

        if (!arr || (arr && arr.length === 0)) {
            return;
        }

        var b;
        var o;
        var r = celLoop.getRange(arr, startIdx, endIdx);

        for (var a = r.start; a < r.end; a++) {
            o = arr[a];

            //18-jul-17,lhw-pass the array index as well.
            //b = p(o);
            b = p(o, a);

            if (!isUndefinedOrNull(b) && !b) {
                break;
            }
        }
    },

    /**
     * 02-Jul-2022,lhw-
     * - Loop through all fields in the given object.
     * @param {Object} o
     * @param {Function} p - fn(v2, k2):[b]
     */
    eachFld: function (o, p) {
        let k = Object.keys(o);

        celLoop.each(k, function (k2) {
            let v2 = o[k2];
            let b = p(v2, k2);

            if (b === false) {
                return false;
            }
        });
    },

    //2.Sep.18,lhw-reverse loop.
    eachReverse: function (arr, p, startIdx, endIdx) {
        if (!arr) {
            return;
        }

        // if the caller pass in the param as an object, parse it to the appropriate param.
        if (typeof arr === 'object') {
            if (arr.startIdx) {
                startIdx = arr.startIdx;
            }
            if (arr.endIdx) {
                endIdx = arr.endIdx;
            }
            if (arr.p) {
                p = arr.p;
            }

            if (arr.arr) {
                arr = arr.arr;
            }
            else if (arr.list) {
                arr = arr.list;
            }
        }

        if (!arr || (arr && arr.length === 0)) {
            return;
        }

        var b;
        var o;
        var r = celLoop.getRange(arr, startIdx, endIdx);

        for (var a = (r.end - 1); a >= r.start; a--) {
            o = arr[a];
            b = p(o, a);

            if (!isUndefinedOrNull(b) && !b) {
                break;
            }
        }
    },

    //27.Aug.16,lhw-returns the range of the array or the user defined range.
    getRange: function (arr, startIdx, endIdx) {
        var r = { start: null, end: null };

        if (arr) {
            if (isUndefinedOrNull(startIdx)) {
                r.start = 0;
            } else {
                r.start = startIdx;
            }

            if (isUndefinedOrNull(endIdx)) {
                r.end = arr.length;
            } else {
                r.end = endIdx;
            }
        }

        return r;
    },

    //3.Jun.17,lhw-sum all the item.
    sum: function (arr, fld, p) {
        if (!arr) {
            return;
        }

        var m = arrLen(arr);
        var total = 0;

        for (var i = 0; i < m; i++) {
            if (!isUndefinedOrNull(p)) {
                // let the predicate to decide whether to sum the value.
                if (p(arr[i])) {
                    total += toDbl(arr[i][fld]);
                }
            }
            else {
                total += toDbl(arr[i][fld]);
            }
        }

        return total;
    },

    //3.Jun.17,lhw-get the max value.
    max: function (arr, fld, p) {
        if (!arr) {
            return;
        }

        var m = arrLen(arr);
        var max = 0;
        var v;

        for (var i = 0; i < m; i++) {
            if (!isUndefinedOrNull(p)) {
                // let the predicate to decide
                if (p(arr[i])) {
                    v = toDbl(arr[i][fld]);

                    if (v > max) {
                        max = v;
                    }
                }
            }
            else if (v > max) {
                v = toDbl(arr[i][fld]);
                max = v;
            }
        }

        return max;
    },

    //1.Jul.18,lhw-returns the first item that matches the predicate.
    findFirst: function (l, p) {
        return arrFindFirst(l, p);
    },

    //1.Jul.18,lhw-returns the array of items that matches the predicate.
    filter: function (l, p) {
        return arrWhere(l, p);
    },

    //19.May.20,lhw-group the items by the given field.
    // By default, it returns an Object. You may pass in 'ret_obj=false' to return an array.
    // fn_get_val(o) => the function that reads and returns the value from the obj.
    //02-Aug-2021,lhw-added 'opt'.
    //  opt.flat_obj=bool - if 'ret_obj=true' and 'flat_obj=true', the id vs item is one to one.
    //                      By default, it is one to an array.
    groupBy: function (l, fld, ret_obj, fn_get_val, opt) {
        var r0;
        let v0 = null;

        // setup the func to read the value.
        if (typeof fn_get_val == 'undefined' || fn_get_val == null) {

            fn_get_val = function (o2) {
                return obj_get_val(o2, fld);
            };

        }

        if (typeof ret_obj == 'undefined' || ret_obj) {
            // return an object structure
            r0 = {};

            celLoop.each(l, function (i0) {
                let v2 = fn_get_val(i0);

                //9.Jun.20,lhw-the following works if the array is sorted by 'fld'.
                ////if (v0 == null || !isStrEqual(v0, v2)) {
                ////    // the value has changed.
                ////    v0 = v2;
                ////    // create new array
                ////    r0[v0] = [];
                ////}
                ////r0[v0].push(i0);

                ////console.log('push, v2=', v2, i0)

                if (opt && opt.flat_obj) {
                    //02-Aug-2021,lhw-this returns 1 to 1 and useful for creating index for an array.
                    r0[v2] = i0;
                }
                else {
                    // this returns 1 to many.
                    //26-Nov-2021,lhw-bug fixed-must convert 'v2' to string when calling obj_has_fld().
                    // Otherwise, numeric field name will have wrong result.
                    if (!obj_has_fld(r0, v2.toString())) {
                        r0[v2] = [];
                    }

                    r0[v2].push(i0);
                }

            });

        }
        else {

            // return an array structure (without the 'group key')
            r0 = [];
            let depth = -1;

            celLoop.each(l, function (i0) {
                let v2 = fn_get_val(i0);

                if (v0 == null || !isStrEqual(v0, v2)) {
                    // the value has changed.
                    v0 = v2;

                    // create new array
                    depth++;
                    r0.push([]);
                }

                r0[depth].push(i0);
            });
        }

        return r0;
    },

    /**
     * 01-Dec-2022,lhw-
     * - Convert the data list to an object where the data is accessible with the unique field value.
     * - This will speed up the lookup process.
     * @param {array} l - the data list.
     * @param {string} fld - group the data by this 'unique' field. If duplicate value was found, the last object will remain.
     * @returns
     */
    toFlatObj: function (l, fld) {
        return celLoop.groupBy(l, fld, true, null, { flat_obj: true });
    },

};


//------------------------------------------------------------------------------
//23.Jan.17,lhw-convert the webcam image (ie, dataURI) to the blob object.
function dataURItoBlob(dataURI) {
    var binary = atob(dataURI.split(',')[1]);
    var array = [];

    for (var i = 0; i < binary.length; i++) {
        array.push(binary.charCodeAt(i));
    }
    return new Blob([new Uint8Array(array)], { type: 'image/jpeg' });
}

//23.Jan.17,lhw-
function createFileObj(file_name, file_type, blob) {
    var f = new File([blob], file_name, { type: file_type });
    return f;
}


//9.Jan.17,lhw-
function getBaseUrl() {
    if (_base_url) {
        if (_base_url.substr(_base_url.length - 1, 1) !== '/') {
            _base_url += '/';
        }

        return _base_url;
    }

    return '';
}

// Returns the full booking URL based on current site origin
function getBookingUrl() {
    return window.location.origin + "/booking";
    //return "http://localhost:81/everly/booking";
}

//
//
/**
 * 12.Dec.16,lhw-perform ajax call.
 * 23.Jan.19,lhw-added param: rtn_jqXHR -default is to delay the ajax call for ui to process.
 * 12-Oct-2021,lhw
 * -Added `on_invalid_sess(p)` and `on_filter_resp(p)` callback.
 * -Added `queue:bool` to run the ajax call sequentially.
 *
 * @param {String|Object} url 19-Nov-2020,lhw-allows caller to pass in args as an object. The query 'url' is optional. It uses the default if missing.
 * struct: {p:{code,axn,data:{}}, on_success(d), on_fail(d),on_filter_resp(d), on_invalid_sess()}
 *
 * @param {Object} p The query param object to be posted to the server.
 * @param {Function} callback
 * @param {Function} on_fail_callback
 * @param {Boolean} check_status
 * @param {Boolean} rtn_jqXHR
 */
function ajaxCall(url, p, callback, on_fail_callback, check_status, rtn_jqXHR) {

    function _ajax_call(url2, p2, callback2, on_fail_callback2, check_status2, rtn_jqXHR2) {
        //22-Jul-2021,lhw-new value is zero (previously was 100ms).
        let run_after = 0;
        //12-Oct-2021,lhw-allows caller to handle the invalid sess situation.
        let on_invalid_sess = null;
        let on_filter_resp = null;
        let queue = null;

        //<<==========
        //19-Nov-2020,lhw- if the caller pass in 1 arg, parse the arg.
        //30-Jul-2021,lhw-skip the checking of args len.
        // if (typeof url2 == 'object' && arguments.length == 1) {
        if (typeof url2 == 'object') {
            let o0 = url2;

            url2 = o0.url;
            p2 = o0.p;

            //22-Jul-2021,lhw-
            run_after = (o0.run_after || 0);

            if (o0.on_success) {
                //30-Dec-2020,lhw-new alias
                callback2 = o0.on_success;
            }
            else if (o0.callback) {
                callback2 = o0.callback;
            }
            else if (o0.cb) {
                callback2 = o0.cb;
            }

            if (o0.on_fail) {
                //30-Dec-2020,lhw-new alias
                on_fail_callback2 = o0.on_fail;
            }
            else if (o0.on_fail_callback) {
                on_fail_callback2 = o0.on_fail_callback;
            }
            else if (o0.on_fail_cb) {
                on_fail_callback2 = o0.on_fail_cb;
            }

            check_status2 = o0.check_status;
            rtn_jqXHR2 = o0.rtn_jqXHR;

            //12-Oct-2021,lhw-
            on_invalid_sess = o0.on_invalid_sess;
            on_filter_resp = o0.on_filter_resp;
            queue = o0.queue;
        }
        /// https://cors-anywhere.herokuapp.com/https://obe.fastsoftware.biz/fastobe/q/
        //allows NULL url - replace it with default value.
        if (typeof url2 == 'undefined' || url2 == null) {
            url2 = getBaseUrl() + 'q';
        }
        //<<==========

        var on_success = function (d) {
            //30-Jul-2021,lhw-
            // d = JSON.parse(d);
            d = parseJSONText(d);


            // console.log('ajax', JSON.stringify(p2));
            // console.log('=> on_success:', d, isInvalidSession(d));

            if ((isUndefinedOrNull(check_status2) || check_status2) && isInvalidSession(d)) {
                // console.log('=> invalid_sess', JSON.stringify(p2, null, 2));

                //12-Oct-2021,lhw-allows override the default behavior.
                if (on_invalid_sess) {
                    on_invalid_sess(d);
                    return;
                }

                //04-Jul-2022,lhw-trigger the global behavior.
                if (celestial.on_invalid_sess) {
                    celestial.on_invalid_sess(d);
                    return;
                }

                //-------------------------------
                //3.Sep.18,lhw-prevent infinite reload on current page.
                var h = data.get_value('reload_hist');

                if (!isUndefinedOrNull(h)) {
                    //30-Jul-2021,lhw-
                    // h = JSON.parse(h);
                    h = parseJSONText(h);

                    if (obj_has_fld(h, window.location.href)) {

                        var ts = new Date(h[window.location.href].ts);
                        var v = (new Date()) - ts;

                        if (v < 500) {
                            //prevent infinite reload of current page.
                            if (h[window.location.href].cnt >= 2) {
                                return;
                            }

                            h[window.location.href].cnt++;
                            data.set_value('reload_hist', JSON.stringify(h));

                            // jump to base url (that should be the login screen).
                            window.location.href = getBaseUrl();
                            return;
                        }
                    }
                    else {
                        //reset the value.
                        h = {};
                    }
                }
                else {
                    h = {};
                }

                h[window.location.href] = { ts: new Date(), cnt: 1 };
                data.set_value('reload_hist', JSON.stringify(h));
                //-------------------------------

                //10.Sep.18,lhw-
                if (typeof _invld_sess_redir != 'undefined' && toInt(_invld_sess_redir) == 1) {
                    // jump to base url (that should be the login screen).
                    window.location.href = getBaseUrl();
                }
                else {
                    reloadCurrentPage();
                }

                return;
            }

            //-------------------------------
            //12-Oct-2021,lhw-preprocess the response - this allows the caller to handle
            // the custom message before throwing it as an err.
            if (on_filter_resp) {
                if (on_filter_resp(d)) {
                    return;
                }
            }

            //06-Aug-2022,lhw-trigger the global behavior.
            if (celestial.on_filter_resp) {
                let b = celestial.on_filter_resp({ req: p2, res: d });

                // if already handled, exit.
                if (b === true) {
                    return;
                }
            }

            if (isUndefinedOrNull(check_status2) || check_status2) {
                if (d && d.msg && !isStrEqual(d.msg, 'ok')) {
                    if (isStrEqual(d.msg, 'access_deny')
                        //25-Jun-2021,lhw-translate the mesage
                        || isStrEqual(d.msg, 'access deny')
                    ) {
                        //30-May-2021,lhw-grammar err.
                        // d.msg = 'Access deny';
                        d.msg = 'Access denied';
                    }

                    //10.Sep.18,lhw-
                    ////msgbox.show(d.msg);
                    msgbox.err(d.msg);

                    if (on_fail_callback2 != null) {
                        on_fail_callback2(d);
                    }
                    return;
                }
            }

            if (callback2) {
                callback2(d);
            }
        };


        // if (typeof url2 == 'object') {
        //     debugger;
        // }

        //-------------------------
        if (rtn_jqXHR2) {

            return $.ajax({
                type: 'POST',
                url: url2,
                data: JSON.stringify(p2),
                contentType: 'application/json',
                success: on_success
            });

        }
        else {

            // console.log('ajax p=', p);
            if (queue || celestial.queue_ajax) {

                //12-Oct-2021,lhw-run the ajax calls sequentially.
                let j = {
                    fn: function _do_ajax_call() {
                        $.ajax({
                            type: 'POST',
                            url: url2,
                            data: JSON.stringify(p2),
                            contentType: 'application/json',
                            success: function (d2) {
                                try {
                                    // run the process
                                    on_success(d2);
                                }
                                finally {
                                    // mark done and next job will be run.
                                    celestial.pd.ajax_seq_job[0].done(j);
                                }
                            },
                            error: function(xhr2, status, err) {
                                //17-Nov-2022,lhw-handle the cors err. If not, the ajax queue will be blocked.
                                // show the err
                                console.log('failed at calling: ' + url2);
                                console.log('-status:' + status);
                                console.log('-err:' + err);

                                // moved on to next request
                                celestial.pd.ajax_seq_job[0].done(j);
                            }
                        });
                    }
                };

                celestial.pd.ajax_seq_job[0].queue(j);

            }
            else if (run_after <= 0) {
                //12-Oct-2021,lhw-this avoids the calls to setTimeout().
                $.ajax({
                    type: 'POST',
                    url: url2,
                    data: JSON.stringify(p2),
                    contentType: 'application/json',
                    success: on_success
                });
            }
            else {

                //23.Jan.19,lhw-default behaviour.
                // delay the ajax call by 100ms so that the "spinner" (ui) won't be
                // blocked by ajax call.
                setTimeout(function () {
                    $.ajax({
                        type: 'POST',
                        url: url2,
                        data: JSON.stringify(p2),
                        contentType: 'application/json',
                        success: on_success
                    });
                }, run_after);
            }
        }
    }

    //-------------------------
    // 30-Jul-2021,lhw-serialize multiple ajax calls.
    // 'url' - [{ url, p, on_success, on_fail, check_status, rtn_jqXHR },..]
    if (Array.isArray(url)) {
        let fn = {};
        fn.idx = 0;

        fn.run = function _run() {
            let o2 = url[fn.idx];
            let on_success0 = o2.on_success;

            o2.on_success = function (d2) {
                if (on_success0) {
                    on_success0(d2);
                }

                fn.idx++;
                if (fn.idx < url.length) {
                    // next step.
                    fn.run();
                }
            };

            _ajax_call(o2);
        }

        // run for the first time.
        fn.run();
    }
    else {
        return _ajax_call(url, p, callback, on_fail_callback, check_status, rtn_jqXHR);
    }
}



//------------------------------------------------------------------------------
//3.Sep.18,lhw-the 'reload_hist' was saved by ajaxCall() above.
function popReloadHist() {
    var h = data.get_value('reload_hist');

    if (!isUndefinedOrNull(h)) {
        var k = Object.keys(JSON.parse(h));

        if (arrLen(k) > 0) {
            h = k[0];
        }
        else {
            h = null;
        }
    }

    data.remove('reload_hist');
    return h;
}


//31.Aug.18,lhw-added 'skip_cache' param. By default, load once and cache the resource.
function loadResource(url, callback, skip_cache) {

    // console.log('loadResource', url);

    //31.Aug.18,lhw-
    ////$.ajax({
    ////    url: url,
    ////    success: callback
    ////});

    if (skip_cache) {

        //always download from web server.
        $.ajax({
            url: url,
            success: function (d) {
                callback(d);
            }
        });

    }
    else {

        if (!obj_has_fld(celestial, 'cache')) {
            celestial.cache = {};
        }

        if (obj_has_fld(celestial.cache, url)) {
            // get the resource from cache
            callback(celestial.cache[url]);
        }
        else {

            // load from web server.
            $.ajax({
                url: url,
                success: function (d) {
                    // cache the resource
                    celestial.cache[url] = d;

                    // exec the callback
                    callback(d);
                },
                //21.Nov.18,lhw-
                error: function (xhr, status, err) {
                    console.log('loadResource err=> ', url, xhr, status, err);
                }
            });
        }
    }

}

//4.Mar.17, lhw-this proc loads the css & js where the js responsible for loading the html.
function loadResourceByCode(code) {
    addCssFile(code, getBaseUrl() + 't?code=' + code + '.css&ts=' + getNowString());
    addJsFile(getBaseUrl() + 't?code=' + code + '.js');
}

//9.Jan.17,lhw-
function addCssFile(id, u) {
    var c = $('#' + id);
    if (c.length === 0) {
        $('head').append('<link href="' + u + '" rel="stylesheet" id="' + id + '" />');
    }
}

//9.Jan.17,lhw-
function removeCssFile(id) {
    var c = $('#' + id);
    c.remove();
}

//9.Jan.17,lhw-
function addJsFile(u, callback) {

    //1.May.20,lhw-delay to execute the callback because the loaded js might not ready immediately.
    // This happened after upgraded jQuery from v1.7 to v3.5 or could be the browser issue.
    //$.getScript(u, callback)
    $.getScript(u, function () {

        setTimeout(function () {
            if (callback) {
                callback();
            }
        }, 200);

    })
        //21.Nov.18,lhw-show err
        .fail(function (xhr, status, err) {
            console.log('loading.. ', u);
            console.log('addJsFile err=>', xhr, status, err);
        });

}

//26.Mar.17, lhw-convert xml doc to string.
function xmlToString(x) {
    var s = new XMLSerializer().serializeToString(x.documentElement);
    return s;
}

//22.Jan.17,lhw-
function monthIndex(s) {
    var m = arrLen(celestial.mth);

    for (var i = 0; i < m; i++) {
        if (isStrEqual(celestial.mth[i], s)) {
            return i;
        }
    }
    return 0;
}

//6.Mar.17, lhw-
function cbo_fill_month(c, blank_text) {
    cbo_clear(c);

    if (!isUndefinedOrNull(blank_text)) {
        cbo_add_item(c, blank_text, '0');
    }

    var m = arrLen(celestial.mth);

    for (var i = 0; i < m; i++) {
        cbo_add_item(c, celestial.mth[i], (i + 1).toString());
    }
}

//8.Mar.17, lhw-
function isMobile() {

    //11.Jul.20,lhw-
    //var c = $(document);
    //return (c.width() < 500);

    // https://stackoverflow.com/questions/3514784/what-is-the-best-way-to-detect-a-mobile-device?rq=1
    let check = false;

    if (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
        check = true;
    }

    return check;
}


//16.Aug.18,lhw-
celestial._isiOS = null;

function isiOS() {
    if (celestial._isiOS == null) {
        var s = navigator.userAgent.toLowerCase();
        celestial._isiOS = s.match(/(iphone|ipod|ipad)/);
    }
    else {
        return celestial._isiOS;
    }
}


//==============================================================================
//5.Jul.17,lhw-tips to be attached to the control.
//
//  var t = new celTips({ text: 'Click here to add new item.',
//      for_ctl: c0.find('.btn-add-item'),
//      width: 300, height: 40,
//      arrow_dir: 'left' });
//  t.show();
//
//==============================================================================
//opt
//- text
//- for_ctl
//- tips_ctl
//- width
//- height
//- arrow_dir:left
//==============================================================================

function celTips(opt) {
    let self = this;
    let myid = celTips.getNewID();

    this.getContainer = function () {
        var c0;

        c0 = getJObject('cel-tips-' + myid);
        if (c0.length === 0) {
            c0 = $('<div class="cel-tips cel-tips-' + myid + ' flx-nw"><div class="cel-tips-arrow"></div><div class="cel-tips-content"></div></div>');
            $('body').append(c0);
            c0 = getJObject('cel-tips-' + myid);
            c0.attr('data-id', myid);
            celTips.addRef(c0);
        }

        return c0;
    };

    this.show = function () {
        var c0;
        var c2;
        var c3;
        var l;
        var t;

        c0 = self.getContainer();
        c2 = c0.find('.cel-tips-content');

        // show the tips.
        c2.html(opt.text);

        if (isUndefinedOrNull(opt.width) || opt.width <= 0) {
            opt.width = 200;
        }
        if (isUndefinedOrNull(opt.height) || opt.height <= 0) {
            opt.height = 200;
        }
        if (isUndefinedOrNull(opt.arrow_dir)) {
            opt.arrow_dir = 'left';
        }

        c2.css('width', opt.width.toString() + 'px');
        c2.css('height', opt.height.toString() + 'px');

        //-------------------------------
        var pos = opt.for_ctl.offset();
        var h = opt.for_ctl.height();
        var w = opt.for_ctl.width();
        // var ph = c0.height();
        var pw = c0.width();

        l = pos.left + w - pw;
        t = pos.top + h + 10;
        c3 = c0.find('.cel-tips-arrow');

        if (opt.arrow_dir == 'left') {
            l = pos.left + w + 10;
            t = pos.top - (opt.height / 2);

            if (l + pw + 20 >= $(document).width()) {
                //bound checking:right => show up arrow
                l = pos.left + w - pw;
                t = pos.top + h + 10;

                if (c3.hasClass('cel-tips-arrow-r')) {
                    c3.removeClass('cel-tips-arrow-r');
                }
                if (c3.hasClass('cel-tips-arrow-l')) {
                    c3.removeClass('cel-tips-arrow-l');
                }

                c3.addClass('cel-tips-arrow-u');
                c3.css('margin-top', '0');

                if (pos.left > opt.width) {
                    c3.css('margin-left', (opt.width - 5).toString() + 'px');
                }
                else {
                    c3.css('margin-left', (pos.left - 1).toString() + 'px');
                }

                c0.css('flex-direction', 'column');
            }
            else {
                // show left arrow.
                if (c3.hasClass('cel-tips-arrow-r')) {
                    c3.removeClass('cel-tips-arrow-r');
                }
                c3.addClass('cel-tips-arrow-l');
                c3.css('margin-top', (opt.height / 2).toString() + 'px');
                c0.css('flex-direction', 'row');
            }

        }
        else if (opt.arrow_dir == 'right') {
            l = pos.left - pw - 10;
            t = pos.top - (opt.height / 2);

            if (l < 10) {
                //bound checking:left=> show up arrow
                l = pos.left - pw + w + 10;
                t = pos.top + h + 10;

                if (c3.hasClass('cel-tips-arrow-r')) {
                    c3.removeClass('cel-tips-arrow-r');
                }
                if (c3.hasClass('cel-tips-arrow-l')) {
                    c3.removeClass('cel-tips-arrow-l');
                }

                c3.addClass('cel-tips-arrow-u');
                c3.css('margin-top', '0');
                c3.css('margin-left', (pos.left - w - 10).toString() + 'px');

                c0.css('flex-direction', 'column');
            }
            else {
                // show right arrow.
                if (c3.hasClass('cel-tips-arrow-l')) {
                    c3.removeClass('cel-tips-arrow-r');
                }

                c3.addClass('cel-tips-arrow-r');
                c3.css('margin-top', (opt.height / 2).toString() + 'px');
                c0.css('flex-direction', 'row-reverse');
            }
        }

        c0.css({ left: l, top: t });
        //-------------------------------

        c0.show();
    };

    this.hide = function () {
        self.getContainer().hide();
    };

    return this;
}

celTips.list = [];
celTips.last_id = 0;

// generate a unique id for the tips.
celTips.getNewID = function () {
    celTips.last_id++;
    return celTips.last_id.toString();
};

// add a reference
celTips.addRef = function (c) {
    celTips.list.push(c);
};

// remove one reference.
celTips.removeRef = function (c) {
    var id0;
    var c0;
    let m = arrLen(celTips.list);
    let id2 = c.attr('data-id');

    for (var i = 0; i < m; i++) {
        c0 = celTips.list[i];
        id0 = c0.attr('data-id');

        if (isStrEqual(id0, id2)) {
            //remove from memory
            arrRemoveItem(celTips.list, i);

            // remove from ui.
            c.remove();
            return;
        }
    }
};

// remove all the references from the ui. This must be called when the ui has been switch to different ui.
celTips.removeAll = function () {
    var c0;
    let m = arrLen(celTips.list);

    if (m > 0) {
        for (var i = 0; i < m; i++) {
            c0 = celTips.list[i];

            // remove from ui
            c0.remove();
        }

        //reset the array.
        celTips.list = [];
    }
};

//==============================================================================
//24.Nov.17,lhw-
function celClickOnce() {
    var _prev_click_ts = null;

    this.canFire = function () {
        if (_prev_click_ts != null) {
            if ((new Date()) - _prev_click_ts < 500) {
                return false;
            }
        }

        _prev_click_ts = new Date();
        return true;
    };

    return this;
}

celClickOnce._data = {};

celClickOnce.canFire = function (code) {
    var v;

    var n = new Date();

    if (obj_has_fld(celClickOnce._data, code)) {
        //v = n - celClickOnce._data[code];
        v = n - celClickOnce._data[code].ts;

        // console.log('can fire var->', v);

        if (v < 500) {
            return false;
        }
        else {
            //reset the value
            //celClickOnce._data[code] = n;
            celClickOnce._data[code] = { ts: n, lock: 1 };
            return true;
        }
    }
    else {
        //celClickOnce._data[code] = n;
        celClickOnce._data[code] = { ts: n, lock: 1 };
        return true;
    }
};


celClickOnce.clear = function () {
    celClickOnce._data = {};
};

//9.Jul.18,lhw-return true if the lock has been acquired. This prevents the user from clicking the button
// multiple times while waiting for the server response due to slow server/internet.
//2.Aug.18,lhw-added new param: 'enforce_click_once'- if true, it will compare the timestamp.
//12.Sep.18,lhw-added new param: 'wait_sec'
celClickOnce.acqLock = function (code, enforce_click_once, wait_sec) {
    const MAX_WAIT = 2000;

    var v;
    var n = new Date();

    if (!wait_sec) {
        wait_sec = MAX_WAIT;
    }

    if (obj_has_fld(celClickOnce._data, code)) {

        ////is_lock = celClickOnce._data[code].lock == 1;
        if (celClickOnce._data[code].lock == 1) {
            return false;
        }

        ////if (is_lock || enforce_click_once) {
        if (enforce_click_once) {
            v = n - celClickOnce._data[code].ts;
        }
        else {
            ////v = MAX_WAIT + 1;
            v = wait_sec + 1;
        }

        ////console.log('acqLock->', v);

        ////if (v < MAX_WAIT || is_lock) {
        ////if (v < MAX_WAIT) {
        if (v < wait_sec) {
            //console.log('celClickOnce.acqLock=false', code);

            return false;
        }
        else {
            //reset the value
            //console.log('celClickOnce.acqLock reset', code);

            ////celClickOnce._data[code] = { ts: n, lock: 1 };
            celClickOnce._data[code].ts = n;
            celClickOnce._data[code].lock = 1;

            //16-Nov-2022,lhw-
            // return true;
            return {
                release: () => {
                    celClickOnce.release(code);
                }
            };
        }
    }
    else {

        //console.log('acqLock-> create lock');

        celClickOnce._data[code] = { ts: n, lock: 1 };
        //16-Nov-2022,lhw-
        // return true;
        return {
            release: () => {
                celClickOnce.release(code);
            }
        };
    }
};

//9.Jul.18,lhw-the caller must release the 'lock' so that the item become clickable again.
celClickOnce.release = function (code) {
    //console.log('celClickOnce.release', code);

    if (obj_has_fld(celClickOnce._data, code)) {
        celClickOnce._data[code].lock = 0;
    }
};


//8.Jul.19,lhw-release it immediately from the mem and let the process re-enter.
celClickOnce.releaseFromMem = function (code) {
    if (obj_has_fld(celClickOnce._data, code)) {
        delete celClickOnce._data[code];
    }
};

//14.Aug.18,lhw-
celClickOnce.isLock = function (code) {
    const MAX_WAIT = 2000;

    if (obj_has_fld(celClickOnce._data, code)) {
        //console.log('celClickOnce.isLock=true', code);

        var n = new Date();
        var v = n - celClickOnce._data[code].ts;

        if (celClickOnce._data[code].lock == 1 || v < MAX_WAIT) {
            return true;
        }
        else {
            return false;
        }
    }

    //console.log('celClickOnce.isLock=false', code);
    return false;
};

//------------------------------------------------------------------------------
//28.Aug.17,lhw-
function isImageFile(t) {
    if (!isStrEmpty(t)) {
        if (t.contains('/')) {
            t = t.toLowerCase().replace('image/', '');
        }
        else if (t.contains('.')) {
            t = t.substr(t.lastIndexOf('.') + 1, t.length - t.lastIndexOf('.'));
        }

        //23.Jan.18,lhw-bug fixed on 't.toLowerCase()'.
        if (celestial.imgFileType.indexOf(t.toLowerCase()) >= 0) {
            return true;
        }
    }

    return false;
}

//------------------------------------------------------------------------------
//8.Apr.18,lhw- hide the current row after x seconds
function hideNRemoveItem(c2, cb) {

    setTimeout(function () {
        c2.fadeOut(function () {
            c2.remove();

            if (cb) {
                cb();
            }
        });
    }, 100);

}


//==============================================================================
//4.Sep.18,lhw-set value into the nested child object.
function obj_set_val(o, k, v) {
    var k2;
    var o2;
    var m;

    if (typeof o == 'undefined' || o == null) {
        return;
    }

    if (k.contains('.')) {
        k2 = k.split('.');
        // the last item is the property name
        m = arrLen(k2) - 1;
        o2 = o;

        for (var i = 0; i < m; i++) {

            if (!obj_has_fld(o2, k2[i])) {
                o2[k2[i]] = {};
            }

            o2 = o2[k2[i]];

            if (i + 1 == m) {
                o2[k2[i + 1]] = v;
            }
        }

    }
    else {
        o[k] = v;
    }
}

//------------------------------------------------------------------------------
//25.Apr.20,lhw-set value if the given field is missing or NULL.
function obj_set_val_if_missing(o, k, v) {
    if (typeof o[k] == 'undefined' || o[k] == null) {
        o[k] = v;
    }
}

//------------------------------------------------------------------------------
//08-Apr-2021,lhw-set the value if it is out of range (oor).
function obj_set_val_if_oor(o, k, v, mn, mx) {
    if (typeof o[k] == 'undefined'
        || o[k] == null
        || (typeof mn != 'undefined' && mn != null && o[k] < mn)
        || (typeof mx != 'undefined' && mx != null && o[k] > mx)
    ) {
        o[k] = v;
    }
}

//------------------------------------------------------------------------------
/**
 * 21-Sep-2020,lhw-parse the field name.
 * Sample
 *      'data'  => returns {fld: 'data', idx: null}
 *      'data[3]' => returns {fld: 'data', idx: 3}
 *
 * @param {String} k Can be 'data' OR 'data[0]'
 */
function obj_parse_field_name(k) {

    if (isUndefinedOrNull(k)) {
        return null;
    }

    //07-Jul-2021,lhw-bug fixed-
    if (typeof k != 'string') {
        k = k.toString();
    }

    //21-Sep-2020,lhw-read the value by array index
    if (k.contains('[') && k.contains(']')) {

        // get the field name.
        let k3 = k.substring(0, k.indexOf('['));

        // get the item index.
        let i3 = toInt(k.extractWithin('[', ']'));

        return {
            fld: k3,
            idx: i3
        };
    }
    else {

        // the field name is not 'array item'
        return {
            fld: k,
            idx: null
        };

    }
}

//------------------------------------------------------------------------------
/**
 * 4.Sep.18,lhw-get the value from the nested child object.
 *
 * Test data:
 *      cust = {name: 'abd'}
 *      cust2 = {name: 'xyz', addr:['1111', '2222']}
 *      cust3 = {name: 'ooii'}
 *      d = {data: [cust, cust2, cust3]}
 *
 *      obj_get_val(d, 'data[1]')
 *      obj_get_val(d, 'data[1].addr[1]')
 *      obj_get_val(cust2, 'name')
 *      obj_get_val(cust2, 'addr[1]')
 *
 *
 * @param {Object} o data object.
 * @param {String} k field name.
 * @param {Any} def_val default value.
 */
function obj_get_val(o, k, def_val) {
    var k2;
    var o2;
    var m;
    var v;
    var k9;

    if (typeof def_val == 'undefined' || def_val == null) {
        def_val = '';
    }

    if (typeof o == 'undefined' || o == null) {
        return def_val;
    }

    //4.Jul.20,lhw-
    ////if (k.contains('.')) {
    if (k.toString().contains('.')) {
        k2 = k.split('.');
        // the last item is the property name
        m = arrLen(k2) - 1;
        o2 = o;

        for (var i = 0; i < m; i++) {

            //21-Sep-2020,lhw-support 'cust[1].addr[2]'
            k9 = obj_parse_field_name(k2[i]);

            if (obj_has_fld(o2, k9.fld)) {

                // o2 = o2[k2[i]];

                if (k9.idx != null) {
                    o2 = o2[k9.fld][k9.idx];
                }
                else {
                    o2 = o2[k9.fld];
                }

                if (i + 1 == m) {
                    //21-Sep-2020,lhw-support 'cust[1].addr[2]'
                    k9 = obj_parse_field_name(k2[i + 1]);

                    if (k9.idx != null) {
                        v = o2[k9.fld][k9.idx];
                    }
                    else {
                        v = o2[k2[i + 1]];
                    }

                    if (typeof v == 'undefined' || v == null) {
                        return def_val;
                    }

                    return v;
                }
            }
            else {
                ////return null;
                return def_val;
            }
        }

        ////return null;
        return def_val;
    }
    else {

        //21-Sep-2020,lhw-read the value by array index
        k9 = obj_parse_field_name(k);

        if (k9.idx != null) {
            // get the value from array
            v = o[k9.fld][k9.idx];
        }
        else {
            v = o[k];
        }


        if (typeof v == 'undefined' || v == null) {
            return def_val;
        }

        return v;
    }
}

//------------------------------------------------------------------------------
//4.Sep.18,lhw- exec the proc either in the o or o2.
// param:
// - o - the object that might hold the function.
// - o2 - optional - the 2nd object that might hold the function.
// - f - the function name to be exec.
// - arr - the parameters stored in array.
function obj_exec_proc(o, o2, f, arr) {
    var fn;

    // if 'o2' is string type, means that the 'o2' is null value.
    if (isStr(o2)) {
        arr = f;
        f = o2;
    }

    if (o && obj_has_fld(o, f)) {
        fn = o[f];

        if (fn) {
            return fn.apply(o, arr);
        }
    }

    if (o2 && obj_has_fld(o2, f)) {
        fn = o2[f];

        if (fn) {
            return fn.apply(o, arr);
        }
    }

    return null;
}

//------------------------------------------------------------------------------
//4.Sep.18,lhw-returns true if the proc exist.
function obj_has_proc(o, o2, f) {
    var fn;

    // if 'o2' is string type, means that the 'o2' is null value.
    if (isStr(o2)) {
        f = o2;
        o2 = null;
    }

    if (o && obj_has_fld(o, f)) {
        fn = o[f];
        if (fn) {
            return true;
        }
    }

    if (o2 && obj_has_fld(o2, f)) {
        fn = o2[f];

        if (fn) {
            return true;
        }
    }

    return false;
}


//------------------------------------------------------------------------------
//19.Nov.18,lhw-get the proc from the object
function obj_get_proc(o, o2, f) {
    var fn;

    // if 'o2' is string type, means that the 'o2' is null value.
    if (isStr(o2)) {
        f = o2;
        o2 = null;
    }

    if (o && obj_has_fld(o, f)) {
        fn = o[f];
        if (fn) {
            return fn;
        }
    }

    if (o2 && obj_has_fld(o2, f)) {
        fn = o2[f];

        if (fn) {
            return fn;
        }
    }

    return null;
}

//8.Sep.18,lhw-this proc perform deep cloning without copying the 'function'.
//3.Oct.18,lhw-this function will crash if it stringify an obj that contains jquery object.
//06-Aug-2023,lhw-relies on the built-in function.
function obj_clone(o) {
    if (isUndefinedOrNull(o)) {
        return null;
    }
    return structuredClone(o);
}

//07-Aug-2023,lhw-merge o0 into o9.
// Notes: this proc replace `obj_copy()`.
function obj_merge(o9, ...o0) {
    for (let i = 0; i < o0.length; i++) {
        obj_copy_fld(o0[i], o9);
    }
}

//16.Sep.18,lhw-deep copy the properties & functions with jQuery.extend().
// param: o0 -new data
// param: o - the final data
function obj_copy(o0, o) {
    if (!o) {
        o = {};
    }

    // perform deep clone
    $.extend(true, o, o0);

    // return the obj.
    return o;
}

//-------------------------------
//2.Dec.18,lhw-
// param:
// - o0 - the source object
// - o2 - the destination object or array (it become 'f' and 'f' param is ignore).
// - f - array of old & new fields =>  [ ['cust_id', 'id'], ['name'], ['age',null,'m0']..]
//       where 'name' will remained unchanged.
function obj_copy_fld(o0, o2, f) {
    if (isUndefinedOrNull(o0)) {
        return;
    }

    if (o2 == null) {
        o2 = {};
    }
    else if (Array.isArray(o2)) {
        f = o2;
        o2 = {};
    }
    else if (typeof o2 == 'string') {
        // convert 'o2' to become the first item in a new array.

        if (o2 == '*') {
            //13-Apr-2021,lhw-copy all fields
            f = Object.keys(o0);
        }
        else {
            f = [o2];
        }

        o2 = {};
    }
    else if (f == '*' || isUndefinedOrNull(f)) {
        //15-Feb-2022,lhw-bug fixed-copy all fields.
        f = Object.keys(o0);
    }

    let v2;
    celLoop.each(f, function (f2) {
        if (Array.isArray(f2)) {
            let m = arrLen(f2);

            if (m > 0 && obj_has_fld(o0, f2[0])) {
                // 'field2' might be NULL (ie, same as 'field1')
                let f3 = (m > 1) ? (f2[1] || f2[0]) : f2[0];
                v2 = o0[f2[0]];

                if (m > 2) {
                    //03-Sep-2021,lhw-i2=[field1, field2, data type]
                    // Convert the value to the given type.
                    if (f2[2] == 'm2') {
                        v2 = toDbl(v2);
                    }
                    else if (f2[2] == 'm0') {
                        v2 = toInt(v2);
                    }
                    else if (f2[2] == 'd') {
                        v2 = toDate(v2);
                    }
                    else {
                        v2 = v2.toString();
                    }
                }

                //06-Aug-2023,lhw-we should create a new Date ref.
                if (v2 instanceof Date) {
                    v2 = new Date(v2.getTime());
                }

                o2[f3] = v2;
            }
        }
        else {
            //29.Apr.20,lhw-copy the field that was specified in 'f'.
            if (obj_has_fld(o0, f2)) {
                v2 = o0[f2];

                //06-Aug-2023,lhw-we should create a new Date ref.
                if (v2 instanceof Date) {
                    v2 = new Date(v2.getTime());
                }

                o2[f2] = v2;
            }
        }
    });

    return o2;
}


//-------------------------------
//16.Nov.18,lhw-rename a field in the object.
// param:
//- 'f0' - can be string or array of old & new fields.
//       - for eg, 'code' will be renamed to 'c':
//          =>  [ ['code', 'c'], ['name', 'n']]

function obj_rename_fld(o, f0, f2) {

    if (isUndefinedOrNull(o)) {
        return;
    }

    if (Array.isArray(f0)) {

        celLoop.each(f0, function (i2) {

            if (Array.isArray(i2)) {
                let m = arrLen(i2);

                if (m > 0 && obj_has_fld(o, i2[0])) {
                    let i = (m > 1) ? i2[1] : i2[0];

                    o[i] = o[i2[0]];
                    delete o[i2[0]];
                }
            }

        });

    }
    else {
        if (obj_has_fld(o, f0)) {
            o[f2] = o[f0];
            delete o[f0];
        }
    }

}

//-------------------------------
//29.Nov.18,lhw-returns true if o/o2 has 'f'.
function obj_has_fld(o, o2, f) {
    // if 'o2' is string type, means that the 'o2' is null value.
    if (isStr(o2)) {
        f = o2;
        o2 = null;
    }

    //08-Apr-2021,lhw-
    // this method is more reliable because 'o' might not inherit from Object
    // (in that case, it won't have 'hasOwnProperty' proc!!).
    if (o && Object.prototype.hasOwnProperty.call(o, f)) {
        return true;
    }

    if (o2 && Object.prototype.hasOwnProperty.call(o2, f)) {
        return true;
    }

    return false;
}



//-------------------------------
//29.Apr.20,lhw-
function obj_delete_fld(o, f) {

    if (Array.isArray(f)) {

        celLoop.each(f, function (f2) {
            if (obj_has_fld(o, f2)) {
                delete o[f2];
            }
        });

    }
    else {
        if (obj_has_fld(o, f)) {
            delete o[f];
        }
    }

}


//20.May.20,lhw-returns true if both params is the same object reference.
function obj_is_same_ref(o1, o2) {

    if (o1 && o2) {
        return Object.is(o1, o2);
    }

    return false;
}


//==============================================================================
/*
26.Mar.17, lhw-
- This class works like a notif center where the functions can be injected into any object.
*/

function celNotif(po) {
    var _notif;

    _notif = {};

    //-------------------------------
    // - to subscribe for the notif.
    //
    // opt=> { name, callback(d) }
    // OR
    //      param 1: name
    //      param 2: callback(d)
    //
    // where 'p' => {should_stop: bool, data: obj}
    //
    // Example,
    //   using name & callback param:
    //      notif.on('onLoadedOption', yourfunction);
    // OR
    //      notif.on({ name: 'logout', callback: function (d) { console.log('user has logout..' ); } });
    //      notif.on({ name: 'onLoadedOption', callback: yourfunction });
    //-------------------------------
    po.on = function (opt) {
        // var o;

        //-------------------------------
        if (typeof opt === 'string') {
            var o2 = {};
            o2.name = opt;

            if (arguments.length > 1 && typeof arguments[1] === 'function') {
                o2.callback = arguments[1];
            }
            else {
                console.assert('callback param is missing');
                return;
            }

            opt = o2;
        }

        //-------------------------------
        if (!obj_has_fld(_notif, opt.name)) {
            _notif[opt.name] = { stack: [] };
        }

        _notif[opt.name].stack.push(opt.callback);

        // console.log('_notif=', _notif);
    };

    //-------------------------------
    //26.May.19,lhw-same as 'on()' except that it register the listener if
    // the callback can't be found in the stack.
    //-------------------------------
    po.regIfNotExists = function (opt) {

        if (typeof opt === 'string') {
            var o2 = {};
            o2.name = opt;

            if (arguments.length > 1 && typeof arguments[1] === 'function') {
                o2.callback = arguments[1];
            }
            else {
                console.assert('callback param is missing');
                return;
            }

            opt = o2;
        }

        //-------------------------------
        if (!obj_has_fld(_notif, opt.name)) {
            _notif[opt.name] = { stack: [] };
        }

        let o = _notif[opt.name];

        if (opt.callback) {
            let m = arrLen(o.stack);
            let f = false;

            for (var i = 0; i < m; i++) {
                // remove the specific callback
                if (o.stack[i] == opt.callback) {
                    f = true;
                    break;
                }
            }

            if (!f) {
                ////console.log('reg notif=', opt.name);
                o.stack.push(opt.callback);
            }
        }
    };


    //-------------------------------
    // Remove using name & callback param:
    //
    //      notif.off('onLoadedOption', yourfunction);
    //      notif.off({ name: 'onLoadedOption', callback: yourfunction });
    //
    // To remove all callbacks in the given namespace:
    //      notif.off('onLoadedOption').
    //
    //-------------------------------
    po.off = function (opt) {

        if (typeof opt === 'string') {
            var o2 = {};
            o2.name = opt;

            if (arguments.length > 1 && typeof arguments[1] === 'function') {
                o2.callback = arguments[1];
            }

            opt = o2;
        }

        //-------------------------------
        if (obj_has_fld(_notif, opt.name)) {
            let o = _notif[opt.name];

            if (opt.callback) {
                let m = arrLen(o.stack);

                for (var i = 0; i < m; i++) {
                    // remove the specific callback
                    if (o.stack[i] == opt.callback) {
                        arrRemoveItem(o.stack, i);
                        break;
                    }
                }
            }
            else {
                // if the callback was not specified, delete the entire notif
                delete _notif[opt.name];
            }
        }
    };

    //-------------------------------
    //26.Mar.17, lhw-inform all subscribers about the notification
    // and pass the data into the callback.
    //
    // Example,
    //      myApp.getNotif().fire('logout');
    //-------------------------------
    po.trigger = function (name, data) {
        po.fire(name, data);
    };

    //27.May.19,lhw-added 'run_async:bool'-a delay calls by timer.
    po.fire = function (name, data, run_async) {
        ////console.log('notif-fire=>', name, _notif);

        if (obj_has_fld(_notif, name)) {

            var f = function () {
                let o = _notif[name];

                ////console.log('notif-fire=>', o);

                if (o && o.stack) {
                    let m = arrLen(o.stack);

                    // setup the data object so that the callback can pass the data around.
                    var d = {};

                    // if the listener decided to stop the propagation, set this to true
                    // and the invocation to the remaining callback will stop.
                    d.should_stop = false;
                    d.data = data;

                    for (var i = 0; i < m; i++) {
                        //exec the callback
                        o.stack[i](d);

                        // if the callback indicating to stop the loop, quit now.
                        if (d.should_stop) {
                            break;
                        }
                    }
                }

            };

            if (typeof run_async == 'undefined') {
                f();
            }
            else {
                //27.May.19,lhw-
                setTimeout(f, 100);
            }
        }
    };

    //-------------------------------
    po.destroyNotif = function () {
        _notif = {};
    };

    //-------------------------------
    po.dump = function () {
        console.log(_notif);
    };

}

//26.May.19,lhw-create a shared instance for global used.
celestial.notif = function () { };
celNotif(celestial.notif);


//==============================================================================
//30.Sep.18,lhw-this function implements the auto loading of next page data.
// - to use this class, you must:
//
//   1. handle 'btn-search' click event
//
//      var f = function () {
//          //reset the counter
//          salesHistory.pager.resetAutoLoadVar();
//          salesHistory.data = null;
//          salesHistory.getContainer().find('.item-list > div').html('');
//
//          // load data
//          salesHistory.list();
//      };
//
//   2. handle salesHistory.onGetListParam =function(){
//          // set the first row index.
//          p.data.startRowIndex = salesHistory.pager.getStartRowIdx();
//          p.data.maximumRows = 50;
//          ...
//      }
//
//   3 . celListingForm setting
//
//      // setup.
//      var opt = {
//          serviceCode: 'tmb-timesheet',
//          containerObj: c0,
//          pagerObj: c0.find('.rec-cnt'),
//          entryObj: null,
//          spinnerContainerObj: c0.find('.sub-title0'),
//          dataListFld: 'data.list',
//          alwaysAppend: true  <<==========================important!!!
//      };
//
//      // init the scrolling data loader
//      celScrollingDataLoader(timesheet.pager, timesheet, c0.find('.item-list'));
//
//      // inject the ui procs.
//      celListingForm(timesheet, opt);
//
//
// param
// - po - the functions will be injected into this object.
// - rootObj - it should be celMasterDetailForm OR celListingForm OR same as po.
// - itemListObj - the jquery obj of the item-list that has the vertical scrollbar.
// - opt {} - added on 02.Jul.2021
//    - maximumRows - for onGetListParam(p) to get this value.
//
//------------------------------------------------------------------------------
function celScrollingDataLoader(po, rootObj, itemListObj, opt) {

    //private var
    var loadRowFromIdx = 0;
    var prev_scrollTop = 0;

    if (!rootObj) {
        rootObj = po;
    }

    //02-Jul-2021,lhw-init the 'opt' param.
    let def_opt = {
        maximumRows: 100
    };

    opt = $.extend(def_opt, (opt || {}));

    //-------------------------------
    po.handleAutoLoad = function (e) {

        if (!itemListObj) {
            itemListObj = $(e.target);
        }

        let st = itemListObj.scrollTop();

        if (st < prev_scrollTop) {
            ////console.log('skip loading due to scroll upward');
            return;
        }

        prev_scrollTop = st;

        let h = itemListObj.height();
        let sh = itemListObj.prop('scrollHeight');

        if ((h + st) * 1.2 >= sh) {
            // console.log('scrollbar hit bottom');

            var max = 0;

            if (rootObj.data && rootObj.data.data) {

                if (obj_has_fld(rootObj.data.data, 'rec_count')) {
                    max = toInt(obj_get_val(rootObj.data, 'data.rec_count'));
                }
                else if (obj_has_fld(rootObj.data.data, 'rec_cnt')) {
                    //13.Mar.20,lhw-backward compatibility.
                    ////max = toInt(obj_get_val(rootObj.data, 'data.rec_cnt'));

                    if (Array.isArray(rootObj.data.data.rec_cnt)) {
                        //7.Apr.20,lhw-bug fixed - omitted to check the type.
                        max = rootObj.data.data.rec_cnt[0].rec_count;
                    }
                    else {
                        max = toInt(rootObj.data.data.rec_cnt);
                    }
                }
                else {

                    //28.May.19,lhw-
                    if (arrLen(rootObj.data.data) > 0) {
                        max = toInt(rootObj.data.data[0].rec_count);

                        ////console.log('scrollbar =>rootObj.data.data[0].rec_count=', max);
                    }
                    else if (rootObj.data.data && arrLen(rootObj.data.data.rec_cnt) > 0) {
                        //3.Feb.20,lhw-new way to handle the data from ajax cmd lib.
                        max = rootObj.data.data.rec_cnt[0].rec_count;

                        ////console.log('scrollbar => rootObj.data.data.rec_cnt[0].rec_count=', max);
                    }
                }
            }

            var l = rootObj.getDataListFromMem();
            var cnt = arrLen(l.data);

            // console.log('scrollbar => cnt=', cnt, ',loadRowFromIdx=', loadRowFromIdx, ', max=', max);

            if (cnt < max && loadRowFromIdx < cnt) {
                //start from this rec
                loadRowFromIdx = cnt;

                // console.log('scrollbar => load data, loadRowFromIdx=', loadRowFromIdx);

                // in case the 'list' depends on 'search timer', indicate that it must continue loading data.
                rootObj.force_continue_list = true;

                // continue loading.
                rootObj.list();
            }
        }
    };

    //-------------------------------
    po.resetAutoLoadVar = function () {
        loadRowFromIdx = 0;
        prev_scrollTop = 0;
    };

    //-------------------------------
    // returns the row index for next call to list().
    po.getStartRowIdx = function () {
        return loadRowFromIdx;
    };


    //-------------------------------
    //attach the event handler if itemListObj has been specified.
    if (itemListObj) {
        itemListObj.on('scroll', po.handleAutoLoad);
    }

    //-------------------------
    //02-Jul-2021,lhw-returns the max rows to be returned by the server.
    po.getMaximumRows = function () {
        return (opt && opt.maximumRows || 100);
    };

}


//==============================================================================
//12.May.19,lhw-track the pending completion job count.
// This is useful for tracking ajax call where the ajax calls are running parallel
// (controlled by the browser).
// Call isAllDone() if you want to manually monitor the job through timer.
//==============================================================================

function celJobTracker(po, opt) {

    var def_opt = {
        id: 'job-tracker-' + getNowString(),

        // This value must be set before any process runs.
        // isAllDone() returns false when 'l.length < max_job_cnt' (waiting for more jobs to come into the queue).
        // and onDone will be raised when 'l.length = max_job_cnt' + 'all jobs done'.
        //
        // NOTES: If you don't want to use this setting, you may call add() to create all job ids (before running the
        // job) and isAllDone() will evaluate the job status (ignore 'l.length = max_job_cnt' rule).
        //
        max_job_cnt: 0,

        //24-Aug-2020,lhw-
        raise_onDone_for_all_job: false,

        //24-Aug-2020,lhw-this is for run().
        manual_update_done_state: false,

        // param: p2 = {id:xx, allDone: true}
        // this proc will be raised when any of the job have been done.
        // NOTES: you may use setInterval() to call isAllDone().

        //24-Aug-2020,lhw- If all jobs done, the param will be '{allDone: true}'.
        onDone: null,

        //24-Aug-2020,lhw-
        // param: p2 {group:xx}
        // this will be raised when a group of jobs have been done.
        onGroupDone: null

    };

    opt = $.extend(def_opt, opt);

    var l = [];
    //24-Aug-2020,lhw-
    var g = {};

    //-------------------------------
    // retuns job name.
    //-------------------------------
    po.id = function () {
        return opt.id;
    };

    //-------------------------------
    // returns the job count
    //-------------------------------
    po.count = function () {
        return arrLen(l);
    };

    //-------------------------------
    // reset the job counter.
    //-------------------------------
    po.clear = function () {
        l = [];
        g = {};
    };

    //27.Jun.19,lhw-do some cleanup.
    po.clearDone = function () {

        celLoop.eachReverse(l, function (o, i) {
            if (o.done != null) {
                arrRemoveItem(l, i);
            }
        });

        //24-Aug-2020,lhw-reset the flag
        var k = Object.keys(g);
        if (k.length > 0) {
            for (let i = 0; i < k.i; i++) {
                g[k[i]] = false;
            }
        }

    };

    //27.Jun.19,lhw-
    po.dump = function () {
        return l;
    };

    //-------------------------------
    // returns unique id.
    //03-Aug-2020,lhw-added param 'data' { fn:func ... } - optional.
    //   If 'data' is null, means we track the completion status only.
    //24-Aug-2020,lhw-'id=rate\\rate-map' => where 'rate' is the group and 'rate-map'
    //   is a job item related to the group.
    //-------------------------------
    po.add = function (id, data) {
        var o;

        if (typeof id == 'undefined' || id == null) {
            id = getUniqueID();
        }

        o = {};
        o.id = id;
        o.start = new Date();
        o.done = null;

        //03-Aug-2020,lhw-
        if (typeof data != 'undefined' && data != null) {
            o.data = data;
        }

        l.push(o);

        //24-Aug-2020,lhw-
        if (id.contains('\\')) {
            g[id.substring(0, id.indexOf('\\'))] = false;
        }

        return o.id;
    };

    //-------------------------------
    // mark the job as done.
    //-------------------------------
    po.done = function (id) {
        var b;

        b = false;
        celLoop.each(l, function (o) {
            if (o.done == null && isStrEqual(o.id, id)) {
                b = true;
                o.done = new Date();
                return false;
            }

        });

        // check the status if onDone() callback has been specified - in this case,
        // we don't need a timer to check the status.
        if (obj_has_proc(opt, 'onDone')) {

            if (opt.raise_onDone_for_all_job) {
                //24-Aug-2020,lhw-inform the caller
                obj_exec_proc(po, opt, 'onDone', [{ id: id }]);
            }

            //24-Aug-2020,lhw-
            if (id.contains('\\')) {
                var k = id.substring(0, id.indexOf('\\'));

                if (po.isGroupDone(k)) {
                    g[k] = true;
                    obj_exec_proc(po, opt, 'onGroupDone', [{ group: k }]);
                }
            }

            po.isAllDone();
        }

        return b;
    };

    //-------------------------------
    //returns the completed job count
    //-------------------------------
    po.doneCnt = function (id) {
        var i;

        i = 0;
        celLoop.each(l, function (o) {
            if (isStrEqual(o.id, id) && o.done) {
                //22-Jul-2021,lhw-bug fixed
                i++;
            }
        });

        return i;
    };

    //-------------------------
    //22-Jul-2021,lhw-returns true if the given job is done.
    po.isDone = function (id) {
        var b;

        b = false;
        celLoop.each(l, function (o) {
            if (isStrEqual(o.id, id)) {
                b = o.done ? true : false;
                // stop the loop
                return false;
            }
        });

        return b;
    };


    //-------------------------------
    // returns true if all jobs have been done.
    //-------------------------------
    po.isAllDone = function () {
        var b;

        ////console.log('celJobTracker.isAllDone..', l)

        // This condition is meant for 'max_job_cnt > 0'!!!
        // wait for the caller to stuff all the jobs before evaluating the job status.
        if ((opt.max_job_cnt > 0) && (arrLen(l) < opt.max_job_cnt)) {
            ////console.log('celJobTracker.isAllDone.. exit #1');
            return false;
        }

        // assume all done.
        b = true;

        celLoop.each(l, function (o) {
            ////console.log('=> celJobTracker.isAllDone.. #2', o.id);

            if (o.done == null) {
                // found a job that has not been completed, exit loop and return false.
                b = false;
                return false;
            }
        });

        ////console.log('celJobTracker.isAllDone.. #2', b);

        //-------------------------------
        if (b) {
            // all jobs completed.
            //24-Aug-2020,lhw-added new param.
            obj_exec_proc(po, opt, 'onDone', [{ allDone: true }]);
        }

        return b;
    };

    //-------------------------
    //24-Aug-2020,lhw-
    po.isGroupDone = function (group) {
        var b;

        if (!group.endsWith('\\')) {
            group += '\\';
        }

        b = true;
        celLoop.each(l, function (o) {
            ////console.log('=> celJobTracker.isGroupDone.. #2', o.id);

            if (!o.id.startsWith(group)) {
                return;
            }

            if (o.done == null) {
                // indicate group not yet completed.
                b = false;

                // if job in the group has not been completed,
                // stop the loop
                return false;
            }

        });

        return b;
    };

    //-------------------------
    //3.Mar.20,lhw-
    po.isWorking = function () {
        return !po.isAllDone();
    };

    //-------------------------
    //03-Aug-2020,lhw-queue the job and don't run it. This is useful
    //  if you have many ajax jobs to be executed and the jobs are not
    //  dependent on other jobs.
    //
    // param:
    //  - 'o={ fn:func }' OR 'o=function'
    //-------------------------
    po.queueJob = (o, id) => {

        if (typeof o == 'function') {
            // create the proper structure to hold the func.
            o = {
                fn: o
            };
        }

        //07-Jan-2021,lhw-we should auto-assign a value in case of null.
        if (typeof id == 'undefined' || id == null) {
            id = getUniqueID();
        }

        po.add(id, o);
    };

    //-------------------------
    //03-Aug-2020,lhw-reset for fresh run.
    //-------------------------
    po.reset = function (id) {
        celLoop.each(l, function (o) {
            if (id) {
                //22-Jul-2021,lhw-reset the given job status.
                if (isStrEqual(o.id, id)) {
                    o.start = new Date();
                    o.done = null;
                    return false;
                }
            }
            else {
                o.start = new Date();
                o.done = null;
            }
        });
    };


    //-------------------------
    //03-Aug-2020,lhw-run the job in the queue.
    // This proc should be called after all jobs have been queued!
    // You may call this proc after it has been completed a cycle.
    //-------------------------
    po.run = () => {
        if (arrLen(l) == 0) {
            // console.log('No job has been queue to run')
            return;
        }

        // reset for fresh run.
        po.reset();

        // run all.
        celLoop.each(l, (o) => {
            if (o.data && o.data.fn) {

                if (opt.manual_update_done_state) {

                    let done = function () {
                        // mark done - onDone() event will be raise if all jobs done.
                        po.done(o.id);
                    };

                    obj_exec_proc(o.data, 'fn', [done]);
                }
                else {
                    // execute the proc.
                    o.data.fn();

                    // mark done - onDone() event will be raise if all jobs done.
                    po.done(o.id);
                }
            }
        });
    };


}

//-------------------------
//22-Jul-2021,lhw-Invoke opt.run() if opt.is_ready() returns true.
//  opt: {run=fn(), is_ready=fn():bool, retry_delay=999, max_retry=10, on_fail=fn(opt)}
celJobTracker.runIf = function (opt) {

    if (!opt.retry_delay) {
        // default retry delay is 200ms.
        opt.retry_delay = 200;
    }

    if (!opt.max_retry) {
        opt.max_retry = 10;
    }

    if (!obj_has_fld(opt, 'retry')) {
        opt.retry = 0;
    }

    //-------------------------
    if (opt.is_ready()) {
        // the dependency is ready, invoke the main process now.
        opt.run();
    }
    else {
        // retry
        setTimeout(() => {
            opt.retry++;

            if (opt.retry >= opt.max_retry) {
                if (opt.on_fail) {
                    opt.on_fail(opt);
                }
                else {
                    console.log('Reaching max_retry. Exit celJobTracker.runIf()', opt);
                }
            }
            else {
                celJobTracker.runIf(opt);
            }
        }, opt.retry_delay);
    }

};



//==============================================================================
//12-Oct-2021,lhw-make po a sequential job object which runs the job one after another.
// - To listen for 'drain' event, calls `your_seq_job_queue.on('drain', your_cb)`.
//==============================================================================

function celSeqJob(po) {
    let pd = {
        jt_id: 0,
        jt_cnt: 0,
        jt: []
    }

    //-------------------------
    po.isBusy = function () {
        return (pd && (pd.jt_cnt > 0));
    };

    //-------------------------
    po.queue = function (j) {
        console.assert(typeof j == 'object', 'j param must be an object');
        // console.log('celSeqJob.queue', j.fn.name);

        j.id0 = ++pd.jt_id;
        pd.jt_cnt++;
        pd.jt.push(j);

        if (pd.jt_cnt == 1) {
            // console.log('=> running', j.id0, j.fn.name);
            j.fn();
        }
    };

    //-------------------------
    po.done = function (j) {
        console.assert(typeof j == 'object', 'j param must be an object');
        // console.log('celSeqJob.done ', j.fn.name);

        let m = pd.jt_cnt;
        for (let i = 0; i < m; i++) {
            if (pd.jt[i].id0 == j.id0) {
                arrRemoveItem(pd.jt, i);
                pd.jt_cnt--;
                break;
            }
        }

        if (pd.jt_cnt > 0) {
            // run next job
            // console.log('=> done:running', pd.jt[0].id0, pd.jt[0].fn.name);
            pd.jt[0].fn();
        }

        if (!po.isBusy()) {
            // all tasks has been completed.
            po.fire('drain');
        }
    };

    // make po a notif object
    celNotif(po);
}

// init the shared object
celSeqJob(celestial.pd.ajax_seq_job[0]);
celSeqJob(celestial.pd.ajax_seq_job[1]);


//-------------------------
//10-Nov-2021,lhw-
// Queue the cb (callback) to be running in sequential mode.
// Default is queuing the cb to `celestial.pd.ajax_seq_job` (ie, queue_id=0).
function queueJob(cb, queue_id) {

    if (typeof queue_id == 'undefined' || queue_id == null) {
        // default is ajax queue
        queue_id = 0;
    }
    else if ([0, 1].indexOf(queue_id) < 0) {
        // only '0' and '1' is valid. Other value will fallback to '0'.
        queue_id = 0;
    }

    let j = {
        fn: function () {
            try {
                cb();
            }
            finally {
                celestial.pd.ajax_seq_job[queue_id].done(j);
            }
        }
    }
    celestial.pd.ajax_seq_job[queue_id].queue(j);
}


//------------------------------------------------------------------------------
//16.Jun.19,lhw-handle the ui.
//------------------------------------------------------------------------------
const celUI = {

    // param:
    // - p.cls - the template class name - must ends with '0'.
    // - p.c0 - the main container that has the 'template-div' (not template-div itself!!).
    // - 'o' - the data obj to be attach to the 'p.c2';

    /* sample code

        p2 = {};
        p2.c0 = c0;

        // optional
        p2.cls = 'item-div0';

        //19-Nov-2020,lhw-
        p2.target = getJObject('my-container');
        p2.clear_b4_append = false;

        //18-Jun-2021,lhw-another way is to provide the template container
        let p3 = {};
        p3.ct0 = $('.template-div');
        p3.cls = 'my-item-div0';
        celUI.clone(p3, o2);


    */

    clone: function (p, o) {

        if (typeof p.cls == 'undefined' || p.cls == null) {
            p.cls = 'item-div0';
        }

        var cls2 = p.cls.substring(0, p.cls.length - 1);

        // find the template
        if (typeof p.ct == 'undefined' || p.ct == null) {
            if (p.ct0) {
                //18-Jun-2021,lhw-added 'ct0'
                p.ct = p.ct0.find('.' + p.cls);
            }
            else {
                p.ct = p.c0.find('.template-div .' + p.cls);
            }
        }

        // clone it.
        p.c2 = p.ct.clone().replaceClass(p.cls).addClass(cls2);

        if (typeof o != 'undefined') {
            p.c2.data('data', o);
        }

        //19-Nov-2020,lhw-
        if (p.target) {
            if (p.clear_b4_append) {
                p.target.html('');
            }

            p.target.append(p.c2);
        }

        return p.c2;
    },

    //3.Jul.19,lhw-returns the item container jobj.
    getContainer: function (e, parent_cls) {
        if (isUndefinedOrNull(parent_cls)) {
            parent_cls = 'item-div';
        }
        else if (parent_cls.startsWith('.')) {
            parent_cls = parent_cls.substr(1, parent_cls.length - 1);
        }

        var c2 = $(e.target);
        if (!c2.hasClass(parent_cls)) {
            c2 = c2.closest('.' + parent_cls);
        }

        return c2;
    },

    //3.Jul.19,lhw-returns the data obj.
    getData: function (e, parent_cls) {
        var c2 = celUI.getContainer(e, parent_cls);
        return c2.data('data');
    },

    //3.Jul.19,lhw-returns the container info => {c, o}.
    getContainerInfo: function (e, parent_cls) {
        var o = {};
        o.c = celUI.getContainer(e, parent_cls);
        o.o = o.c.data('data');
        return o;
    },

    //12.Feb.20,lhw-
    updateWindowResize: function (po) {

        if (obj_has_proc(po, 'onResize')) {

            //26-Aug-2021,lhw-add the resize handler if it has not been attached.
            // $(window).on('resize', po.onResize);

            let wo = $._data(window, 'events');
            let b = true;

            if (wo && 'resize' in wo) {
                let f = celLoop.findFirst(wo.resize,
                    function (wo2) {
                        return wo2.handler == po.onResize;
                    });

                if (f) {
                    b = false;
                }
            }

            if (b) {
                celUI.getWnd().on('resize', po.onResize);
            }

            po.onResize();
        }

    },

    //12.Feb.20,lhw-
    restoreWindowResize: function (po) {

        if (obj_has_fld(po, 'onResize')) {
            celUI.getWnd().off('resize', po.onResize);
        }

    },

    //26-Aug-2021,lhw-dump the jquery event handler.
    dumpEventHandler: function (po, e) {
        let l = $._data(po, 'events');
        if (obj_has_fld(l, e)) {
            celLoop.each(l[e], function (e2) {
                console.log(e2.handler.name || 'anonymous fn');
            });
        }
    },

    //26-Aug-2021,lhw-
    dumpWndResizeEvent: function () {
        celUI.dumpEventHandler(window, 'resize');
    },
    dumpWndKeypressEvent: function () {
        celUI.dumpEventHandler(window, 'keypress');
    },
    dumpWndKeyDownEvent: function () {
        celUI.dumpEventHandler(window, 'keydown');
    },



    //-------------------------------
    //20.Feb.20,lhw- calc the cell/card width when window is resizing.
    // Call cardWidth() to get the proportionate width for the card on desktop.
    //
    // param:
    //  opt0.min_card_width => the minimum card width.
    //  opt0.desktop_width_offset
    //  opt0.mobile_width_offset
    //  opt0.onResize => on window.onresize fired.
    //
    //-------------------------------

    /*
    sample code -added on 16-Jun-2021,lhw
    - add the following code to the init0().
    -------------------------

        myApp.projects.init0 = function () {
            ...

            let il = c0.find('.proj-il');
            celUI.handleCardWidth(myApp.projects.handleCard,
            {
                min_card_width: 200,
                desktop_width_offset: $(window).width() - 100,
                mobile_width_offset: 10,
                attachToResizeEvent: false,

                onGetUsableWidth: function (po2) {
                    let w = il.width();
                    return w;
                },

                onResize: function (po2) {
                    c0.find('.proj-item-div').css('width', po2.cardWidth());
                }
            });
        };

        myApp.projects.onFmtItem2 = function (itemObj, o) {}
            ...
            itemObj.css('width', myApp.projects.handleCard.cardWidth());
        };

    */

    handleCardWidth: function (po, opt0) {

        console.assert(typeof po != 'undefined' && po != null, 'po param cannot be null');
        console.assert(typeof opt0 != 'undefined' && opt0 != null, 'opt0 param cannot be null');

        var card_width;
        var w;
        var wnd = celUI.getWnd();

        po.calcWidth = function () {
            w = wnd.width();

            if (w <= 500) {
                // mobile view

                if (typeof opt0.mobile_width_offset == 'undefined' || opt0.mobile_width_offset == null || toInt(opt0.mobile_width_offset) <= 0) {
                    opt0.mobile_width_offset = 20;
                }

                w -= opt0.mobile_width_offset;
                card_width = w.toString() + 'px';
            }
            else {
                // desktop view

                if (typeof opt0.min_card_width == 'undefined' || opt0.min_card_width == null || toInt(opt0.min_card_width) <= 0) {
                    opt0.min_card_width = 200;
                }

                if (obj_has_proc(opt0, 'onGetUsableWidth')) {

                    // if the hosting obj handle the usable width
                    w = obj_exec_proc(opt0, 'onGetUsableWidth', [po]);

                    if (w <= 0) {
                        w = wnd.width();
                        w -= opt0.desktop_width_offset;
                        ////console.log('==>2=', w)
                    }
                    ////else {
                    ////    console.log('==>3=', w)
                    ////}

                }
                else {
                    if (typeof opt0.desktop_width_offset == 'undefined' || opt0.desktop_width_offset == null || toInt(opt0.desktop_width_offset) <= 0) {
                        opt0.desktop_width_offset = 115;
                    }

                    w -= opt0.desktop_width_offset;
                }

                var cnt = toInt(w / opt0.min_card_width);

                // '-20' is because of the vertical scrollbar.
                var j = toInt((w / cnt) - opt0.min_card_width) - 20;

                card_width = toInt(opt0.min_card_width + j).toString() + 'px';

                // console.log('usable width=', w, 'cell cnt=', cnt, 'card_width=', card_width);
            }

        };

        // calc the card width now so that it can be use after init this class.
        po.calcWidth();

        // attach with jQuery resize.
        if (typeof opt0.attachToResizeEvent == 'undefined' || opt0.attachToResizeEvent == null || opt0.attachToResizeEvent) {
            wnd.on('resize', po.resizeCard);
        }

        po.resizeCard = function () {
            po.calcWidth();

            // handle the resize by po.
            if (opt0.onResize) {
                obj_exec_proc(opt0, 'onResize', [po]);
            }
        };

        po.isMobileView = function () {
            return w <= 500;
        };

        po.windowWidth = function () {
            return w;
        };

        po.cardWidth = function () {
            return card_width;
        };

        // remove current instance from resize event
        po.destroy = function () {

            if (typeof opt0.attachToResizeEvent == 'undefined' || opt0.attachToResizeEvent == null || opt0.attachToResizeEvent) {
                wnd.off('resize', po.resizeCard);
            }

            wnd = null;
        };


    },

    //-------------------------
    /*
    21-Jul-2021,lhw-attach click event to the elem(s). The elem css may/may not starts with '.'.
      This will avoid many dev mistake.
    04-Aug-2021,lhw-attach event handler to the given event (e) to the elems in a container (c0).
    This proc was earlier declared as 'click' and now it has been renamed to 'attachEventHandler'
    which is a more generic proc name. Below celUI block, all event handlers (celUI.click, celUI.keypress, ..)
    will be injected.

    param:
        - c0 - the parent elem.
        - l: [[css,sub-css,fn],..] - where css & sub-css is optional. 'l' can be an array, string or fn.
        - [f9] - optional. This is the click handler fn.

    For example, attaching 'click' event handler,

    Old way of attaching the click event:

        c0.find('.btn-add').on('click', batchUpdate.onAddClick);
        c0.find('.batch-upd-item-list1').on('click', '.btn-edit-batch-upd', batchUpdate.onEditClick);

    New way:

        // attach 1 elem
        celUI.click(c2, batchUpdate.onAddClick);
        celUI.click(c0, 'btn-add', batchUpdate.onAddClick);

        // attach multiple elem
        celUI.click(c0,
            [
                // with a specific css class.
                ['btn-add', batchUpdate.onAddClick],

                // with sub-css class
                ['batch-upd-item-list1', '.btn-edit-batch-upd', batchUpdate.onAddClick]
            ]);

    */

    attachEventHandler: function (e, c0, l, f9) {
        if (typeof l != 'string' && isJQueryObject(l)) {
            //27-Nov-2022,lhw-handle the jquery object.
            l.on(e, f9);
        }
        else if (!Array.isArray(l)) {
            // attach 1 elem
            if (typeof l == 'string' && typeof f9 == 'function') {
                // find the elem and attach the fn
                c0.find(elemCss(l).wrap()).on(e, f9);
            }
            else if (typeof l == 'function') {
                // attach the fn
                c0.on(e, l);
            }
        }
        else {
            // attach many elem
            celLoop.each(l, function (o2) {
                if (arrLen(o2) == 2) {
                    c0.find(elemCss(o2[0]).wrap()).on(e, o2[1]);
                }
                else {
                    c0.find(elemCss(o2[0]).wrap()).on(e, elemCss(o2[1]).wrap(), o2[2]);
                }
            });
        }
    },

    //-------------------------

    // the following code will be injected at the end of this class.
    // click: function (c0, l, f9) {
    //     celUI.attachEventHandler('click', c0, l, f9);
    // },



    //-------------------------
    /*
    21-Jul-2021,lhw-update the elem(s) height. The elem css may/may not starts with '.'.
      This will avoid many dev mistake.

    param:
    - c0 - the parent elem.
    - l: [[css,adj],..] - where adj is the height to be reduce. 'l' can be an array or number (to adjust c0 only).

    Old way:
        c0.find('.shm-item-list').css('height', (h - 245).toString() + 'px');
        c0.find('.term-item-list').css('height', (h - 215).toString() + 'px');
        c0.find('.att-item-list').css('height', (h - 215).toString() + 'px');

    New way:
        // more expressive
        celUI.updateHeight(c0,
            [
                ['shm-item-list', 245],
                ['term-item-list', 215],
                ['.att-item-list', 215],
            ]);

        // std the code
        celUI.updateHeight(c2, 120);

    */

    updateHeight: function (c0, l, opt) {
        let h2;
        let h = celUI.getWndHeight();

        if (typeof l == 'number') {
            // resize 1 elem
            if (opt && opt.fixed) {
                h2 = l
            } else {
                h2 = h - Math.abs(l);
            }

            c0.css('height', h2.toString() + 'px');
        }
        else {
            // resize many elem
            celLoop.each(l, function (o2) {
                if (opt && opt.fixed) {
                    h2 = o2[1];
                }
                else {

                    h2 = h - Math.abs(o2[1]);
                }
                if (isJQueryObject(o2[0])) {
                    o2[0].css('height', h2.toString() + 'px');
                }
                else {
                    c0.find(elemCss(o2[0]).wrap()).css('height', h2.toString() + 'px');
                }
            });
        }
    },

    //21-Jul-2021,lhw-
    getWnd: function () {
        if (typeof celUI.wnd == 'undefined') {
            celUI.wnd = $(window);
        }
        return celUI.wnd;
    },

    //21-Jul-2021,lhw-
    getWndHeight: function () {
        return celUI.getWnd().height();
    },

    //28-Feb-2022,lhw-
    getWndWidth: function () {
        return celUI.getWnd().width();
    },

    //30-Aug-2021,lhw-
    scrollItemToView: function (il0, c2) {
        il0.scrollTop(c2.offset().top - il0.offset().top + il0.scrollTop() - il0.height() + c2.height() + 10);
    },

    /*
        03-Sep-2021,lhw-create the data entry form flow for the given field list

            ```
            let c2 = celUI.entryFlow($('.main-div'),
                [
                    'txt1',
                    'txt2',

                    // where 'idx2' is the current elem index.
                    // returns 'true' to indicate already handled the enter key.
                    ['txt3',
                        function (idx2) {
                            if (chk_get_val('#chk1')) {
                                $('.main-div').find('.btn1').trigger('click');
                                return true;
                            }
                        }],

                    //27-Nov-2022,lhw-provide a jobject.
                    $('.txt4'),

                    // expecting last elem trigger a click event.
                    'btn1',
                ]);

            c2.start();
            ```

        where
        - c0 - the container
        - l - [[elem/css, cb],..]

    */
    entryFlow: function (c0, l) {
        let m = arrLen(l);

        function _on_focus(e) {
            $(e.target).trigger('select');
        }

        function get_elem(idx) {
            const item = l[idx + 1];

            //27-Nov-2022,lhw-handle jobject.
            if (typeof item != 'string' && isJQueryObject(item)) {
                return item;
            }

            if (Array.isArray(item)) {
                return c0.find(elemCss(item[0]).wrap());
            }

            return c0.find(elemCss(item).wrap());
        };

        // setup all input elems.
        celLoop.each(l, function (c20, idx) {
            let c3 = c20;
            let cb = null;

            if (Array.isArray(c3)) {
                if (arrLen(c3) > 1){
                    cb = c3[1];
                }

                c3 = c3[0];
            }

            celUI.attachEventHandler('focus', c0, c3, _on_focus);

            celUI.attachEventHandler('keypress', c0, c3,
                function (e) {
                    // console.log('celUI.entryFlow:keypress', e.keyCode, e.shiftKey);

                    //27-Nov-2022,lhw-for textarea, if not shift+enter, exit
                    if ($(e.target).is('textarea')) {
                        if (!(e.shiftKey && is_enter_key(e))) {
                            return;
                        }
                    }
                    else {
                        if (!is_enter_key(e)) {
                            return;
                        }
                    }

                    celUI.discardEvent(e);

                    const next_idx = idx + 1;
                    if (next_idx <= m) {
                        const c4 = get_elem(idx);
                        // console.log('next_idx', next_idx, c4);

                        if (next_idx < m - 1) {
                            // jump to next field if not yet handle.
                            let h;
                            if (cb) {
                                h = cb(idx);
                            }

                            if (!h) {
                                if ((c4.is('input')
                                        && c4.attr('type') != 'button'
                                        && c4.attr('type') != 'submit'
                                        && !c4.attr('readonly')
                                    )
                                    || c4.is('select')
                                    || c4.is('textarea')
                                ) {
                                    // console.log('=> trigger focus event', c4, c4.attr('readonly'));

                                    //26-May-2022,lhw-it is an input
                                    celUI.focusInput(c4);
                                }
                                else {
                                    // console.log('=> trigger click event', c4);

                                    //27-Nov-2022,lhw-for the elem that cannot handle 'focus', trigger 'click' event.
                                    c4.trigger('click');
                                }
                            }
                        }
                        else if (next_idx == m - 1) {
                            // current elem is the 2nd last, next_idx is the last elem
                            if ((c4.is('input') && c4.attr('type') != 'button' && c4.attr('type') != 'submit')
                                || c4.is('select')
                                || c4.is('textarea')
                            ) {
                                //26-May-2022,lhw-it is an input
                                c4.trigger('focus');
                            }
                            else {
                                // assume the last elem is a button.
                                c4.trigger('click');
                            }
                        }
                        else if (next_idx == m) {
                            //26-May-2022,lhw-this is after the last elem and it is not a button.
                            const c5 = get_elem(idx - 1);
                            if ((c5.is('input') && c5.attr('type') != 'button' && c5.attr('type') != 'submit')
                                || c5.is('select')
                            ) {
                                if (cb) {
                                    c5.trigger('blur');
                                    cb(idx);
                                }
                            }
                            else {
                                // assume the last elem is a button.
                                c5.trigger('click');
                            }
                        }
                    }
                });
        });

        return {
            c0: c0,
            l: l,
            start: function () {
                celUI.focusInput(c0.find(elemCss(l[0]).wrap()));
            },
            reset: function () {
                reset_input(c0, l);
            }
        }
    },

    /**
     * 10-Jul-2022,lhw-by default, it focus on the input and the highlight the current input.
     * @param {Object} c2 - a JQuery object (either a container or input element).
     * @param {String} [id] - element class ID. If it is bool type, it will be treated as `skip_select` param.
     * @param {Boolean} [skip_select]
     */
    focusInput: function (c2, id, skip_select) {

        if (typeof id == 'string') {
            c2 = c2.find(elemCss(id).wrap());
        }
        else {
            skip_select = id;
        }

        c2.trigger('focus');

        if (!skip_select) {
            c2.trigger('select');
        }
    },

    //10-Jul-2022,lhw-stop the
    discardEvent: function (e) {
        e.preventDefault();
        e.stopPropagation();
    },

};

//------------------------------------------------------------------------------
(
    //04-Aug-2021,lhw-inject the event handlers.
    function () {

        [
            'blur',
            'change',
            'click',
            'contextmenu',
            'dblclick',
            'focus',
            'focusin',
            'focusout',
            'keydown',
            'keypress',
            'keyup',
            'mousedown',
            'mouseenter',
            'mouseleave',
            'mousemove',
            'mouseout',
            'mouseover',
            'mouseup',
            'resize',
            'scroll',
            'select',
            'submit',
        ]
            .forEach(function (e2) {
                celUI[e2] = function (c0, l, f9) {
                    celUI.attachEventHandler(e2, c0, l, f9);
                };
            });
    }

)();



//==============================================================================
/*
23.Jul.19,lhw-
- this class helps to destroy ll the html element and reset var after used.

param:
- fo - the parent obj/func that will be injected with the functionalities.

- opt.o0 - the parent obj that holds the func/var to be destroy.
- opt.poName -the name of the func that received the injected functionalities.


*/
//==============================================================================

function celDestroyer(opt) {
    var def_opt = {
        // the func/var container
        o0: null,

        // the name of the func that received the injected functionalities.
        poName: 'destroyer'
    };

    opt = $.extend(def_opt, opt);

    //03-Jul-2021,lhw-bug fixed-should check null or undef.
    // if (!obj_has_fld(opt.o0, opt.poName)) {
    if (typeof opt.o0[opt.poName] == 'undefined' || opt.o0[opt.poName] == null) {
        //declare the function using 'poName'
        opt.o0[opt.poName] = function () { };
    }
    else {
        console.log('celDestroyer has already been init. exit', new Error());
        return;
    }

    var store = [];
    var fo = opt.o0[opt.poName];

    fo.destroyThis = function (name, reset_to_null, po) {
        console.assert(false, '11.Mar.20,lhw-destroyThis() proc has retired. Please call add().');
    };

    //11.Mar.20,lhw-
    // add a func/var to the destroy list
    // param:
    // - name - string or po (22-Jul-2021,lhw).
    // - [reset_to_null] - if true, that reference will be set to NULL upon destroy.
    //        => 22-Jul-2021,lhw-this param can be: [[name, reset],.. ].
    // - [po] - attach to parent other that opt.o0.
    fo.add = function (name, reset_to_null, po) {

        function _add_item(n, r, p) {
            // console.log('celDestroyer.add', n);

            //28-Jun-2021,lhw-check to see if it has been added.
            if (store.length > 0) {
                let b = true;

                celLoop.each(store, function (o2) {
                    if (o2.n == n && o2.po == p) {
                        // dump the info for troubleshooting.
                        console.assert(false, `celDestroyer.add() => ${n} has already been added to the list`);
                        console.log(new Error());
                        console.log('celDestroyer.store:');
                        console.log(store);

                        b = false;
                        return false;
                    }
                });

                if (!b) {
                    return;
                }
            }

            store.push({
                n: n,
                reset: r,
                po: p
            });
        }

        //-------------------------
        //22-Jul-2021,lhw-
        //-------------------------
        if (typeof name == 'string' && typeof reset_to_null == 'boolean') {

            // the conventional way.
            // sample:
            //      batchUpdate.destroyer.add('membSearchResult', true, batchUpdate);

            _add_item(name, reset_to_null, po);
        }
        else if (!Array.isArray(name)
            && (typeof name == 'function' || typeof name == 'object')
            && Array.isArray(reset_to_null)
        ) {
            // the new way: [var/fn, [reset_to_null:bool], [po]]
            // sample:
            // batchUpdate.destroyer.add(batchUpdate,
            //     [
            //         ['membSearchResult', true],
            //         ['selMemb', true],
            //         'dockbar',
            //     ]);

            po = name;

            celLoop.each(reset_to_null, function (a) {
                if (Array.isArray(a)) {

                    if (arrLen(a) > 2) {
                        // the caller pass in the parent object as well.
                        _add_item(a[0], a[1], a[2]);
                    }
                    else if (arrLen(a) > 1) {
                        _add_item(a[0], a[1], po);
                    }
                    else {
                        _add_item(a[0], true, po);
                    }
                }
                else {
                    // default is reset_to_null.
                    _add_item(a, true, po);
                }
            });

        }
        else if (Array.isArray(name) && typeof reset_to_null == 'undefined' && typeof po == 'undefined') {

            // the new way : 3 items are compulsory.
            // sample:
            // batchUpdate.destroyer.add(
            //     [
            //         ['membSearchResult', true, batchUpdate],
            //         ['selMemb', true, batchUpdate]
            //     ]);

            celLoop.each(name, function (a) {
                _add_item(a[0], a[1], a[2]);
            });
        }
        else if (typeof name == 'function') {
            //04-Jul-2022,lhw-run the function to destroy the reference.
            _add_item(name);
        }
        else {
            //04-Jul-2022,lhw-
            console.assert(false, 'celDestroyer.add()- unhandled case');
        }

    };


    fo.destroyAll = function () {
        let p;
        // console.log('destroyAll..', store)

        celLoop.each(store, function (o) {

            // console.log('destroyAll..', o.n, o.po)

            if (typeof o.n == 'function') {
                //23-Apr-2021,lhw-
                if (obj_has_proc(o.n, 'destroy2')) {
                    obj_exec_proc(o.n, 'destroy2');
                }
                else if (obj_has_proc(o.n, 'destroy')) {
                    obj_exec_proc(o.n, 'destroy');
                }
                else {
                    //17-Jul-2021,lhw-exec the fn.
                    o.n();
                }

                // console.log('destroyAll - after', o.n);
            }
            else {

                if (o.po) {
                    // in the specific container
                    p = o.po;
                }
                else {
                    // in the same container.
                    p = opt.o0;
                }

                //-------------------------------
                //11.Mar.20,lhw-we should call destroy2() instead of destroy()
                // because destroy2() was overriden by the hosting object.
                //
                ////if (obj_has_proc(p[o.n], 'destroy')) {
                ////    obj_exec_proc(p[o.n], 'destroy');
                ////}
                ////else if (obj_has_proc(p[o.n], 'destroy2')) {
                ////    obj_exec_proc(p[o.n], 'destroy2');
                ////}

                if (obj_has_proc(p[o.n], 'destroy2')) {
                    obj_exec_proc(p[o.n], 'destroy2');
                }
                else if (obj_has_proc(p[o.n], 'destroy')) {
                    obj_exec_proc(p[o.n], 'destroy');
                }

                //reset to null
                if (o.reset) {
                    p[o.n] = null;
                }

                // console.log('destroyAll - after', o.n, p[o.n]);
            }

        });

        //26.Apr.20,lhw-bug fixed-omitted to destory myself.
        store = [];
    };

    //18-Jul-2023,lhw-for inspecting the contents.
    fo.getStore = function () {
        return store;
    };

    //18-Jul-2023,lhw-to ease the type checking.
    fo.getType = function () {
        return 'celDestroyer';
    };

}

//------------------------------------------------------------------------------

const celImg = {


    //-------------------------------
    //11.Mar.20,lhw-make 'po' as image + file controls as pair
    // to handle image file selection. If the user selected
    // any file, the image will be shown on the screen.
    // Then, the hosting object will have to upload the image programmatically.
    //
    // - onValidate(f):b    => the callback to handle the file before showing it on screen.
    // - cb(f)          => the callback to handle after the file has been triggered to show on the screen.
    //
    //-------------------------------

    makePicker: function (po, opt0) {

        const HEADER_PNG = 'data:image/png;base64,';

        var def_opt = {

            img_ctl: null,
            file_ctl: null,

            // default file size
            max_size_mb: 4,

            // onValidate(file):b
            onValidate: null,

            // param: file
            onDone: null
        };

        opt0 = $.extend(def_opt, opt0);

        //-------------------------------
        // handle the file input change event.
        opt0.file_ctl.off().on('change', function (e) {
            ////console.log(e.target.files[0]);

            var f = e.target.files[0];

            if (typeof opt0.max_size_mb != 'undefined' && opt0.max_size_mb != null && opt0.max_size_mb > 0) {
                var mb = f.size / 1024 / 1024;
                if (mb > opt0.max_size_mb) {
                    msgbox.err(`Exceeded maximum allowed size (${opt0.max_size_mb}MB)`);
                    return;
                }
            }

            // allows hosting object to validate the selection before loading the file.
            if (opt0.onValidate) {
                var b = opt0.onValidate(f);

                if (typeof b != 'undefined' && b != null && !b) {
                    ////console.log('=> skip show file');
                    return;
                }
            }

            var fr = new FileReader();

            // if loaded ok, show it on the screen.
            fr.onload = function (ev2) {
                // show the image
                opt0.img_ctl.attr('src', ev2.target.result);
            };

            // read the file contents
            fr.readAsDataURL(f);

            if (opt0.onDone) {
                opt0.onDone(f);
            }
        });

        // handle the 'img' element click event.
        opt0.img_ctl.on('click', function () {
            opt0.file_ctl.trigger('click');
        });

        // restrict the file extension.
        opt0.file_ctl.attr('accept', '.png, .jpg, .jpeg');

        //-------------------------------
        po.showImg = function (img) {
            if (isStrEmpty(img)) {
                opt0.img_ctl.attr('src', '');
            }
            else {
                // the img data can be png or jpg.
                // And if we use PNG file header, the browser will handle it internally.
                opt0.img_ctl.attr('src', HEADER_PNG + img);
            }
        };

        //-------------------------------
        po.clear = function () {
            opt0.img_ctl.attr('src', '');
        };

        //-------------------------------
        po.getImage = function () {
            var s = opt0.img_ctl.attr('src');
            // remove the 'header' upto comma symbol.
            var i = s.indexOf(',');
            return s.substr(i + 1, s.length - i);
        };

        //-------------------------------
        po.destroy = function () {
            opt0 = null;
        };


    },

};

//------------------------------------------------------------------------------
//29-Dec-2020,lhw-convert the color in decimal value to hex.
function color_decToHex(dec) {
    return '#' + (dec & 0x00FFFFFF).toString(16).padStart(6, '0');
}

//29-Dec-2020,lhw-convert the hex value to decimal value.
function hexToDec(hex) {
    if (isStrEmpty(hex)) {
        return 0;
    }

    return parseInt(hex.replace('#', ''), 16);
}




//==============================================================================
// reference:
// https://www.smashingmagazine.com/2015/07/designing-simple-pie-charts-with-css/
//
// total: radius x 2 x 3.142 => 12 x 2 x 3.142 = 75.408
// Test data: 100%, 75%, 50%, 25% & 0%.
//
// param:
// - c2 - the circle tag in the svg.
// - v0 - range from 0 ~ 100. Negative value will be reset to zero.
// - radius - you may use any value. Default is 12.
//
function fmtPie(c2, v0, radius) {
    var pie;

    if (typeof radius == 'undefined' || radius == null) {
        radius = 12;
    }

    let total = (radius * 2 * Math.PI);

    if (c2.find('.pie').length == 1) {
        pie = c2.find('.pie')[0];
    }
    else {
        pie = c2.find('.pie2')[0];
    }

    if (v0 < 0) {
        v0 = 0;
    }

    pie.style.stroke = heatMapColorforValue(1 - (v0 / 100));
    pie.style.strokeDasharray = '0 ' + total;

    // delay the setting for 'transition' css to work.
    setTimeout(() => {
        if (v0 > 0) {
            let stroke_len = ((v0 * total) / 100);
            pie.style.strokeDasharray = stroke_len.toString() + ' ' + total.toString();
        }
        else {
            pie.style.strokeDasharray = '0 ' + total;

            // hide the 0% dot.
            pie.style.strokeWidth = 0;
        }
    }, 50);

};

//------------------------------------------------------------------------------
/*
0    : blue   (hsl(240, 100%, 50%))
0.25 : cyan   (hsl(180, 100%, 50%))
0.5  : green  (hsl(120, 100%, 50%))
0.75 : yellow (hsl(60, 100%, 50%))
1    : red    (hsl(0, 100%, 50%))
*/

function heatMapColorforValue(pct) {
    var h = (1.0 - pct) * 240;
    return 'hsl(' + h + ', 100%, 50%)';
}

//------------------------------------------------------------------------------
//02-Apr-2021,lhw-
function rgbaToHex(v) {
    if (!v) {
        return 'fff';
    }

    v = v.toString().toLowerCase();
    if (v.indexOf('rgb') < 0) {
        if (v[0] != '#') {
            return '#' + v;
        }
        return v;
    }

    v = v.replace('rgba', '').replace('rgb', '').replace('(', '').replace(')', '').split(',');

    for (let i = 0; i < v.length; i++) {
        v[i] = '0' + toInt(v[i]).toString(16);
        if (v[i].length > 2) {
            v[i] = v[i].substr(1, 2);
        }
    }

    return '#' + v.join('');
}

//------------------------------------------------------------------------------
//02-Apr-2021,lhw-
// reference: copied from MaterialColorPickerJS
//------------------------------------------------------------------------------
function invertColor(hex, bw) {
    if (hex.indexOf('#') === 0) {
        hex = hex.slice(1);
    }
    // convert 3-digit hex to 6-digits.
    if (hex.length === 3) {
        hex = hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2];
    }

    var r = parseInt(hex.slice(0, 2), 16);
    var g = parseInt(hex.slice(2, 4), 16);
    var b = parseInt(hex.slice(4, 6), 16);

    if (bw) {
        // http://stackoverflow.com/a/3943023/112731
        return (r * 0.299 + g * 0.587 + b * 0.114) > 186
            ? '#000000'
            : '#FFFFFF';
    }

    // invert color components
    r = (255 - r).toString(16);
    g = (255 - g).toString(16);
    b = (255 - b).toString(16);

    // pad each with zeros and return
    function padZero(s) {
        if (s.length == 1) {
            s = '0' + s;
        }
        else if (s.length == 0) {
            s = '00';
        }

        return s;
    }

    return '#'
        + padZero(r)
        + padZero(g)
        + padZero(b);

}

//------------------------------------------------------------------------------
//04-Apr-2021,lhw-this proc is for replacing $.isNumeric() since it has been deprecated in the JQuery.
function isNumeric(v) {
    var vt = typeof v;
    return (vt == 'number' || vt == 'string')
        && !isNaN(v - parseFloat(v));
}


//------------------------------------------------------------------------------
//05-Jul-2021,lhw-wrap the css class value.
function elemCss(c) {

    function elemCss2(c) {

        function _wrap(c2) {
            //02-Sep-2021,lhw-we should handle the '.' & '#'.
            // if (c2[0] != '.') {
            if (['.', '#'].indexOf(c2[0]) < 0) {
                return '.' + c2;
            }
            return c2;
        }

        // Ensure that the CSS class starts with dot. Able to handle single value or array of value.
        this.wrap = function () {
            if (!Array.isArray(c)) {
                if (c) {
                    return _wrap(c);
                }
                else {
                    return '';
                }
            }
            else {
                let r = '';
                for (let i = 0; i < c.length; i++) {
                    if (i == 0) {
                        r = _wrap(c[i]);
                    }
                    else {
                        r += ' ' + _wrap(c[i]);
                    }
                }
                return r;
            }
        };

        // Remove the dot from the the start. Able to handle signle value only.
        this.unwrap = function () {
            //02-Sep-2021,lhw-we should handle the '.' & '#'.
            // return (c ? ((c[0] == '.') ? c.substring(1, c.length) : c) : '')
            return (c ? ((['.', '#'].indexOf(c[0]) >= 0) ? c.substring(1, c.length) : c) : '')
        };

        // Create immediate sub-level. Eg: '.item-div > div' after wrap().
        this.immediate = function (c2) {
            return elemCss(c + ' > ' + c2);
        };

        // Create immediate sub-level with wrap. Eg: '.item-div > .prod-desc' after wrap().
        this.immediateWrap = function (c2) {
            let r;
            if (c2) {
                r = _wrap(c2);
            }
            else {
                r = '';
            }

            return elemCss(c + ' > ' + r);
        };
    }

    return new elemCss2(c);
};


//------------------------------------------------------------------------------
//30-Jul-2021,lhw-Parse the JSON string and convert it to an object. This proc handles Date object as well.
function parseJSONText(s) {
    // with millisecond
    const dateFormat = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d{3}Z$/;
    // without millisecond
    const dateFormat2 = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}Z$/;
    //09-Dec-2021,lhw-the value does not end with 'Z'.
    const dateFormat3 = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}$/;

    function reviver(key, value) {
        if (typeof value === "string" && (dateFormat.test(value) || dateFormat2.test(value) || dateFormat3.test(value))) {
            return new Date(value);
        }

        return value;
    }

    //07-Jul-2022,lhw-we should do this if it is json text.
    if (typeof s === 'string'
        && (s[0] == '{' || s[0] == '[')
    ) {
        return JSON.parse(s, reviver);
    }

    return s;
}


function storageSizeToProper(size) {
    let i = toInt(size);
    let u;
    if (i < 1024) {
        u = 'B';
        return addCommas(toDbl(i).toFixed(0)) + u;
    }

    if (i < (1024 * 1024)) {
        u = 'KB';
        i = i / 1024;
    }
    else if (i < (1024 * 1024 * 1024)) {
        u = 'MB';
        i = i / 1024 / 1024;
    }
    else if (i < (1024 * 1024 * 1024 * 1024)) {
        u = 'GB';
        i = i / 1024 / 1024 / 1024;
    }
    else {
        u = 'TB';
        i = i / 1024 / 1024 / 1024 / 1024;
    }

    return addCommas(toDbl(i).toFixed(2)) + u;
}


/**
 * 30-Jun-2022,lhw-sum the value of the selected fields.
 * @param {Object} o
 * @param {Array} flds
 * @returns
 */
function sumFields(o, flds) {
    var d = 0;

    celLoop.each(flds, function (f2) {
        d += toDbl(o[f2]);
    });

    return d;
}

/**
 * 17-Jan-2023,lhw-
 * @param {string} file_name
 * @param {Buffer|Array} buffer
 */
function downloadFileFromBuffer(file_name, buffer){
    // prompt for save the file to disk.
    const blob = new Blob([buffer]);
    const link = document.createElement('a');

    if (link.download !== undefined) {
        const url = URL.createObjectURL(blob);
        link.setAttribute('href', url);
        link.setAttribute('download', file_name);
        link.style.visibility = 'hidden';
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    }
}

/**
 * 05-Sep-2023,lhw-download a file from the given url.
 * @param {String} url
 * @param {String} file_ext
 * @param {Function} cb
 */
function downloadFile(url, file_ext, cb) {
    const o2 = {
       _tmp_file_name: null,
    };

    // console.log('downloadFile=', url);
    fetch(url, { method: 'get' })
        .then((res) => {
            if (!res.ok) {
                return res.statusText;
            }
            else {
                o2._tmp_file_name = res.headers.get('content-disposition');
                return res.blob();
            }
        })
        .then(res => {
            cb();

            if (typeof res == 'string') {
                msgbox.err(res);
            }
            else {
                const aElement = document.createElement('a');
                aElement.setAttribute('download', o2._tmp_file_name || getUniqueID() + (file_ext || '.pdf'));

                const href = URL.createObjectURL(res);
                aElement.href = href;
                aElement.setAttribute('target', '_blank');
                aElement.click();
                URL.revokeObjectURL(href);
            }
        })
        .catch(() => {
            cb();
        });
}

//------------------------------------------------------------------------------
/**
 * 09-May-2023,lhw-
 * This function is for `Array.sort()` and it reduces the number of lines that requires to make it works.
 *
 * For example, sort an array in descending order.
 * ```
 * fs.readdirSync(cache_path)
 *   .sort((a,b) => arrSort(a, b, null, null, true));
 * ```
 *
 * Sort the data list by 'name' field in descending order.
 * ```
 * l2.sort((a,b) => arrSort(a, b, 'name', null, true));
 * ```
 *
 * Sort the data list by 'room_type_id' vs 'rt_id'.
 * ```
 * l2.sort((a,b) => arrSort(a, b, 'room_type_id', 'rt_id'));
 * ```
 *
 * @param {Any} a
 * @param {Any} b
 * @param {string|String[]} [fld] - the field name if a/b is an object. This field may be an array of another string array.
 *
 * For example,
 * ```
 * l3 = l2.sort((a,b) => arrSort(l2,
 *   [
 *     // in desc order
 *     ['is_in_use', true],
 *     // in asc order
 *     ['name', false]
 *   ]);
 * ```
 *
 * @param {string|String[]} [fld2] - the field name in b if b is an object. If undefined/null, follows 'fld' param.
 * @param {boolean} [desc] - by default, this is 'false' which sort the array in ascending order.
 * @returns {Number} - returns -1, 0 or 1.
 */
function arrSort(a, b, fld, fld2, desc) {
    const order = (desc ? -1 : 1);

    // handle undefined & null array item.
    if (typeof a == 'undefined' || a == null) {
        return -1 * order;
    }
    if (typeof b == 'undefined' || b == null) {
        return 1 * order;
    }

    // handle native data type.
    if (typeof fld == 'undefined' || fld == null) {
        if (a > b
            || typeof b == 'undefined'
            || b == null
        ) {
            return 1 * order;
        }

        if (a < b
            || typeof a == 'undefined'
            || a == null
        ) {
            return -1 * order;
        }

        return 0;
    }
    else {
        // handle object type
        if (typeof fld2 == 'undefined' || fld2 == null) {
            fld2 = fld;
        }

        if (Array.isArray(fld)) {
            // for sorting by multiple fields.
            let i9 = 0;
            let m = fld.length;
            let fa, fb, order9;
            for (let i = 0; i < m; i++) {
                if (Array.isArray(fld[i])) {
                    // each field has different sorting order.
                    fa = fld[i][0];
                    order9 = (fld[i][1] ? -1 : 1);
                }
                else {
                    fa = fld[i];
                    order9 = order;
                }

                if (Array.isArray(fld2[i])) {
                    fb = fld2[i][0];
                }
                else {
                    fb = fld2[i];
                }

                i9 = i9 || (comp_a_b(a, b, fa, fb) * order9);
            }

            // return i9 * order;
            return i9;
        }
        else {
            // sort by single field.
            return comp_a_b(a, b, fld, fld2) * order;
        }
    }
};

//------------------------------------------------------------------------------
/**
 * 22-May-2023,lhw-
 * In place sorting an array. This function is same as `arrSort()` except that it does not requires to write callback or lamda function.
 * Notes: please refers to `arrSort()` for more information.
 *
 * Sample,
 * ```
 * l3 = arrSort2(l2,
 *   [
 *     // in desc order
 *     ['is_in_use', true],
 *     // in asc order
 *     ['name', false]
 *   ]);
 * ```
 *
 * @param {Array} arr
 * @param {String|String[]} [fld]
 * @param {String|String[]} [fld2]
 * @param {Boolean} [desc]
 */
function arrSort2(arr, fld, fld2, desc) {
    if (!(typeof fld2 == 'undefined' || fld2 == null || typeof fld2 == 'string' || Array.isArray(fld2))) {
        throw new Error('arrSort2: fld2 param must be String or String[] type');
    }

    return arr.sort((a, b) => arrSort(a, b, fld, fld2, desc));
};


//------------------------------------------------------------------------------
/**
 * Returns the comparison result for 2 given fields.
 * @param {Any} a
 * @param {Any} b
 * @param {String} fld
 * @param {String} fld2
 * @returns
 */
function comp_a_b(a, b, fld, fld2){
    if (typeof b[fld2] == 'undefined'
        || b[fld2] == null
    ) {
        return 1;
    }

    if (typeof a[fld] == 'undefined'
        || a[fld] == null
    ) {
        return -1;
    }

    // for string type only.
    if (typeof a[fld] == 'string') {
        // console.log(`-> ${a[fld]} comp ${b[fld2]} =  ${a[fld].localeCompare(b[fld2])}`);
        return a[fld].localeCompare(b[fld2]);
    }

    if (typeof a[fld] == 'number') {
        return a[fld] - b[fld2];
    }

    if (a[fld] > b[fld2]) {
        return 1;
    }

    if (a[fld] < b[fld2]) {
        return -1;
    }

    return 0;
}


//------------------------------------------------------------------------------
/**
 * 21-May-2023,lhw-round the number to the nearest x decimal point.
 * @param {Number} n
 * @param {Number} [decimal] - default is 2 decimal points.
 * @returns {Number}
 */
function round(n, decimal) {
    if (typeof decimal == 'undefined' || decimal == null) {
        decimal = 2;
    }
    return toDbl(toDbl(n).toFixed(decimal));
};


//------------------------------------------------------------------------------
//08-Mar-2024,lhw-
function redirectByPost(url, p2, new_tab) {
    p2 = p2 || {};

    let frm = document.createElement("form");
    frm.id = "frmbk";
    frm.name = "frmbk";
    frm.action = url;
    frm.method = "post";
    // frm.enctype = "multipart/form-data";

    if (new_tab) {
      frm.target = "_blank";
    }

    Object.keys(p2).forEach(function (key) {
      var input = document.createElement("input");
      input.type = "text";
      input.name = key;
      input.value = p2[key];
      frm.appendChild(input);
    });

    document.body.appendChild(frm);
    frm.submit();
    document.body.removeChild(frm);
    return false;
}



