﻿/*==============================================================================


03-Apr-2021,lhw
- sample code for celMonthView() (static calendar on the screen).
    
    var idx = 1;

    function appendTask(c2) {
        let c3 = $('<div/>');
        c3.addClass('my-task');
        c3.text('task #' + idx);
        c3.attr('id', 'task-' + idx);
        c2.find('.day_il').append(c3);
        idx++;
    }

    function my_cal() { }

    $(function () {
        var p = {
            c0: getJObject('my-calendar'),

            // if false, it will not include the title bar.
            // withTitleBar: false,

            onInit: function (c00) {
                console.log('cal is ready');

                let il = my_cal.getAll();
                // console.log('il=', il)

                for (let i = 0; i < 5; i++) {
                    let c2 = $(il[i]);
                    appendTask(c2);
                    appendTask(c2);
                    appendTask(c2);

                    // console.log('cell data()=', c2.data('dt'));
                }
            },

            onMonthChange: function (e) {
                console.log('onMonthChange', e)
            },
            
            onSelected: function (dt, e) {
                console.log('dt=', dt);
                console.log('e=', e);

                appendTask(e.cell);
            }
        };

        celMonthView(my_cal, p);
    });


==============================================================================*/
'use strict';

const CAL_ID = 'cel_datepicker';

function calendar() { }

calendar.popup = null;

// this is for celDatepicker.
calendar.curr_ctl = null;

//30.Nov.18,lhw-
calendar.animate_duration = 100;

//03-Apr-2021,lhw-in this version, it will build the cal locally.
calendar.load_ui_from_server = false;


calendar.playSound = function () {
    if (typeof app != 'undefined') {
        obj_exec_proc(app, 'playSound');
    }
};

//------------------------------------------------------------------------------
calendar.hide = function (me, hide_progress) {
    var c;

    if (typeof me == 'undefined') {
        me = '#' + CAL_ID;
    }

    c = getJObject(me);

    //13.Mar.20,lhw-should check the visibility to avoid extra calls.
    if (c.is(':visible')) {

        if (c.attr('id') != CAL_ID) {
            c.closest('#' + CAL_ID).slideUp('fast');
        }
        else {
            c.hide();
        }

        calendar.curr_ctl = null;

        if (typeof hide_progress == 'undefined' || hide_progress) {
            progress.hide();
        }
    }

};


//------------------------------------------------------------------------------
calendar.show = function (me) {
    progress.show();

    var c = getJObject(me);
    center(c);
    c.slideDown('fast');
};

//------------------------------------------------------------------------------
//3.Oct.19,lhw-
calendar.preloadForm = function () {
    calendar.loadForm(CAL_ID, null, null, null, null, true);
};

//-------------------------
//3.Oct.19,lhw-added 'skip_show:bool'.
calendar.loadForm = function (id, callback, startup, template_code, container, skip_show) {
    // console.log('calendar.loadForm: id', id);

    var c = getJObject(id);

    if ((c && c.length === 0) || startup) {

        if (c && c.length === 0) {
            var s = '<div id="' + id.replace('#', '').replace('.', '') + '"  class="pp_dlg cal_dlg" style="display:none;"></div>';

            if (container) {
                //27.Sep.18,lhw-load the cal to the specific container.
                container.append(s);
            }
            else {
                $('body').append(s);
            }
        }

        if (!template_code) {
            template_code = 'cal';
        }

        c = getJObject(id);

        if (calendar.load_ui_from_server) {

            c.load(_base_url + 't?code=' + template_code + '&ts=' + getNowString(),
                function () {
                    if (typeof skip_show == 'undefined') {
                        c.show();
                    }

                    if (callback) {
                        callback();
                    }

                });

        }
        else {

            //03-Apr-2021,lhw-
            let c2 = $(calendar.buildCal());

            c.html('').append(c2);
            if (typeof skip_show == 'undefined') {
                c.show();
            }

            if (callback) {
                callback();
            }

        }

    }
    else {

        if (callback) {
            callback();
        }
    }
};

//------------------------------------------------------------------------------
//03-Apr-2021,lhw-this will generate the calendar at the client side which reduce the network payload for downloading celcalendar.html.
calendar.buildCal = function (without_title_bar) {
    let s = [];

    if (typeof without_title_bar == 'undefined' || without_title_bar == null || !without_title_bar) {
        // this is optional for month view.
        s.push('<div class="cal_dlg_title flx-nw">');
        s.push('<div class="cal_pp_list_title"></div>');
        s.push('<div class="flx-nw-rr cal_nav">');
        s.push('<div class="material-icons cal_nav_next" onclick="calendar.nextMonth(this);"></div>');
        s.push('<div class="material-icons cal_nav_prev" onclick="calendar.prevMonth(this);"></div>');
        s.push('</div>');
        s.push('</div>');
    }

    s.push('<div class="cal_data">');
    s.push('<table class="cal_tb" cellpadding="0" cellspacing="0">');
    s.push('<thead>');
    s.push('<tr class="cal_header_row">');

    const wk = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
    for (let i = 0; i < wk.length; i++) {
        s.push('<th><div class="cal_day_header ');
        if (i >= 5) {
            s.push('cal_wend_header');
        }
        else {
            s.push('cal_wday_header');
        }

        s.push('">');
        s.push(wk[i]);
        s.push('</div></th>');
    }
    s.push('</tr>');
    s.push('</thead>');

    let dow;

    s.push('<tbody>');
    for (let r = 0; r < 6; r++) {
        s.push(`<tr class="cal_day_row cal_r${r}">`);

        for (let c = 0; c < wk.length; c++) {
            if (c >= 5) {
                dow = 'cal_wend';
            }
            else {
                dow = 'cal_wday';
            }
            s.push(`<td><div class="cal_day_cell day_r${r}_d${c} ${dow}"></div></td>`);
        }
        s.push('</tr>');
    }

    s.push('</tbody>');
    s.push('</table>');
    s.push('</div>');
    return s.join('');
};



//------------------------------------------------------------------------------
calendar.enableDraggable = function (me) {
    getJObject(me).draggable({ handle: $('.pp_dlg_title') });
};

calendar.disableHideOption = function (me) {
    getJObject(me).find('.hide_cal').hide();
};

//------------------------------------------------------------------------------
calendar.extractRowID = function (cls) {
    var s = '';
    if (cls) {
        // sample cls:
        //      "cal_day_row cal_r1"
        let rg = /day_r(\d{1,2})_d(\d{1,2})/g;
        let l = rg.exec(cls);

        if (arrLen(l) > 0) {
            return toInt(l[1]);
        }
    }
    return s;
};

//------------------------------------------------------------------------------
calendar.getCellIdx = function (cls) {
    var idx = { id: cls, r: 0, d: 0 };

    if (cls) {
        // sample of cls:
        //      "cls cal_day_cell day_r1_d31 cal_wday"
        let rg = /day_r(\d{1,2})_d(\d{1,2})/g;
        let l = rg.exec(cls);

        if (arrLen(l) > 2) {
            idx.r = toInt(l[1]);
            idx.d = toInt(l[2]);
        }
    }

    return idx;
};

//------------------------------------------------------------------------------
//03-Apr-2021,lhw-moved out from calendar.refreshUI()
//------------------------------------------------------------------------------

calendar.onCellClick = function (e) {
    // console.log('cell click', e);

    var c3 = $(e.target);
    var c2 = c3;
    if (!c2.hasClass('cal_day_cell')) {
        c2 = c2.closest('.cal_day_cell');
    }

    var c0 = c2.closest('.cal_tb').parent().parent();
    var cls = c2.attr('class');
    var idx = calendar.getCellIdx(cls);
    idx.dt = c2.data('dt');

    calendar.playSound();

    if (idx.dt) {
        c0.data('sel_dt', idx.dt);

        let on_sel_callback = e.data.on_select;

        // console.log(idx)
        // console.log(on_sel_callback)        

        //03-Apr-2021,lhw-pass the ref to the event handler.
        let e2 = obj_copy(idx, {});
        // the container elem
        e2.c0 = c0;
        // the cell elem
        e2.cell = c2;
        // the clicked elem     
        e2.target = c3;
        e2.orig_e = e;

        if (calendar.curr_ctl) {
            on_sel_callback.call(calendar.curr_ctl, e2);
        }
        else {
            on_sel_callback.call(c0, e2);
        }

        c0.find('.cal_sel_day').each(function () {
            var cc2 = $(this);

            cc2.removeClass('cal_sel_day');
            if (cc2.hasClass('today')) {
                cc2.addClass('cal_today');
            }
        });

        c2.removeClass('cal_today').addClass('cal_sel_day');
    }
};

//------------------------------------------------------------------------------

calendar.refreshUI = function (me, dt, opt) {
    var c0 = getJObject(me);
    var did, day, s, dow, dt2, curr_mth;

    //05-Apr-2021,lhw-
    // var today = moment().startOf('day').toDate();
    var today = dateValue(new Date());

    var sel_dt = c0.data('sel_dt');

    if (!dt) {
        dt = get_begin_of_month(new Date());
    }

    dt2 = get_begin_of_month(dt);
    c0.data('curr_dt', dt2);
    opt.curr_dt = dt2;

    curr_mth = dt2.getMonth();

    if (sel_dt && sel_dt.getMonth() !== curr_mth) {
        sel_dt = null;
    }
    if (curr_mth !== today.getMonth()) {
        today = null;
    }

    //05-Apr-2021,lhw-
    // c0.find('.cal_pp_list_title').text(moment(dt2).format('MMM YYYY'));
    let t0 = formatDateValue(dt2, 'MMM YYYY').split(' ');
    t0[0] = `<div class="cal_title_mth" onclick="calendar.onMthTitleClick(this);">${t0[0]}</div>`;
    t0[1] = `<div class="cal_title_yr" onclick="calendar.onYrTitleClick(this);">${t0[1]}</div>`;
    c0.find('.cal_pp_list_title').html(t0.join(''));

    //-------------------------
    c0.find('.cal_day_cell')
        .removeClass('cal_today')
        .removeClass('cal_sel_day')
        .removeClass('cal_out_of_range');

    //03-Apr-2021,lhw-revamped process to avoid the overhead of looping each elem.
    c0.off('click', calendar.onCellClick)
        .on('click', '.cal_day_cell',
            {
                on_select: opt.on_select
            },
            calendar.onCellClick);

    //-------------------------
    if (!opt) {
        opt = c0.data('option');
    }

    for (var i = 0; i < 6; i++) {
        for (var j = 0; j < 7; j++) {
            did = '.day_r' + i.toString() + '_d' + j.toString();
            day = c0.find(did);
            s = ' ';

            if (i === 0) {
                dow = dt2.getDay() - 1;
                if ((dow === j) || (dow === -1 && j === 6)) {
                    s = dt2.getDate().toString();
                }
            }
            else if (dt2.getMonth() === curr_mth) {
                s = dt2.getDate().toString();
            }

            if (!isStrEmpty(s) && calendar.isOutOfRange(opt, dt2)) {
                //8.Jul.16,lhw- hide the date that is out of range.
                dt2 = addDays(dt2, 1);
                // out of range-show blank text.
                s = ' ';
            }

            if (opt.wrapDayText) {
                //04-Apr-2021,lhw-wrap the day text with a DIV
                // so that the hosting object can update the UI easily.
                let s2 = `<div class="day_t0">${s}</div>`;

                if (opt.addDailyItemList) {
                    s2 += '<div class="flx-w day_il"></div>';
                }
                day.html(s2);
            }
            else {
                day.text(s);
            }

            // 20-jul-17,lhw-bug fixed.
            // if (sel_dt && sel_dt.getDate() === dt2.getDate()) { 
            if (sel_dt && dt_isEqual_date(sel_dt, dt2)) {
                // console.log('sel date', sel_dt, dt2);

                day.addClass('cal_sel_day');
            }
            // 20-jul-17,lhw-bug fixed.
            //else if (today && today.getDate() === dt2.getDate()) { 
            else if (today
                && dt_isEqual_date(today, dt2)
                //01-Jul-2022,lhw-bug fixed-if the date is out of range, skip this condition.
                && (s !== ' ')
            ) {
                day.addClass('cal_today today');
            }

            if (s !== ' ') {
                day.data('dt', dt2);
                dt2 = addDays(dt2, 1);
            }
            else {
                day.removeData('dt').addClass('cal_out_of_range').html('&nbsp;');
            }
        }
    }
};

//------------------------------------------------------------------------------
//8.Jul.16,lhw-
calendar.isOutOfRange = function (opt, dt) {
    return (opt.minDate && dt < opt.minDate) || (opt.maxDate && dt > opt.maxDate);
};

//------------------------------------------------------------------------------
//8.Jul.16,lhw-
calendar.periodIdx = function (dt) {
    return dt.getFullYear() * 100 + dt.getMonth();
};

//------------------------------------------------------------------------------
calendar.prevMonth = function (me) {
    var c0 = $(me);
    var dt = c0.data('curr_dt');

    if (!dt) {
        if (!c0.hasClass('cal_dlg_title')) {
            c0 = c0.closest('.cal_dlg_title');
        }
        c0 = c0.parent();
        dt = c0.data('curr_dt');
    }

    if (dt) {
        var opt = c0.data('option');
        calendar.playSound();

        if (opt.curr_mode && opt.curr_mode != 'd') {
            //09-Apr-2021,lhw-
            opt.curr_mode_dir = '-';
            calendar.refreshUI_ym(c0, opt.curr_mode);
        }
        else {
            dt = addMonths(dt, -1);

            //8.Jul.16,lhw-move the month if the date range is valid.
            if (!opt.minDate || (opt.minDate && calendar.periodIdx(dt) >= calendar.periodIdx(opt.minDate))) {
                calendar.refreshUI(c0, dt, opt);

                if (opt && opt.onMonthChange) {
                    opt.onMonthChange.call(c0,
                        {
                            c0: c0,
                            dt: dt
                        });
                }
            }
        }
    }
};

//------------------------------------------------------------------------------
calendar.nextMonth = function (me) {
    var c0 = $(me);
    var dt = c0.data('curr_dt');

    if (!dt) {
        if (!c0.hasClass('cal_dlg_title')) {
            c0 = c0.closest('.cal_dlg_title');
        }
        c0 = c0.parent();
        dt = c0.data('curr_dt');
    }

    if (dt) {
        var opt = c0.data('option');
        calendar.playSound();

        if (opt.curr_mode && opt.curr_mode != 'd') {
            //09-Apr-2021,lhw-
            opt.curr_mode_dir = null;
            calendar.refreshUI_ym(c0, opt.curr_mode);
        }
        else {
            dt = addMonths(dt, 1);

            //8.Jul.16,lhw-move the month if the date range is valid.
            if (!opt.maxDate || (opt.maxDate && calendar.periodIdx(dt) <= calendar.periodIdx(opt.maxDate))) {
                calendar.refreshUI(c0, dt, opt);

                if (opt && opt.onMonthChange) {
                    opt.onMonthChange.call(c0,
                        {
                            c0: c0,
                            dt: dt
                        });
                }
            }
        }
    }
};

//------------------------------------------------------------------------------
calendar.onYrTitleClick = function (me) {
    let c0 = $(me);
    calendar.refreshUI_ym(c0, 'y')
};

//-------------------------
calendar.onMthTitleClick = function (me) {
    let c0 = $(me);
    calendar.refreshUI_ym(c0, 'm')
};

//-------------------------
calendar.onYmClick = function (e) {
    let c2 = celUI.getContainer(e, '.cal_il_cell');
    let s2 = text_get_val(c2);
    let c0 = c2.closest('.cal_data').parent();
    let dt = c0.data('curr_dt');
    let opt = c0.data('option');

    if (isNumeric(s2)) {
        // yr
        s2 = toInt(s2);
        dt.setFullYear(s2);
    }
    else {
        s2 = monthIndex(s2);
        dt.setMonth(s2);
    }

    c0.data('curr_dt', dt);
    opt.curr_dt = dt;
    // console.log('curr_dt', dt);

    //-------------------------
    calendar.restoreDayCal(c0);
    calendar.refreshUI(c0, dt, opt);

    if (opt && opt.onMonthChange) {
        opt.onMonthChange.call(c0,
            {
                c0: c0,
                dt: dt
            });
    }
};

//-------------------------
calendar.restoreDayCal = function (c0) {
    if (!c0) {
        if (typeof me == 'undefined') {
            c0 = '#' + CAL_ID;
        }

        c0 = getJObject(c0);
    }

    c0.find('.cal_il').hide();
    c0.find('.cal_nav').show();
    c0.find('.cal_tb').show();

    let opt = c0.data('option');
    opt.curr_mode = 'd';
    opt.tmp_last_yr = null;
    opt.curr_mode_dir = null;
};

//-------------------------
calendar.refreshUI_ym = function (c0, ym) {
    let dt = c0.data('curr_dt');

    if (!dt) {
        if (!c0.hasClass('cal_dlg_title')) {
            c0 = c0.closest('.cal_dlg_title');
        }
        c0 = c0.parent();
        dt = c0.data('curr_dt');
    }

    let opt = c0.data('option');
    opt.curr_mode = ym;

    c0.find('.cal_tb').hide();
    let il = c0.find('.cal_il');

    if (il.length == 0) {
        let s = [];
        s.push('<div class="cal_il">');

        for (let r = 0; r < 4; r++) {
            s.push('<div class="flx-nw cal_il_r">');
            for (let c = 0; c < 3; c++) {
                s.push('<div class="cal_il_cell">');
                s.push('</div>');
            }
            s.push('</div>');
        }

        s.push('</div>');
        c0.find('.cal_data').append(s.join(''));

        c0.find('.cal_il').on('click', '.cal_il_cell', calendar.onYmClick);
    }
    else {
        il.show();
    }

    //-------------------------
    if (ym == 'y') {
        let yr;

        //15-Jun-2021,lhw-bug fixed-omitted to show it after mth has been clicked.
        c0.find('.cal_nav').show();

        if (!opt.tmp_last_yr) {
            yr = dt.getFullYear() - 4;
        }
        else {
            yr = opt.tmp_last_yr;
        }

        // back to prev period.
        if ((opt.curr_mode_dir || '') == '-') {
            yr -= 24;
        }

        // console.log('opt.curr_mode_dir=', opt.curr_mode_dir, ((opt.curr_mode_dir || '') == '-'), yr);

        il = c0.find('.cal_il .cal_il_r');
        for (let r = 0; r < il.length; r++) {
            let il2 = $(il[r]).find('.cal_il_cell');
            for (let c = 0; c < il2.length; c++) {
                $(il2[c]).text(yr.toString());

                yr++;
            }
        }

        opt.tmp_last_yr = yr;

    }
    else {
        let mth = 0;
        c0.find('.cal_nav').hide();

        il = c0.find('.cal_il .cal_il_r');
        for (let r = 0; r < il.length; r++) {
            let il2 = $(il[r]).find('.cal_il_cell');
            for (let c = 0; c < il2.length; c++) {
                $(il2[c]).text(celestial.mth[mth]);
                mth++;
            }
        }
    }
};




//------------------------------------------------------------------------------
//08-Apr-2021,lhw-
calendar.genTaskStat = function (o2, opt0) {
    let dt, dt2;

    if (typeof o2 == 'undefined'
        || o2 == null
        //03-Jul-2021,lhw-check null or undef which is more accurate.
        // || !obj_has_fld(o2, 'start_time')
        || typeof o2.start_time == 'undefined'
        || o2.start_time == null
    ) {
        return null;
    }

    let o3 = {};

    // process the data.
    o2.start_time = fmt_time_input(o2.start_time);

    // boundary checking
    if (opt0 && opt0.startTime && o2.start_time < fmt_time_input(opt0.startTime)) {
        //use the startTime for UI.
        let min_hr = fmt_time_input(opt0.startTime);
        o3.start_time2 = min_hr;
        o3.start_tz = toInt(min_hr.replace(':', '.'));
    }
    else {
        // follow the user start_time.
        o3.start_time2 = o2.start_time;
        o3.start_tz = toInt(o2.start_time.replace(':', '.'));
    }

    // convert the minutes to decimal.
    o3.start_minute = toInt(o2.start_time.substr(3, 3));

    if (obj_has_fld(o2, 'end_time')
        //03-Jul-2021,lhw-check null or undef which is more accurate.
        // && !obj_has_fld(o2, 'duration_hr')
        && (typeof o2.duration_hr == 'undefined' || o2.duration_hr == null)
    ) {
        dt = fromSysTime(o2.start_time);
        dt2 = fromSysTime(o2.end_time);
        o2.duration_hr = dateDiff.inMinutes(dt2, dt) / 60.0;

        // console.log('end_time=> ', fmt_time_input(dt2));
        o3.end_time = fmt_time_input(dt2);
    }
    else {

        if (
            //03-Jul-2021,lhw-check null or undef which is more accurate.
            // !obj_has_fld(o2, 'duration_hr') 
            (typeof o2.duration_hr == 'undefined' || o2.duration_hr == null)
            || (o2.duration_hr <= 0)
        ) {
            o2.duration_hr = 1;
        }

        dt = fromSysTime(o2.start_time);
        dt.setMinutes(dt.getMinutes() + o2.duration_hr * 60.0);

        o3.end_time = fmt_time_input(dt);
    }

    //-------------------------
    if (opt0 && opt0.showDurationInMinutes) {
        o3.duration_hr_proper = formatValue(o2.duration_hr * 60, 'm0') + 'M';
    }
    else {
        o3.duration_hr_proper = fmtDuration(o2.duration_hr);
    }

    return o3;
};


//==============================================================================
// static calendar
//04-Apr-2021,lhw-replacing celCalendar() class.
//==============================================================================

function celMonthView(po, opt0) {

    var def_opt = {
        // the month view container
        c0: null,

        // the parent of po.
        o0: null,

        // the first date of the current calendar.
        curr_dt: get_begin_of_month(new Date()),
        sel_dt: null,

        maxDate: null,
        minDate: null,

        // the time range (0 ~ 23)-for calc the task duration used.
        startTime: 0,
        endTime: 23,

        // if true, the duration will be shown in minutes. Otherwise it will be shown in hour.
        showDurationInMinutes: false,

        // If false, the hosting object will have to maintain the title bar themselves.
        // In this case, only the 'calendar' section will be build.
        // If true, both the title bar and calendar will be build.
        withTitleBar: true,

        // wrap the day text with DIV
        wrapDayText: true,

        // append an IL elem ('.day_il') for keeping the daily items.
        addDailyItemList: true,

        // on month value has been changed.
        // fn(c0,dt)
        onMonthChange: null,

        // on selected event.
        // fn({dt, c0, cell, target, orig_e})
        // where 
        //   dt - date
        //   c0 - the month view container.
        //   cell - the day cell.
        //   target - the elem that activated by click.
        //   orig_e - the click event object.
        onSelected: null,

        //03-Apr-2021,lhw-trigger upon completion of building the calendar
        // fn(c0)
        onInit: null,

        // this event will be fire when the user clicks on a task.
        // fn({c0, c2, task, orig_e})
        onTaskClick: null,

        // allows hosting object to do the task formatting rather than using the built-in handler.
        // fn(c2, o2, priv)
        // where 
        //   priv - the info calculated based on o2.
        onFmtTask: null,

        // fn(c2, o2, priv)
        onFmtTaskTooltip: null,

        // Perform filtering process upon adding new task.
        // fn(o2):bool
        onShouldShowTask: null

    };

    opt0 = $.extend(def_opt, opt0);

    // this is for calendar.xxx() to access the settings.
    opt0.c0.data('option', opt0);

    //------------------------------------------------------------------------------
    po.getContainer = function () {
        return opt0.c0;
    };

    //------------------------------------------------------------------------------
    po.refreshUI = function () {
        po.getContainer().data('sel_dt', opt0.sel_dt);

        opt0.on_select = po.fireOnSelect;
        calendar.refreshUI(po.getContainer(),
            (opt0.sel_dt !== null ? opt0.sel_dt : opt0.curr_dt),
            opt0);

    };


    //------------------------------------------------------------------------------
    //09-Dec-2021,lhw-clear the cal and reload the tasks
    po.refreshData = function () {
        po.refreshUI();
        po.fireOnMonthChange();
    };

    //------------------------------------------------------------------------------
    po.fireOnSelect = function (cell) {
        opt0.sel_dt = cell.dt;

        // trigger the 'onSelected' call back => on_dt_changed(dt_value, cell);             
        if (opt0.onSelected) {
            opt0.onSelected.call(po, cell);
        }
    };

    //------------------------------------------------------------------------------
    po.fireOnMonthChange = function () {

        if (opt0.onMonthChange) {
            opt0.onMonthChange({
                c0: po.getContainer(),
                dt: opt0.curr_dt
            });
        }

    };

    //------------------------------------------------------------------------------
    po.setDate = function (dt) {

        //23-May-2021,lhw-ensure that the input value is Date object.
        // opt0.curr_dt = dt;
        opt0.curr_dt = toDate(dt);
        opt0.sel_dt = toDate(dt);

        po.refreshUI();
    };

    //------------------------------------------------------------------------------
    po.getDate = function () {
        //23-May-2021,lhw-bug fixed-'curr_dt' is not 'sel_dt'.
        // if (opt0.curr_dt) {
        // return new Date(opt0.curr_dt.getTime());

        let dt = (opt0.sel_dt !== null ? opt0.sel_dt : opt0.curr_dt);
        if (dt) {
            return new Date(dt.getTime());
        }
        else {
            return null;
        }
    };

    //------------------------------------------------------------------------------
    po.setMinDate = function (dt) {
        opt0.minDate = dt;
        po.refreshUI();
    };

    po.getMinDate = function () {
        return opt0.minDate;
    };

    //------------------------------------------------------------------------------
    po.setMaxDate = function (dt) {
        opt0.maxDate = dt;
        po.refreshUI();
    };

    po.getMaxDate = function () {
        return opt0.maxDate;
    };

    //------------------------------------------------------------------------------
    po.setOption = function (p, v) {
        opt0[p] = v;
    };

    //------------------------------------------------------------------------------
    //03-Apr-2021,lhw-returns all active cells.
    po.getAll = function () {
        return po.getContainer().find('.cal_day_cell').not('.cal_out_of_range');
    };

    //------------------------------------------------------------------------------
    //04-Apr-2021,lhw-returns the item list container for the cell.
    po.getDailyItemList = function (cell) {
        if (cell) {
            return cell.find('.day_il');
        }
        else {
            return po.getContainer().find('.day_il');
        }
    };

    //------------------------------------------------------------------------------
    po.nextMonth = function () {
        po.clearData();
        calendar.nextMonth(po.getContainer());
    };

    po.nextPeriod = function () {
        po.nextMonth();
    };

    po.prevMonth = function () {
        po.clearData();
        calendar.prevMonth(po.getContainer());
    };

    po.prevPeriod = function () {
        po.prevMonth();
    };


    //------------------------------------------------------------------------------
    po.onTaskClick = function (e) {
        e.preventDefault();
        e.stopPropagation();

        let c2 = celUI.getContainer(e, 'cal_task');

        let e2 = {};

        // the container elem
        e2.c0 = po.getContainer();
        // the item that has been clicked
        e2.c2 = c2;
        // the task
        e2.data = c2.data('data');

        e2.orig_e = e;

        if (opt0.onTaskClick) {
            opt0.onTaskClick.call(po, e2);
        }
    };

    //------------------------------------------------------------------------------
    // o2={dt, start_time, duration_hr, text, css}
    // where 
    // - 'start_time' can be in the format of: 'HHMM', 'HH:MM', 'HH'.
    // - 'duration_hr' can be 'x.y' or 'x'.
    //------------------------------------------------------------------------------
    po.appendTask = function (o2) {

        o2.dt = toDate(o2.dt);

        if (calendar.isOutOfRange(opt0, o2.dt)) {
            return false;
        }

        //-------------------------
        // holds the internal values.
        let priv = calendar.genTaskStat(o2, opt0);

        //-------------------------
        // update ui
        let il = po.getAll();
        let c0 = $(il[o2.dt.getDate() - 1]);

        let c2 = $(`<div class="cal_task"></div>`);
        c2.data('data', o2);
        c2.addClass(o2.css);

        if (opt0.onFmtTask) {
            // runs the user defined task formatting process.
            obj_exec_proc(opt0, 'onFmtTask', [c2, o2, priv]);
        }
        else {
            // default handler for formatting the task.
            let s2 = [];
            s2.push(`<div class="cal_task_t1">${htmlEscape(o2.text)}</div>`);
            c2.html(s2.join(''));
        }

        if (opt0.onFmtTaskTooltip) {
            obj_exec_proc(opt0, 'onFmtTaskTooltip', [c2, o2, priv]);
        }

        //-------------------------
        let d2 = {
            o2: o2,
            priv: priv,
            c0: c0,
            c2: c2
        };

        // assign a unique id for deletion used.
        if (!o2.hasOwnProperty('_id')) {
            o2._id = po.last_id;
            po.last_id++;
        }

        // update mem
        let sdt = toSysDate(o2.dt);

        if (!po.data[sdt]) {
            po.data[sdt] = [];
        }

        po.data[sdt].push(d2);

        //-------------------------
        let b;
        if (opt0.onShouldShowTask) {
            b = obj_exec_proc(opt0, 'onShouldShowTask', [d2.o2]);

            if (!b) {
                d2.c2.hide();
            }
        }
        else {
            b = true;
        }

        if (b) {
            c0.find('.day_il').append(c2);
        }

        return true;
    };

    //------------------------------------------------------------------------------
    po.deleteTask = function (_id) {
        if (!po.data) {
            return;
        }

        // console.log('po.data-b4-del=', po.data);
        let k = Object.keys(po.data);
        let f = false;

        celLoop.each(k, function (k2) {
            let l2 = po.data[k2];

            if (l2) {
                celLoop.each(l2, function (d2, idx) {
                    if (d2.o2._id == _id) {
                        // delete from mem
                        l2.splice(idx, 1);

                        // delete from ui
                        d2.c2.remove();

                        f = true;
                        // exit loop
                        return false;
                    }
                });

                if (f) {
                    // exit loop
                    return false;
                }
            }
        });

    };


    //-------------------------
    // filter the task.
    // cb => fn(o2)
    po.filterTask = function (cb) {
        let b;
        let k = Object.keys(po.data);

        celLoop.each(k, function (k2) {
            let l2 = po.data[k2];

            if (l2) {
                celLoop.each(l2, function (d2) {
                    b = cb(d2.o2);
                    if (b) {
                        d2.c2.show();
                    }
                    else {
                        d2.c2.hide();
                    }
                });
            }
        });

    };


    //-------------------------
    po.clearData = function () {
        po.data = {};
        po.last_id = 90000;
    };

    //-------------------------
    po.destroy = function () {
        po.clearData();
        opt0 = null;
    };

    //-------------------------
    // init the object
    //-------------------------

    (() => {

        // for calc the task duration
        obj_set_val_if_oor(opt0, 'startTime', 0, 0, 23);
        obj_set_val_if_oor(opt0, 'endTime', 0, 0, 23);

        let c2 = $(calendar.buildCal(!opt0.withTitleBar));
        let c0 = po.getContainer();

        c0.html('').append(c2);
        po.clearData();

        if (opt0.withTitleBar) {
            // remove the inline js and attach the jquery event handler.
            c0.find('.cal_nav_prev').attr('onclick', null).on('click', po.prevMonth);
            c0.find('.cal_nav_next').attr('onclick', null).on('click', po.nextMonth);
        }

        c0.on('click', '.cal_task', po.onTaskClick);

        if (opt0.o0 && obj_has_fld(opt0.o0, 'destroyer')) {
            opt0.o0.destroyer.add(po);
        }

        po.refreshUI();

        setTimeout(() => {
            if (opt0.onInit) {
                obj_exec_proc(opt0, 'onInit', [c0]);
            }

            if (opt0.onMonthChange) {
                po.fireOnMonthChange();
            }
        }, 100);

    })();

}


//==============================================================================
//05-Apr-2021,lhw-
//==============================================================================

function celDayView(po, opt0) {

    var def_opt = {
        // the container
        c0: null,

        // the parent of po.
        o0: null,

        // the first date in the view.
        curr_dt: dateValue(new Date()),

        // validatity range
        maxDate: null,
        minDate: null,

        // the time range (0 ~ 23)
        startTime: 0,
        endTime: 23,

        // if true, 'now' line (for 'today') will not appear on the screen.
        hideNowLine: false,

        // # of days to be appear on the screen.
        dayCount: 7,

        // the format string for the header
        // NULL means this lib will handle.
        headerFmt: null,

        // if true, the day + month will be shown. Otherwise, only day will appear in the header.
        showMonthTextInHeader: true,

        // if true, the duration will be shown in minutes. Otherwise it will be shown in hour.
        showDurationInMinutes: false,

        // the col width for time column.
        timeColWidth: 80,

        // if true, the time will be formatted into 24 hours format.
        // Otherwise, it will be formatted into '9am' format.
        use24HoursFmt: false,

        // If false, the hosting object will have to maintain the title bar themselves.
        // In this case, only the 'calendar' section will be build.
        // If true, both the title bar and calendar will be build.
        withTitleBar: true,

        // Default is to follow the style defined in the css file.
        // In case, the color is user configurable, then, use this to change the line style.
        currHourLineStyle: null,



        // on month value has been changed.
        // fn(c0,dt)
        OnPeriodChange: null,

        // on selected event.
        // fn({dt, hour, c0, cell, orig_e})
        // where 
        //   c0 - the month view container.
        //   cell - the day cell.
        //   orig_e - the click event object.
        onSelected: null,

        // this event will be fire when the user clicks on a task.
        // fn({c0, c2, task, orig_e})
        onTaskClick: null,

        // allows hosting object to do the task formatting rather than using the built-in handler.
        // fn(c2, o2, priv)
        // where 
        //   priv - the info calculated based on o2.
        onFmtTask: null,

        // fn(c2, o2, priv)
        onFmtTaskTooltip: null,

        //03-Apr-2021,lhw-trigger upon completion of building the calendar.
        // NOTES: do NOT append the task immediately as Google Chrome will not get the correct elem height/width!!
        // fn(c0)
        onInit: null,

        // Perform filtering process upon adding new task.
        // fn(o2):bool
        onShouldShowTask: null

    };

    opt0 = $.extend(def_opt, opt0);

    //------------------------------------------------------------------------------
    po.getContainer = function () {
        return opt0.c0;
    };

    //------------------------------------------------------------------------------
    // returns the col headers.
    po.getColHeaders = function (dt2) {
        let l;

        if (opt0.col_headers) {
            l = opt0.col_headers;
        }
        else {
            l = [];
            let dt = dateValue(opt0.curr_dt);
            let s;

            for (let i = 0; i < opt0.dayCount; i++) {
                if (!opt0.headerFmt) {
                    s = '<div class="cal_day_header_0">' + formatDateValue(dt, 'DDD') + '</div><div class="cal_day_header_1">'
                        + (opt0.showMonthTextInHeader ? formatDateValue(dt, 'd.MMM') : dt.getDate().toString())
                        + '</div>';
                }
                else {
                    // user defined format.
                    s = formatDateValue(dt, opt0.headerFmt);
                }

                l.push({
                    idx: i,
                    dt: dt,
                    dt_str: s,
                    dow: dt.getDay()
                });

                dt = addDays(dt, 1);
            }

            //cache for reuse
            opt0.col_headers = l;
        }

        //-------------------------
        // If 'dt2' has been specified, returns the col object for the given dt2.
        // Otherwise, returns all col objects.
        if (typeof dt2 != 'undefined' && dt2 != null) {
            let t = dt2.getTime();

            return celLoop.findFirst(l, function (o3) {
                return o3.dt.getTime() == t;
            });
        }

        return l;
    };

    //------------------------------------------------------------------------------
    // returns the row headers
    po.getRowHeaders = function (tz) {
        let l;

        if (opt0.row_headers) {
            l = opt0.row_headers;
        }
        else {
            l = [];
            let s;

            for (let i = opt0.startTime; i <= opt0.endTime; i++) {

                s = i.toString();

                if (opt0.use24HoursFmt) {
                    if (s.length == 1) {
                        s = '0' + s;
                    }

                    s += ':00';
                }
                else {
                    if (i < 12) {
                        s = `<span class="cal_hr">${i}</span><span class="cal_hr_apm">am</span>`;
                    }
                    else if (i == 12) {
                        s = `<span class="cal_hr">12</span><span class="cal_hr_apm">pm</span>`;
                    }
                    else {
                        s = `<span class="cal_hr">${(i - 12)}</span><span class="cal_hr_apm">pm</span>`;
                    }
                }

                l.push({
                    idx: i,
                    hour: i,
                    time_str: s,
                });
            }

            //cache for reuse
            opt0.row_headers = l;
        }

        //-------------------------
        // if 'tz' param has been specified, return the row obj.
        // otherwise, returns all row obj.
        if (typeof tz != 'undefined' && tz != null) {
            return celLoop.findFirst(l, function (o3) {
                return o3.hour == tz;
            });
        }

        return l;
    };

    //------------------------------------------------------------------------------
    po.setDayCount = function (i) {
        if (i < 1) {
            i = 1;
        }

        opt0.dayCount = i;

        // reset internal cache
        opt0.col_headers = null;
    };

    //------------------------------------------------------------------------------
    po.setStartTime = function (i) {
        if (i < 0) {
            i = 0;
        }
        if (i > 23) {
            i = 23;
        }
        opt0.startTime = i;

        // reset internal cache
        opt0.row_headers = null;
    };

    //-------------------------
    po.setEndTime = function (i) {
        if (i < 0) {
            i = 0;
        }
        if (i > 23) {
            i = 23;
        }
        opt0.endTime = i;

        // reset internal cache
        opt0.row_headers = null;
    };



    //------------------------------------------------------------------------------
    po.buildCal = function () {
        let s = [];

        if (typeof opt0.withTitleBar == 'undefined' || opt0.withTitleBar == null || opt0.withTitleBar) {
            // this is optional for month view.
            s.push('<div class="cal_dlg_title flx-nw">');
            s.push('<div class="cal_title"></div>');
            s.push('<div class="flx-nw-rr cal_nav">');
            s.push('<div class="material-icons cal_nav_next"></div>');
            s.push('<div class="material-icons cal_nav_prev"></div>');
            s.push('</div>');
            s.push('</div>');
        }

        s.push('<div class="cal_data">');
        s.push('<table class="cal_tb" cellpadding="0" cellspacing="0">');
        s.push('<thead>');
        s.push('<tr class="cal_header_row">');

        // an empty header for time col.
        s.push('<th class="cal_time_col"><div class="cal_time_cell"></div></th>');

        const col_h = po.getColHeaders();
        for (let i = 0; i < col_h.length; i++) {
            s.push('<th class="cal_day_col"><div class="cal_day_header">');
            s.push(col_h[i].dt_str);
            s.push('</div></th>');
        }

        s.push('</tr>');
        s.push('</thead>');
        s.push('<tbody>');

        let row_h = po.getRowHeaders();
        let tz;
        for (let r = 0; r < row_h.length; r++) {
            s.push(`<tr class="cal_day_row cal_r${r}">`);

            tz = row_h[r].time_str;
            s.push(`<td class="cal_time_col"><div class="cal_time_cell day_r${r}">${tz}</div></td>`);

            for (let c = 0; c < col_h.length; c++) {
                s.push(`<td class="cal_day_col cal_cell day_r${r}_d${c}"></td>`);
            }
            s.push('</tr>');
        }

        s.push('</tbody>');
        s.push('</table>');
        s.push('</div>');

        //-------------------------
        let c2 = $(s.join(''));
        let c0 = po.getContainer();

        c0.html('').append(c2);
        c0.find('.cal_nav_prev').attr('onclick', null).on('click', po.prevPeriod);
        c0.find('.cal_nav_next').attr('onclick', null).on('click', po.nextPeriod);
        c0.on('click', '.cal_cell', po.onCellClick);
        c0.on('click', '.cal_task', po.onTaskClick);

        //-------------------------
        // get the ref for future used.
        for (let r = 0; r < row_h.length; r++) {
            row_h[r].c2 = c0.find(`.cal_r${r}`);
        }
    };

    //------------------------------------------------------------------------------
    po.refreshUI = function () {
        let c2;
        let c0 = po.getContainer();

        // delete the user tasks.
        c0.find('.cal_task').remove();

        // remove the weekday and weekend style.
        c0.find('.cal_wday_header').removeClass('cal_wday_header');
        c0.find('.cal_wend_header').removeClass('cal_wend_header');
        c0.find('.cal_wend').removeClass('cal_wend');
        c0.find('.cal_wday').removeClass('cal_wday');

        // update the header
        let hil = c0.find('.cal_header_row .cal_day_header');
        const col_h = po.getColHeaders();

        for (let i = 0; i < col_h.length; i++) {

            c2 = $(hil[i]);
            if (!col_h[i].c2) {
                col_h[i].c2 = c2;
            }

            c2.html(col_h[i].dt_str);
            if (col_h[i].dow == 0 || col_h[i].dow == 6) {
                c2.addClass('cal_wend_header');

                let c3 = c0.find('[class$="d' + i.toString() + '"]');
                c3.addClass('cal_wend');
            }
            else {
                c2.addClass('cal_wday_header');

                let c3 = c0.find('[class$="d' + i.toString() + '"]');
                c3.addClass('cal_wday');
            }
        }

    };

    //------------------------------------------------------------------------------
    //09-Dec-2021,lhw-
    po.refreshData = function () {
        po.refreshUI();
        po.fireOnPeriodChange();
    };

    //------------------------------------------------------------------------------
    po.fireOnPeriodChange = function () {
        po.showNow();

        if (opt0.onPeriodChange) {
            opt0.onPeriodChange({
                c0: po.getContainer(),
                dt: opt0.curr_dt
            });
        }

    };

    //------------------------------------------------------------------------------
    po.setDate = function (dt) {
        // opt0.curr_dt = dt;
        // po.refreshUI();

        opt0.col_headers = null;

        // set the new start date
        opt0.curr_dt = dt;
        po.clearData();

        po.refreshUI();
        po.fireOnPeriodChange();
    };

    //------------------------------------------------------------------------------
    po.getDate = function () {
        if (opt0.curr_dt) {
            return new Date(opt0.curr_dt.getTime());
        }
        else {
            return null;
        }
    };

    //------------------------------------------------------------------------------
    po.setMinDate = function (dt) {
        opt0.minDate = dt;
        po.refreshUI();
    };

    //-------------------------
    po.getMinDate = function () {
        return opt0.minDate;
    };

    //------------------------------------------------------------------------------
    po.setMaxDate = function (dt) {
        opt0.maxDate = dt;
        po.refreshUI();
    };

    //-------------------------
    po.getMaxDate = function () {
        return opt0.maxDate;
    };

    //------------------------------------------------------------------------------
    po.setOption = function (p, v) {
        opt0[p] = v;
    };

    //-------------------------
    po.getOption = function (p) {
        return opt0[p];
    };

    //------------------------------------------------------------------------------
    po.nextPeriod = function () {
        let dt2 = addDays(opt0.curr_dt, opt0.dayCount);

        if (!calendar.isOutOfRange(opt0, dt2)) {
            // reset internal cache
            opt0.col_headers = null;

            // set the new start date
            opt0.curr_dt = dt2;
            po.clearData();

            po.refreshUI();
            po.fireOnPeriodChange();
        }
    };

    po.prevPeriod = function () {
        let dt2 = addDays(opt0.curr_dt, -1 * opt0.dayCount);

        if (!calendar.isOutOfRange(opt0, dt2)) {
            // reset internal cache
            opt0.col_headers = null;

            // set the new start date
            opt0.curr_dt = dt2;
            po.clearData();

            po.refreshUI();
            po.fireOnPeriodChange();
        }
    };


    //------------------------------------------------------------------------------
    po.updateColWidth = function () {
        let c0 = po.getContainer();

        // skip updating the size if hidden.
        if (!c0.is(':visible')) {
            return;
        }

        let day_col = c0.find('.cal_header_row .cal_day_col');
        let w = Math.floor((c0.find('.cal_tb').width() - opt0.timeColWidth) * 1.0 / day_col.length);
        day_col.css('width', w.toString() + 'px');

        // for adding 'task' used.
        opt0.col_width = toInt(w);
        opt0.row_height = Math.ceil(c0.find('.day_r0_d0').outerHeight());
        opt0.row_height_minute = toDbl(opt0.row_height) / 60.0;

        // console.log('cal_tb .width', c0.find('.cal_tb').width());
        // console.log('opt0.timeColWidth', opt0.timeColWidth);
        // console.log('opt0.col_width', opt0.col_width);
        // console.log('opt0.row_height', opt0.row_height);
        // console.log('opt0.row_height_minute', opt0.row_height_minute);

        //-------------------------
        // resize/repos the tasks.
        po.updateAllTaskRect();

    };


    //------------------------------------------------------------------------------
    po.onCellClick = function (e) {
        let c2 = celUI.getContainer(e, 'cal_cell');
        let e2 = calendar.getCellIdx(c2.attr('class'));
        let col_h = po.getColHeaders();
        e2.dt = col_h[e2.d].dt;

        let row_h = po.getRowHeaders();
        e2.hour = row_h[e2.r].hour;

        // the container elem
        e2.c0 = po.getContainer();
        // the cell elem
        e2.cell = c2;

        e2.orig_e = e;

        if (opt0.onSelected) {
            opt0.onSelected.call(po, e2);
        }
    };

    //------------------------------------------------------------------------------
    po.onTaskClick = function (e) {
        e.preventDefault();
        e.stopPropagation();

        let c2 = celUI.getContainer(e, 'cal_task');

        let e2 = {};

        // the container elem
        e2.c0 = po.getContainer();
        // the item that has been clicked
        e2.c2 = c2;
        // the task
        e2.data = c2.data('data');

        e2.orig_e = e;

        if (opt0.onTaskClick) {
            opt0.onTaskClick.call(po, e2);
        }
    };

    //------------------------------------------------------------------------------
    // o2={dt, start_time, duration_hr, text, css}
    // where 
    // - 'start_time' can be in the format of: 'HHMM', 'HH:MM', 'HH'.
    // - 'duration_hr' can be 'x.y' or 'x'.
    //------------------------------------------------------------------------------
    po.appendTask = function (o2) {
        //reset the old data list.
        po.data0 = null;

        o2.dt = toDate(o2.dt);

        let dt2 = toSysDate(o2.dt);
        let c0 = po.getContainer();

        // looking for col.
        let col = po.getColHeaders(o2.dt);
        if (!col) {
            // console.log('o2.dt is out of range.. exit');
            return;
        }

        // holds the internal values.
        let priv = calendar.genTaskStat(o2, opt0);

        // looking for row.
        let row = po.getRowHeaders(priv.start_tz);

        if (!row) {
            // console.log('o2.start_time is out of range.. exit');
            return;
        }

        if (o2.duration_hr > 24) {
            // the UI is not capable to handle more than 24 hours.
            priv.duration_hr2 = 23 - priv.start_tz;
        }
        else {
            priv.duration_hr2 = o2.duration_hr;
        }

        // console.log('==> priv.duration_hr2 ',  priv.duration_hr2)

        // boundary checking
        let max_hr;
        if (opt0.endTime < 23) {
            max_hr = fmt_time_input(opt0.endTime + 1);
        }
        else {
            max_hr = 23;
        }

        if (priv.end_time > max_hr) {
            //recalc the 'duration_hr2' for UI.
            let h0 = fromSysTime(o2.start_time);
            let h1 = fromSysTime(max_hr);
            let diff_mn = dateDiff.inMinutes(h1, h0);

            priv.end_time = max_hr;
            priv.duration_hr2 = diff_mn / 60.0;

            // console.log('exceed max boundary, reset end_hr, priv=', priv, o2);
            // console.log('exceed max boundary, reset (end_time, max_hr, opt0.endTime)=', priv.end_time, max_hr, opt0.endTime);
        }

        // console.log('col', col);
        // console.log('row', row);
        // console.log('data', o2);
        // console.log('=> priv', priv);

        //-------------------------
        let c2 = $(`<div class="cal_task"></div>`);
        c2.data('data', o2);

        if (o2.css) {
            c2.addClass(o2.css);
        }

        if (opt0.onFmtTask) {
            // runs the user defined task formatting process.
            obj_exec_proc(opt0, 'onFmtTask', [c2, o2, priv]);
        }
        else {
            // default handler for formatting the task.
            let s2 = [];
            s2.push(`<div class="cal_task_t0">${o2.start_time} (${priv.duration_hr_proper})</div>`);
            s2.push(`<div class="cal_task_t1">${htmlEscape(o2.text)}</div>`);
            c2.html(s2.join(''));
        }

        if (opt0.onFmtTaskTooltip) {
            obj_exec_proc(opt0, 'onFmtTaskTooltip', [c2, o2, priv]);
        }

        let d2 = {
            o2: o2,
            priv: priv,
            c2: c2,
            col: col,
            row: row,
            slot_idx: 0
        };

        // assign a unique id for deletion used.
        if (!o2.hasOwnProperty('_id')) {
            o2._id = po.last_id;
            po.last_id++;
        }

        if (!po.data[dt2]) {
            po.data[dt2] = [];
        }

        //-------------------------
        appendData(d2);
        // console.log('po.data', po.data);

        // update ui
        c0.find('.cal_tb').append(c2);
        po.updateAllTaskRect(o2.dt);

        return d2;
    };

    //------------------------------------------------------------------------------
    function appendData(d2, l3) {

        //-------------------------
        let b;
        if (opt0.onShouldShowTask) {
            b = obj_exec_proc(opt0, 'onShouldShowTask', [d2.o2]);

            if (!b) {
                d2.c2.hide();
            }
        }
        else {
            b = true;
        }

        // console.log('appendData => onShouldShowTask()=> ', b)

        //-------------------------
        let sdt = toSysDate(d2.o2.dt);

        if (!l3) {
            l3 = po.data[sdt];
        }

        // this is the first task, skip build the conflict table.
        if (!l3) {
            // append the first item.
            if (!po.data[sdt]) {
                po.data[sdt] = [];
            }

            po.data[sdt].push(d2);
            return;
        }

        if (b) {
            celLoop.each(l3, function (d3) {

                if (!d3.c2.is(':visible')) {
                    return;
                }

                if (!((d2.priv.end_time <= d3.o2.start_time)
                    || (d3.priv.end_time <= d2.o2.start_time))
                ) {
                    // has conflict
                    if (!d3.priv.conf) {
                        d3.priv.conf = [];
                        d3.priv.conf.push(d3.o2._id);
                    }

                    if (!d2.priv.conf) {
                        // d2.slot_idx = arrLen(d3.priv.conf);
                        d2.priv.conf = [d2.o2._id];

                        // copy all conflicts from the neighbor.
                        celLoop.each(d3.priv.conf, function (d30) {

                            // d2.priv.conf.push(d30);

                            //07-Jun-2021,lhw-
                            if (isConfWithID(l3, d30, d2)) {
                                d2.priv.conf.push(d30);
                            }

                        });

                        d2.slot_idx = arrLen(d2.priv.conf) - 1;
                    }

                    d3.priv.conf.push(d2.o2._id);
                }
            });

        }

        // append to mem 
        l3.push(d2);
        // console.log(l3)
    }

    //07-Jun-2021,lhw-
    function isConfWithID(l3, id, d2) {
        let d3 = arrFindFirst(l3, function (o3) {
            return (o3.o2._id == id);
        });

        if (d3) {

            if (!((d2.priv.end_time <= d3.o2.start_time)
                || (d3.priv.end_time <= d2.o2.start_time))
            ) {
                return true;
            }
        }

        return false;
    }

    //------------------------------------------------------------------------------
    // reindex task in the day column.
    function reindex(dt, filter_cb) {

        function _reind(sdt) {
            let l2 = po.data[sdt];
            let l3 = [];

            celLoop.each(l2, function (d2) {
                // reset the old ref
                d2.priv.conf = null;
                d2.slot_idx = 0;

                // copy the task to temp store
                l3.push(d2);
            });

            // reset the list
            po.data[sdt] = [];
            l2 = po.data[sdt];

            let b = true;
            celLoop.each(l3, function (d2) {
                if (filter_cb) {
                    b = filter_cb(d2.o2);
                    // console.log('filter_cb=', d2.o2._id, b);

                    if (b) {
                        d2.c2.show();
                    }
                    else {
                        d2.c2.hide();
                    }
                }

                if (b) {
                    appendData(d2, l2);
                }
            });
        }

        if (dt) {
            // reindex the given date
            _reind(toSysDate(dt));
        }
        else {
            // reindex all dates.
            let k = Object.keys(po.data);
            celLoop.each(k, function (k2) {
                _reind(k2);
            });
        }
    }

    //------------------------------------------------------------------------------
    function copyTask(l0) {
        let l3 = {};
        let k = Object.keys(l0);

        celLoop.each(k, function (k2) {
            let l2 = l0[k2];
            l3[k2] = [];
            celLoop.each(l2, function (d2) {
                l3[k2].push(d2);
            });
        });

        return l3;
    }

    //-------------------------
    // filter the task.
    // cb => fn(o2)
    po.filterTask = function (cb) {
        if (po.data0 == null) {
            // keep the original data list.
            po.data0 = copyTask(po.data);
        }
        else {
            po.data = copyTask(po.data0);
        }

        reindex(null, cb);
        po.updateAllTaskRect();
    };

    //-------------------------
    po.updateAllTaskRect = function (dt) {
        // console.log('updateAllTaskRect,dt=', dt);

        if (!po.data) {
            return;
        }

        // get the runtime value once
        let left0 = po.getContainer().offset().left;
        let sdt = toSysDate(dt);

        function _update(k2) {
            let l2 = po.data[k2];

            //<<==========
            // 07-Jun-2021,lhw-determine the # of col for 'slot_idx=0'.
            // This is because conf_cnt is not same as the col count.
            celLoop.each(l2, function (o3) {
                if (o3.slot_idx == 0) {
                    let cfl = o3.priv.conf;
                    o3.col_cnt = 0;

                    celLoop.each(cfl, function (cfl2) {
                        if (cfl2 == o3.o2._id) {
                            return;
                        }

                        // get the item
                        // check the priv.conf.length
                        let d4 = arrFindFirst(l2, function (o4) {
                            return (o4.o2._id == cfl2);
                        });

                        o3.col_cnt = Math.max(o3.col_cnt, arrLen(d4.priv.conf));
                    });
                }
            });
            //<<==========


            celLoop.each(l2, function (d2) {
                po.updateTaskRect(d2, left0);
            });
        }

        if (dt && po.data[sdt]) {
            // update one column
            _update(sdt);
        }
        else {
            // update all task rect.
            let k = Object.keys(po.data);

            celLoop.each(k, function (k2) {
                _update(k2);
            });
        }

        // this will update the current hour line elem (if it exists).
        po.showCurrHour();
    };

    //-------------------------
    po.updateTaskRect = function (d2, left0) {
        if (!left0) {
            left0 = po.getContainer().offset().left;
        }

        let w2 = 0;

        let conf_cnt = arrLen(d2.priv.conf);
        if (conf_cnt > 0) {
            w2 = Math.floor(opt0.col_width / conf_cnt * d2.slot_idx) - 1;
        }
        else {
            // to avoid div by zero.
            conf_cnt = 1;
        }

        if (d2.slot_idx == 0 && d2.col_cnt > 0) {
            //07-Jun-2021,lhw-
            conf_cnt = d2.col_cnt;
        }

        // console.log('d2.slot_idx=', d2.slot_idx, 'conf_cnt=', conf_cnt, 'w2=', w2);

        let r = {
            height: d2.priv.duration_hr2 * 60.0 * opt0.row_height_minute,
            width: ((opt0.col_width - 3) / conf_cnt),
            left: d2.col.c2.offset().left - left0 + w2,
            top: d2.row.c2.position().top + (d2.priv.start_minute * opt0.row_height_minute)
        };

        // update the ui
        d2.c2.css(r);
    };

    //------------------------------------------------------------------------------
    po.deleteTask = function (_id) {
        if (!po.data) {
            return;
        }

        po.data0 = null;

        // console.log('po.data-b4-del=', po.data);
        let k = Object.keys(po.data);
        let dt;
        let f = false;

        celLoop.each(k, function (k2) {
            let l2 = po.data[k2];

            if (l2) {
                celLoop.each(l2, function (d2, idx) {
                    if (d2.o2._id == _id) {
                        // get the date for later used.
                        dt = d2.o2.dt;

                        // delete from mem
                        l2.splice(idx, 1);

                        // delete from ui
                        d2.c2.remove();

                        f = true;
                        // exit loop
                        return false;
                    }
                });

                if (f) {
                    // exit loop
                    return false;
                }
            }
        });

        if (f) {
            // reindex the task
            reindex(dt);
        };

        // console.log('po.data-aft-del=', po.data);
        // console.log('deleteTask, dt=', dt);

        //-------------------------
        if (dt) {
            po.updateAllTaskRect(dt);
        }
    };



    //------------------------------------------------------------------------------
    po.timer = null;

    po.resetNowTimer = function (skip_rm_line) {
        if (po.timer) {
            clearTimeout(po.timer);
            po.timer = null;
        }

        if (!skip_rm_line) {
            po.getContainer().find('.cal_now').remove();
        }
    };

    //------------------------------------------------------------------------------
    po.showNow = function () {
        // console.log('show now')

        if (!opt0) {
            return;
        }

        if (opt0.hideNowLine) {
            return;
        }

        let today = dateValue(new Date());
        let min_dt = opt0.curr_dt;
        let max_dt = addDays(min_dt, opt0.dayCount);

        // do it for 'today' only.
        if (today.getTime() >= min_dt.getTime()
            && today.getTime() <= max_dt.getTime()
        ) {
            po.showCurrHour();
        }
        else {
            po.resetNowTimer();
        }
    };

    //------------------------------------------------------------------------------
    po.showCurrHour = function () {
        let now = new Date();
        let curr_tz = now.getHours();

        let col = po.getColHeaders(dateValue(now));
        if (!col) {
            // console.log('o2.dt is out of range.. exit');
            return;
        }
        // console.log('col', col)

        let row = po.getRowHeaders(curr_tz);
        if (!row) {
            return;
        }

        let c0 = po.getContainer();
        let line = c0.find('.cal_now');

        if (line.length == 0) {
            line = $('<div class="cal_now">&nbsp;</div>');
            c0.find('.cal_tb').append(line);
            line = c0.find('.cal_now');
        }

        // Always update rect due to the following:
        // 1. current hour value changed 
        // 2. window resizing or 
        // 3. period changed.
        let t = row.c2.position().top + (now.getMinutes() * opt0.row_height_minute);
        line.css({
            top: t,
            left: col.c2.offset().left - c0.offset().left,
            width: col.c2.width()
        });

        if (opt0.currHourLineStyle && typeof opt0.currHourLineStyle == 'object') {
            line.css(currHourLineStyle);
        }

        //-------------------------
        // scroll top for '.cal_data'
        let ch = c0.find('.cal_data').height();
        if (t > ch * .8) {
            t = t + (opt0.row_height_minute * 120) - (ch * .8);
            c0.find('.cal_data').scrollTop(t);
        }

        //-------------------------
        // reset the existing timer and don't remove the line elem.
        po.resetNowTimer(true);

        // sch/recreate for next update after 5 minutes.
        po.timer = setTimeout(() => {
            po.showCurrHour();
        }, 5 * 60000);

    };



    //-------------------------
    po.clearData = function () {
        po.data = {};
        po.data0 = null;
        po.last_id = 90000;
    };

    //-------------------------
    po.destroy = function () {
        $(window).off('resize', po.updateColWidth);
        po.resetNowTimer();
        po.clearData();
        opt0 = null;
    };


    //------------------------------------------------------------------------------
    // init the object
    //------------------------------------------------------------------------------

    (() => {

        obj_set_val_if_oor(opt0, 'startTime', 0, 0, 23);
        obj_set_val_if_oor(opt0, 'endTime', 0, 0, 23);

        // update & check the setting
        po.setDayCount(opt0.dayCount);

        po.buildCal();
        po.clearData();
        po.refreshUI();

        // attach the window resize event 
        $(window).on('resize', po.updateColWidth);

        if (opt0.o0 && obj_has_fld(opt0.o0, 'destroyer')) {
            opt0.o0.destroyer.add(po);
        }

        setTimeout(() => {
            // resize the col for the first time
            po.updateColWidth();

            if (opt0.onInit) {
                obj_exec_proc(opt0, 'onInit', [po.getContainer()]);
            }

            if (opt0.onPeriodChange) {
                po.fireOnPeriodChange();
            }
        }, 100);


    })();

}


//==============================================================================
// date picker
//==============================================================================

(function ($) {
    const BLK = 'celcalblk';
    const CLS = 'celDatePicker';

    var methods = {

        init: function (option) {

            var def_opt = {
                curr_dt: get_begin_of_month(new Date()),
                sel_dt: null,
                maxDate: null,
                minDate: null,
                format: 'D.MMM.YYYY',

                popup: null,
                disable_hide_option: false,
                template_code: 'cal',
                within: false,

                //1.Sep.18,lhw-
                //25-Apr-2021,lhw-revised the default value
                // block_on_show: true,
                block_on_show: false,

                use_effect: true,

                //25-Apr-2021,lhw-revised the default value
                // show_on_focus: true,
                show_on_focus: false,


                disable: false,

                onSelected: null,
                imgBtn: null
            };

            option = $.extend(def_opt, option);
            var self = this;

            self.each(function () {
                var cc = $(this);

                // already init. exit.
                if (cc.hasClass(CLS)) {
                    return;
                }

                var opt = $.extend({}, option);
                cc.addClass(CLS);
                cc.data('option', opt);

                var s = text_get_val(cc);

                if (!isStrEmpty(s)) {
                    //05-Apr-2021,lhw-
                    // opt.sel_dt = moment(s, option.format).toDate();
                    opt.sel_dt = parseDateStr(s);
                }

                methods.setImgBtn.call(cc, opt.imgBtn);
            });

            if (option.show_on_focus) {
                //18-Apr-2021,lhw-prevent double attach
                // self.on('focus', methods.show);
                self.off('focus', methods.show).on('focus', methods.show);
            }

            //18-Apr-2021,lhw-prevent double attach
            // self.on('blur', methods.on_blur);
            self.off('blur', methods.on_blur).on('blur', methods.on_blur);

            return self;
        },

        refreshUI: function (c, opt) {
            c.data('sel_dt', opt.sel_dt);

            //03-Apr-2021,lhw-
            opt.on_select = methods.on_select;

            calendar.refreshUI(c,
                (opt.sel_dt !== null ? opt.sel_dt : opt.curr_dt),
                opt);
        },

        show: function (e) {
            var c, self, opt, id;

            if (e && e.target) {
                c = $(e.target);
            }
            else {
                c = $(this);
            }

            self = c;
            opt = c.data('option');
            id = '#' + CAL_ID;
            calendar.curr_ctl = c;

            calendar.loadForm(id,
                function () {
                    calendar.popup = getJObject(id);
                    var c2 = calendar.popup;

                    //04-Apr-2021,lhw-attach the setting for nextMonth/prevMonth to pickup.
                    c2.data('option', opt);

                    methods.refreshUI.call(self, c2, opt);

                    //13.Nov.17,lhw-create a special layer for the calendar
                    if (opt.block_on_show) {
                        var blk = progress.getNewLayer(BLK);
                        blk.show();
                        blk.off().on('click', function () {
                            methods.hide.call(self);
                        });
                    }
                    else {
                        $(document).off('click', methods.hideOnDocClick)
                            .on('click', { me: self }, methods.hideOnDocClick);
                    }

                    //30.Nov.18,lhw-reduce the duration to 100.
                    //show_popup(c, calendar.popup, null, null, false, null, true, opt.use_effect);
                    show_popup(c, calendar.popup, null, calendar.animate_duration, false, null, true, opt.use_effect);

                    if (opt.disable_hide_option) {
                        calendar.disableHideOption(self);
                    }

                    //13-Jul-2022,lhw-handle the touch based device
                    c2.off('mouseenter touchstart').on('mouseenter touchstart', function (e) { opt.within = true; });
                    c2.off('mouseleave').on('mouseleave', function (e) { opt.within = false; });
                    c2.off('mousedown').on('mousedown', function (e) { e.preventDefault(); });

                },
                null, opt.template_code);

            return false;
        },

        hideOnDocClick: function (e) {
            var c, opt, c2;

            c = e.data.me;
            opt = c.data('option');

            //3.Nov.18,lhw-lost contact with the ui.
            if (!opt) {
                calendar.hide(null, false);

                $(document).off('click', methods.hideOnDocClick);
                return;
            }

            // if the target is image btn, skip.
            c2 = $(e.target);
            if (c2.is(opt.imgBtn) || opt.within) {
                return;
            }

            methods.hide.call(c);
            $(document).off('click', methods.hideOnDocClick);

            //09-Apr-2021,lhw-do it after the elem has disappeared from the screen.
            setTimeout(() => {
                calendar.restoreDayCal();
            }, 50);

        },

        hide: function () {
            var opt = this.data('option');

            if (calendar.popup) {
                if (!opt.use_effect) {
                    calendar.popup.hide();
                }
                else {
                    //30.Nov.18,lhw-
                    ////calendar.popup.slideUp('fast');
                    calendar.popup.slideUp(calendar.animate_duration);
                }

                calendar.curr_ctl = null;

                if (opt.block_on_show) {
                    progress.getNewLayer(BLK).hide();
                }
            }
        },

        on_blur: function (e) {
            var c = getJObject(e.target);
            var opt = c.data('option');

            if (typeof dt_auto_fill === 'function') {
                //04-Apr-2021,lhw-save the orig value for later used.
                let s0 = text_get_val(c);

                //18-Apr-2021,lhw-bug fixed-dt_auto_fill() will trigger onSelected event
                // before the min/max range checking. This will crash the normal flow.
                // Instead, the onSelected event should be trigger manually (within on_blur) after
                // checking the min/max range.
                if (!e.data) {
                    e.data = {};
                }
                e.data.skip_trigger_cb = true;

                dt_auto_fill(e);

                var v = dt_get_val(c);

                if (opt && v) {
                    //8.Jul.16,lhw- ensure that the input value is within the range.
                    if (opt.minDate && v < opt.minDate) {
                        v = opt.minDate;
                        dt_set_val(c, opt.minDate);
                    }
                    else if (opt.maxDate && v > opt.maxDate) {
                        v = opt.maxDate;
                        dt_set_val(c, opt.maxDate);
                    }
                }

                //3.Oct.19,lhw-raise the onSelected event
                if (opt && opt.onSelected) {
                    //04-Apr-2021,lhw-trigger the onSelected event only if the value has been changed.
                    let s2 = text_get_val(c);

                    if (s0 != s2) {
                        //04-Apr-2021,lhw-bug fixed
                        // opt.onSelected.call(e);
                        opt.onSelected.call(this, v);
                    }
                }

            }

            if (opt && opt.within) {
                return;
            }

            //hide on clicking outside of the calendar.
            ////  methods.hide();
        },

        on_select: function (cell) {
            methods.setDate.call(this, cell.dt);

            // trigger the 'onSelected' call back => on_dt_changed(dt_value, cell); 
            var opt = this.data('option');

            if (opt.onSelected) {
                opt.onSelected.call(this, cell.dt, cell);
            }

            methods.hide.call(this);
        },

        //26.Aug.16,lhw-manually trigger the onSelected event. This proc will be called by dt_auto_fill().
        triggerOnSelected: function () {
            var opt = this.data('option');
            if (opt.onSelected) {
                opt.onSelected.call(this);
            }
        },

        setDate: function (dt) {
            var opt = this.data('option');
            opt.sel_dt = dt;

            //23-Jul-2021,lhw-remove the dependency of calling text_set_val()
            // which might caught in too many recursive calls.
            // if (dt) {
            //     //05-Apr-2021,lhw-
            //     // text_set_val(this, moment(dt).format(opt.format));
            //     text_set_val(this, formatDateValue(dt, opt.format));
            // }
            // else {
            //     text_set_val(this, '');
            // }

            let s2;
            if (dt) {
                s2 = formatDateValue(dt, opt.format);
            }
            else {
                s2 = '';
            }

            if (this.is('input')) {
                this.val(s2);
            }
            else {
                this.text(s2);
            }
        },

        getDate: function () {
            var opt = this.data('option');

            //24.Sep.18,lhw-
            ////return opt.sel_dt;
            if (opt.sel_dt) {
                return new Date(opt.sel_dt.getTime());
            }
            else {
                return null;
            }
        },

        setMinDate: function (dt) {
            var opt = this.data('option');
            opt.minDate = dt;

            if (calendar.popup) {
                var c2 = calendar.popup;
                if (c2.is(':visible')) {
                    methods.refreshUI.call($(this), c2, opt);
                }
            }
        },

        getMinDate: function (dt) {
            var opt = this.data('option');
            return opt.minDate;
        },

        setMaxDate: function (dt) {
            var opt = this.data('option');
            opt.maxDate = dt;

            if (calendar.popup) {
                var c2 = calendar.popup;
                if (c2.is(':visible')) {
                    methods.refreshUI.call($(this), c2, opt);
                }
            }
        },

        getMaxDate: function (dt) {
            var opt = this.data('option');
            return opt.maxDate;
        },

        option: function (p, v) {
            var opt = this.data('option');
            opt[p] = v;

            if (!opt.show_on_focus) {
                //1.Sep.18,lhw-
                this.off('focus', methods.show);
            }

        },

        setImgBtn: function (imgBtn) {
            // 21-oct-17,lhw-
            var self = this;
            var opt = this.data('option');
            opt.imgBtn = imgBtn;

            if (!opt.imgBtn) {
                //26-Apr-2021,lhw-look for the select date img button
                let c2 = self.next();
                if (c2.hasClass('material-icons')) {
                    opt.imgBtn = c2;
                }
            }

            if (opt.imgBtn != null) {

                // 21-oct-17,lhw-show/hide the calendar upon clicking on the image button.
                //18-Apr-2021,lhw-opt.imgBtn must be jquery object.
                // getJObject(opt.imgBtn).on('click', function () {
                //     //7.Nov.18,lhw-
                //     if (opt.disable) {
                //         return;
                //     }

                //     if ($('#' + CAL_ID).is(':visible')) {
                //         methods.hide.call(self);
                //     }
                //     else {
                //         methods.show.call(self);
                //     }
                // });

                function datepicker_on_click() {
                    //7.Nov.18,lhw-
                    if (opt.disable) {
                        return;
                    }

                    //31-Jan-2023,lhw-
                    calendar.playSound();

                    if ($('#' + CAL_ID).is(':visible')) {
                        methods.hide.call(self);
                    }
                    else {
                        methods.show.call(self);
                    }
                }

                //18-Apr-2021,lhw-we must disable the earlier handler before re-attaching.
                // This will prevent attaching twice.
                opt.imgBtn.off('click', datepicker_on_click).on('click', datepicker_on_click);

            }
            else {
                // getJObject(opt.imgBtn).off('click');
                //18-Apr-2021,lhw-opt.imgBtn must be jquery object
                //25-Apr-2021,lhw-bug fixed-if the img button has not been specified, the following line will crash.
                // opt.imgBtn.off('click');
            }

            return self;
        }

    };

    $.fn.celDatePicker = function (method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method === 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Method ' + method + ' does not exist on jQuery.celDatePicker');
        }
    };

    //15-Jun-2021,lhw-preload the date picker so that showing it will not affect the vertical scrollbar.
    setTimeout(() => {
        calendar.preloadForm();
    }, 1000);


})(jQuery);

