﻿/*==============================================================================
//@@
18.Aug.18,lhw
-this class INJECTS the default data procs to the po to handle the data to ui and vice versa.

NOTES:
- the proc name in this class will be used in celDetailForm & celMasterDetailForm!!

 Sample code:

    // the parent object
    function prod_cat(){}

    // inject the data proc
    celDataProc(prod_cat,
    {
        c0: prod_cat.getContainer(),
        fld: {
            prod_cat_desc: {c2: 'prod-cat-desc-input', compulsoryMsg: 'Description cannot be blank'},
            is_in_use: {c2: 'is-in-use-input', ct:CTL_TYPE_CHECKBOX},
            modified_on: { ct: CTL_TYPE_DATE, ic2: 'modified-on', fmt: 'dt2' },
            no_of_adult: { c2: 'no-of-adult-input', fmt: 'm0' },
            amt: { c2: 'amt', fmt: 'm2', skipSave: true },
        },
        inject_common_fn: true,
    });

    prod_cat.initInput(c0);

19-Nov-2020,lhw-new shortcut to do the job.

    //show the data
    let o2 = mailLog.getTmpData();
    // console.log(o2);

    let s2 = o2.sent_status_desc;
    if (o2.sent_on) {
        s2 += ' - ' + formatValue(toDate(o2.sent_on), 'dt');
    }

    let f_map = {
        fld: {
            email: { c2: 'email', cm:'Email address cannot be blank' },
            sent_status_desc: { c2: 'sent-status', get_val: (o0,f0) => { return s2; } },
            created_on: { c2: 'created-on', fmt: 'dt' },
            subject: { c2: 'subject' },
            body_text: { c2: 'body-text', ct: CTL_TYPE_HTML }
        }
    };

    celDataProc.process(f_map, pp, o2);



==============================================================================*/

function celDataProc(po, opt) {
    var def_opt;

    def_opt = {

        //10-Aug-2023,lhw-optional. If set, it replaces 'entryObj' param in all procs in this lib.
        c0: null,

        //-------------------------------
        // 'fld' is an object that contains all the fields settings.
        //  It can be a nested object property => 'contact_settings.biz_reg_no1'.
        //
        // 'dataType' => special case: 'guid' (or 'id'), 'email'.
        //  => 't' or 'time'
        //  => 'curr' - currency (fmt=m2), CTL_TYPE_MONEY.
        //-------------------------------
        fld: {
            // - Common settings:
            //      (ctlCls OR c2) - compulsory.
            //      [ctlType OR ct] - the control type (select, date picker, checkbox).
            //      [(dataType OR dt)] - the data type of the value. Either this or 'ctlType' must be set.
            //      [(itemCtlCls OR ic2)] - for displaying the value in a data listing item (read-only).
            //      [fmt] - the format string
            //
            //      [nullVal] - if the user did not key in any value, this value will be set.
            //      [get_val:function(o0,f0)] - reads & processes the value and return to this lib.
            //      [fmt_val:function(o0)] -09-Dec-2022,lhw-for onFmtItem() to get the translated text.
            //      [show_input:function(c2, o0, v0)] - manually format the value and then show on the ui.
            //      [show_value]:function(c2, o0, v0) - same as `show_input`.
            //
            //      [init_input:function(c2,entryObj)] - manually init the current input field.
            //      [chk_lbl] - the label obj for checkbox.
            //      [imgBtn] - the image button for datepicker.
            //      [negative OR neg]:bool - for init currency field.
            //
            //      [item_list] - 08-Aug-2023,lhw-the item list for checkbox list & radiobutton list. struct: [{id,text}, ..].
            //      [item_list_opt] - 08-Aug-2023,lhw-struct:{id_fld, text_fld}. Used in conjunction with the above.
            //
            // - trigger on saving user input.
            //      [skipSave] - if true, skip submitting to the server.
            //      [save_val:function(c2, f2):any] - returning the user input after it has been translated/computed.
            //      [save_val2:function(c2, o0):void] - 25-Jan-2023,lhw-for saving multiple fields.
            //      [readonly]:bool - if true, indicates that the field is read-only.
            //
            // - input restriction/validation:
            //      [text] - the display text for input validation.
            //      [compulsoryMsg OR cm] - if set, the input is compulsory.
            //      [nullable] - use in conjunction with `text`. If true while `cm` is missing, celDataFieldHandler will handle it.
            //      [defVal] - default value to be used on resetting the input. Refers to `celDataProc.genDefaultValue()` for the supported options.
            //      [minLen] - for text input.
            //      [maxLen] - for text input or limit the number of digits for numeric input.
            //      [min] - minimum value for numeric input.
            //      [max] - maximum value for numeric input.

        },

        // default is formatting the user date input in sys format.
        //01-Apr-2021,lhw-
        // fmtDateInSysFmt: true,
        fmtDateInSysFmt: false,

        // the text to be shown on the screen in case of null value.
        nullValDisplayText: '-',

        //if true, the hosting object must provide the custom item formatting in onFmtItem2().
        manualFmtItem: false,

        //if true, the hosting object will populate the data (in entryObj) manually.
        manualSelItem: false,

        //19-Nov-2020,lhw-
        treatItemCtlClsSameAsCtlCls: null,

        //07-Dec-2022,lhw-if true, inject: resetInput(c0), validateInput(c0,o2), getInput(c0,o2), showData(c0,o2), fmtItem(c0,o2).
        inject_common_fn: false,

        //-------------------------------
        // pre-validation process.
        // param: entryObj, p
        onValidateInput20: null,

        // custom validation.
        // param: entryObj, p
        onValidateInput2: null,

        // save the data from ui
        // param: entryObj, o
        onGetUserInput2: null,

        // populate the data to ui
        // param: entryObj, o
        // return 'false'=to indicate stop the reset of the process.
        onSelItem2: null,

        // clear the entry form.
        // param: entryObj
        onNewItemClick2: null,

        // format an item for the item list. This is not for data entry.
        // param: function(c20, o20)
        onFmtItem2: null,

        //01-Apr-2021,lhw-for init the input fields.
        // param: entryObj
        onInitInput2: null


    };

    opt = $.extend(def_opt, opt);

    //13-Aug-2023,lhw-
    po.getType = function() { return 'celDataProc'; };

    //<<==========
    //19-Nov-2020,lhw-validate opt.fld
    celLoop.each(Object.keys(opt.fld), function (f20) {
        let f2 = opt.fld[f20];

        if (!f2._isProxy) {
            opt.fld[f20] = new Proxy(f2, celDataFieldHandler);
        }

        // if itemCtlCls is missing, make it same as the ctlCls.
        if (opt.treatItemCtlClsSameAsCtlCls) {
            if (typeof f2.itemCtlCls == 'undefined' || f2.itemCtlCls == null) {
                f2.itemCtlCls = f2.ctlCls;
            }
        }

        //11-Aug-2023,lhw-set the input field name that will ease the data sharing
        // for function call.
        f2.f = f20;
    });
    // console.log(opt.fld);
    //<<==========


    /**
     * 10-Aug-2023,lhw-returns the default container if it has been set to `opt.c0`.
     * Otherwise, returns the entryObj.
     * @param {object} [entryObj] - this is the container or incoming param.
     * @param {Object} [p2] - the incoming param (which could appear in `entryObj` if `opt.c0` has been set).
     * @returns {Object} - struct: {c0, p2}.
     */
    function get_container(entryObj, p2) {
        if (!isJQueryObject(entryObj) && opt.c0) {
            return {
                // the container
                c0: opt.c0,
                // this is the incoming param
                p2: entryObj
            };
        }

        return {
            // the container
            c0: entryObj,
            // this is the incoming param
            p2: p2
        };
    };


    /**
     * 07-Aug-2023,lhw-get the input element for the given field.
     * @param {object} entryObj - the container.
     * @param {String} fld
     * @returns {Object} - returns the input element (jQuery type).
     */
    po.getEditingInput = function(entryObj, fld) {
        const ctx = get_container(entryObj, fld);
        fld = ctx.p2;

        if (!opt.fld[fld]) {
            return null;
        }

        return ctx.c0.find(opt.fld[fld]._ctlCls);
    };

    //------------------------------------------------------------------------------
    po.onValidateInput = function (entryObj, p) {
        var b, f, f2, c2;

        const ctx = get_container(entryObj, p);
        entryObj = ctx.c0;
        p = ctx.p2;

        ////console.log('celDataProc => onValidateInput start..');

        //-------------------------------
        // run the pre-validation process.
        b = obj_exec_proc(po, opt, 'onValidateInput20', [entryObj, p]);

        if (b == false) {
            ////console.log('celDataProc => onValidateInput20 failed.. exit..');

            return false;
        }

        // default validation
        f = Object.keys(opt.fld);
        b = null;

        celLoop.each(f, function (f20) {
            f2 = opt.fld[f20];
            c2 = entryObj.find(f2._ctlCls);

            // console.log(c2)
            // console.log(f2)
            // console.log(f2.hasOwnProperty('compulsoryMsg'), f2.ctlType);

            //09-Aug-2023,lhw-moved the validation process into a proc for code sharing.
            if (!celDataProc.validateUserInput(f2, c2)) {
                // set the result.
                b = false;

                // exit the loop
                return false;
            }
        });

        //-------------------------------
        // check the result (null means no err)
        //-------------------------------
        if (b == false) {
            return false;
        }

        //reset var
        b = null;

        //-------------------------------
        b = obj_exec_proc(po, opt, 'onValidateInput2', [entryObj, p]);
        if (b == false) {
            return false;
        }

        return true;
    };

    //------------------------------------------------------------------------------
    po.onGetUserInput = function (entryObj, o) {
        var f, f2, c2, v;
        const ctx = get_container(entryObj, o);
        entryObj = ctx.c0;
        o = ctx.p2;

        // default saving process.
        f = Object.keys(opt.fld);

        celLoop.each(f, function (f20) {
            f2 = opt.fld[f20];

            if (f2.hasOwnProperty('skipSave') && f2.skipSave) {
                return;
            }

            c2 = entryObj.find(f2._ctlCls);

            ////console.log('celDataProc.onGetUserInput=>c2', c2);

            if (obj_has_proc(f2, 'save_val')) {
                //14-Jun-2021,lhw-the hosting object will decide what to save
                v = obj_exec_proc(f2, 'save_val', [c2, f2]);
            }
            else if (obj_has_proc(f2, 'save_val2')) {
                //25-Jan-2023,lhw-allows the hosting object to set multiple fields.
                obj_exec_proc(f2, 'save_val2', [c2, o]);

                // continue to saving next input.
                return;
            }
            else {

                // using standard way to save the user input
                if (f2.ctlType === CTL_TYPE_DATE) {
                    v = dt_get_val(c2);
                    if (v != null) {

                        if (opt.fmtDateInSysFmt) {
                            v = toSysDate(v);
                        }
                        else {
                            v = dt_to_local_time(v);
                        }
                    }
                }
                else if (f2.ctlType === CTL_TYPE_DROPDONWLIST) {
                    v = cbo_get_val(c2);

                    if (f2.dataType == 'guid'
                        //01-Apr-2021,lhw-
                        || f2.dataType == 'id'
                    ) {
                        if (v == '0') {
                            v = null;
                        }
                    }

                    //10-May-2023,lhw-type conversion
                    if (f2.fmt == 'm0') {
                        v = toInt(v);
                    }
                    else if (f2.fmt == 'm2') {
                        v = toDbl(v);
                    }
                }
                else if (f2.ctlType === CTL_TYPE_CHECKBOX) {
                    v = chk_get_val(c2) ? 1 : 0;
                }
                else if (f2.ctlType === CTL_TYPE_CHECKBOX_LIST) {
                    //08-Aug-2023,lhw-
                    v = chklist_get_val(c2);
                }
                else if (f2.ctlType === CTL_TYPE_RADIOLIST) {
                    v = rb_get_val(c2);

                    //10-May-2023,lhw-type conversion
                    if (f2.fmt == 'm0') {
                        v = toInt(v);
                    }
                    else if (f2.fmt == 'm2') {
                        v = toDbl(v);
                    }

                }
                else if (f2.ctlType === CTL_TYPE_NUMERIC) {
                    v = toDbl(text_get_val(c2));
                }
                else {
                    // default is text
                    // (f2.ctlType === CTL_TYPE_TEXT || f2.ctlType == CTL_TYPE_HTML)
                    v = text_get_val(c2);
                }
            }

            // console.log('get user input', f20, v);

            //-------------------------
            // avoid sending 'null' to server.
            if (v != null) {
                obj_set_val(o, f20, v);
            }
            else {
                //22.May.20,lhw-bug fixed
                // If 'o' has the field and value, setting NULL value will have no effect.
                // Best is to delete the field with 'null' value.
                obj_delete_fld(o, f20);
            }

        });

        // user defined saving process
        obj_exec_proc(po, opt, 'onGetUserInput2', [entryObj, o]);
    };

    //------------------------------------------------------------------------------
    // show user input on a data entry screen.
    po.onSelItem = function (entryObj, o) {
        var f, f2, c2, v, fmt, skip;
        const ctx = get_container(entryObj, o);
        entryObj = ctx.c0;
        o = ctx.p2;

        if (!opt.manualSelItem && entryObj) {

            // default populating process
            f = Object.keys(opt.fld);

            // console.log('onSelItem..', entryObj);

            celLoop.each(f, function (f20) {

                f2 = opt.fld[f20];
                c2 = entryObj.find(f2._ctlCls);

                if (obj_has_proc(f2, 'get_val')) {
                    //19-Nov-2020,lhw-getting the computed value.
                    //26-Jun-2021,lhw-added 'f2' param
                    v = obj_exec_proc(f2, 'get_val', [o, f2]);
                }
                else {
                    v = obj_get_val(o, f20);
                }

                skip = false;

                // console.log('onSelItem..', f20, v);
                //console.log('onSelItem..', f20, c2);

                if (obj_has_proc(f2, 'show_input')) {
                    //01-Apr-2021,lhw-allows hosting obj to call an user defined method
                    // to show the data in the input field.
                    obj_exec_proc(f2, 'show_input', [c2, o, v]);
                }
                else if (f2.ctlType === CTL_TYPE_DATE) {

                    if (!c2.is('input')) {
                        if (f2.hasOwnProperty('fmt')) {
                            fmt = f2.fmt;
                        }
                        else {
                            fmt = 'd2';
                        }

                        text_set_val(c2, formatValue(toDate(v), fmt));
                    }
                    else {
                        dt_set_val(c2, toDate(v));
                    }
                }
                else if (f2.ctlType === CTL_TYPE_DROPDONWLIST) {
                    cbo_set_val(c2, (v ? v : '0'));
                }
                else if (f2.ctlType === CTL_TYPE_CHECKBOX) {
                    chk_set_val(c2, v);
                }
                else if (f2.ctlType === CTL_TYPE_CHECKBOX_LIST) {
                    //08-Aug-2023,lhw-
                    chklist_set_val(c2, v);
                }
                else if (f2.ctlType === CTL_TYPE_RADIOLIST) {
                    //08-Aug-2023,lhw-
                    rb_set_val(c2, (!isStrEmpty(v) ? v : '0'));
                }
                else if (f2.ctlType === CTL_TYPE_NUMERIC) {

                    //9.Sep.18,lhw-nb_set_val() does not format the value properly.
                    ////nb_set_val(c2, toDbl(v));

                    if (f2.hasOwnProperty('fmt')) {
                        fmt = f2.fmt;
                        v = formatValue(toDbl(v), fmt);
                    }

                    if (!c2.is('input')) {

                        if (f2.hasOwnProperty('dataType') && isStrEqual(f2.dataType, CTL_TYPE_MONEY)) {
                            //27.Sep.19,lhw-
                            skip = true;
                            text_set_curr(c2, v, '0.00');
                        }
                    }

                    if (!skip) {
                        text_set_val(c2, v);
                    }

                }
                else if (f2.ctlType === CTL_TYPE_HTML) {
                    //19-Nov-2020,lhw-support html value.
                    c2.html(v);
                }
                else {
                    // ([CTL_TYPE_TEXT, CTL_TYPE_LABEL].indexOf(f.ctlType) > -1)
                    // console.log('ct=unknow..treat as text', f20, f2.ctlType);

                    //08-Sep-2020,lhw-use nullVal.
                    if (isStrEmpty(v) && !isUndefinedOrNull(f2.nullVal)) {
                        v = f2.nullVal;
                    }

                    text_set_val(c2, (!isUndefinedOrNull(v) ? v : ''));
                }

            });

        }

        ////console.log('celDataProc.onSelItem - manualSelItem=', opt.manualSelItem, po);

        // user defined populating process
        // return 'false'=to indicate stop the reset of the process.
        return obj_exec_proc(po, opt, 'onSelItem2', [entryObj, o]);
    };

    //------------------------------------------------------------------------------
    po.onNewItemClick = function (entryObj) {
        var f, f2, c2, dv;
        const ctx = get_container(entryObj);
        entryObj = ctx.c0;

        if (entryObj) {
            // default saving process.
            f = Object.keys(opt.fld);

            celLoop.each(f, function (f20) {
                f2 = opt.fld[f20];
                c2 = entryObj.find(f2._ctlCls);

                //11-Aug-2023,lhw-gen the default value.
                dv = celDataProc.genDefaultValue(f2);

                if (f2.ctlType === CTL_TYPE_DATE) {
                    dt_set_val(c2, coalesce(dv, ''));
                }
                else if (f2.ctlType === CTL_TYPE_DROPDONWLIST) {
                    cbo_set_val(c2, coalesce(dv, '0'));
                }
                else if (f2.ctlType === CTL_TYPE_CHECKBOX) {
                    chk_set_val(c2, coalesce(dv, false));
                }
                else if (f2.ctlType === CTL_TYPE_CHECKBOX_LIST) {
                    //08-Aug-2023,lhw-
                    // chklist_set_val(c2, coalesce(dv, ''));
                    chklist_reset(c2);
                }
                else if (f2.ctlType === CTL_TYPE_RADIOLIST) {
                    rb_set_val(c2, coalesce(dv, '0'));

                }
                else if (f2.ctlType === CTL_TYPE_NUMERIC) {
                    nb_set_val(c2, coalesce(dv, ''));
                }
                else {
                    // ([CTL_TYPE_TEXT, CTL_TYPE_LABEL, CTL_TYPE_HTML].indexOf(f.ctlType) > -1)
                    text_set_val(c2, coalesce(dv, ''));
                }

            });
        }

        // user defined saving process
        obj_exec_proc(po, opt, 'onNewItemClick2', [entryObj]);
    };

    //------------------------------------------------------------------------------
    // format the data object in the item list.
    po.onFmtItem = function (itemObj, o) {
        var f, f2, c2, v, fmt, skip;

        // console.log('onFmtItem', itemObj);

        // default populating process
        if (!opt.manualFmtItem) {
            f = Object.keys(opt.fld);

            celLoop.each(f, function (f20) {
                f2 = opt.fld[f20];

                // if (f20 == 'status') {
                //     console.log(f2)
                //     console.log(f2.hasOwnProperty('itemCtlCls'))
                // }

                if (!f2.hasOwnProperty('itemCtlCls')) {
                    return;
                }

                c2 = itemObj.find(f2._itemCtlCls);

                if (obj_has_proc(f2, 'fmt_val')) {
                    //09-Dec-2022,lhw-this is good for onFmtItem() to get the translated text.
                    v = obj_exec_proc(f2, 'fmt_val', [o]);
                }
                else if (obj_has_proc(f2, 'get_val')) {
                    //19-Nov-2020,lhw-getting the computed value.
                    // whereas `get_val` is good for returning the 'actual value'
                    v = obj_exec_proc(f2, 'get_val', [o]);
                }
                else {
                    v = obj_get_val(o, f20);
                }

                skip = false;

                if (obj_has_proc(f2, 'show_input')) {
                    //01-Apr-2021,lhw-allows hosting obj to call an user defined method to show the data in the input field.
                    obj_exec_proc(f2, 'show_input', [c2, o, v]);
                    skip = true;
                }
                else if (obj_has_proc(f2, 'show_value')) {
                    //12-Aug-2023,lhw-
                    obj_exec_proc(f2, 'show_value', [c2, o, v]);
                    skip = true;
                }
                else if (f2.ctlType === CTL_TYPE_DATE) {
                    if (f2.hasOwnProperty('fmt')) {
                        fmt = f2.fmt;
                    }
                    else {
                        fmt = 'd';
                    }

                    v = formatValue(toDate(v), fmt);
                }
                else if (f2.ctlType === CTL_TYPE_NUMERIC) {

                    if (f2.hasOwnProperty('fmt')) {
                        fmt = f2.fmt;
                    }
                    else {
                        fmt = 'm2';
                    }

                    if (f2.hasOwnProperty('dataType') && isStrEqual(f2.dataType, CTL_TYPE_MONEY)) {
                        //27.Sep.19,lhw-
                        skip = true;
                        text_set_curr(c2, v, '0.00');
                    }
                    else {
                        v = formatValue(toDbl(v), fmt);
                    }

                }
                else if (f2.ctlType === CTL_TYPE_CHECKBOX) {
                    //format to yes/no.
                    v = formatValue(toInt(v), 'yn');
                }

                ////text_set_val(c2, (!isUndefinedOrNull(v) ? v : ''));

                if (!isUndefinedOrNull(f2.nullVal) && isStrEmpty(v)) {
                    v = f2.nullVal;
                }
                else if (opt.nullValDisplayText != null && isStrEmpty(v)) {
                    v = opt.nullValDisplayText;
                }

                if (!skip) {
                    if (f2.ctlType === CTL_TYPE_HTML) {
                        //19-Nov-2020,lhw-
                        c2.html(v);
                    }
                    else {
                        text_set_val(c2, v);
                    }
                }

            });
        }

        // user defined populating process
        obj_exec_proc(po, opt, 'onFmtItem2', [itemObj, o]);
    };


    //------------------------------------------------------------------------------
    // returns the fields.
    po.getFields = function () {
        return opt.fld;
    };

    //01-Nov-2021,lhw-loop all the fields.
    // cb:function(f2)
    po.eachField = function (cb) {
        let f = Object.keys(opt.fld);

        celLoop.each(f, function (f20) {
            f2 = opt.fld[f20];
            cb(f2);
        });
    };

    //01-Nov-2021,lhw-loop all fields with input.
    // cb:function(f2, c2)
    po.eachInput = function (entryObj, cb) {
        const ctx = get_container(entryObj, cb);
        entryObj = ctx.c0;
        cb = ctx.p2;

        let f = Object.keys(opt.fld);
        celLoop.each(f, function (f20) {
            f2 = opt.fld[f20];
            c2 = entryObj.find(f2._ctlCls);
            cb(f2, c2);
        });
    };


    //------------------------------------------------------------------------------
    //01-Apr-2021,lhw-in case celDataProc() was call directly, the hosting object should call this proc
    // to release the settings from mem.
    po.destroy = function () {
        po.destroyDataProc();
    };

    //02-Jul-2021,lhw-po.destroy() will be replaced by celListingForm or any other lib
    // that has implemented destroy(). As a result, the po.destroy() will not be triggered at all.
    // So, we have to use another name for it.
    po.destroyDataProc = function () {
        opt = null;
    };

    //------------------------------------------------------------------------------
    //01-Apr-2021,lhw-this proc init the input fields.
    po.initInput = function (entryObj) {
        const ctx = get_container(entryObj);
        entryObj = ctx.c0;

        //11-Aug-2023,lhw-moved the code block and make it a standard proc.
        celDataProc.initInput(entryObj, po, opt);
    };


    //-------------------------
    //07-Dec-2022,lhw-inject the comman functions for handling the data input and display.
    if (opt.inject_common_fn) {
        po.resetInput = function(c0) {
            const ctx = get_container(c0);
            return po.onNewItemClick(ctx.c0);
        };

        // this proc validate and get input/
        po.validateInput = function(c0, o2) {
            const ctx = get_container(c0, o2);
            c0 = ctx.c0;
            o2 = ctx.p2;

            if (!po.onValidateInput(c0, { data: o2})) {
                return false;
            }

            po.onGetUserInput(c0, o2);
            return true;
        };

        po.getInput = function(c0, o2) {
            const ctx = get_container(c0, o2);
            c0 = ctx.c0;
            o2 = ctx.p2;

            return po.onGetUserInput(c0, o2);
        };

        po.editData = function(c0, o2) {
            const ctx = get_container(c0, o2);
            c0 = ctx.c0;
            o2 = ctx.p2;

            return po.onSelItem(c0, o2);
        };

        po.fmtItem = function(c0, o2) {
            const ctx = get_container(c0, o2);
            c0 = ctx.c0;
            o2 = ctx.p2;

            return po.onFmtItem(c0, o2);
        };
    }


}


/*------------------------------------------------------------------------------
//@@
19-Nov-2020,lhw-populate the data on the ui.

sample:

    let c0 = GearHistory.entry.dockbar.getInnerContainer();

    // fld_map has the same structure like opt param pass into celDataProc().
    let fld_map = {
        for_entry:true,

        fld: {
            prod_desc: {
                c2: 'prod-id-input',
                get_val: (o0) => {
                    return `${o0.prod_cat_desc}\\${o0.prod_code}\\${o0.prod_desc}`;
                }
            },

            prod_id: { c2: 'prod-id' },
            sub_item_no: { c2: 'sub-item-no' },
            last_mt_on: { c2: 'last-mt-on', fmt: 'dt' },
        }
    }

    let o2 = (arrLen(l2) > 0 ? l2[0] : {});
    celDataProc.process(fld_map, c0, o2);

------------------------------------------------------------------------------*/
celDataProc.process = (f_map, ui, o, d0, get_user_input) => {

    if (typeof d0 == 'boolean'
        && d0 == true
    ) {
        //21-Jun-2021,lhw-added new param
        get_user_input = true;
        d0 = null;
    }


    // create a dummy object

    //27-Apr-2021,lhw-if this proc was called multiple times,
    // it will create a new instance of celDataProc. To avoid
    // instantiating a new instance, the caller may keep the
    // reference of d0 and reuse will become possible.
    if (typeof d0 == 'undefined' || d0 == null) {
        d0 = {};

        f_map.treatItemCtlClsSameAsCtlCls = true;

        // inject the data proc-s to a new object.
        celDataProc(d0, f_map);
    }

    // console.log(d0.getFields());

    if (get_user_input) {
        //21-Jun-2021,lhw-
        //07-Dec-2022,lhw-replaced `entryObj` with `ui` - bug fixed.
        d0.onValidateInput(ui, { data: o });
        d0.onGetUserInput(ui, o);
    }
    else {

        // populate the data on the ui
        if (f_map.for_entry || f_map.use_sel_item_proc) {
            // for data entry
            d0.onSelItem(ui, o);
        }
        else {
            // for display (usually on a listing item).
            d0.onFmtItem(ui, o);
        }
    }
    return d0;
};


//------------------------------------------------------------------------------
/**
 * 09-Aug-2023,lhw-this code block was moved out from `po.onValidateInput()`.
 * Now, it is a standalone proc that can be shared with any other lib.
 *
 * @param {Object} f2
 * @param {Object} c2
 * @returns {boolean}
 */
celDataProc.validateUserInput = function(f2, c2) {
    let s;

    if (f2.ctlType === CTL_TYPE_DROPDONWLIST) {
        if ((f2.hasOwnProperty('compulsoryMsg') || (f2.nullable === false))) {
            //09-Aug-2023,lhw-
            if (f2.text) {
                s = `${f2.text} cannot be blank`;
            }
            else if (f2.compulsoryMsg) {
                s = f2.compulsoryMsg;
            }
            else {
                //11-Aug-2023,lhw-use the field name if the above is missing
                s = `${f2.f} cannot be blank`;
                console.error(`celDataProc:"${f2.f}" has missing setting on text or compulsoryMsg`);
            }

            if (cbo_is_blank(c2, s)){
                return false;
            }
        }
    }
    else if (f2.ctlType === CTL_TYPE_DATE) {
        if ((f2.hasOwnProperty('compulsoryMsg') || (f2.nullable === false))) {
            //09-Aug-2023,lhw-
            if (f2.text) {
                s = `${f2.text} cannot be blank`;
            }
            else if (f2.compulsoryMsg) {
                s = f2.compulsoryMsg;
            }
            else {
                //11-Aug-2023,lhw-use the field name if the above is missing
                s = `${f2.f} cannot be blank`;
                console.error(`celDataProc:"${f2.f}" has missing setting on text or compulsoryMsg`);
            }

            if (dt_is_blank(c2, s)) {
                return false;
            }
        }
    }
    else if (f2.ctlType === CTL_TYPE_TEXT
        //19-Nov-2020,lhw-
        || f2.ctlType == CTL_TYPE_HTML
    ) {

        // console.log('validate text input', f2.compulsoryMsg, f2.hasOwnProperty('compulsoryMsg'));
        if ((f2.hasOwnProperty('compulsoryMsg') || (f2.nullable === false))) {
            if (f2.text) {
                s = `${f2.text} cannot be blank`;
            }
            else if (f2.compulsoryMsg) {
                s = f2.compulsoryMsg;
            }
            else {
                //11-Aug-2023,lhw-use the field name if the above is missing
                s = `${f2.f} cannot be blank`;
                console.error(`celDataProc:"${f2.f}" has missing setting on text or compulsoryMsg`);
            }

            if (text_is_blank(c2, s)) {
                return false;
            }
        }

        if (f2.hasOwnProperty('dataType')) {
            if (isStrEqual(f2.dataType, 'email')) {
                if (f2.text) {
                    //11-Aug-2023,lhw-
                    s = `${f2.text} is not a valid email address`;
                }
                else {
                    s = `Invalid email address`;
                }

                if (!isStrEmpty(text_get_val(c2)) && text_is_invalid_email(c2, s)) {
                    return false;
                }
            }

            //18.Jul.19,lhw-
            if (isStrEqual(f2.dataType, 't') || isStrEqual(f2.dataType, 'time')) {
                if (f2.text) {
                    //11-Aug-2023,lhw-
                    s = `${f2.text} is not a valid time`;
                }
                else {
                    s = `Invalid time`;
                }

                if (!isStrEmpty(text_get_val(c2)) && text_is_invalid_time(c2, s)) {
                    return false;
                }
            }
        }

        if (f2.hasOwnProperty('minLen')) {
            //07-Dec-2022,lhw-enforce the min len input.
            let v = toDbl(text_get_val(c2));
            unhighlight_compulsory(c2);

            if (v.length < f2.minLen) {
                if (f2.text) {
                    //11-Aug-2023,lhw-
                    s = `${f2.text} should have at least ${f2.minLen} characters` ;
                }
                else {
                    s = `${f2.f} should have at least ${f2.minLen} characters` ;
                }

                msgbox.err(s);
                highlight_compulsory(c2);
                c2.trigger('focus');
                return false;
            }
        }

        if (f2.hasOwnProperty('maxLen')) {
            //07-Dec-2022,lhw-enforce the max len input.
            let v = toDbl(text_get_val(c2));
            unhighlight_compulsory(c2);

            if (v.length > f2.maxLen) {
                //25-May-2023,lhw-
                if (f2.text) {
                    s = `${f2.text} has exceeded the maximum of ${f2.maxLen} characters`;
                }
                else if (f2.compulsoryMsg) {
                    s = f2.compulsoryMsg + ` (maximum character is ${f2.maxLen})`;
                }
                else {
                    //11-Aug-2023,lhw-use the field name if the above is missing
                    s = `${f2.f} has exceeded the maximum of ${f2.maxLen} characters`;
                    console.error(`celDataProc:"${f2.f}" has missing setting on text or compulsoryMsg`);
                }

                msgbox.err(s);
                highlight_compulsory(c2);
                c2.trigger('focus');
                return false;
            }
        }
    }
    else if (f2.ctlType === CTL_TYPE_NUMERIC) {
        if (f2.hasOwnProperty('min') || f2.hasOwnProperty('max')) {
            if (f2.hasOwnProperty('min')) {
                //02-Dec-2022,lhw-enforce the min value input.
                let v = toDbl(text_get_val(c2));
                unhighlight_compulsory(c2);

                if (v < f2.min) {
                    if (f2.text) {
                        s = `${f2.text} must be greater than ${f2.min}`;
                    }
                    else if (f2.compulsoryMsg) {
                        s = f2.compulsoryMsg + ` (minimum value is ${f2.min})`;
                    }
                    else {
                        //11-Aug-2023,lhw-use the field name if the above is missing
                        s = `${f2.f} must be greater than ${f2.min}`;
                        console.error(`celDataProc:"${f2.f}" has missing setting on text or compulsoryMsg`);
                    }

                    msgbox.err(s);
                    highlight_compulsory(c2);
                    c2.trigger('focus');
                    return false;
                }
            }

            if (f2.hasOwnProperty('max')) {
                //07-Dec-2022,lhw-enforce the max value input.
                let v = toDbl(text_get_val(c2));
                unhighlight_compulsory(c2);

                if (v > f2.max) {
                    if (f2.text) {
                        s = `${f2.text} must be lesser than ${f2.max}`;
                    }
                    else if (f2.compulsoryMsg) {
                        s = f2.compulsoryMsg + ` (maximum value is ${f2.max})`;
                    }
                    else {
                        //11-Aug-2023,lhw-use the field name if the above is missing
                        s = `${f2.f} must be lesser than ${f2.max}`;
                        console.error(`celDataProc:"${f2.f}" has missing setting on text or compulsoryMsg`);
                    }

                    msgbox.err(s);
                    highlight_compulsory(c2);
                    c2.trigger('focus');
                    return false;
                }
            }
        }
        else {
            //18-Oct-2021,lhw-
            if ((f2.hasOwnProperty('compulsoryMsg') || (f2.nullable === false))) {
                //09-Aug-2023,lhw-
                if (f2.text) {
                    s = `${f2.text} cannot be blank`;
                }
                else if (f2.compulsoryMsg) {
                    s = f2.compulsoryMsg;
                }
                else {
                    //11-Aug-2023,lhw-use the field name if the above is missing
                    s = `${f2.f} cannot be blank`;
                    console.error(`celDataProc:"${f2.f}" has missing setting on text or compulsoryMsg`);
                }

                if (nb_is_zero_or_less(c2, s)) {
                    return false;
                }
            }
        }
    }

    return true;
};

//------------------------------------------------------------------------------
//01-Apr-2021,lhw-this proc init the input fields.
//11-Aug-2023,lhw-this proc was moved out from `po.initInput()` and it is a standard proc now.
celDataProc.initInput = function (entryObj, po, opt) {

    if (entryObj) {
        // default saving process.
        const f = Object.keys(opt.fld);

        celLoop.each(f, function (f20) {
            const f2 = opt.fld[f20];
            let c2 = entryObj.find(f2._ctlCls);

            //25-Apr-2021,lhw-bug fixed-for date, time & numeric, it is limited to 'input' only.
            let inp = c2.is('input');

            //23-Jun-2021,lhw-ensure that the auto search control is reset to NULL after used.
            // Upon reloading the UI, those auto found elem will not refer to the previous 'reference'.
            let auto = false;

            // console.log('celDataProc.initInput', f2);
            // console.log('celDataProc.initInput', f2, c2);

            if (obj_has_proc(f2, 'init_input')) {
                obj_exec_proc(f2, 'init_input', [c2, entryObj]);
            }
            else if (f2.dataType == 't' || f2.dataType == 'time') {
                if (inp) {
                    text_accept_time(c2);
                }
            }
            else if (f2.ctlType === CTL_TYPE_DATE) {
                //05-Jul-2021,lhw-
                if (f2.ci2) {
                    c2 = entryObj.find(f2._ci2);
                    inp = c2.is('input');
                }

                if (inp) {
                    let p = {
                        block_on_show: false,
                        show_on_focus: false,
                    };

                    if (!f2.imgBtn) {
                        //14-Jun-2021,lhw-auto search for the select date image button.
                        let c3 = c2.parent().find('.material-icons');
                        if (c3.length > 0) {
                            f2.imgBtn = c3;
                            auto = true;
                        }
                    }

                    if (f2.imgBtn) {
                        p.imgBtn = f2.imgBtn;
                    }

                    dt_makeDatePicker(c2, p);

                    if (auto) {
                        f2.imgBtn = null;
                    }

                    //07-Dec-2022,lhw-set value range.
                    if (f2.hasOwnProperty('min') && f2.hasOwnProperty('max')) {
                        dt_set_range(c2, f2.min, f2.max);
                    }
                }
            }
            else if (f2.ctlType === CTL_TYPE_CHECKBOX) {
                //05-Jul-2021,lhw-
                if (f2.ci2) {
                    c2 = entryObj.find(f2._ci2);
                }

                if (!f2.chk_lbl) {
                    f2.chk_lbl = c2.parent().find('.chk-lbl');

                    // the 'label' elem is optional.
                    if (f2.chk_lbl.length == 0) {
                        f2.chk_lbl = null;
                    }
                    else {
                        auto = true;
                    }
                }

                c2.celCheckbox({ lbl: f2.chk_lbl });

                if (auto) {
                    f2.chk_lbl = null;
                }

            }
            else if (f2.ctlType === CTL_TYPE_CHECKBOX_LIST) {
                //08-Aug-2023,lhw-auto setup the item list. struct: [{id,text},..]
                if (f2.item_list) {
                    chklist_make(c2, f2.item_list, item_list_opt);
                }
            }
            else if (f2.ctlType === CTL_TYPE_RADIOLIST) {
                //08-Aug-2023,lhw-auto setup the item list. struct: [{id,text},..]
                if (f2.item_list) {
                    rb_make(c2, f2.item_list, item_list_opt);
                }
            }
            else if (f2.ctlType === CTL_TYPE_NUMERIC) {
                if (inp) {
                    if (f2.fmt == 'm0') {
                        if (f2.negative) {
                            //27-Jun-2021,lhw-bug fixed-must allow negative integer.
                            text_accept_currency_only(c2, 0, (f2.maxLen || 15), null, f2.negative, f2.fmt);
                        }
                        else {
                            text_accept_numeric_only(c2);
                            c2.attr('maxlength', (f2.maxLen || 15));
                        }
                    }
                    else {
                        let dec = toInt(f2.fmt.replace('m', ''));
                        if (dec == 0) {
                            dec = 2;
                        }

                        text_accept_currency_only(c2, dec, (f2.maxLen || 15), null, f2.negative, f2.fmt);
                    }
                }
            }
            else {
                //07-Dec-2022,lhw-
                if (f2.hasOwnProperty('maxLen') && inp) {
                    c2.attr('maxlength', f2.maxLen);
                }
            }

        });
    }

    // run custom init such as popup selection.
    obj_exec_proc(po, opt, 'onInitInput2', [entryObj]);
};

//------------------------------------------------------------------------------
//11-Aug-2023,lhw-
//06-Sep-2023,lhw-used by celRepotrForm.
celDataProc.genDefaultValue = function(f2) {
    let v2;
    let v = f2.defVal;

    // console.log(f2.f, f2.defVal)
    if (v) {
        if (f2.ctlType === CTL_TYPE_DATE) {
            //sample value
            //   today
            //   today-7
            if (typeof v == 'string') {
                if (v.indexOf('today') >= 0) {
                    v2 = toInt(v.replace('today', ''));
                    v = addDays(dateValue(new Date), v2);
                }
                else if (v == 'month start' || v == 'month_start' || v == 'month_start()') {
                    v = get_begin_of_month(dateValue(new Date));
                }
                else if (v == 'month end' || v == 'month_end' || v == 'month_end()') {
                    v = get_end_of_month(dateValue(new Date));
                }
                else if (v == 'year start' || v == 'year_start' || v == 'year_start()') {
                    v = get_begin_of_yr(dateValue(new Date));
                }
                else if (v == 'year end' || v == 'year_end' || v == 'year_end()') {
                    v = get_end_of_yr(dateValue(new Date));
                }
            }
        }
    }

    return v;
};



/*==============================================================================
//@@
28-Feb-2021,lhw-
- This proc is to make an item line to be able to handle the user input.

NOTES:


-------------------------



sample :

    celItemLine({
        c0: c0,
        po: stockAdjEntry.itemLine,
        il: c0.find('.il1'),
        counter: c0.find('.rec-cnt'),

        itemlinePerBatch: 10,
        inject_edit_axn: true,
        inject_move_axn: false,

        del_confirm_msg: null,
        del_msg: null,
        removeRowOnDel: true,
        editable_on_all_line: false,
        movable_on_all_line: false,
        // do_local_validate: false,
        // del_confirm_msg: null,
        // del_msg: null,

        fmap: [
            // this is the read-only field (ci=null)
            { f: 'tr_id', co: '.tr-id', ci: null },
            { f: 'prod_id', co: '.prod-id', ci: '.prod-id-input' },
            { f: 'prod_code', co: '.prod-code', ci: '.prod-code-input0', ci2: '.prod-code-input', skipSave: true },

            {
                f: 'prod_size', co: '.size-color', ci: '.size-color-input', skipSave: true,
                get_val: function (o2) {
                    return myApp.fmtProdSizeColor(o2);
                }
            },
        ],

        // onBeforeEditItem: function(r, {c2, o2, resolve, reject}) {},
        // onAfterEditItem: function(c2, o2) {},

        // onBeforeSaveItem: function(r, {c2, o0, o2, msg, resolve,reject) {},
        // onAfterSaveItem: function (c2, o2) {},

        // onBeforeDelItem: function(r, {c2, o2, msg, resolve, reject, row_idx}) {},
        // onAfterDelItem: function (c2, o0, row_idx) {},
    });


    stockAdjEntry.itemLine.initInput();
    let l = [];
    stockAdjEntry.itemLine.list(l);

==============================================================================*/

function celItemLine(opt0) {

    var def_opt = {
        // the parent container that has the template-div.
        c0: null,

        //26-Jun-2021,lhw-the template container can be outside of the main container.
        ct0: null,

        // the parent obj (usually it is a function).
        po: null,

        // the item list container (jquery object)
        il: null,

        // the item counter elem (jquery object)
        counter: null,

        // item classes
        itemTemplateCls: 'item-div0',
        itemCls: 'item-div',

        // the field name in the data object to be send to the server.
        itemLineFld: 'item_line',

        //12-Jul-2023,lhw-allows hosting control to name the btn.
        btn_calendar_cls: 'btn-calendar',
        btn_select_cls: 'btn-select',

        // append empty item line so that it can be display on the screen.
        // default is 50 item lines. If the user has filled up 50 lines,
        // append blank lines will be adding 50 lines.
        itemlinePerBatch: 50,

        /*
        - 'fmap' is an array of the field mapping where the field has the following structure:

            f       - the field name.
            co      - elem for output/display.
            ci      - elem for capture input.
            [ci2]   - the actual input elem and ci is the container of ci2.
            [dt]    - the data type
            [skipSave]:bool - true if skip saving to the doc
            [fmt]   - input format.
            [negative]:bool - default is true.
            [nullVal] - the display text if the data value is null.

            [get_val]:function(o0, f0) - translate the database value to display value.
            [show_value]:function(c2, o0, v0) - allows update the ui on showing the data.
            [save_val]:function(c2, f0, v0) - 26-Jun-2021,lhw-translate the display value to database value.


            [show_input:function(c2, o0, v0)] - 04-Jul-2021,lhw-allows hosting obj to call an user defined
                                          method to show the data in the input field.
            [init_input:function(c2,c0)] - 04-Jul-2021,lhw-


            * the following settings are meant for initInput():
            [lbl]:str     - the checkbox label.
            [hidden]:bool - if true, the 'ci' is a hidden INPUT elem.
            [readonly]:bool - if true, the 'ci' is a DIV (not INPUT).
            [maxlength]:99  - for 'INPUT.maxlength=99'.
            [popup]:bool    - if true, inject a DIV elem with select button.
            [disable_wrap_text]:bool- if true, the MEMO value will NOT replace the '\n' with '</br>' tag.
                                      Default is false (wrap the text).

            [on_click]:function() - this is for 'popup=true' that handles the on click event.

            //12-Jul-2023,lhw-
            [placeholder]:str

        */
        fmap: [],

        //31-Mar-2021,lhw-if true, the current row will be deleted and a new blank row will be added.
        removeRowOnDel: null,

        //26-Jun-2021,lhw-if true inject edit, delete, save & undo options.
        // Calls initAxnOptions() to inject the elem.
        inject_edit_axn: null,

        // if true, inject move up and down options.
        // Calls initAxnOptions() to inject the elem.
        inject_move_axn: null,

        //27-Jun-2021,lhw-if this element (DIV or INPUT) holds a value, it will be treated as 'not blank item line'.
        // This value is for isBlankItem() proc to work and you don't need to implement `onIsBlankItem()` callback.
        compulsory_input: null,

        // Default is the item line is allowed editing.
        enable: true,

        //08-Aug-2023,lhw-if false, only first dummy line (`Object.keys(o2).length == 0`) is editable.
        editable_on_all_line: true,

        //08-Aug-2023,lhw-if false, only not isBlankItem() is movable.
        movable_on_all_line: true,

        //09-Aug-2023,lhw-runs local validation (ie, not using any ajax)
        // will if `do_local_validate=true`. Set `nullable=false` and `text=x`
        // for the validation err message.
        do_local_validate: false,

        del_confirm_msg: 'Click OK to confirm deleting the current line',
        del_msg: null,


        //-------------------------
        //f(c2):bool - returns true if the key field is blank (ie, skip submitting to the server).
        onIsBlankItem: null,

        // onBeforeSaveItem = function(r, {c2, o0, o2, msg, resolve,reject) {}
        //12-Jul-2023,lhw-added 'o0' (original data) and 'o2' (modified data).
        //  - calls 'r.resolve()' if the user input has fulfilled the
        // business process validation. Otherwise, calls 'r.reject()'.
        onBeforeSaveItem: null,

        //03-Aug-2021,lhw-
        //      onAfterSaveItem0: function(c2, o2, o20) { },
        // - for running any other process after saved the changes with default process
        //   and before removing the input elem from the screen.
        //16-Oct-2021,lhw-added 'o20' which is the orig value.
        onAfterSaveItem0: null,

        // f(c2, o2) - to run any other process after saved the changes.
        onAfterSaveItem: null,

        // f(o0, o2) - allows the hosting object to continue with other process.
        // - o0 - the data object in the mem.
        // - o2 - the new data object to be submitted to the server.
        onSaveItemToDoc: null,

        // f(o2) - allows the hosting to patch the item data before appending to the data object.
        onSaveToDoc: null,

        // onBeforeEditItem: function(r, {c2, o2, resolve, reject}) {},
        // - the hosting object must call r.resolve() manually!
        //25-Jun-2021,lhw-call r.reject() to prevent enabling the edit mode.
        onBeforeEditItem: null,

        // onAfterEditItem: function(c2, o2) {},
        //  - allows perform any ajax process before open the field for editing.
        onAfterEditItem: null,

        // onBeforeDelItem: function(r, {c2, o2, msg, resolve, reject}) {},
        // - allows overriding the the message prompt (r.msg)
        // and calls 'r.resolve()' to confirm deleting the user input (on the UI) (by clearing the
        // values in the row but not physically deleting the row!). Otherwise, calls 'r.reject()'.
        onBeforeDelItem: null,

        //  f(c2, o0,row_idx) - to run any other process after deletion where 'c2' is the row.
        onAfterDelItem: null,

        //01-Apr-2021,lhw-after populated the data to an item line (for display).
        // f(c2, is_empty:bool, o2)
        onShowItemLine: null,

    };

    opt0 = $.extend(def_opt, opt0);

    //-------------------------
    var po = opt0.po;

    //-------------------------
    var internal = {
        edit_mode: 0,
        edit_row: null
    };

    po.getContainer = function () {
        return opt0.il;
    };

    //16-Aug-2023,lhw-
    po.getAllItemLines = function () {
        const c0 = po.getContainer();
        return c0.find(elemCss(opt0.itemCls).wrap());
    };

    po.reset = function () {
        internal.edit_mode = 0;
        internal.edit_row = null;
    };

    po.isEditing = function () {
        return (internal.edit_mode == 1);
    };

    po.getEditingRow = function () {
        return internal.edit_row;
    };

    /**
     * 14-Jul-2023,lhw-get the user input from the current editing row.
     * @param {String|Object} fld - can be a string (a field name) or an object in `opt0.fmap`.
     * @param {Object} [r] - struct: {c2, v0, v2, f2}. (input control, user input value (before conversion), final user input, field setting)
     * @returns {any} - the user input value.
     */
    po.getEditingInputVal = function(fld, r) {
        if (!internal.edit_row) {
            return null;
        }

        const c0 = internal.edit_row;
        let f0;

        if (typeof fld == 'string') {
            f0 = celLoop.findFirst(opt0.fmap, function(f2) {
                    return f2.f == fld;
                });

            if (!f0) {
                return null;
            }
        }
        else if (typeof fld == 'object') {
            f0 = fld;
        }

        let c2, v0, v2;

        if (f0.ci2) {
            //26-Jun-2021,lhw-bug fixed-this is the physical input elem.
            if (f0.dt == CTL_TYPE_CHECKBOX || f0.ct == CTL_TYPE_CHECKBOX) {
                c2 = c0.find('.celchk');
            }
            else {
                c2 = c0.find(f0._ci2);
            }
        }
        else {
            c2 = c0.find(f0._ci);
        }

        //-------------------------
        if (f0.dt == CTL_TYPE_DROPDONWLIST) {
            // the cbo item id will be treated as a 'field' that store its' value in a hidden elem.
            // on the other hand, we have to keep the 'item text' for display purpose.
            v0 = cbo_get_sel_item_text(c2);
        }
        else if (f0.dt == CTL_TYPE_DATE) {
            v0 = dt_get_val(c2);
        }
        else if (f0.dt == CTL_TYPE_CHECKBOX) {
            //26-Jun-2021,lhw-
            v0 = chk_get_val(c2);
        }
        else if (f0.dt == CTL_TYPE_CHECKBOX_LIST) {
            //08-Aug-2023,lhw-
            v0 = chklist_get_val(c2);
        }
        else if (f0.dt == CTL_TYPE_RADIOLIST) {
            //08-Aug-2023,lhw-
            v0 = rb_get_val(c2);
        }
        else {
            v0 = text_get_val(c2);
        }

        // convert the input to the appropriate type.
        v2 = po.toNativeValue(f0, v0, c2);

        // returns the result if `r` has been specified.
        if (r) {
            r.f2 = f0;
            r.c2 = c2;
            r.v0 = v0;
            r.v2 = v2;
        }

        return v2;
    };

    /**
     * 14-Jul-2023,lhw-get the input element for the given field.
     * @param {String} fld
     * @returns {Object} - returns the input element (jQuery type).
     */
    po.getEditingInput = function(fld) {
        if (!internal.edit_row) {
            return null;
        }

        const c0 = internal.edit_row;
        const f0 = celLoop.findFirst(opt0.fmap, function(f2) {
                return f2.f == fld;
            });

        if (!f0) {
            return null;
        }

        let c2;
        if (f0.ci2) {
            //26-Jun-2021,lhw-bug fixed-this is the physical input elem.
            if (f0.dt == CTL_TYPE_CHECKBOX || f0.ct == CTL_TYPE_CHECKBOX) {
                c2 = c0.find('.celchk');
            }
            else {
                c2 = c0.find(f0._ci2);
            }
        }
        else {
            c2 = c0.find(f0._ci);
        }

        return c2;
    };

    //29-Jun-2021,lhw-replaced by setEnable() and getEnable().
    // po.allowEdit = function (b) {
    //     if (typeof b == 'undefined' || b == null) {
    //         return internal.allow_edit;
    //     }
    //     else {
    //         internal.allow_edit = b;

    //         if (po.isEditing()) {
    //             po.onUndoItem();
    //         }
    //     }
    // };

    //------------------------------------------------------------------------------
    // convert the value for display with proper formatting.
    po.toDisplayValue = function (f0, o0) {
        var v, fmt;

        if (obj_has_proc(f0, 'get_val') && o0) {
            v = obj_exec_proc(f0, 'get_val', [o0, f0]);
            return v;
        }

        v = obj_get_val(o0, f0.f);

        if (typeof v == 'undefined' || v == null || v == '') {
            if (f0.hasOwnProperty('nullVal')) {
                return f0.nullVal;
            }
        }

        //-------------------------
        if (f0.dt == CTL_TYPE_NUMERIC) {
            fmt = coalesce(f0.fmt, 'm0');
            v = formatValue(v, fmt);
        }
        else if (f0.dt == CTL_TYPE_MONEY) {
            fmt = coalesce(f0.fmt, 'm2');
            v = formatValue(v, fmt);
        }
        else if (f0.dt == CTL_TYPE_DATE) {
            fmt = coalesce(f0.fmt, 'd');
            v = formatValue(v, fmt);
        }
        else if (f0.dt == CTL_TYPE_CHECKBOX) {
            fmt = coalesce(f0.fmt, 'yn');
            v = toInt(v);
            v = formatValue(v, fmt);
        }

        return v;
    };

    //------------------------------------------------------------------------------
    // for saving the value to the object.
    po.toNativeValue = function (f0, v, c2) {
        //26-Jun-2021,lhw-
        if (obj_has_proc(f0, 'save_val')) {
            v = obj_exec_proc(f0, 'save_val', [c2, f0, v]);
            return v;
        }

        if (f0.dt == CTL_TYPE_CHECKBOX) {
            //26-Jun-2021,lhw-
            v = boolToInt(v);
        }
        else if (f0.dt == CTL_TYPE_NUMERIC) {
            v = toInt(v);
        }
        else if (f0.dt == CTL_TYPE_MONEY) {
            v = toDbl(v);
        }
        else if (f0.dt == CTL_TYPE_DATE) {
            v = toDate(v);
        }

        return v;
    };


    //------------------------------------------------------------------------------
    // show the data list on the item line ui.
    //------------------------------------------------------------------------------
    po.list = function (l, skip_reset_content, skip_append_blank_line) {
        l = l || [];
        while (arrLen(l) < opt0.itemlinePerBatch) {
            // append empty item line so that it can be display on the screen.
            l.push({});
        }

        //-------------------------
        const il = po.getContainer();
        // console.log(il, l)

        if (!skip_reset_content) {
            il.html('');
        }

        let h_editable_on_all_line = false;

        const opt = po.createItemLineCloneOpt();
        celLoop.each(l, function (o20) {
            celUI.clone(opt, o20);
            // console.log('item line', opt.c2);

            if (!opt0.enable) {
                po.setEnable(false, opt.c2);
            }

            il.append(opt.c2);
            po.showItemLine(opt.c2, o20);

            //08-Aug-2023,lhw-
            if (!opt0.editable_on_all_line) {
                h_editable_on_all_line = ref_state_for_editable_on_all_line(o20, opt.c2, h_editable_on_all_line);
            }

            //08-Aug-2023,lhw-
            if (!opt0.movable_on_all_line) {
                ref_state_for_movable_on_all_line(o20, opt.c2);
            }
        });

        po.reset();
        po.refCounter(skip_append_blank_line);
    };



    //------------------------------------------------------------------------------
    // append blank line after the previous 50 lines have been used up.
    po.appendBlankLines = function () {
        po.list(null, true, true);
    };

    //------------------------------------------------------------------------------
    // for saving the item line before submitting the doc to the server.
    //------------------------------------------------------------------------------
    po.saveToDoc = function (o) {
        const c0 = po.getContainer();
        const il = c0.find(elemCss(opt0.itemCls).wrap());

        if (!o[opt0.itemLineFld]) {
            o[opt0.itemLineFld] = [];
        }

        const b2 = obj_has_proc(opt0, 'onSaveItemToDoc');

        celLoop.each(il, (c20) => {
            let c2 = $(c20);

            // check to see if the item line is blank or not.
            // skip saving if the compulsory field is empty.
            let b = po.isBlankItem(c2);
            if (b) {
                return;
            }

            let o2 = {};
            let o0 = c2.data('data');

            celLoop.each(opt0.fmap, function (f0) {

                if (f0.skipSave) {
                    return;
                }

                // copy the value from mem
                o2[f0.f] = o0[f0.f];

                if (f0.dt == CTL_TYPE_DATE) {
                    if (o2[f0.f] instanceof Date) {
                        //27-Jun-2021,lhw-remove the time zone.
                        o2[f0.f] = dt_to_local_time(o2[f0.f]);
                    }
                }

                // let the hosting object to continue with other process.
                if (b2) {
                    obj_exec_proc(opt0, 'onSaveItemToDoc', [o0, o2]);
                }

            });

            // allows the hosting to patch the item data before appending to the data object.
            obj_exec_proc(opt0, 'onSaveToDoc', [o2]);

            o[opt0.itemLineFld].push(o2);
        });
    };

    //------------------------------------------------------------------------------
    //12-Jul-2023,lhw-collect the user input and stores in a temporary data object.
    // Returns:
    //  1. {o0, o2} OR
    //  2. null if validation failed when do_local_validate=true.
    //------------------------------------------------------------------------------
    po.saveFromEditingRow = function() {
        if (!internal.edit_row) {
            return null;
        }

        const c2 = internal.edit_row;
        // save the item line only if the callback allows to do so.
        const o2 = c2.data('data');

        // duplicate the data obj in case the user wants to undo the changes.
        const o20 = obj_copy(o2);
        const o22 = obj_copy(o20);

        let b = true;

        celLoop.each(opt0.fmap, function (f0) {
            // skip if the input elem is NULL.
            if (!f0.ci) {
                return;
            }

            const r2 = {};
            po.getEditingInputVal(f0, r2);
            // console.log(r2);

            //09-Aug-2023,lhw-local validation (ie, not using any ajax)
            // will run if `do_local_validate=true`.
            if (opt0.do_local_validate) {
                if (!celDataProc.validateUserInput(f0, r2.c2)) {
                    // to indicate validation failed
                    b = false;

                    // exit the loop
                    return false;
                }
            }

            o22[f0.f] = r2.v2;
        });

        if (b) {
            return {
                // the original data
                o0: o20,
                // the modified data
                o2: o22,
            };
        }
        else {
            return null;
        }
    }

    //------------------------------------------------------------------------------
    po.onEditItem = function (e2) {
        var c2;

        if (!po.getEnable()) {
            return;
        }

        if (po.isEditing()) {
            // discard the changes made at other item line.
            po.onUndoItem();
        }

        //26-Jun-2021,lhw-should ensure one process is running.
        if (!celClickOnce.acqLock('celItemLine.onEditItem')) {
            return;
        }

        const unlock = function () {
            celClickOnce.release('celItemLine.onEditItem');
        };

        if (typeof app != 'undefined') {
            obj_exec_proc(app, 'playSound');
        }

        c2 = celUI.getContainer(e2, opt0.itemCls);
        // console.log('onEditItem, o=', c2.data('data'));
        const o2 = c2.data('data') || {};

        //25-Jun-2021,lhw-
        const r = {
            c2: c2,
            o2: o2,

            // ok to edit
            resolve: function resolve_edit() {
                // show the details
                celLoop.each(opt0.fmap, function (f0) {
                    po.showInput(c2, o2, f0);
                });

                // show axn
                c2.find('.btn-i-edit').hide();
                c2.find('.btn-i-delete').hide();
                c2.find('.btn-i-save').show();
                c2.find('.btn-i-undo').show();

                internal.edit_mode = 1;
                internal.edit_row = c2;

                // the input controls are ready for editing.
                // allows the hosting object to continue any other ajax process.
                //14-Jul-2023,lhw-added 'o2'
                obj_exec_proc(opt0, 'onAfterEditItem', [c2, o2]);

                unlock();
            },

            // reject the edit request
            reject: function reject_edit() {
                unlock();
            }

        };

        //-------------------------
        if (obj_has_proc(opt0, 'onBeforeEditItem')) {
            obj_exec_proc(opt0, 'onBeforeEditItem', [r, r]);
        }
        else {
            r.resolve();
        }

    };

    //------------------------------------------------------------------------------
    // save the user input into the mem.
    //------------------------------------------------------------------------------
    po.onSaveItem = function (e2) {
        if (typeof app != 'undefined') {
            obj_exec_proc(app, 'playSound');
        }

        let c2 = celUI.getContainer(e2, opt0.itemCls);
        po.save(c2);
    };

    //-------------------------
    //31-Mar-2021,lhw-
    // - allows the hosting object to trigger the save item process.
    //-------------------------
    po.save = function (c2) {
        if (!celClickOnce.acqLock('celItemLine.save')) {
            return;
        }

        const unlock = function () {
            celClickOnce.release('celItemLine.save');
        };

        if (!c2) {
            c2 = internal.edit_row;
        }

        //12-Jul-2023,lhw-
        const user_input = po.saveFromEditingRow();

        //09-Aug-2023,lhw-for `opt0.do_local_validate=true` only.
        if (!user_input) {
            unlock();
            return;
        }

        //-------------------------
        //25-Jun-2021,lhw-
        const r = {
            c2: c2,

            //12-Jul-2023,lhw-original data
            o0: user_input.o0,
            // new data (before committing to the mem).
            o2: user_input.o2,

            // save the changes.
            resolve: function resolve_save() {
                // save the item line only if the callback allows to do so.
                const o2 = c2.data('data');
                celLoop.each(opt0.fmap, function (f0) {
                    // skip if the input elem is NULL.
                    if (!f0.ci) {
                        return;
                    }

                    // copy the value from the user input.
                    o2[f0.f] = r.o2[f0.f];
                });

                //03-Aug-2021,lhw-allows the host object to continue saving other fields that cannot be handle by above.
                //12-Jul-2023,lhw-change replace 'o20' with 'user_input.o0'.
                // obj_exec_proc(opt0, 'onAfterSaveItem0', [c2, o2, o20]);
                obj_exec_proc(opt0, 'onAfterSaveItem0', [c2, o2, user_input.o0]);

                //-------------------------
                po.hideInput();
                po.refCounter();

                obj_exec_proc(opt0, 'onAfterSaveItem', [c2, o2]);
                unlock();


                //08-Aug-2023,lhw-update the action option.
                if (!opt0.editable_on_all_line) {
                    ref_state_for_editable_on_all_line0();
                }

                if (!opt0.movable_on_all_line) {
                    // console.log('====>', o2)
                    ref_state_for_movable_on_all_line(o2, c2);
                }
            },

            // do not save the changes
            reject: function reject_save() {
                unlock();
            }

        };

        //-------------------------
        // validate input before saving the user input.
        if (obj_has_proc(opt0, 'onBeforeSaveItem')) {

            // the hosting object must call r.resolve() to accept the item line.
            // You may run some ajax process in onBeforeSaveItem() before calling r.resolve().
            obj_exec_proc(opt0, 'onBeforeSaveItem', [r, r]);

        }
        else {
            // if the hosting object did not implement onBeforeSaveItem, save the item line to mem.
            r.resolve();
        }

    };

    //------------------------------------------------------------------------------
    po.onDelItem = function (e2) {
        var o;

        if (!po.getEnable()) {
            return;
        }

        if (po.isEditing()) {
            po.onUndoItem();
        }

        if (!celClickOnce.acqLock('celItemLine.onDelItem')) {
            return;
        }

        const unlock = function () {
            celClickOnce.release('celItemLine.onDelItem');
        };

        if (typeof app != 'undefined') {
            obj_exec_proc(app, 'playSound');
        }

        //-------------------------
        function _do_delete_il() {
            // delete the data instead of the line

            //28-Oct-2021,lhw-we should reset the object while keeping it's ref.
            //  This allows the obj in mem to have the same content as it has been attached to the row.
            // let o0 =  o.o;
            // o.o = {};
            // o.c.data('data', o.o);

            let o0 = obj_copy(o.o);
            celLoop.each(Object.keys(o.o), function (k2) {
                delete o.o[k2];
            });

            if (opt0.removeRowOnDel) {
                //31-Mar-2021,lhw-
                o.c.remove();

                //<<==========
                //append a new row
                let il = po.getContainer();
                let opt = po.createItemLineCloneOpt();
                let o20 = {};
                celUI.clone(opt, o20);
                il.append(opt.c2);
                po.showItemLine(opt.c2, o20);
                //<<==========

                //08-Aug-2023,lhw-
                if (!opt0.editable_on_all_line) {
                    opt.c2.find('.btn-i-edit').hide();
                }

                o.c = opt.c2;
            }
            else {
                // remove the value from the ui.
                po.showItemLine(o.c, o.o);

                //08-Aug-2023,lhw-
                ref_state_for_editable_on_all_line0();
            }

            po.refCounter();
            unlock();

            obj_exec_proc(opt0, 'onAfterDelItem', [o.c, o0, o.row_idx]);

            if (opt0.del_msg) {
                msgbox.show(opt0.del_msg);
            }
        }

        //-------------------------
        o = celUI.getContainerInfo(e2, opt0.itemCls);

        //28-Oct-2021,lhw-passing the row_idx to onAfterDelItem so that it can further process it.
        const c0 = po.getContainer();
        const il = c0.find(elemCss(opt0.itemCls).wrap());

        //14-Jul-2023,lhw-moved to `r`.
        // o.row_idx = il.index(o.c);

        const r = {
            msg: opt0.del_confirm_msg,
            c2: o.c,
            o2: o.o,
            row_idx: il.index(o.c),

            resolve: function _resolve_delete_il() {
                if (r.msg) {
                    msgbox.confirm(r.msg,
                        _do_delete_il,
                        unlock);
                }
                else {
                    //11-Oct-2021,lhw-delete without cfm prompt.
                    _do_delete_il();
                }
            },

            reject: function reject_delete() {
                unlock();
            }
        };

        //-------------------------
        if (obj_has_proc(opt0, 'onBeforeDelItem')) {
            obj_exec_proc(opt0, 'onBeforeDelItem', [r, r]);
        }
        else {
            r.resolve();
        }
    };

    //------------------------------------------------------------------------------
    po.onUndoItem = function () {
        po.hideInput();
    };

    //------------------------------------------------------------------------------
    po.refCounter = function (skip_append_blank_line) {
        if (!opt0.counter) {
            return;
        }

        const cnt = [0, 0];
        const c0 = po.getContainer();
        //16-Mar-2023,lhw-bug fixed
        // il = c0.find(opt0._itemCls);
        const il = c0.find(elemCss(opt0.itemCls).wrap());

        celLoop.each(il, function (c20) {
            let b = po.isBlankItem($(c20));

            if (!b) {
                // non-blank
                cnt[0]++;
            }
            else {
                cnt[1]++;
            }
        });

        // console.log('cnt', cnt)

        if (opt0.counter) {
            text_set_val(opt0.counter, toInt(cnt[0]).toString());
        }

        // automatically append new 'batch' if all rows has been filled up.
        if (!skip_append_blank_line && cnt[1] == 0) {
            po.appendBlankLines();
        }

    };

    //------------------------------------------------------------------------------
    // populate a data object to an item line (ui).
    po.showItemLine = function (c2, o2) {
        o2 = o2 || {};
        // console.log('showItemLine', o2);

        // show the user data on screen.
        celLoop.each(opt0.fmap, function (f0) {
            let v = po.toDisplayValue(f0, o2);

            if (obj_has_proc(f0, 'show_value')) {
                //27-Jun-2021,lhw-allows hosting obj to call an user defined method
                // to show the data in the ui.
                obj_exec_proc(f0, 'show_value', [c2.find(f0._co), o2, v]);
            }
            else {
                if (f0.dt == CTL_TYPE_MEMO && !f0.disable_wrap_text) {
                    v = v.replace(/(\r\n|\n|\r)/g, '</br>');
                    c2.find(f0._co).html(v);
                }
                else {
                    // console.log(f0.f, f0._co, v );
                    text_set_val(c2.find(f0._co), v);
                }
            }
        });


        //29-Jun-2021,lhw-should call isBlankItem() to determine the state of the item line.
        // let is_empty = (Object.keys(o2).length == 0);
        // if (is_empty) {
        //     c2.find('.btn-i-delete').hide();
        // }
        let b = po.isBlankItem(c2);
        if (b) {
            c2.find('.btn-i-delete').hide();
        }
        else if (po.getEnable()) {
            c2.find('.btn-i-delete').show();
        }

        //08-Aug-2023,lhw-
        if (!opt0.movable_on_all_line) {
            ref_state_for_movable_on_all_line(o2, c2);
        }

        //01-Apr-2021,lhw-for hosting object to do some cosmetic works.
        obj_exec_proc(opt0, 'onShowItemLine', [c2, b, o2]);

    };

    //------------------------------------------------------------------------------
    // show the input fields/editors for the given item line.
    po.showInput = function (c2, o2, f0) {
        var c22, v;

        // skip if the input elem is NULL.
        if (!f0.ci) {
            return;
        }

        //10-Aug-2023,lhw-
        // let input_c = opt0.c0.find(f0._ci);
        let input_c = po.getTemplateContainer().find(f0._ci);

        let output_c = c2.find(f0._co);

        if (f0.ci2) {
            // get the actual input elem from the container (f0._ci).
            if (f0.dt == CTL_TYPE_CHECKBOX || f0.ct == CTL_TYPE_CHECKBOX) {
                c22 = input_c.find('.celchk');
            }
            else {
                c22 = input_c.find(f0._ci2);
            }
        }
        else {
            // the input elem.
            c22 = input_c;
        }

        //-------------------------
        // show the value
        if (obj_has_proc(f0, 'show_input')) {
            //04-Jul-2021,lhw-allows hosting obj to call an user defined method to show the data in the input field.
            v = obj_get_val(o2, f0.f);
            obj_exec_proc(f0, 'show_input', [c22, o2, v]);
        }
        else if (f0.dt == CTL_TYPE_DROPDONWLIST) {
            // the cbo item id will be treated as a 'field' that store its' value in a hidden elem.
            // Over here, we are handling the 'item text' only.
            v = obj_get_val(o2, f0.f);
            cbo_set_item_text(c22, v);
        }
        else if (f0.dt == CTL_TYPE_DATE) {
            v = toDate(obj_get_val(o2, f0.f));
            dt_set_val(c22, v);
        }
        else if (f0.dt == CTL_TYPE_CHECKBOX || f0.ct == CTL_TYPE_CHECKBOX) {
            //27-Jun-2021,lhw-
            v = intToBool(toInt(obj_get_val(o2, f0.f)));
            chk_set_val(c22, v);
        }
        else if (f0.dt == CTL_TYPE_CHECKBOX_LIST) {
            //08-Aug-2023,lhw-
            v = obj_get_val(o2, f0.f);
            chklist_set_val(c22, v);
        }
        else if (f0.dt == CTL_TYPE_RADIOLIST) {
            //08-Aug-2023,lhw-
            v = obj_get_val(o2, f0.f);
            rb_set_val(c22, v);
        }
        else {
            v = po.toDisplayValue(f0, o2);

            if (f0.dt == CTL_TYPE_MEMO && !f0.disable_wrap_text) {
                v = v.replace(/\<\/br\>/g, '\n');
                c22.val(v);
            }
            else {
                text_set_val(c22, v);
            }
        }

        //-------------------------
        // clear the content in the cell
        text_set_val(output_c, '');
        unhighlight_compulsory(input_c);

        // attach the input elem to the cell.
        input_c.detach();
        output_c.append(input_c);
    };


    //------------------------------------------------------------------------------
    po.hideInput = function () {
        if (!internal.edit_row) {
            return;
        }

        let c2 = internal.edit_row;
        let c0 = opt0.c0;

        //10-Aug-2023,lhw-
        // let ct = c0.find('.template-div');
        let ct = po.getTemplateContainer();

        // move the input control back to the template placeholder.
        celLoop.each(opt0.fmap, function (f0) {
            ct.append(c0.find(f0._ci).detach());
        });

        // show axn
        c2.find('.btn-i-edit').show();
        c2.find('.btn-i-save').hide();
        c2.find('.btn-i-undo').hide();

        //07-Aug-2023,lhw-this should be handled by `showItemLine()`.
        // //29-Jun-2021,lhw-should call isBlankItem() to determine the state of the item line.
        // // if (Object.keys(o2).length > 0) {
        // //     c2.find('.btn-i-delete').show();
        // // }
        // let b = po.isBlankItem(c2);
        // if (b) {
        //     c2.find('.btn-i-delete').hide();
        // }
        // else if (po.getEnable()) {
        //     c2.find('.btn-i-delete').show();
        // }

        // restore the value
        let o2 = c2.data('data');
        po.showItemLine(c2, o2);

        po.reset();
    };

    //------------------------------------------------------------------------------
    po.isBlankItem = function (c2) {
        if (!c2) {
            //27-Jun-2021,lhw-'c2' is optional.
            c2 = internal.edit_row;
        }

        if (c2) {
            if (obj_has_proc(opt0, 'onIsBlankItem')) {
                return obj_exec_proc(opt0, 'onIsBlankItem', [c2]);
            }
            else if (opt0.do_local_validate) {
                //09-Aug-2023,lhw-returns true if the nullable fields are empty.
                let b = false;

                celLoop.each(opt0.fmap, function (f0) {
                    if (f0.nullable === false && f0.co) {
                        if (isStrEmpty(text_get_val(c2.find(elemCss(f0.co).wrap())))) {
                            b = true;
                            // exit loop
                            return false;
                        }
                    }
                });

                return b;
            }
            else {
                let compulsory_input = elemCss(opt0.compulsory_input).wrap();
                return isStrEmpty(text_get_val(c2.find(compulsory_input)));
            }
        }

        return false;
    };


    //------------------------------------------------------------------------------
    //01-Apr-2021,lhw-
    po.onMoveItemUp = function (e2) {
        var c2, il;

        il = po.getContainer().find(elemCss(opt0.itemCls).wrap());
        c2 = celUI.getContainer(e2, opt0.itemCls);

        let idx = il.index(c2);
        if (idx == 0) {
            return;
        }

        let c3 = $(il[idx - 1]);
        c2.detach().insertBefore(c3);
    };

    //------------------------------------------------------------------------------
    //01-Apr-2021,lhw-
    po.onMoveItemDown = function (e2) {
        var c2, il;

        il = po.getContainer().find(elemCss(opt0.itemCls).wrap());
        c2 = celUI.getContainer(e2, opt0.itemCls);

        let idx = il.index(c2);

        if (idx == (il.length - 1)) {
            return;
        }

        let c3 = $(il[idx + 1]);
        c2.detach().insertAfter(c3);
    };


    //------------------------------------------------------------------------------
    //10-Aug-2023,lhw-
    po.getTemplateContainer = function() {
        if (opt0.ct0) {
            return opt0.ct0;
        }
        else {
            return opt0.c0.find('.template-div');
        }
    };

    //------------------------------------------------------------------------------
    //26-Jun-2021,lhw-
    po.createItemLineCloneOpt = function () {
        let opt = {};

        if (opt0.ct0) {
            //get from the specific template container.
            opt.ct0 = opt0.ct0;
        }
        else {
            // get from the main container.
            opt.c0 = opt0.c0;
        }

        opt.cls = opt0.itemTemplateCls;
        return opt;
    };

    //------------------------------------------------------------------------------
    //26-Jun-2021,lhw-returns the item template.
    po.getItemTemplate = function () {
        // var ct;
        // if (opt0.ct0) {
        //     //10-Jun-2021,lhw-
        //     ct = opt0.ct0.find(elemCss(opt0.itemTemplateCls).wrap());
        // }
        // else {
        //     ct = opt0.c0.find('.template-div ' + elemCss(opt0.itemTemplateCls).wrap());
        // }

        let i = elemCss(opt0.itemTemplateCls).wrap();
        let ct0 = po.getTemplateContainer();
        let ct = ct0.find(i);

        return ct;
    };

    //------------------------------------------------------------------------------
    //26-Jun-2021,lhw-build the input element and init it.
    po.initInput = function () {
        let s, ct0, cls, cls2, input_c;
        let dp_opt = { fld: {} };

        function review_cls2(f0) {
            if (!cls2) {
                f0.ci2 = cls + '-1';
                cls2 = f0.ci2;

                // refresh the internal setting.
                f0._refresh();
            }
        }

        // locate the template container
        ct0 = po.getTemplateContainer();

        //-------------------------
        // look through all the input elem - to ensure that the input editors are already in the container.
        //-------------------------
        celLoop.each(opt0.fmap, function (f0) {
            if (!f0.ci) {
                return;
            }

            cls = elemCss(f0.ci).unwrap();

            cls2 = null;
            if (f0.ci2) {
                cls2 = elemCss(f0.ci2).unwrap();
            }

            input_c = opt0.c0.find(f0._ctlCls);

            if (input_c.length == 0) {

                // inject the input field
                if (f0.hidden) {
                    // hidden field
                    s = $(`<div class="${cls}" style="display:none;"></div>`);
                }
                else if (f0.readonly) {
                    // readonly field.
                    s = $(`<div class="${cls}"></div>`);
                }
                else if (f0.popup) {
                    // this is a popup input field.
                    review_cls2(f0);

                    //12-Jul-2023,lhw-allows hosting control to change the icon class.
                    s = $(`
<div class="flx-nw ${cls}">
<div class="${cls2}"></div>
<div class="material-icons ${opt0.btn_select_cls} btn-select-${cls.replace('-input0', '')}"></div>
</div>
                    `);

                    // attach the click event handler if any.
                    if (f0.on_click) {
                        s.find(elemCss(cls).wrap()).on('click', f0.on_click);
                        //12-Jul-2023,lhw-
                        // s.find('.btn-select').on('click', f0.on_click);
                        s.find(elemCss(opt0.btn_select_cls).wrap()).on('click', f0.on_click);
                    }

                }
                else if (f0.dt == CTL_TYPE_DATE) {

                    review_cls2(f0);

                    //12-Jul-2023,lhw-allows hosting control to change the icon class.
                    s = $(`
<div class="flx-nw ${cls}">
<input class="${cls2}" type="text" placeholder="${f0.placeholder ||''}"/>
<div class="${opt0.btn_calendar_cls} btn-select-${cls2} material-icons"></div>
</div>
                    `);

                    if (typeof f0.ctlType == 'undefined' || f0.ctlType == null) {
                        f0.ctlType = CTL_TYPE_DATE;
                    }

                }
                else if (f0.dt == CTL_TYPE_CHECKBOX) {
                    review_cls2(f0);

                    if (f0.lbl) {

                        s = $(`
<div class="flx-nw ${cls}">
<div class="material-icons btn-checkbox0 ${cls2}"></div>
<div class="chk-lbl ${cls.replace('-input0', '')}0">${f0.lbl}</div>
</div>
                        `);
                    }
                    else {

                        s = $(`
<div class="flx-nw ${cls}">
<div class="material-icons btn-checkbox0 ${cls2}"></div>
</div>
                        `);
                    }

                    if (typeof f0.fmt == 'undefined' || f0.fmt == null) {
                        f0.fmt = 'yn';
                    }

                    if (typeof f0.ctlType == 'undefined' || f0.ctlType == null) {
                        f0.ctlType = CTL_TYPE_CHECKBOX;
                    }

                }
                else if (f0.dt == CTL_TYPE_MEMO) {
                    s = `<textarea class="${cls}"`;

                    if (f0.maxlength) {
                        s += ` maxlength="${f0.maxlength}"`;
                    }

                    s += '></textarea>';
                    s = $(s);
                }
                else if (f0.dt == CTL_TYPE_CHECKBOX_LIST) {
                    //08-Aug-2023,lhw-
                    s = $(`<div class="${cls}"></div>`);

                    if (f0.item_list) {
                        chklist_make(s, f0.item_list, f0.item_list_opt);
                    }
                }
                else if (f0.dt == CTL_TYPE_RADIOLIST) {
                    //08-Aug-2023,lhw-
                    s = $(`<div class="${cls}"></div>`);

                    if (f0.item_list) {
                        rb_make(s, f0.item_list, item_list_opt);
                    }
                }
                else {
                    s = `<input type="text" class="${cls}" placeholder="${f0.placeholder ||''}"`;

                    if (f0.maxlength) {
                        s += ` maxlength="${f0.maxlength}"`;
                    }

                    s += '/>';
                    s = $(s);
                }

                // append the input editor.
                // console.log('inject ', s);
                ct0.append(s);
            }

            //-------------------------
            // we need the field map for initInput().
            dp_opt.fld[f0.f] = f0;

        });

        // console.log(opt0.fmap);
        // console.log(dp_opt);


        // Calls celDataProc.initInput() to init the input editors (numeric, date, checkbox, etc).
        // (standardize the init process.)
        const dp2 = {};
        celDataProc(dp2, dp_opt);

        //10-Aug-2023,lhw-
        dp2.initInput(ct0);
    };

    //------------------------------------------------------------------------------
    //26-Jun-2021,lhw-inject the necessary html tags to ease the ui design.
    // It will inject the tags into the template section.
    po.initAxnOptions = function () {
        if (opt0.inject_edit_axn || opt0.inject_move_axn) {
            //reset the content before injecting any new tags.
            po.getItemTemplate().find('.item-axn').html('');
        }

        if (opt0.inject_edit_axn) {
            let s = [];
            s.push('<div class="material-icons btn-i-edit" title="Edit item line"></div>');
            s.push('<div class="material-icons btn-i-delete" title="Clear item line"></div>');
            s.push('<div class="material-icons btn-i-save" title="Save changes in the item line" style="display: none;"></div>');
            s.push('<div class="material-icons btn-i-undo" title="Undo the changes" style="display: none;"></div>');

            // find the item template, ibject the above to 'item-axn' div.
            po.getItemTemplate().find('.item-axn').append($(s.join('')));
        }

        if (opt0.inject_move_axn) {
            let s = [];
            s.push('<div class="material-icons move-axn btn-i-move-up" title="Move up"></div>');
            s.push('<div class="material-icons move-axn btn-i-move-down" title="Move down"></div>');

            // find the item template, ibject the above to 'item-axn' div.
            po.getItemTemplate().find('.item-axn').append($(s.join('')));
        }
    };

    //------------------------------------------------------------------------------
    //28-Jun-2021,lhw-enable/disable the editing.
    po.setEnable = function (b, il) {

        opt0.enable = b;
        po.hideInput();

        if (!il) {
            const c0 = po.getContainer();
            il = c0.find(elemCss(opt0.itemCls).wrap());
        }

        if (b) {
            // show edit, move up and down.
            let state1 = [
                'btn-i-edit',
            ];

            //08-Aug-2023,lhw-
            if (opt0.movable_on_all_line) {
                state1.push('btn-i-move-up');
                state1.push('btn-i-move-down');
            }

            let state2 = [
                'btn-i-edit',
                'btn-i-delete',
                'btn-i-move-up',
                'btn-i-move-down',
            ];

            let h_editable_on_all_line;

            celLoop.each(il, (c20) => {
                const c2 = $(c20);
                const o20 = c2.data('data');

                // check to see if the item line is blank or not.
                // skip saving if the compulsory field is empty.
                if (po.isBlankItem(c2)) {
                    hide_input(c2, state1, false);

                    //08-Aug-2023,lhw-
                    if (!opt0.editable_on_all_line) {
                        h_editable_on_all_line = ref_state_for_editable_on_all_line(o20, c2, h_editable_on_all_line);
                    }
                }
                else {
                    hide_input(c2, state2, false);
                }
            });

        }
        else {

            hide_input(il,
                [
                    'btn-i-edit',
                    'btn-i-delete',
                    'btn-i-save',
                    'btn-i-undo',
                    'btn-i-move-up',
                    'btn-i-move-down',
                ]);

        }
    };

    //-------------------------
    //28-Jun-2021,lhw-returns the status of enable/disable from editing.
    po.getEnable = function () {
        return opt0.enable;
    };

    //-------------------------
    //08-Aug-2023,lhw-change the settings at runtime
    po.setOption = function(opt, v) {
        opt0[opt] = v;
        // console.log(opt, v)

        if (opt == 'editable_on_all_line') {
            po.onUndoItem();
            ref_state_for_editable_on_all_line0();
        }
        else if (opt == 'movable_on_all_line') {
            po.onUndoItem();
            ref_state_for_movable_on_all_line0();
        }
    };


    //08-Aug-2023,lhw-refresh the state for 1 line
    function ref_state_for_editable_on_all_line(o2, c2, h_editable_on_all_line) {
        if (Object.keys(o2).length == 0) {
            if (!h_editable_on_all_line){
                c2.find('.btn-i-edit').show();
                h_editable_on_all_line = true;
            }
            else {
                c2.find('.btn-i-edit').hide();
            }
        }

        return h_editable_on_all_line;
    };

    //08-Aug-2023,lhw-refresh the state for all lines.
    function ref_state_for_editable_on_all_line0() {
        const c0 = po.getContainer();
        const il = c0.find(elemCss(opt0.itemCls).wrap());
        let h_editable_on_all_line;

        celLoop.each(il, (c20) => {
            const c2 = $(c20);
            const o20 = c2.data('data');

            // check to see if the item line is blank or not.
            // skip saving if the compulsory field is empty.
            if (po.isBlankItem(c2)) {
                if (opt0.editable_on_all_line) {
                    c2.find('.btn-i-edit').show();
                }
                else {
                    h_editable_on_all_line = ref_state_for_editable_on_all_line(o20, c2, h_editable_on_all_line);
                }
            }
        });
    }


    //08-Aug-2023,lhw-refresh the state for 1 line
    function ref_state_for_movable_on_all_line(o2, c2) {
        if (Object.keys(o2).length == 0) {
            if (opt0.movable_on_all_line){
                c2.find('.btn-i-move-up').show();
                c2.find('.btn-i-move-down').show();
            }
            else {
                c2.find('.btn-i-move-up').hide();
                c2.find('.btn-i-move-down').hide();
            }
        }
        else {
            c2.find('.btn-i-move-up').show();
            c2.find('.btn-i-move-down').show();
        }
    };

    //08-Aug-2023,lhw-refresh the state for all lines.
    function ref_state_for_movable_on_all_line0() {
        const c0 = po.getContainer();
        const il = c0.find(elemCss(opt0.itemCls).wrap());

        celLoop.each(il, (c20) => {
            const c2 = $(c20);
            const o20 = c2.data('data');

            if (po.isBlankItem(c2)) {
                ref_state_for_movable_on_all_line(o20, c2);
            }
        });
    }


    //------------------------------------------------------------------------------
    // auto-init
    //------------------------------------------------------------------------------

    opt0.il.on('click', '.btn-i-edit', po.onEditItem);
    opt0.il.on('click', '.btn-i-delete', po.onDelItem);
    opt0.il.on('click', '.btn-i-save', po.onSaveItem);
    opt0.il.on('click', '.btn-i-undo', po.onUndoItem);

    opt0.il.on('click', '.btn-i-move-up', po.onMoveItemUp);
    opt0.il.on('click', '.btn-i-move-down', po.onMoveItemDown);

    // convert the field to proxy.
    celLoop.each(opt0.fmap, function (f0, idx) {
        opt0.fmap[idx] = new Proxy(f0, celDataFieldHandler);
    });

}


//==============================================================================
/*
05-Jul-2021,lhw
- Using Proxy to overcome the field map structure difference between celDataProc() and celItemLine().
  With this new class, the hosting object may defined 'ct' or 'ctlType' and this proxy will translate
  look for the value either in 'ct' or 'ctlType'.

*/


const celDataFieldHandler = {

    has: function (o, n) {

        if (n == 'ctlCls' || n == 'c2' || n == 'ci') {
            // returns the value that was originally setup.
            return !!(o.ctlCls || o.c2 || o.ci);
        }

        // for display control.
        if (n == '_itemCtlCls' || n == '_ic2' || n == '_co') {
            // returns the css class name starts with '.'
            return !!(o._internal._itemCtlCls);
        }

        if (n == 'itemCtlCls' || n == 'ic2' || n == 'co') {
            // returns the value that was originally setup.
            return !!(o.itemCtlCls || o.ic2 || o.co);
        }

        if (n == 'ctlType' || n == 'ct') {
            return !!(o.ctlType || o.ct);
        }

        if (n == 'dataType' || n == 'dt') {
            return !!(o.dataType || o.dt);
        }

        if (n == 'compulsoryMsg' || n == 'cm') {
            //07-Dec-2022,lhw-auto generate the compulsory msg.
            if (o.nullable === false && o.text) {
                return true;
            }

            return !!(o.compulsoryMsg || o.cm || null);
        }

        //09-Aug-2023,lhw-
        if (n == 'maxlen' || n == 'maxLen' || n == 'maxlength' || n == 'maxLength') {
            return !!(o.maxlen || o.maxLen || o.maxlength || o.maxLength);
        }

        return n in o;
    },

    set: function (o, n, v) {
        // allows any setting to the object but we might use different 'name'!
        o[n] = v;
    },

    get: function (o, n) {

        if (n == 'compulsoryMsg' || n == 'cm') {

            //07-Dec-2022,lhw-auto generate the compulsory msg.
            if (o.nullable === false && o.text) {
                return `${o.text} cannot be blank`;
            }

            return o.compulsoryMsg || o.cm || null;
        }

        if (!o._internal) {
            o._internal = {};
        }

        // patch the settings once.
        if (!o._internal.patch) {
            this.patchSetting(o);
            o._internal.patch = true;
        }

        //-------------------------
        // synonymous field name.
        //-------------------------

        // for input control.
        if (n == '_ctlCls' || n == '_c2' || n == '_ci') {
            // returns the css class name starts with '.'
            return o._internal._ctlCls;
        }

        if (n == '_ci2' || n == '_c22' || n == '_ctlCls2') {
            // returns the css class name starts with '.'
            return o._internal._ctlCls2;
        }

        if (n == 'ctlCls' || n == 'c2' || n == 'ci') {
            // returns the value that was originally setup.
            return o.ctlCls || o.c2 || o.ci;
        }

        // for display control.
        if (n == '_itemCtlCls' || n == '_ic2' || n == '_co') {
            // returns the css class name starts with '.'
            return o._internal._itemCtlCls;
        }

        if (n == 'itemCtlCls' || n == 'ic2' || n == 'co') {
            // returns the value that was originally setup.
            return o.itemCtlCls || o.ic2 || o.co;
        }

        if (n == 'ctlType' || n == 'ct') {
            return o.ctlType || o.ct;
        }

        if (n == 'dataType' || n == 'dt') {
            return o.dataType || o.dt;
        }

        if (n == 'negative' || n == 'neg') {
            //18-Oct-2021,lhw-
            if (o.hasOwnProperty('negative')) {
                return o.negative;
            }

            if (o.hasOwnProperty('neg')) {
                return o.neg;
            }

            return false;
        }

        //09-Aug-2023,lhw-
        if (n == 'maxlen' || n == 'maxLen' || n == 'maxlength' || n == 'maxLength') {
            return o.maxlen || o.maxLen || o.maxlength || o.maxLength;
        }

        //-------------------------
        // function call.
        //-------------------------
        // to indicate the object is proxy.
        if (n == '_isProxy') {
            return true;
        }

        if (n == '_refresh') {
            let self = this;
            return function () {
                self.patchSetting(o);
            };
        }

        if (n == 'hasOwnProperty') {
            if (!o._internal['_hasOwnProperty']) {
                let self = this;
                o._internal['_hasOwnProperty'] = function (...args) {
                    let result = self.has(o, args[0]);
                    return result;
                };
            }
            return o._internal['_hasOwnProperty'];
        }

        //-------------------------
        let v = o[n];

        if (typeof v == 'function') {

            // handling the function call on behalf of the field object.
            // We cache the new function for reuse.
            if (!o._internal[n]) {
                o._internal[n] = function (...args) {
                    let result = v.apply(o, args);
                    return result;
                };
            }

            return o._internal[n];
        }
        else {
            return v;
        }
    },

    hasFld: function (o, ...n) {
        let i = 0;

        do {
            if ((typeof o[n[i]] != 'undefined') && (o[n[i]] != null)) {
                return true;
            }
        } while (n.length > ++i)

        return false;
    },

    patchSetting: function (o) {

        // update the data type & control type if 'fmt' has been set.
        if (o.fmt) {

            // infer the dataType and ctlType with fmt.
            if (o.fmt == 'yn') {
                // for checkbox, dataType can be either CTL_TYPE_NUMERIC or CTL_TYPE_CHECKBOX.
                o.dataType = CTL_TYPE_CHECKBOX;

                if (!this.hasFld(o, 'ctlType', 'ct')) {
                    o.ctlType = CTL_TYPE_CHECKBOX;
                }
            }
            else if (o.fmt[0] == 'd'
                // time
                || o.fmt[0] == 't'
                // month+year
                || o.fmt == 'my'
            ) {
                o.dataType = CTL_TYPE_DATE;

                if (!this.hasFld(o, 'ctlType', 'ct')) {
                    o.ctlType = CTL_TYPE_DATE;
                }
            }
            else if (o.fmt[0] == 'm') {
                o.dataType = CTL_TYPE_NUMERIC;

                if (!this.hasFld(o, 'ctlType', 'ct')) {
                    o.ctlType = CTL_TYPE_NUMERIC;
                }
            }
        }
        else {
            // if 'fmt' setting is missing, we have to do the following.

            // without 'ctlType' field, 'compulsoryMsg' will not work.
            if (!this.hasFld(o, 'ctlType', 'ct')) {

                if ((o.dataType || o.dt) == CTL_TYPE_NUMERIC) {
                    // for numeric data type, set the control type as numeric
                    o.ctlType = CTL_TYPE_NUMERIC;

                    if (!o.fmt) {
                        o.fmt = 'm0';
                    }
                }
                if ((o.dataType || o.dt) == CTL_TYPE_DATE) {
                    o.ctlType = CTL_TYPE_DATE;

                    if (!o.fmt) {
                        o.fmt = 'd';
                    }
                }
                else if ((o.dataType || o.dt) == CTL_TYPE_MONEY) {
                    o.ctlType = CTL_TYPE_NUMERIC;

                    // set default format string is money (currency).
                    if (!o.fmt) {
                        o.fmt = 'm2';
                    }
                }
                else if ((o.dataType || o.dt) == CTL_TYPE_CHECKBOX) {
                    o.ctlType = CTL_TYPE_CHECKBOX;

                    // set default format
                    if (!o.fmt) {
                        o.fmt = 'yn';
                    }
                }
            }
        }

        //-------------------------
        // set the default data type.
        if (!this.hasFld(o, 'dataType', 'dt')) {
            o.dataType = CTL_TYPE_TEXT;
        }

        // set the default control type.
        if (!this.hasFld(o, 'ctlType', 'ct')) {
            o.ctlType = CTL_TYPE_TEXT;
        }
        else if (((o.ctlType || o.ct) == CTL_TYPE_HTML)
            && !this.hasFld(o, 'dataType', 'dt')
        ) {
            o.dataType = CTL_TYPE_TEXT;
        }

        //-------------------------
        // cache the elem css class for jquery. This will be done once and will
        // speed up the data population process especially for item line/list.
        //-------------------------

        let c = o.ctlCls || o.c2 || o.ci;
        if (c) {
            o._internal._ctlCls = elemCss(c).wrap();
        }

        c = o.ci2;
        if (c) {
            o._internal._ctlCls2 = elemCss(c).wrap();
        }

        c = o.itemCtlCls || o.ic2 || o.co;
        if (c) {
            o._internal._itemCtlCls = elemCss(c).wrap();
        }
    }
}

//==============================================================================
/*
11-Aug-2023,lhw-
- Saves the user input into localStorage and load it back when the UI init/reload.

Use case:
- The search bar in the listing screen.


Sample,

```
search_box.user_pref = function() {};
celUserPref({
    po: search_box.user_pref,
    c0: c0,
    // destroyer: mainForm,             //<<==========this works like 'mainForm.destroyer' (auto inference).
    // destroyer: mainForm.destroyer,   //<<==========this is a long and specific pointing.

    name: 'my-search-pref',

    //if true, the localStorage will not be touch.
    // skip_update_store: false,

    fld: {
        start_dt: {c2: 'search-start-dt', ct: CTL_TYPE_DATE, nullable: false, text:'Start date', defVal: 'today-7' },
        end_dt: {c2: 'search-end-dt', ct: CTL_TYPE_DATE, nullable: false, text:'End date', defVal: 'today' },
        search_text: {c2: 'search-text', maxlen: 255},
    },


    // onInitInput2: function(entryObj) {},
    // onNewItemClick2: function(entryObj) {},
    // onValidateInput2: function(entryObj, p) {},
    // onGetUserInput2: function(entryObj, o) {},
});
```


*/

function celUserPref(opt0) {
    console.assert(!isStrEmpty(opt0.name), 'celUserPref:opt0.name cannot be null' );

    let def_opt = {
        // the container that holds the input element to be saved to localStorage.
        c0: null,

        // the parent object (must be a function type for destroyer to work).
        po: null,

        // an instance of celDestroyer(). It should be hold by the main container.
        destroyer: null,

        // the user preference name.
        name: 'user_pref1',

        // if true, the localStorage will not be updated.
        skip_update_store: false,

        /*
        - 'fmap' is an array of the field mapping where the field has the following structure:
            f       - the field name.
            ci      - elem for capture input.
            [dt]    - the data type

        */
        fld: [],


        // for init the input fields.
        // param: entryObj
        onInitInput2: null,


        // pre-validation process.
        // param: entryObj, p
        onValidateInput20: null,

        // custom validation.
        // param: entryObj, p
        onValidateInput2: null,

        // save the data from ui
        // param: entryObj, o
        onGetUserInput2: null,

        // clear the entry form.
        // param: entryObj
        onNewItemClick2: null,

    };

    opt0 = $.extend(def_opt, opt0);

    // for saving to localStorage, it must be in sys date format.
    opt0.fmtDateInSysFmt = true;
    opt0.inject_common_fn = true;

    const po = opt0.po;
    let dp2 = {};
    celDataProc(dp2, opt0);

    //-------------------------
    po.getContainer = function () {
        return opt0.c0;
    };

    // restore the user pref.
    po.load = function () {
        po.reset();

        if (!opt0.skip_update_store) {
            const pref = data.get_obj(opt0.name);
            if (pref) {
                // show the data on screen.
                dp2.editData(pref);
            }

            return pref;
        }
    };

    // save the user pref to localStorage.
    po.save = function (to_sys_dt) {
        const pref = {};
        if (!dp2.validateInput(pref)) {
            return null;
        }

        if (!opt0.skip_update_store) {
            data.set_value(opt0.name, pref);
        }

        if (!to_sys_dt) {
            const k2 = Object.keys(opt0.fld);
            celLoop.each(k2, function(k3) {
                if (opt0.fld[k3].ctlType == CTL_TYPE_DATE) {
                    pref[k3] = toDate(pref[k3]);
                }
            });
        }

        return pref;
    };

    // reset all input fields
    po.reset = function(clear_pref) {
        dp2.onNewItemClick();

        if (clear_pref) {
            if (!opt0.skip_update_store) {
                data.remove(opt0.name);
            }
        }
    };

    // get the input field by field name
    po.getEditingInput = function(fld) {
        return dp2.getEditingInput(fld);
    };

    // returns all fields that has been setup.
    po.getFields = function() {
        return opt0.fld;
    };

    po.destroy = function() {
        dp2.destroy();
        dp2 = null;
        opt0 = null;
    };

    //-------------------------
    // startup
    dp2.initInput();
    po.load();

    if (opt0.destroyer) {
        let d;

        if (opt0.destroyer.getType && opt0.destroyer.getType() == 'celDestroyer') {
            d = opt0.destroyer;
        }
        else if (opt0.destroyer.destroyer.getType && opt0.destroyer.destroyer.getType() == 'celDestroyer') {
            d = opt0.destroyer.destroyer;
        }

        if (d) {
            d.add(po, true);
        }
        else {
            throw new Error('opt0.destroyer must be an instance of celDestroyer()');
        }
    }
};




//==============================================================================
/*
12-Aug-2023,lhw-
- This proc helps to do the following
    - Load the data from server with scroll pager support (optional).
    - It loads/saves the user pref from/to localStorage.

Sample,

    appAuditLog.item_list = function() {};
    celItemList({
        po: appAuditLog.item_list,
        destroyer: appAuditLog,
        c0: c0,
        // ct0: null,
        il0: 'al-il0',
        // ct_item_div: 'item-div0',
        // ct_no_data: 'no-data',
        spinner0: c0.find('.al-sb-l'),
        rec_cnt0: 'rec-cnt',

        ajax_cmd: 'audit-log',
        ajax_cmd_axn: 'l',
        // big_list: true,

        // group_fld: 'floor_no',
        // group_sort_fld: [ 'fl_disp_seq', 'floor_no', 'display_seq', 'room_no'],
        // ct_item_div_group: 'item-group-div0',
        // group_title0: 'item-group-title',

        // the settings for celDataProc()
        data_proc: {
            fld: {
                created_on: { ic2: 'al-dt', fmt: 'dt3' },
                created_by: { ic2: 'al-by' },
                msg: { ic2: 'al-msg' },
                status: {
                    ic2: 'al-status',
                    show_value: function(c2, o2, v0) {
                        text_set_val(c2, 'some text');
                    }
                },
            },
            // onFmtItem2: function (itemObj, o) {
            //     if (toInt(o.is_in_use) == 0) {
            //         itemObj.find('.inactive').show();
            //     }
            // }
        },

        // the settings for celUserPref()
        user_pref: {
            name: 'al-his-pref',
            fld: {
                start_dt: {c2: 'search-start-dt', ct: CTL_TYPE_DATE, nullable: false, text:'Start date', defVal: 'today-7' },
                end_dt: {c2: 'search-end-dt', ct: CTL_TYPE_DATE, nullable: false, text:'End date', defVal: 'today' },
                msg: {c2: 'search-txt', maxlen: 255},
            }
        },

        // onInit: function() {},
        // onGetListParam: function(p2) {},
        // onList0: function(d2) {},
        // onList: function(d2) {},

        //17-Sep-2023,lhw-
        // enable_filter: true,
        // filter_input: '.search-txt',
        // match_field: ['prod_code','prod_desc','barcode'],

        // For implementing a user defined matching process. Otherwise, set this to null.
        // onMatching: function (o2, r) { r.f: true; }

    });

*/
function celItemList(opt0) {

    const def_opt = {
        // the parent object (must be a function type for destroyer to work).
        po: null,

        // an instance of celDestroyer(). It should be hold by the main container.
        destroyer: null,

        // the container that holds the input element to be saved to localStorage.
        c0: null,

        // the ref to 'template-div '.
        ct0: null,
        il0: 'il0',
        ct_item_div: 'item-div0',
        ct_no_data: 'no-data',

        // the spinner container
        spinner0: null,

        // the record counter placeholder.
        rec_cnt0: 'rec-cnt',

        ajax_cmd: null,
        ajax_cmd_axn: 'l',

        // if true, setup the scroll pager.
        big_list: false,

        // if true, you will have to call `onSearch()` manually.
        skip_list_on_init: null,

        // the settings for celDataProc()
        data_proc: null,

        // the settings for celUserPref()
        user_pref: null,

        //-------------------------
        // for grouping the items
        //-------------------------

        // group field name (support 1 field name only)
        group_fld: null,

        // for sorting the data.
        // type: string[]
        group_sort_fld: null,

        // the group template
        ct_item_div_group: null,

        // the group title placeholder
        group_title0: null,

        // for internal used
        is_first_run: true,

        //-------------------------
        // for init the input fields.
        // onInit: function() {},
        onInit: null,

        // review the search param value.
        // onGetListParam: function(p2) {},
        //  - param: p (ie, the param to be pass to the ajax server).
        onGetListParam: null,

        // Before building the ui.
        // onList0: function(d2) {},
        onList0: null,

        // after the list has been loaded onto the screen.
        // - param: d2 - the ajax result.
        // onList: function(d2) {},
        onList: null,

        //-------------------------
        //17-Sep-2023,lhw-
        enable_filter: null,

        // the filter input elem. Either JQuery obj or css class name.
        filter_input: null,

        // an array of the field to be match.
        match_field: null,

        // the interval to wait for user input before performing the filtering process.
        // Set it to null to disable this feature (after disabled, it will be slow for any large item list).
        filter_delay_ms: 1000,

        // For implementing a user defined matching process. Otherwise, set this to null.
        // onMatching: function (o2, r) { r.f: true; }
        //
        // where
        //  - 'o' is the object to be match.
        //  - r = { f: false } => stores the result. 'f'-found.
        //
        onMatching: null,
        //-------------------------

    };

    opt0 = $.extend(def_opt, opt0);
    opt0.item_div_cls = opt0.ct_item_div.substring(0, opt0.ct_item_div.length - 1);

    const po = opt0.po;

    //13-Aug-2023,lhw-
    po.getType = function() { return 'celItemList'; };

    po.getContainer = function () {
        return opt0.c0;
    };

    po.getItemListContainer0 = function () {
        return opt0.c0.find(elemCss(opt0.il0).wrap());
    };

    po.getItemListContainer = function () {
        return opt0.c0.find(elemCss(opt0.il0).wrap() + '>div');
    };

    po.getTemplateContainer = function () {
        if (opt0.ct0) {
            return opt0.ct0;
        }
        return opt0.c0.find('.template-div');
    };

    po.getOptions = function () {
        return opt0;
    };

    // returns true if the `list()` is running for the first round.
    po.isFirstRun = function() {
        return opt0.is_first_run;
    };

    //------------------------------------------------------------------------------
    // startup
    po.init = function () {

        // init data proc
        po.data_proc = function() {};
        opt0.data_proc.c0 = opt0.c0;
        opt0.data_proc.inject_common_fn = true,
        celDataProc(po.data_proc, opt0.data_proc);

        // init user pref
        if (opt0.user_pref) {
            po.user_pref = function() {};
            opt0.user_pref.c0 = opt0.c0;
            opt0.user_pref.po = po.user_pref;
            opt0.user_pref.destroyer = opt0.destroyer;
            celUserPref(opt0.user_pref);
        }

        if (opt0.spinner0) {
            progress.addSpinnerFunc(po, opt0.spinner0);
        }

        // continue with exec the user defined init process
        if (obj_has_fld(po, opt0, 'onInit')){
            obj_exec_proc(po, opt0, 'onInit', []);
        }

        //-------------------------
        // init the scrolling data loader
        if (opt0.big_list) {
            po.scroll_pager = function () { };
            celScrollingDataLoader(po.scroll_pager, po, po.getItemListContainer0());
        }

        if (!opt0.skip_list_on_init) {
            po.list();
        }

        if (opt0.destroyer) {
            let d;

            if (opt0.destroyer.getType && opt0.destroyer.getType() == 'celDestroyer') {
                d = opt0.destroyer;
            }
            else if (opt0.destroyer.destroyer.getType && opt0.destroyer.destroyer.getType() == 'celDestroyer') {
                d = opt0.destroyer.destroyer;
            }

            if (d) {
                d.add('scroll_pager', true, po);
                d.add('data_proc', true, po);

                d.add(function() {
                    opt0 = null;
                });
            }
            else {
                throw new Error('opt0.destroyer must be an instance of celDestroyer()');
            }
        }


        //<<====
        //17-Sep-2023,lhw-
        if (opt0.enable_filter) {
            const search_c2 = _filter_get_search_input();

            if (opt0.filter_delay_ms) {
                opt0.lz_search = celListFilter.createLazySearch({
                    c2: search_c2,
                    list_cb: _filter_item,
                    delay_ms: opt0.filter_delay_ms
                });
            }
            else {
                search_c2.off('keypress keyup')
                    .on('keypress keyup', _filter_item);
            }
        }
        //<<====

    };


    //------------------------------------------------------------------------------
    /**
     * to integrate with celScrollingDataLoader().
     */
    po.list = function () {
        if (opt0.spinner0) {
            po.showSpinner(true);
        }

        const p2 = (opt0.user_pref ? po.user_pref.save() : {});

        if (opt0.big_list) {
            p2.start_row = po.scroll_pager.getStartRowIdx();
            p2.max_row = po.scroll_pager.getMaximumRows();
        }

        const p0 = {
            code: opt0.ajax_cmd,
            axn: opt0.ajax_cmd_axn,
            data: p2,
        };

        if (obj_has_fld(po, opt0, 'onGetListParam')) {
            obj_exec_proc(po, opt0, 'onGetListParam', [p0]);
        }

        ajaxCall({
            p: p0,
            on_success: celItemLine_onList,
            on_fail: function() {
                if (opt0.spinner0) {
                    po.showSpinner(false);
                }
            }
        });
    };

    //------------------------------------------------------------------------------
    function celItemLine_onList(d) {
        // to integrate with celScrollingDataLoader().
        if (d) {
            po.data = d;
        }

        const l0 = po.getDataList();
        const c0 = po.getContainer();
        const il = po.getItemListContainer();

        if (opt0.rec_cnt0) {
            let cnt = null;
            if (arrLen(d.data.rec_cnt) > 0) {
                cnt = d.data.rec_cnt[0].rec_count;
            }

            if (cnt == null) {
                cnt = arrLen(l0);
            }

            text_set_val(c0.find(elemCss(opt0.rec_cnt0).wrap()), formatValue(cnt, 'm0'));
        }

        //-------------------------
        if (arrLen(l0) == 0
            && (
                !opt0.big_list
                || (opt0.big_list && arrLen(po.getDataListFromMem().data) == 0)
            )
        ) {
            po.appendNoDataItem();
        }
        else {

            if (obj_has_fld(po, opt0, 'onList0')) {
                obj_exec_proc(po, opt0, 'onList0', [po.data]);
            }

            const opt = po.getCloneItemOption();

            const has_match_f = obj_has_proc(po, opt0, 'onMatching');
            const r = {f:true};
            let filter_text;

            if (opt0.enable_filter) {
                filter_text = _filter_get_search_text();
            }

            if (opt0.group_fld) {
                //-------------------------
                // build the list with grouping
                //-------------------------

                // sort data
                arrSort2(l0, opt0.group_sort_fld || opt0.group_fld);

                // loop items, create group item if needed, append item.
                const ct0 = po.getTemplateContainer();
                const opt_g = {
                    ct: ct0.find(elemCss(opt0.ct_item_div_group).wrap()),
                    cls: opt0.ct_item_div_group,
                };

                let prev, g_il;
                celLoop.each(l0, function (o2) {
                    celUI.clone(opt, o2);
                    po.data_proc.fmtItem(opt.c2, o2);

                    if (!prev || prev != o2[opt0.group_fld]) {
                        prev = o2[opt0.group_fld];
                        celUI.clone(opt_g);

                        text_set_val(opt_g.c2.find(elemCss(opt0.group_title0).wrap()), prev);

                        // append group
                        il.append(opt_g.c2);
                        g_il = opt_g.c2.find('.il2');
                    }

                    // append item
                    g_il.append(opt.c2);

                    //<<====
                    if (opt0.enable_filter) {
                        r.f = true;
                        _filter_on_matching(o2, r, filter_text, has_match_f);
                        if (r.f) {
                            opt.c2.show();
                        }
                        else {
                            opt.c2.hide();
                        }
                    }
                    //<<====
                });
            }
            else {
                //-------------------------
                // build the list without any grouping
                //-------------------------

                celLoop.each(l0, function (o2) {
                    celUI.clone(opt, o2);
                    po.data_proc.fmtItem(opt.c2, o2);
                    il.append(opt.c2);

                    //<<====
                    if (opt0.enable_filter) {
                        r.f = true;
                        _filter_on_matching(o2, r, filter_text, has_match_f);
                        if (r.f) {
                            opt.c2.show();
                        }
                        else {
                            opt.c2.hide();
                        }
                    }
                    //<<====
                });
            }
        }

        if (obj_has_fld(po, opt0, 'onList')) {
            obj_exec_proc(po, opt0, 'onList', [po.data]);
        }

        if (opt0.spinner0) {
            po.showSpinner(false);
        }

        opt0.is_first_run = false;
    };

    // rebuild the item list.
    po.refList = function(group_fld, group_sort_fld) {
        if (group_fld) {
            opt0.group_fld = group_fld;
        }

        if (group_sort_fld) {
            opt0.group_sort_fld = group_sort_fld;
        }

        po.getItemListContainer().html('');
        celItemLine_onList();
    };

    // returns a new item ui.
    po.getCloneItemOption = function() {
        const ct0 = po.getTemplateContainer();
        const opt = {
            ct: ct0.find(elemCss(opt0.ct_item_div).wrap()),
            cls: opt0.ct_item_div,
        };

        return opt;
    };

    // append new item to the item list.
    // Notes: this is not for bulk insert and it is slow.
    po.appendItem = function(c2) {
        po.getItemListContainer().append(c2);
    };

    // append 'no-data' elem to the item list container.
    po.appendNoDataItem = function() {
        const il = po.getItemListContainer();
        const ct0 = po.getTemplateContainer();
        const c2 = ct0.find(elemCss(opt0.ct_no_data).wrap()).clone();
        il.append(c2);
    };

    // returns the 'no-data' elem
    po.getNoDataItem = function() {
        const il = po.getItemListContainer();
        return il.find(elemCss(opt0.ct_no_data).wrap());
    };

    // returns the item count
    po.getItemCount = function() {
        return po.getDataListFromMem().data.length;
    };

    // returns all items (ui elem)
    po.getAllItems = function() {
        return po.getDataListFromMem().data;
    };

    // returns the items in the mem
    // which could be stored in `.list` or `.data`.
    po.getDataList = function(){
        return (po.data && po.data.data && po.data.data.list ? po.data.data.list : po.data.data);
    };


    //------------------------------------------------------------------------------
    /**
     * to integrate with celScrollingDataLoader().
     */
    po.data = null;

    /**
     * to integrate with celScrollingDataLoader().
     */
    po.getDataListFromMem = function () {
        return {
            data: po.getItemListContainer0().find(elemCss(opt0.item_div_cls).wrap()),
        };
    };

    //------------------------------------------------------------------------------
    // for search button click event handler.
    // For reseting the scroll_page internal values at runtime
    // before perform ajax call.
    po.onSearch = function () {
        if (window.app && window.app.playSound) {
            window.app.playSound();
        }

        // clear all items
        po.getItemListContainer().html('');

        if (opt0.big_list) {
            po.scroll_pager.resetAutoLoadVar();
        }

        po.list();
    };


    //------------------------------------------------------------------------------
    //17-Sep-2023,lhw-
    function _filter_get_search_input() {
        if (opt0.filter_input) {
            if (isJQueryObject(opt0.filter_input)) {
                return opt0.filter_input;
            }
            return po.getContainer().find(elemCss(opt0.filter_input).wrap());
        }
    }

    function _filter_get_search_text() {
        if (opt0.filter_input) {
            return text_get_val(_filter_get_search_input());
        }
    }

    function _filter_item(e) {
        if (!opt0.filter_input) {
            throw new Error('celItemList:_filter_item:opt0.filter_input has not been set');
        }

        if (e) {
            celUI.discardEvent(e);
        }

        const il = po.getItemListContainer0().find(elemCss(opt0.item_div_cls).wrap());
        const filter_text = _filter_get_search_text();
        const has_match_f = obj_has_proc(po, opt0, 'onMatching');
        const r = {f:true};

        celLoop.each(il, function (c20) {
            const c2 = $(c20);
            const o2 = c2.data('data');
            r.f = true;

            _filter_on_matching(o2, r, filter_text, has_match_f);
            if (r.f) {
                c2.show();
            }
            else {
                c2.hide();
            }
        });
    };

    function _filter_on_matching(o2, r, filter_text, has_match_f) {
        if (has_match_f) {
            obj_exec_proc(po, opt0, 'onMatching', [o2, r]);
        }
        else {
            celListFilter.wildcardByText(o2, opt0.match_field, filter_text, r);
        }
    }

}

//==============================================================================
/*
13-Aug-2023,lhw-
- An item/record editor.
- Able to work in conjunction with `celItemList()`.


Sample,


    cliPmsFloorSetup.item_editor = function() {};
    celItemEditor({
        po: cliPmsFloorSetup.item_editor,
        destroyer: cliPmsFloorSetup,
        c0: c0,
        name: 'floor-setup',
        cel_item_list: cliPmsFloorSetup.item_list,

        // use the same ref OR a new celDataProc() settings.
        data_proc: cliPmsFloorSetup.item_list.data_proc,

        // the spinner container
        // spinner0: null,

        ajax_cmd: 'pms-floor',
        // ajax_cmd_axn_save: 's',
        // ajax_cmd_axn_delete: 'd',
        pk_fld: 'floor_id',

        // sel_cls: 'sel-opt',
        // save_confirm_msg: null,
        // save_msg: 'The changes have been saved',
        // del_confirm_msg: 'Please click OK to confirm deleting the current record',
        // del_msg: 'The record have been deleted',

        //-------------------------
        // onInit: function() {},

        // onSaveParam: function(p2) {},
        // onDeleteParam: function(p2) {},
        // onNewItem: function() {},

        // onBeforeEditItem: function(r, {c2, o2, resolve, reject}) {},
        // onAfterEditItem: function(c2, o2) {},

        // onBeforeSaveItem: function(r, {c2, o0, o2, msg, resolve,reject) {},
        // onAfterSaveItem: function(c2, o2, d2) {},

        // onBeforeDelItem: function(r, {c2, o2, msg, resolve, reject}) {},
        // onAfterDelItem: function(c2, o0) {},

    });

    cliPmsFloorSetup.item_editor.init();

    //-------------------------
    app.setCreateCtl(cliPmsFloorSetup.item_editor.onNew);
    app.setSaveCtl(cliPmsFloorSetup.item_editor.onSave);
    app.setDeleteCtl(cliPmsFloorSetup.item_editor.onDelete);

    const il = cliPmsFloorSetup.item_list.getItemListContainer()
    il.off().on('click', '.item-div', cliPmsFloorSetup.item_editor.onEdit);


*/
function celItemEditor(opt0) {
    console.assert(!isStrEmpty(opt0.name), 'celItemEditor:opt0.name cannot be null' );

    let def_opt = {
        // the parent object (must be a function type for destroyer to work).
        po: null,

        // an instance of celDestroyer(). It should be hold by the main container.
        destroyer: null,

        // the container that holds the input element to be saved to localStorage.
        c0: null,

        name: null,

        // Optional. The ref to celItemLine().
        // If set, the item list will be automatically refresh when there is edit/delete (in the browser only!).
        cel_item_list: null,

        // the settings of celDataProc() - to be setup for the editor.
        // OR use the same `data_proc` ref in `celItemList()`.
        data_proc: null,

        // the spinner container
        spinner0: null,

        ajax_cmd: null,
        ajax_cmd_axn_save: 's',
        ajax_cmd_axn_delete: 'd',

        // the primary key field.
        pk_fld: 'id',

        // the selected item css class
        sel_cls: 'sel-opt',

        // set the value to null to avoid showing the msg prompt.
        save_confirm_msg: null,
        save_msg: 'The changes have been saved',

        del_confirm_msg: 'Please click OK to confirm deleting the current record',
        del_msg: null,

        //-------------------------
        // for init the ui and other stuffs.
        onInit: null,

        // review the search param value.
        // param: p2 (ie, the param to be pass to the ajax server).
        // onSaveParam: function(p2) {};
        onSaveParam: null,

        // review the search param value.
        // param: p2 (ie, the param to be pass to the ajax server).
        // onDeleteParam: function(p2) {};
        onDeleteParam: null,

        // f()
        onNewItem: null,

        // onBeforeEditItem = function(r, {c2, o2, resolve, reject}) {}
        // - the hosting object must call r.resolve() manually!
        // -call r.reject() to prevent enabling the edit mode.
        onBeforeEditItem: null,

        // onAfterEditItem = function(c2, o2) {}
        //  - allows perform any ajax process before open the field for editing.
        onAfterEditItem: null,

        // onBeforeSaveItem = function(r, {c2, o0, o2, msg, resolve,reject) {}
        //12-Jul-2023,lhw-added 'o0' (original data) and 'o2' (modified data).
        // - allows overriding the the message prompt (r.msg)
        // - calls 'r.resolve()' if the user input has fulfilled the
        //   business process validation. Otherwise, calls 'r.reject()'.
        onBeforeSaveItem: null,

        // onAfterSaveItem = function(c2, o2, d2) {}
        // - to run any other process after saved the changes.
        onAfterSaveItem: null,

        // onBeforeDelItem = function(r, {c2, o2, msg, resolve, reject}) {}
        // - allows overriding the the message prompt (r.msg)
        // - calls 'r.resolve()' to confirm deleting the user input (on the UI) (by clearing the
        //   values in the row but not physically deleting the row!). Otherwise, calls 'r.reject()'.
        onBeforeDelItem: null,

        //  onAfterDelItem = function(c2, o0) {};
        // - to run any other process after deletion where 'c2' is the row.
        onAfterDelItem: null,

    };

    opt0 = $.extend(def_opt, opt0);
    const po = opt0.po;

    po.curr_o = null;
    po.curr_c = null;

    //------------------------------------------------------------------------------

    po.getType = function() { return 'celItemEditor'; };

    po.getContainer = function () {
        return opt0.c0;
    };

    po.getOptions = function () {
        return opt0;
    };

    po.getPkID = function() {
        return po.curr_o ? po.curr_o[opt0.pk_fld] : undefined;
    };

    po.getItemDiv = function() {
        return opt0.cel_item_list.getOptions().item_div_cls;
    };

    po.imBusy = function() {
        if (opt0.spinner0) {
            po.showSpinner(true);
        }
    };

    po.imFree = function() {
        if (opt0.spinner0) {
            po.showSpinner(false);
        }
    };

    //------------------------------------------------------------------------------
    // startup
    po.init = function () {
        let is_local_data_proc;
        if (opt0.data_proc && opt0.data_proc.getType && opt0.data_proc.getType() == 'celDataProc') {
            // use the same ref.
            po.data_proc = opt0.data_proc;
        }
        else {
            // init data proc
            po.data_proc = function() {};
            opt0.data_proc.c0 = opt0.c0;
            opt0.data_proc.inject_common_fn = true,
            celDataProc(po.data_proc, opt0.data_proc);
            is_local_data_proc = true;
        }

        // init the input elem
        po.data_proc.initInput();

        if (opt0.spinner0) {
            progress.addSpinnerFunc(po, opt0.spinner0);
        }

        // continue with exec the user defined init process
        if (obj_has_fld(po, opt0, 'onInit')){
            obj_exec_proc(po, opt0, 'onInit', []);
        }

        if (opt0.destroyer) {
            let d;

            if (opt0.destroyer.getType && opt0.destroyer.getType() == 'celDestroyer') {
                d = opt0.destroyer;
            }
            else if (opt0.destroyer.destroyer.getType && opt0.destroyer.destroyer.getType() == 'celDestroyer') {
                d = opt0.destroyer.destroyer;
            }

            if (d) {
                if (is_local_data_proc) {
                    d.add('data_proc', true, po);
                }

                d.add(function() {
                    // console.log(`${opt0.name}:destroyer:`);
                    po.curr_c = null;
                    po.curr_o = null;
                    opt0 = null;
                });
            }
            else {
                throw new Error('opt0.destroyer must be an instance of celDestroyer()');
            }
        }
    };

    //------------------------------------------------------------------------------
    po.onEdit = function (e) {
        // edit the entry.
        let c2, o2;

        if (opt0.cel_item_list) {
            // the caller is editing an item in the list.
            c2 = celUI.getContainer(e, po.getItemDiv());
            o2 = c2.data('data');
        }
        else {
            // the caller pass in the data.
            c2 = e.c2;
            o2 = e.o2;
        }

        // console.log('onEdit:c2', c2);
        // console.log('onEdit:o2', o2);

        if (!o2) {
            return;
        }

        if (!e.skip_play_sound) {
            if (typeof app != 'undefined') {
                obj_exec_proc(app, 'playSound');
            }
        }

        po.curr_o = o2;
        po.curr_c = c2;

        const r = {
            c2: c2,
            o2: o2,

            // ok to edit
            resolve: function resolve_edit() {
                po.data_proc.editData(o2);

                if (opt0.cel_item_list) {
                    // highlight the selection.
                    const il = opt0.cel_item_list.getItemListContainer();

                    il.find(elemCss(opt0.sel_cls).wrap()).removeClass(opt0.sel_cls);
                    po.curr_c.addClass(opt0.sel_cls);
                }

                // the input controls are ready for editing.
                // allows the hosting object to continue any other ajax process.
                //14-Jul-2023,lhw-added 'o2'
                obj_exec_proc(opt0, 'onAfterEditItem', [c2, o2]);
            },

            // reject the edit request
            reject: function reject_edit() {
                // no action
            }
        };

        //-------------------------
        if (obj_has_proc(opt0, 'onBeforeEditItem')) {
            obj_exec_proc(opt0, 'onBeforeEditItem', [r, r]);
        }
        else {
            r.resolve();
        }
    };


    //------------------------------------------------------------------------------
    po.onNew = function () {
        po.curr_o = null;
        po.curr_c = null;
        po.data_proc.resetInput();

        if (opt0.cel_item_list) {
            const il = opt0.cel_item_list.getItemListContainer();
            il.find(elemCss(opt0.sel_cls).wrap()).removeClass(opt0.sel_cls);
        }

        if (obj_has_proc(opt0, 'onNewItem')) {
            obj_exec_proc(opt0, 'onNewItem', []);
        }
    };

    //------------------------------------------------------------------------------
    po.onSave = function () {
        if (!celClickOnce.canFire(`${opt0.name}.onSave`)) {
            return false;
        }

        const o2 = {};
        o2[opt0.pk_fld] = po.getPkID();

        if (!po.data_proc.validateInput(o2)) {
            return false;
        }

        const p0 = {
            code: opt0.ajax_cmd,
            axn: opt0.ajax_cmd_axn_save,
            data: o2,
        };

        if (obj_has_fld(po, opt0, 'onSaveParam')) {
            obj_exec_proc(po, opt0, 'onSaveParam', [p0]);
        }

        const r = {
            c2: po.curr_c,
            o0: po.curr_o,
            o2: o2,
            msg: opt0.save_confirm_msg,

            // ok to save
            resolve: function resolve_edit() {
                // submit the data to the server.
                if (r.msg) {
                    msgbox.confirm(r.msg, function () {
                        ajaxCall({
                            p: p0,
                            on_success: po.onSaveResponse
                        });
                    });
                }
                else {
                    ajaxCall({
                        p: p0,
                        on_success: po.onSaveResponse
                    });
                }
            },

            // reject the edit request
            reject: function reject_edit() {
                // no action
            }
        };

        //-------------------------
        if (obj_has_proc(opt0, 'onBeforeSaveItem')) {
            obj_exec_proc(opt0, 'onBeforeSaveItem', [r, r]);
        }
        else {
            r.resolve();
        }
    };

    //------------------------------------------------------------------------------
    po.onSaveResponse = function (d) {
        if (!po.curr_o) {
            // for creating new rec
            po.curr_o = {};
            po.curr_o[opt0.pk_fld] = d.data[opt0.pk_fld];

            if (opt0.cel_item_list) {
                const opt = opt0.cel_item_list.getCloneItemOption();
                celUI.clone(opt, po.curr_o);

                const c_no_data = opt0.cel_item_list.getNoDataItem();
                if (c_no_data.length == 1) {
                    c_no_data.remove();
                }

                opt0.cel_item_list.appendItem(opt.c2);

                const l3 = opt0.cel_item_list.getDataList();
                l3.push(po.curr_o);

                // set the new ref
                po.curr_c = opt.c2;
            }
        }

        // save the user input into mem.
        po.data_proc.getInput(po.curr_o);

        if (obj_has_proc(opt0, 'onAfterSaveItem')) {
            //16-Jan-2024,lhw-added `d` param.
            obj_exec_proc(opt0, 'onAfterSaveItem', [po.curr_c, po.curr_o, d]);
        }

        // ref the item display
        po.data_proc.fmtItem(po.curr_c, po.curr_o);

        if (opt0.save_msg) {
            msgbox.show(opt0.save_msg);
        }
    };

    //------------------------------------------------------------------------------
    po.onDelete = function () {
        if (!celClickOnce.canFire(`${opt0.name}.onDelete`)) {
            return false;
        }

        if (!po.curr_o) {
            return;
        }

        const o2 = {};
        o2[opt0.pk_fld] = po.getPkID();

        const p0 = {
            code: opt0.ajax_cmd,
            axn: opt0.ajax_cmd_axn_delete,
            data: o2,
        };

        if (obj_has_fld(po, opt0, 'onDeleteParam')) {
            obj_exec_proc(po, opt0, 'onDeleteParam', [p0]);
        }

        //-------------------------
        const r = {
            c2: po.curr_c,
            o2: po.curr_o,
            msg: opt0.del_confirm_msg,

            // ok to save
            resolve: function resolve_delete() {
                // submit the data to the server.
                if (r.msg) {
                    msgbox.confirm(r.msg, function () {
                        ajaxCall({
                            p: p0,
                            on_success: po.onDeleteResponse
                        });
                    });
                }
                else {
                    // the hosting object will handle the deletion msg prompt,
                    // skip showing the msg prompt here.
                    ajaxCall({
                        p: p0,
                        on_success: po.onDeleteResponse
                    });
                }
            },

            // reject the edit request
            reject: function reject_delete() {
                // no action
            }
        };

        //-------------------------
        if (obj_has_proc(opt0, 'onBeforeDelItem')) {
            obj_exec_proc(opt0, 'onBeforeDelItem', [r, r]);
        }
        else {
            r.resolve();
        }
    };

    //------------------------------------------------------------------------------
    po.onDeleteResponse = function (d) {
        // delete the item without any animation effect.
        po.curr_c.remove();

        if (opt0.cel_item_list) {
            if (opt0.cel_item_list.getItemCount() == 0) {
                opt0.cel_item_list.appendNoDataItem();
            }

            if (opt0.cel_item_list.data) {
                const v3 = po.curr_o[opt0.pk_fld];
                const l3 = opt0.cel_item_list.getDataList();

                celLoop.each(l3, function(o3, idx3) {
                    if (o3[opt0.pk_fld] == v3) {
                        // delete the item from mem.
                        arrRemoveItem(l3, idx3);

                        // exit the loop
                        return false;
                    }
                });
            }
        }

        if (obj_has_proc(opt0, 'onAfterDelItem')) {
            obj_exec_proc(opt0, 'onAfterDelItem', [po.curr_c, po.curr_o]);
        }

        // reset the input fields
        po.onNew();

        if (opt0.del_msg) {
            msgbox.show(opt0.del_msg);
        }
    };
}


