/*

//24-sep-17,lhw-dockbar for showing more info or parameters.


    // sample
  
    cust.showPopup = function () {

        if (cust.dockbar === null) {

            cust.dockbar = new celDockbar({
                pp_cls: 'my-pp',
                width: 300,
                bounce_width: 10,
                blk_z: 900,
                ////preventClickBlkToHide: false,

                // param:pp
                onInit: function (pp) {

                    //prepare the pp
                    cust.dockbar.getInnerContainer().html('');

                },

                onBeforeShow: function (pp) {
                    //load the data


                },

                onBeforeHide: function (p) {
                    //p.ok:bool -> false to quit hiding process

                },

            });
        }

        cust.dockbar.show();
    };


*/

'use strict';

function celDockbar(opt) {
    var self = this;

    opt = $.extend({
        ////// the main container
        ////c0: null,

        // the pp class name
        pp_cls: null,

        // the width of the pp
        //17-Apr-2021,lhw-revised the default width.
        // width: 250,
        width: 300,

        //20.May.18,lhw- the bouncing width. This value must be added to the declaration in css.
        bounce_width: 0,

        //left,right(default)
        dock_pos: 'right',

        //10-mar-18,lhw-to prevent double click.
        click_once_code: null,

        //12.Sep.18,lhw-if true, clicking on the blk will not hide the dockbar.
        preventClickBlkToHide: false,

        //17.Nov.18,lhw-the duration of the animation.
        duration: 200,

        //27.May.19,lhw-the z-index (int) for the blk - recommended to set a value. 
        // Default value is '100' which is same as the settings in ui.css.
        // If there is a need to have multiple celDockbar instance in the same page,
        // you should create different z-index value for those overlapping celDockbar instance.
        ////blk_z: null,
        blk_z: 100,

        //18-Oct-2022,lhw-
        play_sound_on_show: true,
        

        //-------------------------------
        // the callback for on init the pp
        // param: pp
        onInit: null,

        // param: pp
        onBeforeShow: null,

        // on showing the dockbar.
        // param: pp
        onShow: null,

        // param: p (p.ok:bool -> false to quit hiding process)
        onBeforeHide: null,

        // param: pp
        onHide: null,

        //21-Jun-2021,lhw-override the getInnerContainer() proc.
        onGetInnerContainer: null,


    }, opt);

    var curr_blk = null;

    //02-Mar-2021,lhw-
    let internal = {
        has_init: false
    };

    //---------------------------
    self.getContainer = function () {
        return $('.' + opt.pp_cls);
    };

    //-------------------------
    self.getInnerContainer = function () {

        //21-Jun-2021,lhw-allows overriding the actual item list container.
        if (opt.onGetInnerContainer) {
            return obj_exec_proc(opt, 'onGetInnerContainer');
        }

        return $('.' + opt.pp_cls + ' > div');
    };

    //-------------------------
    //09-Sep-2020,lhw-
    self.init = function () {
        var pp;

        pp = self.getContainer();

        if (pp.length == 0) {
            pp = $('<div class="' + opt.pp_cls + '" style="display:none;"><div></div></div>');

            //18.Apr.20,lhw-automatically bring the pp to the top of blk.
            if (opt.blk_z != null) {
                pp.css('z-index', toInt(opt.blk_z) + 10);
            }

            //19-Nov-2020,lhw-this will simplify the dev because CSS class is not require for the pp.
            pp.css('width', opt.width);

            //19-Nov-2020,lhw-this is new standard to reduce the coding.
            pp.addClass('std-pp');


            $('body').append(pp);

            //02-Mar-2021,lhw-moved outside of current condition.
            // pp = self.getContainer();
            // if (opt.onInit) {
            //     opt.onInit(pp);
            // }
        }

        //<<==========
        //02-Mar-2021,lhw-bug fixed-the onInit() must be trigger regardless DIV exist or not.
        if (!internal.has_init) {
            pp = self.getContainer();
            if (opt.onInit) {
                opt.onInit(pp);
            }

            //02-Mar-2021,lhw-
            internal.has_init = true;
        }
        //<<==========

        return pp;
    };

    //---------------------------
    self.show = function () {
        var pp, is_ready;

        //18-Oct-2022,lhw-the caller should handle it manually. 
        //   For eg, if the user clicks the button (play sound once),
        //   and then showing the popup (play sounce another round), 
        //   it will be playing the sound twice.

        // console.log(opt.play_sound_on_show)
        if (opt.play_sound_on_show && typeof app != 'undefined') {
            obj_exec_proc(app, 'playSound');
        }

        //09-Sep-2020,lhw-moved out as a proc.
        pp = self.init();

        if (opt.onBeforeShow != null) {
            opt.onBeforeShow(pp);
        }

        //---------------------------
        // hide the pp
        if (opt.dock_pos === 'right') {
            // position the pp on the hidden right.
            //23-Sep-2021,lhw-
            // pp.css('left', $(window).width());
            pp.css('right', -1 * opt.width.toString() + 'px');
        }
        else if (opt.dock_pos === 'left') {
            pp.css('left', -1 * opt.width.toString() + 'px');
        }

        //19.Sep.18,lhw-this should be before '$(window).width())' because we might need to hide the v scrollbar.
        ////if (opt.onBeforeShow != null) {
        ////    opt.onBeforeShow(pp)
        ////}


        //13.Apr.20,lhw-bug fixed-hide the horz scrollbar so that the sliding 
        // pp does not causing the flickering.
        // $('body').css('overflow-x', 'hidden');
        $('body').css({
            'overflow-x': 'hidden',
            //22-Jun-2021,lhw-the body should not show vert scrollbar as well.
            'overflow-y': 'hidden'
        });


        pp.show();

        //---------------------------

        if (opt.blk_z != null) {
            //27.May.19,lhw-create a custom layer.
            curr_blk = progress.getNewLayer(opt.blk_z, opt.blk_z);
            progress.show_layer(curr_blk);
        }
        else {
            progress.show();
            curr_blk = progress.get();
        }

        //19.Dec.18,lhw-we must always clear the previous settings.
        curr_blk.off();

        if (!opt.preventClickBlkToHide) {

            curr_blk.on('click', function () {

                //7.Nov.18,lhw-prevent closing the dockbar if it is not ready on screen.
                if (!is_ready) {
                    return;
                }

                //30-Sep-2021,lhw-allows dynamically control whether allows hiding the pp or not.
                if (obj_has_proc(opt, 'canHide')) {
                    let b = obj_exec_proc(opt, 'canHide', []);
                    if (typeof b == 'boolean' && b == false) {
                        return;
                    }
                }


                self.hide();
            });

        }

        //---------------------------
        if (opt.dock_pos === 'right') {

            if (opt.bounce_width == 0) {
                // no bouncing effect
                //23-Sep-2021,lhw-
                // pp.animate({ 'left': '-=' + (opt.width + opt.bounce_width).toString() },
                pp.animate({ 'right': '+=' + opt.width.toString() },
                    opt.duration,
                    function () {
                        fireOnShow(pp);
                        is_ready = true;
                    });

            }
            else {

                // with bouncing effect
                //23-Sep-2021,lhw-
                // pp.animate({ 'left': '-=' + (opt.width + opt.bounce_width).toString() }, opt.duration)
                //     .animate({ 'left': '+=' + opt.bounce_width.toString() },
                pp.animate({ 'right': '+=' + (opt.width + opt.bounce_width).toString() }, opt.duration)
                    .animate({ 'right': '-=' + opt.bounce_width.toString() },
                        opt.duration,
                        function () {
                            fireOnShow(pp);
                            is_ready = true;
                        });

            }

        }
        else if (opt.dock_pos === 'left') {

            if (opt.bounce_width == 0) {
                // no bouncing effect
                pp.animate({ 'left': '+=' + opt.width.toString() },
                    opt.duration,
                    function () {
                        fireOnShow(pp);
                        is_ready = true;
                    });

            }
            else {

                // with bouncing effect
                pp.animate({ 'left': '+=' + (opt.width + opt.bounce_width).toString() }, opt.duration)
                    .animate({ 'left': '-=' + opt.bounce_width.toString() },
                        opt.duration,
                        function () {
                            fireOnShow(pp);
                            is_ready = true;
                        });

            }

        }
    };

    function fireOnShow(pp) {
        if (opt.onShow != null) {
            opt.onShow(pp);
        }
    }

    //---------------------------
    self.hide = function () {

        // 10-mar-18,lhw-prevent double click
        if (!isStrEmpty(opt.click_once_code) && typeof celClickOnce == 'function') {
            if (!celClickOnce.canFire(opt.click_once_code)) {
                return false;
            }
        }

        var pp = self.getContainer();

        if (opt.onBeforeHide != null) {
            var p2 = { ok: true };
            opt.onBeforeHide(p2);

            if (!p2.ok) {
                return;
            }
        }

        if (opt.dock_pos === 'right') {
            //23-Sep-2021,lhw-
            // pp.animate({ 'left': '+=' + opt.width.toString() },
            pp.animate({ 'right': '-=' + opt.width.toString() },
                opt.duration,
                function () {
                    if (opt) {
                        if (opt.onHide != null) {
                            opt.onHide(pp);
                        }

                        //13.Feb.18,lhw-
                        pp.hide();
                    }

                    //13.Apr.20,lhw-
                    $('body').css({
                        'overflow-x': '',
                        //22-Jun-2021,lhw-reset the setting
                        'overflow-y': ''
                    });
                });

        }
        else if (opt.dock_pos === 'left') {
            pp.animate({ 'left': '-=' + opt.width.toString() },
                opt.duration,
                function () {
                    if (opt.onHide != null) {
                        opt.onHide(pp);
                    }

                    //13.Feb.18,lhw-
                    pp.hide();

                    //13.Apr.20,lhw-
                    $('body').css({
                        'overflow-x': '',
                        //22-Jun-2021,lhw-reset 
                        'overflow-y': '',
                        'overflow': '',
                    });
                });
        }

        //27.May.19,lhw-
        ////progress.hide();
        if (curr_blk) {
            if (opt.blk_z != null) {
                progress.hide_layer(curr_blk);
            }
            else {
                progress.hide();
            }
        }

        //reset
        curr_blk = null;
    };

    //------------------------------------------------------------------------------
    //15.Sep.18,lhw-
    self.disableClickBlkToHide = function () {
        if (curr_blk) {
            curr_blk.off();
        }

        opt.preventClickBlkToHide = true;
    };


    //------------------------------------------------------------------------------
    self.destroy = function () {
        //10-Aug-2021,lhw-prevent re-entrant.
        if (!opt) {
            return;
        }

        var pp = self.getContainer();

        if (pp.length > 0) {
            pp.remove();
        }

        internal.has_init = null;

        //22-Jul-2021,lhw-
        opt = null;

        // console.log('celDockbar.destroy');
    };

    //------------------------------------------------------------------------------
    //27.May.19,lhw-
    self.getBlk = function () {
        return curr_blk;
    };

    //------------------------------------------------------------------------------
    //09-Sep-2021,lhw-
    self.setWidth = function (i) {
        if (i <= 0) {
            i = 500;
        }

        opt.width = i;
        self.getContainer().css('width', opt.width);
    };


}

/*==============================================================================
26-Apr-2021,lhw-
- This is a convenient proc that helps to setup all the basic stuffs including 
  adding this object instance for auto destroy.
- Call this in the click event handler.


celDockbar.makePp(membList,
    {
        name: 'dockbar',
        
        // destroyer: mainForm,             //<<==========this works like 'mainForm.destroyer' (auto inference).
        // destroyer: mainForm.destroyer,   //<<==========this is a long and specific pointing.

        pp_cls: 'search-memb-pp',
        // width: 500,

        // optional setting. Mark as init and skip showing the pp for the first time.
        init_only: true,

        // param:pp
        onInit: function (pp) {

            let opt = {
                c0: membList.getContainer(),
                cls: 'memb-filter-pp-dtl0'
            };

            celUI.clone(opt);
            dt_makeDatePicker(opt.c2.find('.search-dob'));
            opt.c2.find('.search-exact-mobile-no').celCheckbox();
            opt.c2.find('.search-show-all').celCheckbox();

            opt.c2.find('.btn-search').on('click',
                function _do_search() {
                    membList.list2();
                    obj_exec_proc(membList.dockbar, 'hide');
                });

            membList.dockbar.getInnerContainer().append(opt.c2);

        },

    });
    
==============================================================================*/

celDockbar.makePp = function (po, opt) {

    // console.log('celDockbar.makePp - opt.init_only=', opt.init_only);

    if (obj_get_val(po, opt.name) == '') {
        // if (typeof po[opt.name] == 'undefined' || po[opt.name] == null) {

        obj_set_val_if_missing(opt, 'preventClickBlkToHide', false);

        if (!opt.width) {
            // default width
            opt.width = $(window).width() * .8;
        }

        po[opt.name] = new celDockbar({
            pp_cls: (opt.popupCls || opt.pp_cls || opt.name),
            width: opt.width,
            bounce_width: (opt.bounce_width || 10),
            blk_z: (opt.blk_z || 900),
            preventClickBlkToHide: opt.preventClickBlkToHide,
            //10-Mar-2022,lhw-
            dock_pos: opt.dock_pos,

            //23-Jul-2023,lhw-bug fixed-omitted to pass this setting.
            play_sound_on_show: opt.play_sound_on_show,

            onInit: function (pp) {
                po[opt.name].getInnerContainer().html('');

                // The inner container must handle the overflow themselves.
                // The pp will disable it to make the screen looks nicer in desktop.
                pp.css({
                    'overflow': 'hidden',

                    //22-Jun-2021,lhw-should hide the x & y as well.
                    'overflow-y': 'hidden'
                });

                obj_exec_proc(opt, 'onInit', [pp]);
            },

            onBeforeShow: function (pp) {
                obj_exec_proc(opt, 'onBeforeShow', [pp]);
            },

            onShow: function (pp) {
                obj_exec_proc(opt, 'onShow', [pp]);
            },

            onBeforeHide: function (p) {
                //p.ok:bool -> false to quit hiding process
                obj_exec_proc(opt, 'onBeforeHide', [p]);
            },

            onHide: function (pp) {
                obj_exec_proc(opt, 'onHide', [pp]);
            }

        });

        //-------------------------
        if (!opt.skipDestroy) {
            // log for destroying.
            // console.log('destroyer -> pp,opt.name=', opt.name);
            
            //18-Jul-2023,lhw-allows attaching to a dedicated destroyer.
            if (opt.destroyer) {
                let d;

                if (opt.destroyer.getType && opt.destroyer.getType() == 'celDestroyer') {
                    d = opt.destroyer;
                }
                else if (opt.destroyer.destroyer.getType && opt.destroyer.destroyer.getType() == 'celDestroyer') {
                    d = opt.destroyer.destroyer;
                }

                if (d) {
                    d.add(opt.name, true, po);
                }
                else {
                    throw new Error('opt.destroyer must be an instance of celDestroyer()');
                }
            }
            //03-Jul-2021,lhw-check null or undef which is more accurate.
            // if (!obj_has_fld(po, 'destroyer')) {
            else if ((typeof po.destroyer == 'undefined' || po.destroyer == null)) {
                // enable the destroyer
                celDestroyer({
                    // the parent object
                    o0: po
                });

                po.destroyer.add(opt.name, true, po);
            }
        }

        //22-Jun-2021,lhw-to init without showing the pp.
        if (opt.init_only) {
            po[opt.name].init();
            return;
        }

    }

    //-------------------------
    // show popup when the user clicks on the button.
    obj_exec_proc(po[opt.name], 'show');

};

